/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import projects.tals.epigenetic.NarrowPeak;

public class NarrowPeakConvertToPromoterSearch
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new NarrowPeakConvertToPromoterSearch());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter narrowPeakFile = new FileParameter("NarrowPeak file", "Peak-calling output in narrowPeak format.", "narrowPeak,narrowPeak.gz", true);
        FileParameter promotorFasta = new FileParameter("Promoter fasta file", "Promoter fastA file", "fa,fasta", true);
        return new ToolParameterSet(this.getShortName(), narrowPeakFile, promotorFasta);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        progress.setLast(1.0);
        progress.setCurrent(0.0);
        String narrowPeakFile = parameters.getParameterAt(0).getValue().toString();
        BufferedReader BR = null;
        BR = narrowPeakFile.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(narrowPeakFile))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(narrowPeakFile))));
        String promotorFasta = parameters.getParameterAt(1).getValue().toString();
        BufferedReader FA = new BufferedReader(new FileReader(promotorFasta));
        File outF = File.createTempFile("promoter.peaks.narrowPeak", ".temp.gz", new File("."));
        outF.deleteOnExit();
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(outF));
        PrintStream os_ps = new PrintStream(os);
        HashMap<String, HashMap> NarrowPeakHash = new HashMap<String, HashMap>();
        String line = "";
        HashMap temp = null;
        while ((line = BR.readLine()) != null) {
            String[] splitLine = line.split("\t");
            String chrom = splitLine[0];
            Integer startPos = Integer.parseInt(splitLine[1]);
            temp = NarrowPeakHash.containsKey(chrom) ? (HashMap)NarrowPeakHash.get(chrom) : new HashMap();
            temp.put(startPos, new NarrowPeak(splitLine[0], startPos, Integer.parseInt(splitLine[2]), Float.parseFloat(splitLine[4]), Float.parseFloat(splitLine[6])));
            NarrowPeakHash.put(chrom, temp);
        }
        BR.close();
        line = "";
        String gene = "";
        String chrom = "";
        int startPos = -1;
        int endPos = -1;
        NarrowPeak aktNarrowPeak = null;
        String out = "";
        while ((line = FA.readLine()) != null) {
            if (!line.startsWith(">")) continue;
            String[] splitHeader = line.split(" ");
            String[] splitArea = splitHeader[2].split(":");
            String[] splitPos = splitArea[1].split("-");
            gene = line.substring(1).trim();
            int idx = gene.indexOf(" ");
            if (idx > 0) {
                gene = gene.substring(0, idx);
            }
            chrom = splitArea[0];
            startPos = Integer.parseInt(splitPos[0]);
            endPos = Integer.parseInt(splitPos[1]);
            if (!NarrowPeakHash.containsKey(chrom)) continue;
            temp = (HashMap)NarrowPeakHash.get(chrom);
            Iterator iterator = temp.keySet().iterator();
            while (iterator.hasNext()) {
                int endPosPeak;
                int startPosPeak = (Integer)iterator.next();
                if (!(startPosPeak <= endPos & (endPosPeak = (aktNarrowPeak = (NarrowPeak)temp.get(startPosPeak)).getPeakEndPos()) >= startPos)) continue;
                if (startPosPeak >= startPos & endPosPeak <= endPos) {
                    out = String.valueOf(gene) + "\t" + (startPosPeak - startPos) + "\t" + (endPosPeak - startPos) + "\t" + "." + "\t" + aktNarrowPeak.getPeakScore() + "\t" + "." + "\t" + aktNarrowPeak.getPeakValue();
                    os_ps.print(String.valueOf(out) + "\n");
                    continue;
                }
                if (startPosPeak <= startPos & endPosPeak <= endPos) {
                    out = String.valueOf(gene) + "\t" + 0 + "\t" + (endPosPeak - startPos) + "\t" + "." + "\t" + aktNarrowPeak.getPeakScore() + "\t" + "." + "\t" + aktNarrowPeak.getPeakValue();
                    os_ps.print(String.valueOf(out) + "\n");
                    continue;
                }
                if (startPosPeak >= startPos & endPosPeak >= endPos) {
                    out = String.valueOf(gene) + "\t" + (startPosPeak - startPos) + "\t" + (endPos - startPos) + "\t" + "." + "\t" + aktNarrowPeak.getPeakScore() + "\t" + "." + "\t" + aktNarrowPeak.getPeakValue();
                    os_ps.print(String.valueOf(out) + "\n");
                    continue;
                }
                if (!(startPosPeak <= startPos & endPosPeak >= endPos)) continue;
                out = String.valueOf(gene) + "\t" + 0 + "\t" + (endPos - startPos) + "\t" + "." + "\t" + aktNarrowPeak.getPeakScore() + "\t" + "." + "\t" + aktNarrowPeak.getPeakValue();
                os_ps.print(String.valueOf(out) + "\n");
            }
        }
        FA.close();
        os.close();
        TextResult tr = new TextResult("Narrow peak promoter file", "Narrow peak promoter file", new FileParameter.FileRepresentation(outF.getAbsolutePath()), "narrowPeak.gz", this.getToolName(), null, true);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(tr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "NarrowPeakConvertToPromoter";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "peak2Prom";
    }

    @Override
    public String getDescription() {
        return "Creates NarrowPeak file in promoter region";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(NarrowPeakConvertToPromoterSearch.class.getClassLoader().getResourceAsStream("projects/tals/epigenetic/toolHelpFiles/NarrowPeakConvertToPromoterSearch.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

