/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import de.jstacs.clustering.hierachical.PWMSupplier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.QuickScanningSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import projects.tals.epigenetic.MethylationSequenceAnnotation;
import projects.tals.epigenetic.Methylationprofil;

public class PFMWrapperTrainSMMethyl
extends AbstractTrainableStatisticalModel
implements PWMSupplier,
QuickScanningSequenceScore {
    private double[][] logPWM;
    private double[][] pfm;
    private String name;

    public PFMWrapperTrainSMMethyl(AlphabetContainer alphabets, String name, double[][] pfm, double ess) throws CloneNotSupportedException {
        super(alphabets, pfm.length);
        this.pfm = (double[][])ArrayHandler.clone((Cloneable[])pfm);
        this.logPWM = new double[pfm.length][];
        int i = 0;
        while (i < pfm.length) {
            this.logPWM[i] = new double[pfm[i].length];
            int j = 0;
            while (j < this.logPWM[i].length) {
                this.logPWM[i][j] = Math.log(pfm[i][j] + ess / (double)pfm[i].length);
                ++j;
            }
            double norm = Normalisation.getLogSum(this.logPWM[i]);
            int j2 = 0;
            while (j2 < this.logPWM[i].length) {
                double[] dArray = this.logPWM[i];
                int n = j2++;
                dArray[n] = dArray[n] - norm;
            }
            ++i;
        }
        this.name = name;
    }

    public PFMWrapperTrainSMMethyl(AlphabetContainer alphabets, String name, double[][] pssm) throws CloneNotSupportedException {
        super(alphabets, pssm.length);
        this.pfm = new double[0][0];
        this.logPWM = (double[][])ArrayHandler.clone((Cloneable[])pssm);
        this.name = name;
    }

    public PFMWrapperTrainSMMethyl(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.alphabets, "alphabet");
        XMLParser.appendObjectWithTags(sb, this.logPWM, "logPWM");
        XMLParser.appendObjectWithTags(sb, this.pfm, "pfm");
        XMLParser.appendObjectWithTags(sb, this.name, "name");
        XMLParser.addTags(sb, this.getClass().getSimpleName());
        return sb;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        double prob = this.logPWM[0][sequence.discreteVal(startpos)];
        MethylationSequenceAnnotation methylAnno = (MethylationSequenceAnnotation)sequence.getSequenceAnnotationByType("methylationprofil", 0);
        if (methylAnno != null) {
            Methylationprofil MP = methylAnno.getMethylationprofile();
            boolean strand = MP.getStrand();
            int k = 1;
            int i = startpos + 1;
            while (i <= endpos) {
                if (MP.getMethylPropAtPos(k) > 0.0 & (double)sequence.discreteVal(i) == sequence.getAlphabetContainer().getCode(0, "C")) {
                    prob += (1.0 - MP.getMethylPropAtPos(k)) * this.logPWM[i - startpos][sequence.discreteVal(i)];
                    prob += MP.getMethylPropAtPos(k) * this.logPWM[i - startpos][4];
                } else {
                    prob += this.logPWM[i - startpos][sequence.discreteVal(i)];
                }
                ++k;
                ++i;
            }
        } else {
            int i = startpos + 1;
            while (i <= endpos) {
                prob += this.logPWM[i - startpos][sequence.discreteVal(i)];
                ++i;
            }
        }
        return prob;
    }

    public String getMethylProb(Sequence sequence, int startpos, int endpos) throws Exception {
        MethylationSequenceAnnotation methylAnno = (MethylationSequenceAnnotation)sequence.getSequenceAnnotationByType("methylationprofil", 0);
        String methProb = "";
        if (methylAnno != null) {
            Methylationprofil MP = methylAnno.getMethylationprofile();
            boolean strand = MP.getStrand();
            int k = 1;
            int i = startpos + 1;
            while (i <= endpos) {
                methProb = String.valueOf(methProb) + ",";
                methProb = (double)sequence.discreteVal(i) == sequence.getAlphabetContainer().getCode(0, "C") ? String.valueOf(methProb) + k + ":" + MP.getMethylPropAtPos(k) : String.valueOf(methProb) + k + ":" + 0.0;
                ++k;
                ++i;
            }
        }
        methProb = methProb.replaceFirst(",", "");
        return methProb;
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        return 0.0;
    }

    @Override
    public String getInstanceName() {
        return this.name == null ? "PFM Wrapper" : this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return null;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String toString(NumberFormat nf) {
        if (this.name != null) {
            return this.name;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.logPWM.length) {
            sb.append(nf.format(Math.exp(this.logPWM[i][0])));
            int j = 1;
            while (j < this.logPWM[i].length) {
                sb.append("\t" + nf.format(Math.exp(this.logPWM[i][j])));
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabet");
        this.logPWM = (double[][])XMLParser.extractObjectForTags(xml, "logPWM");
        this.pfm = (double[][])XMLParser.extractObjectForTags(xml, "pfm");
        this.name = (String)XMLParser.extractObjectForTags(xml, "name");
        this.length = this.logPWM.length;
    }

    public double[][] getPFM() throws CloneNotSupportedException {
        return (double[][])ArrayHandler.clone((Cloneable[])this.pfm);
    }

    @Override
    public double[][] getPWM() {
        double[][] pwm = new double[this.logPWM.length][];
        int i = 0;
        while (i < pwm.length) {
            pwm[i] = new double[this.logPWM[i].length];
            int j = 0;
            while (j < pwm[i].length) {
                pwm[i][j] = Math.exp(this.logPWM[i][j]);
                ++j;
            }
            ++i;
        }
        return pwm;
    }

    @Override
    public void fillInfixScore(int[] seq, int start, int length, double[] scores) {
        int i = start;
        while (i < start + length) {
            scores[i] = this.logPWM[i][seq[i]];
            ++i;
        }
    }

    @Override
    public boolean[][] getInfixFilter(int kmer, double thresh, int ... start) {
        double[] maxs = new double[this.logPWM.length];
        int i = 0;
        while (i < maxs.length) {
            maxs[i] = ToolBox.max(this.logPWM[i]);
            ++i;
        }
        boolean[][] use = new boolean[start.length][(int)Math.pow(this.getAlphabetContainer().getAlphabetLengthAt(0), kmer)];
        int i2 = 0;
        while (i2 < start.length) {
            double cumPref = ToolBox.sum(0, start[i2], maxs);
            double cumSuf = ToolBox.sum(start[i2] + kmer, maxs.length, maxs);
            DiscreteSequenceEnumerator en = new DiscreteSequenceEnumerator(this.getAlphabetContainer().getSubContainer(start[i2], kmer), kmer, false);
            int k = 0;
            while (en.hasMoreElements()) {
                Object temp = en.nextElement();
                double score = 0.0;
                int valueNuklC = -1;
                try {
                    valueNuklC = (int)((Sequence)temp).getAlphabetContainer().getCode(0, "C");
                }
                catch (WrongAlphabetException e) {
                    e.printStackTrace();
                }
                int j = 0;
                while (j < kmer) {
                    score = start[i2] + j == 0 ? (score += this.logPWM[start[i2] + j][((Sequence)temp).discreteVal(((Sequence)temp).getLength() - j - 1)]) : (((Sequence)temp).discreteVal(((Sequence)temp).getLength() - j - 1) == valueNuklC ? (score += Math.max(this.logPWM[start[i2] + j][((Sequence)temp).discreteVal(((Sequence)temp).getLength() - j - 1)], this.logPWM[start[i2] + j][4])) : (score += this.logPWM[start[i2] + j][((Sequence)temp).discreteVal(((Sequence)temp).getLength() - j - 1)]));
                    ++j;
                }
                use[i2][k] = cumPref + score + cumSuf > thresh;
                ++k;
            }
            ++i2;
        }
        return use;
    }
}

