/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.StringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.clustering.hierachical.Hclust;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import de.jstacs.utils.graphics.GraphicsAdaptorFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import projects.tals.ScanForTBSCLI;
import projects.tals.TALgetterDiffSM;
import projects.xanthogenomes.AlignmentPValues;
import projects.xanthogenomes.FamilyGroupPlotter;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEAligner;
import projects.xanthogenomes.TALEFamilyBuilder;
import projects.xanthogenomes.Tools;
import projects.xanthogenomes.alignmentCosts.RVDCosts;

public class BuildFamilies {
    private static double extraGapOpening = 1.0;
    private static double extraGapExtension = 0.1;
    private static Hclust.Linkage linkage = Hclust.Linkage.AVERAGE;
    private static Alignment.AlignmentType at = Alignment.AlignmentType.SEMI_GLOBAL;
    private static NumberFormat format = DecimalFormat.getInstance(Locale.US);
    private static NumberFormat formatE = new DecimalFormat("0.##E0");

    public static FamilyResult[] getFamilyResults(TALEFamilyBuilder.TALEFamily[] fams, double pval, TALEFamilyBuilder builder, int offset) {
        Costs costs = builder.getCosts();
        AlignmentPValues pv = null;
        if (costs instanceof AffineCosts && ((AffineCosts)costs).getInternalCosts() instanceof RVDCosts) {
            pv = new AlignmentPValues(builder.getAllTALEs(), (RVDCosts)((AffineCosts)costs).getInternalCosts());
        }
        FamilyResult[] ress = new FamilyResult[fams.length - offset];
        int i = offset;
        while (i < fams.length) {
            TALE[] members = fams[i].getFamilyMembers();
            LinkedList<TALEFamilyBuilder.TALEFamily> relFams = new LinkedList<TALEFamilyBuilder.TALEFamily>();
            LinkedList<TALE[]> relsTales = new LinkedList<TALE[]>();
            LinkedList<StringAlignment[]> relsAls = new LinkedList<StringAlignment[]>();
            LinkedList<int[]> relsMys = new LinkedList<int[]>();
            LinkedList<double[]> relPs = new LinkedList<double[]>();
            int j = 0;
            while (j < fams.length) {
                if (i != j) {
                    LinkedList<TALE> relTales = new LinkedList<TALE>();
                    LinkedList<StringAlignment> relAls = new LinkedList<StringAlignment>();
                    IntList relMy = new IntList();
                    DoubleList relP = new DoubleList();
                    TALE[] members2 = fams[j].getFamilyMembers();
                    int k = 0;
                    while (k < members.length) {
                        int l = 0;
                        while (l < members2.length) {
                            double p;
                            StringAlignment al = TALEAligner.align(members[k], members2[l], costs, at, extraGapOpening, extraGapExtension);
                            if (pv != null && (p = pv.getLog10PValue(members[k], members2[l], al.getCost(), extraGapOpening, extraGapExtension)) < Math.log10(pval)) {
                                relTales.add(members2[l]);
                                relAls.add(al);
                                relMy.add(k);
                                relP.add(p);
                            }
                            ++l;
                        }
                        ++k;
                    }
                    if (relTales.size() > 0) {
                        relFams.add(fams[j]);
                        relsTales.add(relTales.toArray(new TALE[0]));
                        relsAls.add(relAls.toArray(new StringAlignment[0]));
                        relsMys.add(relMy.toArray());
                        relPs.add(relP.toArray());
                    }
                }
                ++j;
            }
            ress[i - offset] = new FamilyResult(fams[i], relFams.toArray(new TALEFamilyBuilder.TALEFamily[0]), (TALE[][])relsTales.toArray((T[])new TALE[0][0]), (StringAlignment[][])relsAls.toArray((T[])new StringAlignment[0][0]), (double[][])relPs.toArray((T[])new double[0][0]), (int[][])relsMys.toArray((T[])new int[0][0]));
            ++i;
        }
        return ress;
    }

    public static Pair<TALEFamilyBuilder, FamilyResult[]> build(TALE[] ttales, double cut, double pval) throws NonParsableException, IOException {
        RVDCosts rvdCosts = new RVDCosts(1.0, 0.2, 0.8, 0.0);
        AffineCosts costs = new AffineCosts(5.0, 5.0, rvdCosts);
        TALEFamilyBuilder builder = new TALEFamilyBuilder(ttales, costs, linkage, at, extraGapOpening, extraGapExtension, cut, pval);
        TALEFamilyBuilder.TALEFamily[] fams = builder.getFamilies();
        FamilyResult[] ress = BuildFamilies.getFamilyResults(fams, pval, builder, 0);
        return new Pair<TALEFamilyBuilder, FamilyResult[]>(builder, ress);
    }

    public static void rename(TALE[] ttales) throws IOException {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        BufferedReader read = new BufferedReader(new FileReader("/Users/dev/Desktop/TAL-Chips/Genomes/proteins/tal_names.csv"));
        String str = null;
        while ((str = read.readLine()) != null) {
            String[] parts = str.split("\t");
            nameMap.put(parts[0].trim(), String.valueOf(parts[2].trim()) + " (" + parts[1].trim() + ")");
        }
        read.close();
        int i = 0;
        while (i < ttales.length) {
            if (nameMap.get(ttales[i].getId()) == null) {
                System.out.println(ttales[i].getId());
            }
            ttales[i].setId((String)nameMap.get(ttales[i].getId()));
            ++i;
        }
    }

    public static void plotGroups(GraphicsAdaptor adaptor, ClusterTree<TALEFamilyBuilder.TALEFamily> tree, String nameBase) throws IOException {
        FamilyGroupPlotter plotter = new FamilyGroupPlotter(100);
        Graphics2D dummy = adaptor.getGraphics(10, 10);
        int[] dim = plotter.getDimension(dummy, tree);
        Graphics2D graphics = adaptor.getGraphics(dim[0], dim[1]);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dim[0], dim[1]);
        graphics.setColor(Color.black);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        plotter.plot(graphics, tree);
        adaptor.generateOutput(String.valueOf(nameBase) + "." + adaptor.getGraphicsExtension());
    }

    public static void main(String[] args) throws Exception {
        GraphicsAdaptor adaptor = GraphicsAdaptorFactory.getAdaptor(GraphicsAdaptorFactory.OutputFormat.PDF);
        TALE[] tales = TALE.readTALEs(args[0], args[1], args[2]);
        String outpath = args[3];
        TALE[] ttales = TALE.translateTALEs(tales, Tools.Translator.DEFAULT);
        BuildFamilies.rename(ttales);
        double cut = 6.0;
        double pval = 0.01;
        Pair<TALEFamilyBuilder, FamilyResult[]> res = BuildFamilies.build(ttales, cut, pval);
        FamilyResult[] famRes = res.getSecondElement();
        TALgetterDiffSM model = (TALgetterDiffSM)XMLParser.extractObjectForTags(FileManager.readInputStream(ScanForTBSCLI.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/talfinder_obg2_hyp_bg.xml")), "model");
        ClusterTree<TALEFamilyBuilder.TALEFamily> famTree = res.getFirstElement().clusterFamilies();
        BuildFamilies.plotGroups(adaptor, famTree, String.valueOf(outpath) + "/family_tree");
        int i = 0;
        while (i < famRes.length) {
            TALEFamilyBuilder.TALEFamily fam = famRes[i].getFamily();
            fam.plotFamilyToFile(String.valueOf(outpath) + "/family_" + (i + 1), adaptor);
            PrintWriter wr = new PrintWriter(String.valueOf(outpath) + "/family_" + (i + 1) + "_report.txt");
            wr.println(famRes[i].toString(model, res.getFirstElement()));
            wr.close();
            double[][] specs = fam.getSpecificityProfile(model);
            int w = SeqLogoPlotter.getWidth(300, specs);
            Graphics2D graph = adaptor.getGraphics(w, 300);
            String[] labels = new String[specs.length];
            int j = 0;
            while (j < labels.length) {
                labels[j] = String.valueOf(j);
                ++j;
            }
            SeqLogoPlotter.plotLogo(graph, 300, specs, labels, "Position", "bits");
            adaptor.generateOutput(String.valueOf(outpath) + "/family_" + (i + 1) + "_specificity." + adaptor.getGraphicsExtension());
            ++i;
        }
    }

    public static class FamilyResult
    implements Comparable<FamilyResult> {
        private TALEFamilyBuilder.TALEFamily family;
        private TALEFamilyBuilder.TALEFamily[] relatedFams;
        private TALE[][] relatedTALEs;
        private int[][] myTALEs;
        private StringAlignment[][] alignments;
        private double[][] pvals;
        private ClusterTree<TALEFamilyBuilder.TALEFamily> familyTree;

        public FamilyResult(TALEFamilyBuilder.TALEFamily family, TALEFamilyBuilder.TALEFamily[] relatedFams, TALE[][] relatedTALEs, StringAlignment[][] alignments, double[][] pvals, int[][] myTALEs) {
            this.family = family;
            this.relatedFams = relatedFams;
            this.relatedTALEs = relatedTALEs;
            this.alignments = alignments;
            this.myTALEs = myTALEs;
            this.pvals = pvals;
        }

        @Override
        public int compareTo(FamilyResult fr) {
            return this.family.getFamilyId().compareTo(fr.family.getFamilyId());
        }

        public void setSimilarityGroup(ClusterTree<TALEFamilyBuilder.TALEFamily>[] famTrees) {
            int i = 0;
            while (i < famTrees.length) {
                TALEFamilyBuilder.TALEFamily[] fams = famTrees[i].getClusterElements();
                int j = 0;
                while (j < fams.length) {
                    if (fams[j].getFamilyId().equals(this.family.getFamilyId())) {
                        this.familyTree = famTrees[i];
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public TALEFamilyBuilder.TALEFamily getFamily() {
            return this.family;
        }

        public TALEFamilyBuilder.TALEFamily[] getRelatedFams() {
            return this.relatedFams;
        }

        public TALE[][] getRelatedTALEs() {
            return this.relatedTALEs;
        }

        public StringAlignment[][] getAlignments() {
            return this.alignments;
        }

        public String toString(TALgetterDiffSM model, TALEFamilyBuilder builder) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(this.family.toString(model, builder)) + "\n");
            if (this.relatedFams.length == 0) {
                sb.append("No related classes.\n");
            } else {
                TALE[] members = this.family.getFamilyMembers();
                sb.append("Related classes with significant matches:\n");
                int i = 0;
                while (i < this.relatedFams.length) {
                    sb.append("Class " + this.relatedFams[i].getFamilyId() + " with members\n");
                    int j = 0;
                    while (j < this.relatedTALEs[i].length) {
                        sb.append(String.valueOf(this.relatedTALEs[i][j].getId()) + " related to " + members[this.myTALEs[i][j]].getId() + " with score " + format.format(this.alignments[i][j].getCost()) + " (p=" + formatE.format(Math.pow(10.0, this.pvals[i][j])) + ")\n");
                        ++j;
                    }
                    sb.append("\n");
                    sb.append("Alignments:\n");
                    j = 0;
                    while (j < this.alignments[i].length) {
                        sb.append(String.valueOf(this.relatedTALEs[i][j].getId()) + " vs. " + members[this.myTALEs[i][j]].getId() + ":\n");
                        sb.append(String.valueOf(TALEAligner.alignmentToString(this.alignments[i][j], format)) + "\n\n");
                        ++j;
                    }
                    ++i;
                }
            }
            sb.append("\n");
            if (this.familyTree != null) {
                if (this.familyTree.getNumberOfElements() == 1) {
                    sb.append("This class belongs to its own similarity group\n");
                } else {
                    sb.append("This class belongs to a similarity group together with classes ");
                    TALEFamilyBuilder.TALEFamily[] group = this.familyTree.getClusterElements();
                    int j = 0;
                    while (j < group.length) {
                        if (!group[j].getFamilyId().equals(this.family.getFamilyId())) {
                            sb.append(String.valueOf(group[j].getFamilyId()) + ", ");
                        }
                        ++j;
                    }
                    sb.delete(sb.length() - 2, sb.length());
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
    }
}

