/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import projects.xanthogenomes.TALEFamilyBuilder;
import projects.xanthogenomes.TALEFamilyTreePlotter;

public class FamilyGroupPlotter
extends TALEFamilyTreePlotter {
    public FamilyGroupPlotter(int lineHeight) {
        super(lineHeight);
    }

    private double[] getIDFontDimensions(Graphics2D graphics, TALEFamilyBuilder.TALEFamily[] members) {
        double fontHeight = 0.0;
        double fontWidth = 0.0;
        int i = 0;
        while (i < members.length) {
            String id = members[i].getFamilyId();
            Rectangle2D rect = graphics.getFontMetrics().getStringBounds(id, graphics);
            if (rect.getHeight() > fontHeight) {
                fontHeight = rect.getHeight();
            }
            if (rect.getWidth() > fontWidth) {
                fontWidth = rect.getWidth();
            }
            ++i;
        }
        return new double[]{fontWidth, fontHeight};
    }

    private void plotIDs(Graphics2D graphics, TALEFamilyBuilder.TALEFamily[] members, int xoff, int yoff) {
        int i = 0;
        while (i < members.length) {
            graphics.drawString(members[i].getFamilyId(), xoff, yoff);
            yoff += 2 * this.lineHeight;
            graphics.setColor(Color.BLACK);
            ++i;
        }
    }

    public int[] getDimension(Graphics2D graphics, ClusterTree<TALEFamilyBuilder.TALEFamily> tree) {
        int height;
        graphics = (Graphics2D)graphics.create();
        graphics.setFont(new Font("Monospaced", 0, graphics.getFont().getSize()));
        int treeWidth = height = this.getHeight(tree.getNumberOfElements());
        double[] idDim = this.getIDFontDimensions(graphics, tree.getClusterElements());
        double rat = (double)this.lineHeight / idDim[1];
        int idWidth = (int)Math.ceil(idDim[0] * rat);
        return new int[]{treeWidth + idWidth + 2 * this.lineHeight, height + (tree.getNumberOfElements() > 1 ? 2 * this.lineHeight : 0)};
    }

    public PlotGeneratorResult.PlotGenerator getPlotGenerator(ClusterTree<TALEFamilyBuilder.TALEFamily> tree) {
        return new FamilyGroupPlotGenerator(tree);
    }

    public void plot(Graphics2D graphics, ClusterTree<TALEFamilyBuilder.TALEFamily> tree) {
        int height;
        int treeWidth;
        graphics = (Graphics2D)graphics.create();
        graphics.setFont(new Font("Monospaced", 0, graphics.getFont().getSize()));
        TALEFamilyBuilder.TALEFamily[] members = tree.getClusterElements();
        int numMem = members.length;
        int xoff = treeWidth = (height = this.getHeight(numMem));
        int yoff = (int)Math.ceil((double)this.lineHeight * 1.5);
        double[] idDim = this.getIDFontDimensions(graphics, members);
        double rat = (double)this.lineHeight / idDim[1];
        int idWidth = (int)Math.ceil(idDim[0] * rat);
        graphics.setFont(new Font(graphics.getFont().getFontName(), graphics.getFont().getStyle(), (int)Math.floor((double)graphics.getFont().getSize() * rat)));
        this.plotTree(graphics, treeWidth, tree, 0, 0);
        this.plotIDs(graphics, members, xoff, yoff);
    }

    public static class FamilyGroupPlotGenerator
    implements PlotGeneratorResult.PlotGenerator {
        private ClusterTree<TALEFamilyBuilder.TALEFamily> groupTree;

        public FamilyGroupPlotGenerator(ClusterTree<TALEFamilyBuilder.TALEFamily> groupTree) {
            this.groupTree = groupTree;
        }

        public FamilyGroupPlotGenerator(StringBuffer xml) throws NonParsableException {
            this.groupTree = (ClusterTree)XMLParser.extractObjectForTags(xml, "groupTree");
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.groupTree, "groupTree");
            return xml;
        }

        @Override
        public void generatePlot(GraphicsAdaptor adaptor) throws Exception {
            FamilyGroupPlotter plotter = new FamilyGroupPlotter(30);
            Graphics2D dummy = adaptor.getGraphics(10, 10);
            int[] dim = plotter.getDimension(dummy, this.groupTree);
            Graphics2D graphics = adaptor.getGraphics(dim[0], dim[1]);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dim[0], dim[1]);
            graphics.setColor(Color.black);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            plotter.plot(graphics, this.groupTree);
        }
    }
}

