/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.utils.NiceScale;
import de.jstacs.utils.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEFamilyBuilder;

public class TALEFamilyTreePlotter {
    protected static DecimalFormat format = new DecimalFormat();
    protected int lineHeight;

    public TALEFamilyTreePlotter(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    protected int getHeight(int numMem) {
        return numMem * this.lineHeight + (numMem - 1) * this.lineHeight + this.lineHeight;
    }

    private double[] getIDFontDimensions(Graphics2D graphics, TALE[] members) {
        double fontHeight = 0.0;
        double fontWidth = 0.0;
        int i = 0;
        while (i < members.length) {
            String id = members[i].getId();
            Rectangle2D rect = graphics.getFontMetrics().getStringBounds(id, graphics);
            if (rect.getHeight() > fontHeight) {
                fontHeight = rect.getHeight();
            }
            if (rect.getWidth() > fontWidth) {
                fontWidth = rect.getWidth();
            }
            ++i;
        }
        return new double[]{fontWidth, fontHeight};
    }

    private double[] getAlignmentFontDimensions(Graphics2D graphics, TALEFamilyBuilder.TALEFamily family) {
        Pair<TALE[], String[]> pair = family.getInducedMultipleAlignment();
        String[] als = pair.getSecondElement();
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(als[0], graphics);
        return new double[]{rect.getWidth(), rect.getHeight()};
    }

    protected void plotTree(Graphics2D graphics, int treeDim, ClusterTree tree, int xoff, int yoff) {
        graphics = (Graphics2D)graphics.create();
        graphics.setStroke(new BasicStroke((float)this.lineHeight / 15.0f));
        graphics.setFont(new Font("SansSerif", 0, graphics.getFont().getSize() * 2 / 3));
        double minDist = tree.getMinimumDistance();
        double maxDist = tree.getMaximumDistance();
        double rat = (double)((treeDim -= this.lineHeight / 2) - this.lineHeight * 2) / (maxDist - minDist);
        int loc = this.plotEdges(graphics, tree, xoff + this.lineHeight, this.lineHeight / 4, 0, treeDim, maxDist, rat);
        graphics.drawLine(0, loc, this.lineHeight, loc);
        if (tree.getNumberOfElements() > 1) {
            graphics.drawLine(this.lineHeight / 2, treeDim + this.lineHeight, treeDim - this.lineHeight / 2, treeDim + this.lineHeight);
            if (tree.getNumberOfElements() == 2 || minDist == maxDist) {
                int x = this.lineHeight + (int)Math.round((maxDist - tree.getDistance()) * rat);
                graphics.drawLine(x, treeDim + this.lineHeight, x, treeDim + this.lineHeight + this.lineHeight / 4);
                String label = format.format(tree.getDistance());
                int textCenter = (int)Math.round(graphics.getFontMetrics().getStringBounds(label, graphics).getCenterX());
                graphics.drawString(label, x - textCenter, treeDim + this.lineHeight * 2);
            } else {
                NiceScale scale = new NiceScale(minDist, maxDist);
                scale.setMaxTicks(Math.min(tree.getNumberOfElements(), 5));
                double min = scale.getNiceMin();
                double max = scale.getNiceMax();
                double tick = scale.getTickSpacing();
                double i = min;
                while (i <= max + tick / 2.0) {
                    int x;
                    if (i < 1.0E-6 && i > -1.0E-6) {
                        i = 0.0;
                    }
                    if ((x = this.lineHeight + (int)Math.round((maxDist - i) * rat)) > this.lineHeight / 2) {
                        graphics.drawLine(x, treeDim + this.lineHeight, x, treeDim + this.lineHeight + this.lineHeight / 4);
                        String label = format.format(i);
                        int textCenter = (int)Math.round(graphics.getFontMetrics().getStringBounds(label, graphics).getCenterX());
                        graphics.drawString(label, x - textCenter, treeDim + this.lineHeight * 2);
                    }
                    i += tick;
                }
            }
        }
    }

    private int plotEdges(Graphics2D graphics, ClusterTree tree, int xoff, int yoff, int numAtop, int treeWidth, double maxDist, double rat) {
        if (tree.getNumberOfElements() == 1) {
            graphics.drawLine(xoff, yoff + numAtop * this.lineHeight * 2 + this.lineHeight, treeWidth, yoff + numAtop * this.lineHeight * 2 + this.lineHeight);
            return yoff + numAtop * this.lineHeight * 2 + this.lineHeight;
        }
        ClusterTree<T>[] subs = tree.getSubTrees();
        int minPrev = Integer.MAX_VALUE;
        int maxPrev = 0;
        int newXoff = this.lineHeight + (int)Math.round((maxDist - tree.getDistance()) * rat);
        int i = 0;
        while (i < subs.length) {
            int prev = this.plotEdges(graphics, subs[i], newXoff, yoff, numAtop, treeWidth, maxDist, rat);
            if (prev < minPrev) {
                minPrev = prev;
            }
            if (prev > maxPrev) {
                maxPrev = prev;
            }
            numAtop += subs[i].getNumberOfElements();
            ++i;
        }
        graphics.drawLine(xoff, minPrev + (maxPrev - minPrev) / 2, newXoff, minPrev + (maxPrev - minPrev) / 2);
        graphics.drawLine(newXoff, minPrev, newXoff, maxPrev);
        return minPrev + (maxPrev - minPrev) / 2;
    }

    private void plotIDs(Graphics2D graphics, TALE[] members, int xoff, int yoff) {
        int i = 0;
        while (i < members.length) {
            if (members[i].isNew()) {
                graphics.setColor(Color.BLUE);
            }
            graphics.drawString(members[i].getId(), xoff, yoff);
            yoff += 2 * this.lineHeight;
            graphics.setColor(Color.BLACK);
            ++i;
        }
    }

    private void plotTALEAlignment(Graphics2D graphics, TALEFamilyBuilder.TALEFamily family, int xoff, int yoff) {
        Pair<TALE[], String[]> pair = family.getInducedMultipleAlignment();
        String[] als = pair.getSecondElement();
        TALE[] members = pair.getFirstElement();
        String space = " ";
        int spacew = graphics.getFontMetrics().stringWidth(space);
        int i = 0;
        while (i < als.length) {
            if (members[i].isNew()) {
                graphics.setColor(Color.BLUE);
            }
            String[] al = als[i].trim().split(" ");
            int currOff = xoff + spacew;
            int j = 0;
            int r = 0;
            while (j < al.length) {
                Color bef = graphics.getColor();
                if (!"--".equals(al[j]) && r < members[i].getNumberOfRepeats() - 1) {
                    if (members[i].getRepeat(r).getType() == TALE.Type.LONG) {
                        graphics.setColor(Color.RED);
                    } else if (members[i].getRepeat(r).getType() == TALE.Type.SHORT) {
                        graphics.setColor(Color.GREEN);
                    } else if (members[i].getRepeat(r).getType() == TALE.Type.THIRTYFIVE) {
                        graphics.setColor(Color.GRAY);
                    }
                    ++r;
                }
                graphics.drawString(al[j], currOff, yoff);
                int w = graphics.getFontMetrics().stringWidth(al[j]);
                currOff += w + spacew;
                graphics.setColor(bef);
                ++j;
            }
            graphics.setColor(Color.BLACK);
            yoff += this.lineHeight;
            if (i < als.length - 1) {
                String[] s1 = als[i].trim().split(" ");
                String[] s2 = als[i + 1].trim().split(" ");
                currOff = xoff + spacew;
                int j2 = 0;
                int r1 = 0;
                int r2 = 0;
                while (j2 < s1.length) {
                    int k = 0;
                    while (k < 2) {
                        Color bef = graphics.getColor();
                        if (s1[j2].charAt(k) == '-' || s2[j2].charAt(k) == '-') {
                            currOff += spacew;
                        } else if (s1[j2].charAt(k) == s2[j2].charAt(k)) {
                            String cod1 = members[i].getCodon(r1, k);
                            String cod2 = members[i + 1].getCodon(r2, k);
                            if (cod1 != null && cod2 != null && !cod1.equals(cod2)) {
                                graphics.setColor(Color.RED);
                            }
                            graphics.drawString("|", currOff, yoff);
                            currOff += graphics.getFontMetrics().stringWidth("|");
                        } else {
                            graphics.drawString(":", currOff, yoff);
                            currOff += graphics.getFontMetrics().stringWidth(":");
                        }
                        graphics.setColor(bef);
                        ++k;
                    }
                    if (!"--".equals(s1[j2])) {
                        ++r1;
                    }
                    if (!"--".equals(s2[j2])) {
                        ++r2;
                    }
                    currOff += spacew;
                    ++j2;
                }
                yoff += this.lineHeight;
            }
            ++i;
        }
    }

    public int[] getDimension(Graphics2D graphics, TALEFamilyBuilder.TALEFamily family) {
        int height;
        graphics = (Graphics2D)graphics.create();
        graphics.setFont(new Font("Monospaced", 0, graphics.getFont().getSize()));
        int treeWidth = height = this.getHeight(family.getFamilySize());
        double[] idDim = this.getIDFontDimensions(graphics, family.getFamilyMembers());
        double rat = (double)this.lineHeight / idDim[1];
        int idWidth = (int)Math.ceil(idDim[0] * rat);
        double[] alDim = this.getAlignmentFontDimensions(graphics, family);
        return new int[]{treeWidth + idWidth + (int)Math.ceil(alDim[0] * rat) + 2 * this.lineHeight, height + (family.getFamilySize() > 1 ? 2 * this.lineHeight : 0)};
    }

    public void plot(Graphics2D graphics, TALEFamilyBuilder.TALEFamily family) {
        int height;
        int treeWidth;
        graphics = (Graphics2D)graphics.create();
        graphics.setFont(new Font("Monospaced", 0, graphics.getFont().getSize()));
        ClusterTree<TALE> tree = family.getTree();
        TALE[] members = tree.getClusterElements();
        int numMem = family.getFamilySize();
        int xoff = treeWidth = (height = this.getHeight(numMem));
        int yoff = (int)Math.ceil((double)this.lineHeight * 1.5);
        double[] idDim = this.getIDFontDimensions(graphics, members);
        double rat = (double)this.lineHeight / idDim[1];
        int idWidth = (int)Math.ceil(idDim[0] * rat);
        graphics.setFont(new Font(graphics.getFont().getFontName(), graphics.getFont().getStyle(), (int)Math.floor((double)graphics.getFont().getSize() * rat)));
        this.plotTree(graphics, treeWidth, family.getTree(), 0, 0);
        this.plotIDs(graphics, members, xoff, yoff);
        this.plotTALEAlignment(graphics, family, xoff += idWidth, yoff);
    }
}

