/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes.tools;

import de.jstacs.DataType;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.LinkedList;
import projects.xanthogenomes.SplitTALEs;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.Tools;

public class TALEAnalysisTool
implements JstacsTool {
    @Override
    public ToolParameterSet getToolParameters() {
        try {
            SimpleParameter name = new SimpleParameter(DataType.STRING, "Name", "A name for this run of " + this.getToolName(), false);
            FileParameter fp = new FileParameter("TALE DNA sequences", "The DNA sequences of the TALEs", "fasta,fa,fas,fna", true);
            fp.setExtendedType("fasta/dna");
            return new ToolParameterSet(this.getShortName(), name, fp);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        String name = (String)parameters.getParameterAt(0).getValue();
        FileParameter fp = (FileParameter)parameters.getParameterAt(1);
        FileParameter.FileRepresentation fr = fp.getFileContents();
        BufferedReader br = new BufferedReader(new StringReader(fr.getContent()));
        DataSet ds = new DataSet(DNAAlphabetContainer.SINGLETON, new SparseStringExtractor(br, '>', "", (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()));
        StringBuffer dnaTALEs = new StringBuffer();
        StringBuffer protTALEs = new StringBuffer();
        StringBuffer rvdTALEs = new StringBuffer();
        progress.setLast(ds.getNumberOfElements());
        progress.setCurrent(0.0);
        protocol.append("Analyzing TALEs:\n");
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            String id = ds.getElementAt(i).getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue().toString();
            protocol.append(String.valueOf(id) + "\n");
            TALE[] tales = SplitTALEs.split(id, ds.getElementAt(i), protocol);
            TALE dna = tales[0];
            if (dna != null) {
                dnaTALEs.append(">" + id + ": N-terminus\n" + dna.getStart().toString() + "\n");
                int j = 0;
                while (j < dna.getNumberOfRepeats()) {
                    dnaTALEs.append(">" + id + ": repeat " + (j + 1) + "\n" + dna.getRepeat(j).getRepeat().toString() + "\n");
                    ++j;
                }
                dnaTALEs.append(">" + id + ": C-terminus\n" + dna.getEnd().toString() + "\n");
            } else {
                protocol.appendWarning("TALE " + id + " could not be analyzed, splitting into regions failed.\n");
            }
            TALE prot = tales[1];
            if (prot != null) {
                Sequence rvds = tales[1].getRvdSequence();
                protTALEs.append(">" + id + ": N-terminus\n" + prot.getStart().toString() + "\n");
                int j = 0;
                while (j < prot.getNumberOfRepeats()) {
                    protTALEs.append(">" + id + ": repeat " + (j + 1) + "\n" + prot.getRepeat(j).getRepeat().toString() + "\n");
                    ++j;
                }
                protTALEs.append(">" + id + ": C-terminus\n" + prot.getEnd().toString() + "\n");
                String rvdStr = rvds.toString("-", 0, rvds.getLength());
                if (prot.containsAberrantRepeat()) {
                    CharSequence[] rvdAr = rvdStr.split("-");
                    int j2 = 0;
                    while (j2 < prot.getNumberOfRepeats() - 1) {
                        if (prot.getRepeat(j2).getType() == TALE.Type.LONG || prot.getRepeat(j2).getType() == TALE.Type.SHORT) {
                            rvdAr[j2] = ((String)rvdAr[j2]).toLowerCase();
                        }
                        ++j2;
                    }
                    rvdStr = String.join((CharSequence)"-", rvdAr);
                }
                rvdTALEs.append(">" + id + "\n" + rvdStr + "\n");
                progress.setCurrent(i);
            } else {
                protocol.appendWarning("Protein version of TALE " + id + " could not be analyzed, splitting into regions failed.\n");
            }
            ++i;
        }
        protocol.append("\nWriting outputs.\n");
        String names = name == null || name.length() == 0 ? "" : " (" + name + ")";
        TextResult fr1 = new TextResult("TALE DNA parts" + names, "Parts of the TALE (N-/C-terminus, repeats) as DNA sequences", new FileParameter.FileRepresentation("", dnaTALEs.toString()), "fasta", "TALE Analysis", "fasta/dna", true);
        TextResult fr2 = new TextResult("TALE Protein parts" + names, "Parts of the TALE (N-/C-terminus, repeats) as protein sequences", new FileParameter.FileRepresentation("", protTALEs.toString()), "fasta", "TALE Analysis", "fasta/as", true);
        TextResult fr3 = new TextResult("TALE RVDs" + names, "Sequence of RVDs of the TALEs", new FileParameter.FileRepresentation("", rvdTALEs.toString()), "fasta", "TALE Analysis", "fasta/rvd", true);
        ResultSet set = new ResultSet(new Result[][]{{fr1, fr2, fr3}});
        return new ToolResult("Result of " + this.getToolName() + names, String.valueOf(this.getToolName()) + " on \"" + fr.getFilename() + "\"", null, set, parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    public static TALE[] parseTALEsFromParts(String content, Protocol protocol) throws Exception {
        DataSet ds = null;
        try {
            BufferedReader br = new BufferedReader(new StringReader(content));
            ds = new DataSet(DNAAlphabetContainer.SINGLETON, new SparseStringExtractor(br, '>', "", (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()));
        }
        catch (Exception e) {
            try {
                BufferedReader br = new BufferedReader(new StringReader(content));
                ds = new DataSet(Tools.ProteinAlphabetContainer.SINGLETON, new SparseStringExtractor(br, '>', "", (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()));
            }
            catch (Exception ex) {
                throw e;
            }
        }
        String lastid = null;
        Sequence nterm = null;
        Sequence cterm = null;
        LinkedList<Sequence> repeats = new LinkedList<Sequence>();
        LinkedList<TALE> tales = new LinkedList<TALE>();
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            String part;
            Sequence seq = ds.getElementAt(i);
            String name = seq.getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue().toString();
            int colon = name.lastIndexOf(":");
            String id = name.substring(0, colon).trim();
            if (lastid != null && !lastid.equals(id)) {
                if (repeats.size() > 0) {
                    TALE.Repeat[] repeatss = new TALE.Repeat[repeats.size()];
                    int j = 0;
                    while (j < repeats.size()) {
                        repeatss[j] = new TALE.Repeat((Sequence)repeats.get(j));
                        ++j;
                    }
                    TALE t = new TALE(lastid, nterm, repeatss, cterm, false);
                    if (ds.getAlphabetContainer().checkConsistency(DNAAlphabetContainer.SINGLETON)) {
                        try {
                            t = t.getTranslatedTALE(Tools.Translator.DEFAULT);
                        }
                        catch (Exception e) {
                            protocol.appendWarning("Could not translate TALE " + t.getId() + ". Reason:\n" + e.getMessage() + "\n");
                            t = null;
                        }
                    }
                    if (t != null) {
                        tales.add(t);
                    }
                } else {
                    protocol.appendWarning("Removed TALE " + lastid + ", because it has zero repeats.\n");
                }
                nterm = null;
                cterm = null;
                repeats.clear();
            }
            if ("N-terminus".equals(part = name.substring(colon + 1).trim())) {
                nterm = seq;
            } else if ("C-terminus".equals(part)) {
                cterm = seq;
            } else if (part.startsWith("repeat")) {
                repeats.add(seq);
            } else {
                throw new Exception();
            }
            lastid = id;
            ++i;
        }
        if (cterm != null && nterm != null && repeats.size() > 0) {
            TALE.Repeat[] repeatss = new TALE.Repeat[repeats.size()];
            int j = 0;
            while (j < repeats.size()) {
                repeatss[j] = new TALE.Repeat((Sequence)repeats.get(j));
                ++j;
            }
            TALE t = new TALE(lastid, nterm, repeatss, cterm, false);
            if (ds.getAlphabetContainer().checkConsistency(DNAAlphabetContainer.SINGLETON)) {
                t = t.getTranslatedTALE(Tools.Translator.DEFAULT);
            }
            tales.add(t);
        }
        return tales.toArray(new TALE[0]);
    }

    @Override
    public String getToolName() {
        return "TALE Analysis";
    }

    @Override
    public String getShortName() {
        return "analyze";
    }

    @Override
    public String getDescription() {
        return "Analyzes TALE structure and RVDs";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(TALEAnalysisTool.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/tools/TALEAnalysisTool.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getToolVersion() {
        return "1.4.1";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return new String[]{"@article{grau16annotale,\n\ttitle = {{AnnoTALE}: bioinformatics tools for identification, annotation, and nomenclature of {TALEs} from \\emph{Xanthomonas} genomic sequences},\n\tauthor = {Grau, Jan and Reschke, Maik and Erkes, Annett and Streubel, Jana and Morgan, Richard D. and Wilson, Geoffrey G. and Koebnik, Ralf and Boch, Jens},\n\tjournal = {Scientific Reports},\n\tyear = {2016},\n\tvolume = {6},\n\tpages = {21077},\n\tdoi = {10.1038/srep21077}\n\t}\n"};
    }
}

