/*
 * Decompiled with CFR 0.152.
 */
package supplementary;

import de.jstacs.io.FileManager;
import de.jstacs.utils.SafeOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class Tex2Wiki {
    private static final String HOME = "./supplementary/cookbook/";
    private static final String START = "\\begin{document}";
    private static final String END = "\\end{document}";
    private static final String CMD = "\\newcommand{";
    private static final String INPUT = "\\input{";
    private static final String OPEN = "{";
    private static final String CLOSE = "}";
    private static HashMap<Character, Character> tag = new HashMap();
    private static HashMap<String, Replacement> hash;
    private static ArrayList<String> list;
    private static HashMap<String, int[]> counter;

    static {
        tag.put(Character.valueOf('{'), Character.valueOf('}'));
        tag.put(Character.valueOf('['), Character.valueOf(']'));
        tag.put(Character.valueOf('('), Character.valueOf(')'));
        hash = new HashMap(50);
        list = new ArrayList();
        counter = new HashMap();
    }

    private static boolean isOkay(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static int findOpeningTag(String tag, int startIdx, StringBuffer s) {
        return s.indexOf(tag, startIdx);
    }

    private static char getEndTag(char c) {
        Character end = tag.get(Character.valueOf(c));
        if (end == null) {
            return c;
        }
        return end.charValue();
    }

    private static int findClosingTag(int startIdx, StringBuffer s) throws Exception {
        char startTag = s.charAt(startIdx);
        char endTag = Tex2Wiki.getEndTag(startTag);
        String eTag = "" + endTag;
        String sTag = "" + startTag;
        return Tex2Wiki.findClosingTag(++startIdx, sTag, eTag, s);
    }

    private static int findClosingTag(int startIdx, String sTag, String eTag, StringBuffer s) throws Exception {
        int idx;
        int hh = startIdx;
        int anz = 1;
        do {
            int h;
            idx = s.indexOf(eTag, startIdx);
            --anz;
            while ((h = s.indexOf(sTag, startIdx)) < idx && h > 0) {
                ++anz;
                startIdx = h + 1;
            }
            startIdx = idx + 1;
        } while (idx > 0 && anz > 0);
        if (idx < 0) {
            System.out.println("CLOSE?\t" + s.substring(hh));
            throw new Exception("could not parse: did not find closing \"" + eTag + "\"");
        }
        return idx;
    }

    private static void add(StringBuffer s, HashMap<String, Replacement> hash) throws Exception {
        String rep;
        int idx2;
        int idx1;
        int startIdx = 0;
        while ((idx1 = s.indexOf(CMD, startIdx)) >= 0) {
            int params;
            idx2 = s.indexOf(CLOSE, idx1);
            int idx3 = Tex2Wiki.findOpeningTag(OPEN, idx2 + 1, s);
            int idx4 = Tex2Wiki.findClosingTag(idx3, s);
            String cmd = s.substring(idx1 + CMD.length(), idx2).trim();
            rep = s.substring(idx3 + 1, idx4);
            if (idx2 + 1 == idx3) {
                params = 0;
            } else if (s.charAt(idx2 + 1) == '[' && s.charAt(idx3 - 1) == ']') {
                params = Integer.parseInt(s.substring(idx2 + 2, idx3 - 1));
            } else {
                throw new Exception("could not parse command");
            }
            hash.put(cmd, new SimpleReplacement(params, rep));
            startIdx = idx4 + 1;
        }
        startIdx = 0;
        while ((idx1 = s.indexOf(INPUT, startIdx)) >= 0) {
            idx2 = s.indexOf(CLOSE, idx1);
            rep = s.substring(idx1 + INPUT.length(), idx2);
            StringBuffer sb = FileManager.readFile(new File(HOME + rep));
            Tex2Wiki.add(sb, hash);
            startIdx = idx2 + 1;
        }
    }

    public static void main(String[] args) throws Exception {
        hash.put("\\newcommand", new NewCommandReplacement(null, null));
        hash.put("\\renewcommand", new RenewCommandReplacement());
        hash.put("\\section", new SimpleReplacement(1, ""));
        hash.put("\\subsection", new SimpleReplacement(1, "== #1 =="));
        hash.put("\\subsubsection", new SimpleReplacement(1, "=== #1 ==="));
        hash.put("\\emph", new SimpleReplacement(1, "''#1''"));
        hash.put("\\textit", new SimpleReplacement(1, "''#1''"));
        hash.put("\\textbf", new SimpleReplacement(1, "'''#1'''"));
        hash.put("\\textsc", new SimpleReplacement(1, "<span style=\"font-variant: small-caps;\">#1</span>"));
        hash.put("\\href", new SimpleReplacement(2, "[#1 #2]"));
        hash.put("\\url", new SimpleReplacement(1, "[#1 #1]"));
        hash.put("\\caption", new SimpleReplacement(1, "#1"));
        hash.put("\\lstinline", new SimpleReplacement(1, "<code>#1</code>"));
        hash.put("\\label", new SimpleReplacement(1, "\n<span id=\"#1\"> </span>"));
        hash.put("\\ref", new SimpleReplacement(1, "[[##1 (link)]]"));
        hash.put("\\lstset", new SimpleReplacement(1, ""));
        hash.put("\\textcolor", new SimpleReplacement(2, "<font color=#1>#2</font>"));
        hash.put("\\newcounter", new NewCounterReplacement());
        hash.put("\\setcounter", new SetCounterReplacement());
        hash.put("\\stepcounter", new StepCounterReplacement());
        hash.put("\\addtocounter", new AddToCounterReplacement());
        hash.put("\\code", new CodeReplacement());
        hash.put("\\begin", new EnvironmentReplacement());
        Tex2Wiki.createWiki(false, "defs", System.out);
        Tex2Wiki.createWiki(true, "preface", System.out);
        Tex2Wiki.createWiki(true, "quickstart", System.out);
        Tex2Wiki.createWiki(true, "data", System.out);
        Tex2Wiki.createWiki(true, "infrastructure", System.out);
        Tex2Wiki.createWiki(true, "sequenceScore", System.out);
        Tex2Wiki.createWiki(true, "classifier", System.out);
        Tex2Wiki.createWiki(true, "optimization", System.out);
        Tex2Wiki.createWiki(true, "goodies", System.out);
        Tex2Wiki.createWiki(true, "recipes", System.out);
    }

    private static void createWiki(boolean create, String file, OutputStream out) throws Exception {
        int end;
        SafeOutputStream sos = SafeOutputStream.getSafeOutputStream(out);
        System.out.println("--------------------------------------------------");
        System.out.println(file);
        File f = new File("./supplementary/cookbook//../wiki/");
        if (!f.exists()) {
            System.out.println("CREATE WIKI DIRECTORY\t" + f.mkdirs());
        }
        StringBuffer s = FileManager.readFile(new File(HOME + file + ".tex"));
        int start = 0;
        while ((start = s.indexOf("%", 0)) >= 0) {
            if (s.charAt(start - 1) != '\\') {
                end = s.indexOf("\n", start + 1);
                if (end < 0) {
                    end = s.length();
                }
                s.delete(start, end);
                continue;
            }
            ++start;
        }
        start = s.indexOf(START);
        end = s.indexOf(END);
        StringBuffer wiki = new StringBuffer(s.toString().replaceAll("\\\\\\\\", "\n").replaceAll("~", " ").replaceAll("\\\\&", "&").replaceAll("''", "&quot;").replaceAll("``", "&quot;"));
        if (start >= 0 && end >= 0) {
            wiki = new StringBuffer(wiki.substring(start + START.length(), end));
        } else if (start >= 0 || end >= 0) {
            throw new Exception("could not localize part for parsing");
        }
        int idx1 = 0;
        while ((idx1 = wiki.indexOf("\\", idx1)) >= 0) {
            int idx2 = idx1 + 1;
            while (Tex2Wiki.isOkay(wiki.charAt(idx2))) {
                ++idx2;
            }
            String cmd = wiki.substring(idx1, idx2);
            Replacement e = hash.get(cmd);
            try {
                if (e == null) {
                    ++idx1;
                    sos.writeln("PROBLEM\t" + cmd);
                    continue;
                }
                list.clear();
                idx1 = e.replace(wiki, idx1, idx2);
            }
            catch (Exception ex) {
                System.out.println("ERROR\t" + cmd + "\t" + ex.getMessage());
                ex.printStackTrace();
                ++idx1;
            }
        }
        idx1 = 0;
        boolean open = true;
        while ((idx1 = wiki.indexOf("$", idx1)) >= 0) {
            if (idx1 > 0 && wiki.charAt(idx1 - 1) != '\\') {
                wiki.replace(idx1, idx1 + 1, open ? "<math>" : "</math>");
                idx1 += open ? 6 : 7;
                open = !open;
                continue;
            }
            ++idx1;
        }
        if (create) {
            FileManager.writeFile(new File("./supplementary/cookbook//../wiki/" + file + ".wiki"), (CharSequence)wiki);
        }
    }

    private static int fillParams(StringBuffer wiki, int idx2, int anz) throws Exception {
        int idx4 = idx2;
        int i = 0;
        while (i < anz) {
            int idx3 = idx4;
            idx4 = Tex2Wiki.findClosingTag(idx3, wiki);
            list.add(wiki.substring(idx3 + 1, idx4));
            ++idx4;
            ++i;
        }
        return idx4;
    }

    private static class AddToCounterReplacement
    implements Replacement {
        private AddToCounterReplacement() {
        }

        @Override
        public int replace(StringBuffer wiki, int start, int startParams) throws Exception {
            int end = Tex2Wiki.fillParams(wiki, startParams, 2);
            int[] c = (int[])counter.get(list.get(0));
            c[0] = c[0] + Integer.parseInt((String)list.get(1));
            wiki.delete(start, end);
            return start;
        }
    }

    private static class CodeReplacement
    implements Replacement {
        private CodeReplacement() {
        }

        @Override
        public int replace(StringBuffer wiki, int start, int startParams) throws Exception {
            int end = Tex2Wiki.fillParams(wiki, startParams, 1);
            int off = ((int[])counter.get("off"))[0];
            StringBuffer _new = new StringBuffer();
            _new.append("<source lang=\"java5\" enclose=\"div\">\n");
            String s = "\\codefile";
            while ((s = ((SimpleReplacement)hash.get((Object)s)).template).charAt(0) == '\\') {
            }
            BufferedReader r = new BufferedReader(new FileReader(Tex2Wiki.HOME + s));
            int i = 1;
            while (i < off) {
                r.readLine();
                ++i;
            }
            int anz = Integer.parseInt((String)list.get(0));
            String prefix = null;
            int i2 = 0;
            while (i2 <= anz) {
                String line = r.readLine();
                if (i2 == 0) {
                    int p = 0;
                    while (p < line.length() && line.charAt(p) == '\t') {
                        ++p;
                    }
                    prefix = line.substring(0, p);
                }
                if (line.startsWith(prefix)) {
                    line = line.substring(prefix.length());
                } else if (line.length() > 0) {
                    System.out.println("WARNING " + this.getClass().getSimpleName() + "\t" + (off + i2) + "\t" + s + "\t\"" + line + "\"");
                }
                _new.append(line);
                _new.append("\n");
                ++i2;
            }
            r.close();
            _new.append("</source>\n");
            wiki.replace(start, end, _new.toString());
            return start + _new.length();
        }
    }

    private static class EnvironmentReplacement
    implements Replacement {
        private EnvironmentReplacement() {
        }

        @Override
        public int replace(StringBuffer wiki, int start, int startParams) throws Exception {
            int end = Tex2Wiki.fillParams(wiki, startParams, 1);
            int end2 = Tex2Wiki.findClosingTag(end, "\\begin{" + (String)list.get(0) + Tex2Wiki.CLOSE, "\\end{" + (String)list.get(0) + Tex2Wiki.CLOSE, wiki);
            int x = wiki.indexOf("\\begin", start + 1);
            if (x > -1 && x < end2) {
                System.out.println("WARNING: nested environments (cf. \\begin{" + (String)list.get(0) + "})");
            }
            int res = start;
            StringBuffer _new = new StringBuffer();
            String s = (String)list.get(0);
            if (s.equals("itemize")) {
                String h = wiki.substring(end, end2);
                h = h.replaceAll("[ \\t]*\\\\item", "*");
                _new.append(h);
            } else if (s.equals("figure")) {
                String h = wiki.substring(end, end2);
                System.out.println(h);
                _new.append("[[File:TODO|thumb|");
                _new.append(h);
                _new.append("]]\n");
            } else if (s.equals("align*") || s.equals("align") || s.equals("equation*") || s.equals("equation") || s.equals("eqnarray*") || s.equals("eqnarray")) {
                String s2 = wiki.substring(end, end2);
                String s3 = s;
                if (s.endsWith("*")) {
                    s3 = s.substring(0, s.length() - 1);
                }
                _new.append("\n<math>");
                _new.append("\\begin{");
                res += _new.length();
                _new.append(s3);
                _new.append("}\n");
                _new.append(s2);
                _new.append("\n\\end{");
                _new.append(s3);
                _new.append(Tex2Wiki.CLOSE);
                _new.append("</math>\n");
            } else if (s.equals("lstlisting")) {
                String s2 = wiki.substring(end, end2);
                String lang = "java5";
                if (s2.startsWith("[")) {
                    int end3 = s2.indexOf("]");
                    if (s2.startsWith("[language=")) {
                        lang = s2.substring(10, end3);
                    }
                    s2 = s2.substring(end3 + 1);
                }
                _new.append("<source lang=\"" + lang + "\" enclose=\"div\">");
                _new.append(s2);
                _new.append("</source>");
            } else {
                throw new Exception(s);
            }
            wiki.replace(start, end2 + s.length() + 2 + 4, _new.toString());
            return res;
        }
    }

    private static class NewCommandReplacement
    implements Replacement {
        private NewCommandReplacement() {
        }

        @Override
        public int replace(StringBuffer wiki, int start, int startParams) throws Exception {
            int end = Tex2Wiki.fillParams(wiki, startParams, 1);
            this.delete();
            int anz = wiki.charAt(end) == '[' ? 2 : 1;
            int end2 = Tex2Wiki.fillParams(wiki, end, anz);
            anz = anz == 2 ? Integer.parseInt((String)list.get(1)) : 0;
            hash.put((String)list.get(0), new SimpleReplacement(anz, (String)list.get(list.size() - 1)));
            wiki.delete(start, end2);
            return start;
        }

        private void delete() {
        }

        /* synthetic */ NewCommandReplacement(NewCommandReplacement newCommandReplacement, NewCommandReplacement newCommandReplacement2) {
            this();
        }
    }

    private static class NewCounterReplacement
    implements Replacement {
        private NewCounterReplacement() {
        }

        @Override
        public int replace(StringBuffer wiki, int start, int startParams) throws Exception {
            int end = Tex2Wiki.fillParams(wiki, startParams, 1);
            counter.put((String)list.get(0), new int[1]);
            wiki.delete(start, end);
            return start;
        }
    }

    private static class RenewCommandReplacement
    extends NewCommandReplacement {
        private RenewCommandReplacement() {
        }

        private void delete() {
            hash.remove(list.get(0));
        }
    }

    private static interface Replacement {
        public int replace(StringBuffer var1, int var2, int var3) throws Exception;
    }

    private static class SetCounterReplacement
    implements Replacement {
        private SetCounterReplacement() {
        }

        @Override
        public int replace(StringBuffer wiki, int start, int startParams) throws Exception {
            int v;
            int end = Tex2Wiki.fillParams(wiki, startParams, 2);
            int[] c = (int[])counter.get(list.get(0));
            try {
                v = Integer.parseInt((String)list.get(1));
            }
            catch (Exception e) {
                String s = (String)list.get(1);
                v = ((int[])counter.get(s.substring(8, s.length() - 1)))[0];
            }
            if (c == null) {
                counter.put((String)list.get(0), new int[]{v});
            } else {
                c[0] = v;
            }
            wiki.delete(start, end);
            return start;
        }
    }

    private static class SimpleReplacement
    implements Replacement {
        int anz;
        String template;

        public SimpleReplacement(int anz, String template) {
            this.anz = anz;
            this.template = template;
        }

        @Override
        public int replace(StringBuffer wiki, int start, int startParams) throws Exception {
            int end = Tex2Wiki.fillParams(wiki, startParams, this.anz);
            String result = this.template;
            int anz = list.size();
            while (anz > 0) {
                String h = "#" + anz;
                --anz;
                while (result.indexOf(h) >= 0) {
                    result = result.replace(h, (CharSequence)list.get(anz));
                }
            }
            wiki.replace(start, end, result);
            return start;
        }
    }

    private static class StepCounterReplacement
    implements Replacement {
        private StepCounterReplacement() {
        }

        @Override
        public int replace(StringBuffer wiki, int start, int startParams) throws Exception {
            int end = Tex2Wiki.fillParams(wiki, startParams, 1);
            int[] nArray = (int[])counter.get(list.get(0));
            nArray[0] = nArray[0] + 1;
            wiki.delete(start, end);
            return start;
        }
    }
}

