/*
 * Decompiled with CFR 0.152.
 */
package supplementary.cookbook;

import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.algorithms.alignment.cost.SimpleCosts;
import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.algorithms.optimization.NumericalDifferentiableFunction;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.termination.CombinedCondition;
import de.jstacs.algorithms.optimization.termination.IterationCondition;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.algorithms.optimization.termination.SmallGradientConditon;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.assessment.KFoldCrossValidation;
import de.jstacs.classifiers.assessment.KFoldCrossValidationAssessParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.DoesNothingLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasure;
import de.jstacs.classifiers.trainSMBased.TrainSMBasedClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.GenericComplementableDiscreteAlphabet;
import de.jstacs.data.bioJava.BioJavaAdapter;
import de.jstacs.data.bioJava.SimpleSequenceIterator;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SequenceScoringParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.MeanResultSet;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.sampling.BurnInTest;
import de.jstacs.sampling.VarianceRatioBurnInTest;
import de.jstacs.sampling.VarianceRatioBurnInTestParameterSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.IndependentProductDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.btMeasures.BTExplainingAwayResidual;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.MixtureDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.ExtendedZOOPSDiffSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.DifferentiableStatisticalModelWrapperTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.BayesianNetworkTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.BayesianNetworkTrainSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.HMMFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.DifferentiableHigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.HigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.DiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.BaumWelchParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.HMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.NumericalHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.BasicHigherOrderTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.TransitionElement;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.MixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.StrandTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.motif.ZOOPSTrainSM;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.SubclassFinder;
import de.jstacs.utils.ToolBox;
import java.util.LinkedList;
import java.util.Random;
import org.biojava.bio.seq.SequenceIterator;
import org.biojavax.bio.db.ncbi.GenbankRichSequenceDB;

public class Cookbook {
    public static void main(String[] args) throws Exception {
        Cookbook.trainSMs();
    }

    public static void data() throws Exception {
        DNAAlphabet dna = DNAAlphabet.SINGLETON;
        DiscreteAlphabet discrete = new DiscreteAlphabet(false, "W", "S", "w", "x");
        DiscreteAlphabet numerical = new DiscreteAlphabet(3, 10);
        ContinuousAlphabet continuousInf = new ContinuousAlphabet();
        ContinuousAlphabet continuousPos = new ContinuousAlphabet(0.0, 100.0);
        int[] nArray = new int[2];
        nArray[0] = 1;
        GenericComplementableDiscreteAlphabet complementable = new GenericComplementableDiscreteAlphabet(true, new String[]{"A", "B"}, nArray);
        DNAAlphabetContainer dnaContainer = DNAAlphabetContainer.SINGLETON;
        AlphabetContainer contContainer = new AlphabetContainer((Alphabet)continuousInf);
        AlphabetContainer mixedContainer = new AlphabetContainer(dna, discrete, continuousPos);
        int[] nArray2 = new int[6];
        nArray2[2] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        AlphabetContainer complex = new AlphabetContainer(new Alphabet[]{dna, continuousInf}, nArray2);
        Sequence dnaSeq = Sequence.create(dnaContainer, "ACGTACGTACGT");
        Sequence contSeq = Sequence.create(contContainer, "0.5 1.32642 99.5 20.4 5 7.7", " ");
        Sequence mixedSeq = Sequence.create(mixedContainer, "C;x;5.67", ";");
        SparseSequence sparse = new SparseSequence((AlphabetContainer)dnaContainer, "ACGTACGTACGT");
        int length = dnaSeq.getLength();
        int value = dnaSeq.discreteVal(2);
        double value2 = contSeq.continuousVal(5);
        Sequence contSub = contSeq.getSubSequence(2, 3);
        Sequence revComp = dnaSeq.reverseComplement();
        Sequence subComp = dnaSeq.complement(3, 6);
        PermutedSequence permuted = new PermutedSequence(dnaSeq);
        Sequence annotatedDnaSeq = dnaSeq.annotate(true, new MotifAnnotation("new motif", 3, 5, StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD, new Result[0]));
        SequenceAnnotation[] allAnnotations = annotatedDnaSeq.getAnnotation();
        MotifAnnotation motif = (MotifAnnotation)annotatedDnaSeq.getSequenceAnnotationByType("Motif", 0);
        DNADataSet dnaDataSet = new DNADataSet("myfile.fa");
        DataSet contDataSet = new DataSet(contContainer, (AbstractStringExtractor)new SparseStringExtractor("myfile.tab", '#'), "\t");
        DataSet sparseDataSet = SparseSequence.getDataSet((AlphabetContainer)dnaContainer, new SparseStringExtractor("myfile.fa", '>'));
        Sequence fifth = dnaDataSet.getElementAt(5);
        int i = 0;
        while (i < dnaDataSet.getNumberOfElements()) {
            System.out.println(dnaDataSet.getElementAt(i));
            ++i;
        }
        for (Sequence seq : contDataSet) {
            System.out.println(seq.getLength());
        }
        DataSet infix = dnaDataSet.getInfixDataSet(3, 10);
        DataSet suffix = dnaDataSet.getSuffixDataSet(7);
        DataSet allRevComplements = dnaDataSet.getReverseComplementaryDataSet();
        DataSet[] fiveParts = dnaDataSet.partition(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS, 5);
        DataSet[] randParts = dnaDataSet.partition(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_SYMBOLS, 0.1, 0.2, 0.7);
        DataSet sliding = new DataSet(dnaDataSet, 8);
        DNADataSet dnaWithComments = new DNADataSet("myfile.fa", '>', new SimpleSequenceAnnotationParser());
        String comment = dnaWithComments.getElementAt(0).getAnnotation()[0].getResultAt(0).getValue().toString();
        DNADataSet dnaWithParsedComments = new DNADataSet("myfile.fa", '>', new SplitSequenceAnnotationParser("=", ";"));
        SequenceAnnotation[] allAnnotations2 = dnaWithParsedComments.getElementAt(0).getAnnotation();
        GenbankRichSequenceDB db = new GenbankRichSequenceDB();
        SimpleSequenceIterator dbIterator = new SimpleSequenceIterator(db.getRichSequence("NC_001284"), db.getRichSequence("NC_000932"));
        DataSet fromBioJava = BioJavaAdapter.sequenceIteratorToDataSet(dbIterator, null, null);
        SequenceIterator backFromJstacs = BioJavaAdapter.dataSetToSequenceIterator(fromBioJava, true, false);
    }

    public static void xmlParser() throws Exception {
        StringBuffer buffer = new StringBuffer();
        int integer = 5;
        XMLParser.appendObjectWithTags(buffer, integer, "integer");
        String bar = "hello world";
        XMLParser.appendObjectWithTags(buffer, bar, "foo");
        double[][] da = new double[4][6];
        XMLParser.appendObjectWithTags(buffer, da, "da");
        HomogeneousMM hMM = new HomogeneousMM(new HomMMParameterSet(DNAAlphabetContainer.SINGLETON, 4.0, "hmm(0)", 0));
        XMLParser.appendObjectWithTags(buffer, hMM, "hMM");
        Storable[] storAr = (Storable[])ArrayHandler.createArrayOf((Cloneable)hMM, (int)5);
        XMLParser.appendObjectWithTags(buffer, storAr, "storAr");
        integer = (Integer)XMLParser.extractObjectForTags(buffer, "integer");
        da = XMLParser.extractObjectForTags(buffer, "da", double[][].class);
        hMM = XMLParser.extractObjectForTags(buffer, "hMM", HomogeneousMM.class);
        storAr = (Storable[])XMLParser.extractObjectForTags(buffer, "storAr");
        HomogeneousMM[] hmAr = (HomogeneousMM[])ArrayHandler.createArrayOf((Cloneable)hMM, (int)5);
        XMLParser.appendObjectWithTags(buffer, hmAr, "hmAr");
        hmAr = (HomogeneousMM[])XMLParser.extractObjectForTags(buffer, "hmAr");
    }

    public static void parameters() throws Exception {
        SimpleParameter simplePar = new SimpleParameter(DataType.INT, "Sequence length", "The required length of a sequence", true, new NumberValidator<Integer>(1, 100), 10);
        SimpleParameter simplePar2 = new SimpleParameter(DataType.STRING, "Name", "The name of the game", false);
        EnumParameter enumpar = new EnumParameter(DataType.class, "Data types", true);
        SelectionParameter collPar = new SelectionParameter(DataType.DOUBLE, new String[]{"small", "large"}, new Double[]{5.0, 5000000.0}, "Numbers", "A selection of numbers", true);
        collPar = SubclassFinder.getSelectionParameter(SequenceScoringParameterSet.class, "de", "Sequence scores", "All Sequence scores in Jstacs that can be created from parameter sets", true);
        SimpleParameterSet parSet = new SimpleParameterSet(simplePar, collPar);
        InstanceParameterSet myInstancePS = new InstanceParameterSet(TrainableStatisticalModel.class){
            {
                this.initParameterList();
                this.parameters.add(new Parameter[]{new EnumParameter(DataType.class, "Data types", true)});
                this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Sequence length", "The accepted length of a sequence", true, new NumberValidator<Integer>(1, 100), 10)});
            }

            @Override
            public String getInstanceName() {
                return "MyModel";
            }

            @Override
            public String getInstanceComment() {
                return "A fancy model created by me";
            }
        };
        ParameterSetContainer container = new ParameterSetContainer("Set", "A set of parameters", parSet);
    }

    public static void results() throws Exception {
        NumericalResult res = new NumericalResult("A double result", "This result contains some double value", 5.0);
        CategoricalResult catRes = new CategoricalResult("A boolean result", "This result contains some boolean", true);
        ResultSet resSet = new ResultSet(new Result[][]{{res, catRes}});
        MeanResultSet mrs = new MeanResultSet();
        Random r = new Random();
        int i = 0;
        while (i < 10) {
            mrs.addResults(new NumericalResultSet(new NumericalResult("Single", "A single result to be aggregated", r.nextDouble())));
            ++i;
        }
        System.out.println(mrs.getStatistics());
    }

    public static void trainSMs() throws Exception {
        DNAAlphabetContainer alphabet = DNAAlphabetContainer.SINGLETON;
        DataSet ds = new DataSet(new DNADataSet("supplementary/cookbook/recipes/myfile.fa"), 10);
        FSDAGTrainSM pwm = TrainableStatisticalModelFactory.createPWM(alphabet, 10, 4.0);
        FSDAGTrainSM imm = TrainableStatisticalModelFactory.createInhomogeneousMarkovModel(alphabet, 12, 4.0, (byte)2);
        BayesianNetworkTrainSM pmm = TrainableStatisticalModelFactory.createPermutedMarkovModel(alphabet, 7, 4.0, (byte)1);
        HomogeneousMM hmm = TrainableStatisticalModelFactory.createHomogeneousMarkovModel(alphabet, 400.0, (byte)3);
        ZOOPSTrainSM zoops = TrainableStatisticalModelFactory.createZOOPS(pwm, hmm, new double[]{4.0, 4.0}, false);
        pwm.train(ds);
        HomogeneousMM hmm2 = new HomogeneousMM(new HomMMParameterSet(alphabet, 4.0, "hmm(0)", 0));
        BayesianNetworkTrainSM bnm = new BayesianNetworkTrainSM(new BayesianNetworkTrainSMParameterSet(alphabet, 8, 4.0, "Bayesian network", StructureLearner.ModelType.BN, 1, StructureLearner.LearningType.ML_OR_MAP));
        BaumWelchParameterSet trainingPars = new BaumWelchParameterSet(5, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), 2);
        Emission[] emissions = new Emission[]{new DiscreteEmission((AlphabetContainer)alphabet, 4.0), new DiscreteEmission((AlphabetContainer)alphabet, new double[]{2.0, 1.0, 1.0, 2.0})};
        AbstractHMM myHMM = HMMFactory.createErgodicHMM(trainingPars, 1, 4.0, 0.1, 100.0, emissions);
        BasicHigherOrderTransition.AbstractTransitionElement[] abstractTransitionElementArray = new BasicHigherOrderTransition.AbstractTransitionElement[3];
        abstractTransitionElementArray[0] = new TransitionElement(null, new int[1], new double[]{4.0});
        int[] nArray = new int[2];
        nArray[1] = 1;
        abstractTransitionElementArray[1] = new TransitionElement(new int[1], nArray, new double[]{2.0, 2.0});
        abstractTransitionElementArray[2] = new TransitionElement(new int[]{1}, new int[1], new double[]{4.0});
        HigherOrderHMM hohmm = new HigherOrderHMM((HMMTrainingParameterSet)trainingPars, new String[]{"A", "B"}, emissions, abstractTransitionElementArray);
        System.out.println(hohmm.getGraphvizRepresentation(null));
        MixtureTrainSM mixEm = new MixtureTrainSM(10, new TrainableStatisticalModel[]{pwm, pwm}, 3, new double[]{4.0, 4.0}, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.LAMBDA);
        MixtureTrainSM mixGibbs = new MixtureTrainSM(10, new TrainableStatisticalModel[]{pwm, pwm}, 3, new double[]{4.0, 4.0}, 100, 1000, (BurnInTest)new VarianceRatioBurnInTest(new VarianceRatioBurnInTestParameterSet(3, 1.2)));
        StrandTrainSM strandModel = new StrandTrainSM((TrainableStatisticalModel)imm, 3, 0.5, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.LAMBDA);
        ZOOPSTrainSM zoops2 = new ZOOPSTrainSM((TrainableStatisticalModel)pwm, (TrainableStatisticalModel)hmm, true, 4, 0.7, null, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.LAMBDA);
    }

    public static void diffSMs() throws Exception {
        DNAAlphabetContainer alphabet = DNAAlphabetContainer.SINGLETON;
        DataSet[] data = null;
        BayesianNetworkDiffSM bnDsm = new BayesianNetworkDiffSM(new BayesianNetworkDiffSMParameterSet(alphabet, 10, 4.0, true, new BTExplainingAwayResidual(new double[]{4.0, 4.0})));
        MarkovModelDiffSM mmDsm = new MarkovModelDiffSM((AlphabetContainer)alphabet, 8, 4.0, true, new InhomogeneousMarkov(1));
        GenDisMixClassifierParameterSet params = new GenDisMixClassifierParameterSet(alphabet, 8, 20, 1.0E-6, 1.0E-6, 1.0, false, OptimizableFunction.KindOfParameter.PLUGIN, true, 4);
        GenDisMixClassifier cl = new GenDisMixClassifier(params, (LogPrior)new CompositeLogPrior(), LearningPrinciple.MSP, mmDsm, mmDsm);
        cl.train(data);
        System.out.println(cl);
        HomogeneousMMDiffSM hmmDsm = new HomogeneousMMDiffSM(alphabet, 3, 4.0, 100);
        DifferentiableEmission[] emissions = new DifferentiableEmission[]{new DiscreteEmission((AlphabetContainer)alphabet, 4.0), new DiscreteEmission((AlphabetContainer)alphabet, new double[]{2.0, 1.0, 1.0, 2.0})};
        NumericalHMMTrainingParameterSet trainingParameterSet = new NumericalHMMTrainingParameterSet(3, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), 2, 20, 1.0E-6, 1.0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        TransitionElement[] transitionElementArray = new TransitionElement[3];
        transitionElementArray[0] = new TransitionElement(null, new int[1], new double[]{4.0});
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        transitionElementArray[1] = new TransitionElement(new int[1], nArray2, new double[]{2.0, 2.0});
        transitionElementArray[2] = new TransitionElement(new int[]{1}, new int[1], new double[]{4.0});
        DifferentiableHigherOrderHMM hmm = new DifferentiableHigherOrderHMM(trainingParameterSet, new String[]{"A", "B"}, nArray, new boolean[]{true, true}, emissions, true, 4.0, transitionElementArray);
        MixtureDiffSM mixDsm = new MixtureDiffSM(3, true, mmDsm, mmDsm);
        StrandDiffSM strandDsm = new StrandDiffSM((DifferentiableStatisticalModel)mmDsm, 0.5, 1, true, StrandDiffSM.InitMethod.INIT_BOTH_STRANDS);
        ExtendedZOOPSDiffSM zoops = new ExtendedZOOPSDiffSM(false, 500, 4, false, (HomogeneousDiffSM)hmmDsm, (DifferentiableStatisticalModel)strandDsm, null, true);
        IndependentProductDiffSM ipsf = new IndependentProductDiffSM(4.0, true, bnDsm, mmDsm);
        DifferentiableStatisticalModelWrapperTrainSM trainSm = new DifferentiableStatisticalModelWrapperTrainSM(mmDsm, 4, 20, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), 1.0E-6, 1.0);
        trainSm.train((DataSet)data[0]);
    }

    public static void optimization() throws Exception {
        NumericalDifferentiableFunction ndf = new NumericalDifferentiableFunction(null, 1.0E-10){

            @Override
            public int getDimensionOfScope() {
                return 2;
            }

            @Override
            public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
                return x[0] * x[0] + x[1] * x[1];
            }
        };
        DifferentiableFunction df = new DifferentiableFunction(){

            @Override
            public int getDimensionOfScope() {
                return 2;
            }

            @Override
            public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
                return x[0] * x[0] + x[1] * x[1];
            }

            @Override
            public double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
                return new double[]{2.0 * x[0], 2.0 * x[1]};
            }
        };
        SmallDifferenceOfFunctionEvaluationsCondition tc = new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6);
        IterationCondition tc2 = new IterationCondition(100);
        SmallGradientConditon tc3 = new SmallGradientConditon(1.0E-6);
        CombinedCondition combined = new CombinedCondition(2, tc, tc3);
        double[] parameters = new double[df.getDimensionOfScope()];
        Optimizer.optimize((byte)20, df, parameters, combined, 1.0E-6, new ConstantStartDistance(1.0E-4), System.out);
    }

    public static void classifier() throws Exception {
        DNAAlphabetContainer alphabet = DNAAlphabetContainer.SINGLETON;
        DataSet[] data = new DataSet[]{new DNADataSet("supplementary/cookbook/recipes/fg.fa"), new DNADataSet("supplementary/cookbook/recipes/bg.fa")};
        FSDAGTrainSM pwm = TrainableStatisticalModelFactory.createPWM(alphabet, 10, 4.0);
        AbstractScoreBasedClassifier cl = new TrainSMBasedClassifier(pwm, pwm);
        GenDisMixClassifierParameterSet ps = new GenDisMixClassifierParameterSet(alphabet, 10, 10, 1.0E-6, 1.0E-9, 1.0, false, OptimizableFunction.KindOfParameter.PLUGIN, true, 2);
        BayesianNetworkDiffSM pwm2 = new BayesianNetworkDiffSM(alphabet, 10, 4.0, true, new InhomogeneousMarkov(0));
        cl = new GenDisMixClassifier(ps, (LogPrior)DoesNothingLogPrior.defaultInstance, LearningPrinciple.ML, pwm2, pwm2);
        CompositeLogPrior prior = new CompositeLogPrior();
        cl = new GenDisMixClassifier(ps, (LogPrior)prior, LearningPrinciple.MSP, pwm2, pwm2);
        cl = new GenDisMixClassifier(ps, (LogPrior)prior, new double[]{0.4, 0.1, 0.5}, pwm2, pwm2);
        cl.train(data);
        System.out.println(((AbstractClassifier)cl).classify(data[0].getElementAt(0)));
        AbstractPerformanceMeasureParameterSet measures = AbstractPerformanceMeasureParameterSet.createFilledParameters(false, 0.999, 0.95, 0.95, 1.0);
        NumericalPerformanceMeasure[] m = new NumericalPerformanceMeasure[]{new AucROC(), new AucPR()};
        measures = new NumericalPerformanceMeasureParameterSet(m);
        System.out.println(cl.evaluate((AbstractPerformanceMeasureParameterSet<? extends PerformanceMeasure>)measures, true, data));
        NumericalPerformanceMeasureParameterSet numMeasures = AbstractPerformanceMeasureParameterSet.createFilledParameters();
        KFoldCrossValidation assessment = new KFoldCrossValidation(cl);
        KFoldCrossValidationAssessParameterSet params = new KFoldCrossValidationAssessParameterSet(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS, cl.getLength(), true, 10);
        System.out.println(assessment.assess(numMeasures, params, data));
    }

    public static void alignment() throws Exception {
        Costs costs = new SimpleCosts(0.0, 1.0, 0.5);
        Sequence seq1 = Sequence.create(DNAAlphabetContainer.SINGLETON, "ACGTACGTAGCTGATCG");
        Sequence seq2 = Sequence.create(DNAAlphabetContainer.SINGLETON, "TATCGATCGATGCGTAGCT");
        Alignment align = new Alignment(costs);
        System.out.println(align.getAlignment(Alignment.AlignmentType.GLOBAL, seq1, seq2));
        costs = new AffineCosts(1.0, costs);
        align = new Alignment(costs);
        System.out.println(align.getAlignment(Alignment.AlignmentType.GLOBAL, seq1, seq2));
    }

    public static void utils() throws Exception {
        REnvironment re = new REnvironment();
        double[] values = new double[10];
        re.createVector("values", values);
        re.voidEval("values=rnorm(length(values));");
        re.plotToPDF("plot(values,t=\"l\");", "values.pdf", true);
        double[][] twodim = new double[5][5];
        double[][] clone = (double[][])ArrayHandler.clone((Cloneable[])twodim);
        FSDAGTrainSM pwm = TrainableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, 10, 4.0);
        Object[] models = (TrainableStatisticalModel[])ArrayHandler.createArrayOf((Cloneable)pwm, (int)10);
        Object[] m = new Object[]{TrainableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, 10, 4.0), TrainableStatisticalModelFactory.createHomogeneousMarkovModel(DNAAlphabetContainer.SINGLETON, 40.0, (byte)0)};
        TrainableStatisticalModel[] sms = ArrayHandler.cast(TrainableStatisticalModel.class, models);
        double max = ToolBox.max(values);
        double sum = ToolBox.sum(values);
        int maxIndex = ToolBox.getMaxIndex(values);
        double logSum = Normalisation.getLogSum(values);
        Normalisation.logSumNormalisation(values);
        Normalisation.sumNormalisation(values);
        SafeOutputStream stream = SafeOutputStream.getSafeOutputStream(System.out);
        LinkedList<Class<TrainableStatisticalModel>> list = SubclassFinder.findInstantiableSubclasses(TrainableStatisticalModel.class, "de.jstacs");
    }
}

