/*
 * Decompiled with CFR 0.152.
 */
package supplementary.cookbook.recipes;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.assessment.KFoldCrossValidation;
import de.jstacs.classifiers.assessment.KFoldCrossValidationAssessParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.msp.MSPClassifier;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.classifiers.trainSMBased.TrainSMBasedClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.MixtureDiffSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.BayesianNetworkTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.BayesianNetworkTrainSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.MixtureTrainSM;

public class CrossValidation {
    public static void main(String[] args) throws Exception {
        DataSet[] data = new DataSet[2];
        data[0] = new DNADataSet(args[0]);
        int length = data[0].getElementLength();
        data[1] = new DataSet(new DNADataSet(args[1]), length);
        AlphabetContainer container = data[0].getAlphabetContainer();
        BayesianNetworkTrainSM pwm = new BayesianNetworkTrainSM(new BayesianNetworkTrainSMParameterSet(container, length, 4.0, "my PWM", StructureLearner.ModelType.IMM, 0, StructureLearner.LearningType.ML_OR_MAP));
        MixtureTrainSM mixPwms = new MixtureTrainSM(length, new TrainableStatisticalModel[]{pwm, pwm}, 10, new double[]{pwm.getESS(), pwm.getESS()}, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.LAMBDA);
        BayesianNetworkTrainSM mm = new BayesianNetworkTrainSM(new BayesianNetworkTrainSMParameterSet(container, length, 256.0, "my iMM(3)", StructureLearner.ModelType.IMM, 3, StructureLearner.LearningType.ML_OR_MAP));
        BayesianNetworkDiffSM dPwm = new BayesianNetworkDiffSM(container, length, 4.0, true, new InhomogeneousMarkov(0));
        MixtureDiffSM dMixPwms = new MixtureDiffSM(2, true, dPwm, dPwm);
        BayesianNetworkDiffSM dMm = new BayesianNetworkDiffSM(container, length, 4.0, true, new InhomogeneousMarkov(3));
        int threads = AbstractMultiThreadedOptimizableFunction.getNumberOfAvailableProcessors();
        AbstractClassifier[] classifiers = new AbstractScoreBasedClassifier[]{new TrainSMBasedClassifier(mixPwms, mm), new MSPClassifier(new GenDisMixClassifierParameterSet(container, length, 20, 0.01, 0.01, 1.0, true, OptimizableFunction.KindOfParameter.PLUGIN, false, threads), dMixPwms, dMm)};
        KFoldCrossValidation cv = new KFoldCrossValidation(classifiers);
        NumericalPerformanceMeasureParameterSet mp = PerformanceMeasureParameterSet.createFilledParameters();
        KFoldCrossValidationAssessParameterSet cvpars = new KFoldCrossValidationAssessParameterSet(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_SYMBOLS, length, true, 10);
        System.out.println(cv.assess(mp, cvpars, data));
    }
}

