/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.FoldedNormalDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class FoldedNormalGen
extends RandomVariateGen {
    protected double mu;
    protected double sigma;

    public FoldedNormalGen(RandomStream s, double mu, double sigma) {
        super(s, new FoldedNormalDist(mu, sigma));
        this.setParams(mu, sigma);
    }

    public FoldedNormalGen(RandomStream s, FoldedNormalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    public static double nextDouble(RandomStream s, double mu, double sigma) {
        return FoldedNormalDist.inverseF(mu, sigma, s.nextDouble());
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    protected void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (mu < 0.0) {
            throw new IllegalArgumentException("mu < 0");
        }
        this.mu = mu;
        this.sigma = sigma;
    }
}

