/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.SymbolExtractor;

public class ByteSequence
extends SimpleDiscreteSequence {
    protected byte[] content;

    public ByteSequence(AlphabetContainer alphabetContainer, byte[] content) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, null);
        if (alphabetContainer.getMaximalAlphabetLength() > 127.0) {
            throw new WrongSequenceTypeException();
        }
        this.content = new byte[content.length];
        int i = 0;
        while (i < content.length) {
            if (!alphabetContainer.isEncodedSymbol(i, content[i])) {
                throw new WrongAlphabetException();
            }
            this.content[i] = content[i];
            ++i;
        }
    }

    private ByteSequence(AlphabetContainer cont, SequenceAnnotation[] annotation, byte[] content) throws WrongAlphabetException {
        super(cont, annotation);
        this.content = content;
    }

    public ByteSequence(AlphabetContainer alphabetContainer, String sequence) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, null, sequence, alphabetContainer.getDelim());
    }

    public ByteSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, annotation, new SymbolExtractor(sequence, delim));
    }

    public ByteSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, SymbolExtractor extractor) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, annotation);
        if (alphabetContainer.getMaximalAlphabetLength() > 127.0) {
            throw new WrongSequenceTypeException();
        }
        this.content = new byte[extractor.countElements()];
        int k = 0;
        while (k < this.content.length) {
            this.content[k] = (byte)alphabetContainer.getCode(k, extractor.nextElement());
            ++k;
        }
    }

    @Override
    public int discreteVal(int pos) {
        return this.content[pos];
    }

    @Override
    public int getLength() {
        return this.content.length;
    }

    @Override
    protected ByteSequence flatCloneWithoutAnnotation() {
        try {
            return new ByteSequence(this.getAlphabetContainer(), null, this.content);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }
}

