/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.MultiDimensionalSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;

public class MultiDimensionalDiscreteSequence
extends MultiDimensionalSequence<int[]> {
    public MultiDimensionalDiscreteSequence(SequenceAnnotation[] seqAn, SimpleDiscreteSequence ... sequence) throws WrongLengthException, WrongAlphabetException {
        super(seqAn, sequence);
    }

    @Override
    public void fillContainer(int[] container, int pos) {
        int s = 0;
        while (s < this.content.length) {
            container[s] = this.content[s].discreteVal(pos);
            ++s;
        }
    }

    @Override
    public int[] getEmptyContainer() {
        return new int[this.content.length];
    }

    protected MultiDimensionalDiscreteSequence getInstance(SequenceAnnotation[] seqAn, Sequence ... seqs) throws WrongLengthException, WrongAlphabetException {
        return new MultiDimensionalDiscreteSequence(seqAn, ArrayHandler.cast(SimpleDiscreteSequence.class, seqs));
    }

    @Override
    public int compareTo(int[] t1, int[] t2) {
        if (t1.length == t2.length) {
            int i = 0;
            while (i < t1.length) {
                if (t1[i] != t2[i]) {
                    return t1[i] - t2[i];
                }
                ++i;
            }
            return 0;
        }
        return t1.length - t2.length;
    }
}

