/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.naming.OperationNotSupportedException;

public final class KMereStatistic {
    private AlphabetContainer abc;
    private int length;
    private int k;
    private int n;
    private int[] powers;
    private int[][] counts;

    public KMereStatistic(DataSet data, int k) {
        this.abc = data.getAlphabetContainer();
        this.length = data.getElementLength();
        if (!this.abc.isSimple() || this.length == 0) {
            throw new IllegalArgumentException("Can not compute the statistic: check the data set");
        }
        if (k < 1 || k >= this.length) {
            throw new IllegalArgumentException("Can not compute the statistic: check the order");
        }
        this.k = k;
        this.powers = new int[Math.max(k + 1, 2)];
        this.powers[0] = 1;
        this.powers[1] = (int)this.abc.getAlphabetLengthAt(0);
        int i = 2;
        while (i < this.powers.length) {
            this.powers[i] = this.powers[1] * this.powers[i - 1];
            ++i;
        }
        this.counts = new int[this.length - k + 1][this.powers[k]];
        i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            int idx = 0;
            int l = 0;
            while (l < k - 1) {
                idx = idx * this.powers[1] + seq.discreteVal(l);
                ++l;
            }
            int s = 0;
            while (l < this.length) {
                idx = (idx * this.powers[1] + seq.discreteVal(l)) % this.powers[k];
                int[] nArray = this.counts[s];
                int n = idx;
                nArray[n] = nArray[n] + 1;
                ++l;
                ++s;
            }
            ++i;
        }
        this.n = data.getNumberOfElements();
    }

    public double[][] getSmoothedProfile(int window, String ... kmere) {
        Sequence[] seq = null;
        try {
            seq = new Sequence[kmere.length];
            int i = 0;
            while (i < seq.length) {
                seq[i] = Sequence.create(this.abc, kmere[i]);
                ++i;
            }
        }
        catch (Exception e) {
            seq = null;
        }
        if (seq == null) {
            throw new IllegalArgumentException();
        }
        return this.getSmoothedProfile(window, seq);
    }

    public double[][] getSmoothedProfile(int window, Sequence ... seq) {
        if (window < 1) {
            throw new IllegalArgumentException("The window has to have at least length 1.");
        }
        if (seq == null) {
            throw new IllegalArgumentException("check the subsequences");
        }
        int i = 0;
        int m = this.n * window;
        double[][] res = new double[seq.length][this.counts.length - window + 1];
        i = 0;
        while (i < seq.length) {
            if (seq[i].getLength() != this.k) {
                throw new IllegalArgumentException();
            }
            int idx = 0;
            int l = 0;
            while (l < this.k) {
                idx = idx * this.powers[1] + seq[i].discreteVal(l);
                ++l;
            }
            l = 0;
            while (l < window) {
                double[] dArray = res[i];
                dArray[0] = dArray[0] + (double)this.counts[l][idx];
                ++l;
            }
            int s = 1;
            while (s < res[i].length) {
                res[i][s] = res[i][s - 1] - (double)this.counts[l - window][idx] + (double)this.counts[l][idx];
                double[] dArray = res[i];
                int n = s - 1;
                dArray[n] = dArray[n] / (double)m;
                ++l;
                ++s;
            }
            double[] dArray = res[i];
            int n = s - 1;
            dArray[n] = dArray[n] / (double)m;
            ++i;
        }
        return res;
    }

    public static Sequence[] getCommonString(DataSet data, int motifLength, boolean bothStrands) throws Exception {
        int f = bothStrands ? 2 : 1;
        LinkedList<Sequence> candidates = new LinkedList<Sequence>();
        HashSet<Sequence> current = new HashSet<Sequence>(f * data.getMaximalElementLength());
        Sequence s = data.getElementAt(0);
        int i = 0;
        int end = s.getLength() - motifLength;
        while (i <= end) {
            Sequence help = s.getSubSequence(i, motifLength);
            if (!current.contains(help)) {
                current.add(help);
                candidates.add(help);
            }
            ++i;
        }
        int j = 1;
        while (candidates.size() > 0 && j < data.getNumberOfElements()) {
            current.clear();
            KMereStatistic.add(current, data.getElementAt(j), motifLength);
            KMereStatistic.intersection(candidates, current, bothStrands);
            ++j;
        }
        Object[] empty = new Sequence[]{};
        empty = candidates.toArray(empty);
        Arrays.sort(empty);
        return empty;
    }

    private static void add(HashSet<Sequence> hash, Sequence sequence, int motifLength) {
        int i = 0;
        int end = sequence.getLength() - motifLength;
        while (i <= end) {
            Sequence help = sequence.getSubSequence(i, motifLength);
            if (!hash.contains(help)) {
                hash.add(help);
            }
            ++i;
        }
    }

    private static void intersection(LinkedList<Sequence> candidates, HashSet<Sequence> current, boolean bothStrands) throws OperationNotSupportedException {
        int i = 0;
        while (i < candidates.size()) {
            Sequence seq = candidates.get(i);
            if (!current.contains(seq) && !current.contains(seq.reverseComplement())) {
                candidates.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static DataSet.WeightedDataSetFactory getAbsoluteKMereFrequencies(DataSet data, int k, boolean bothStrands) throws Exception {
        return KMereStatistic.getAbsoluteKMereFrequencies(data, k, bothStrands, DataSet.WeightedDataSetFactory.SortOperation.NO_SORT);
    }

    public static DataSet.WeightedDataSetFactory getAbsoluteKMereFrequencies(DataSet data, int k, boolean bothStrands, DataSet.WeightedDataSetFactory.SortOperation sortOp) throws Exception {
        DataSet myData = data;
        if (bothStrands) {
            Sequence[] seqs = new Sequence[2 * data.getNumberOfElements()];
            int j = 0;
            while (j < data.getNumberOfElements()) {
                seqs[2 * j] = data.getElementAt(j);
                seqs[2 * j + 1] = seqs[2 * j].reverseComplement();
                ++j;
            }
            myData = new DataSet("both strands of " + data.getAnnotation(), seqs);
        }
        DataSet.WeightedDataSetFactory wsf = new DataSet.WeightedDataSetFactory(sortOp, myData, null, k);
        if (bothStrands) {
            wsf = KMereStatistic.removeReverseComplements(wsf, 2, sortOp);
        }
        return wsf;
    }

    public static Hashtable<Sequence, BitSet[]> getKmereSequenceStatistic(int k, boolean bothStrands, int addIndex, DataSet ... data) throws WrongAlphabetException, OperationNotSupportedException {
        AlphabetContainer con = data[0].getAlphabetContainer();
        if (!con.isSimple() || !con.isDiscrete()) {
            throw new WrongAlphabetException();
        }
        int[] anz = new int[data.length];
        int d = 0;
        while (d < data.length) {
            if (!con.checkConsistency(data[d].getAlphabetContainer())) {
                throw new WrongAlphabetException();
            }
            anz[d] = data[d].getNumberOfElements();
            ++d;
        }
        Hashtable<Sequence, BitSet[]> res = new Hashtable<Sequence, BitSet[]>();
        boolean add = false;
        int d2 = 0;
        while (d2 < data.length) {
            int n = 0;
            while (n < anz[d2]) {
                Sequence seq = data[d2].getElementAt(n);
                int m = seq.getLength() - k + 1;
                int l = 0;
                while (l < m) {
                    Sequence current = seq.getSubSequence(con, l, k);
                    BitSet[] b = res.get(current);
                    if (b == null && bothStrands) {
                        b = res.get(current.reverseComplement());
                    }
                    if (b != null || d2 <= addIndex) {
                        if (b == null) {
                            b = KMereStatistic.createBitSets(anz);
                            add = true;
                        }
                        b[d2].set(n);
                        if (add) {
                            res.put(current, b);
                            add = false;
                        }
                    }
                    ++l;
                }
                ++n;
            }
            ++d2;
        }
        return res;
    }

    private static BitSet[] createBitSets(int[] anz) {
        BitSet[] b = new BitSet[anz.length];
        int h = 0;
        while (h < anz.length) {
            b[h] = new BitSet(anz[h]);
            ++h;
        }
        return b;
    }

    public static Pair<Sequence, BitSet[]>[] getKmereSequenceStatistic(boolean bothStrands, int maxMismatch, HashSet<Sequence> filter, DataSet ... data) throws WrongAlphabetException, OperationNotSupportedException {
        AlphabetContainer con = data[0].getAlphabetContainer();
        if (!con.isSimple() || !con.isDiscrete()) {
            throw new WrongAlphabetException();
        }
        int[] anz = new int[data.length];
        int d = 0;
        while (d < data.length) {
            if (!con.checkConsistency(data[d].getAlphabetContainer())) {
                throw new WrongAlphabetException();
            }
            anz[d] = data[d].getNumberOfElements();
            ++d;
        }
        Pair[] res = new Pair[filter.size()];
        Iterator<Sequence> it = filter.iterator();
        int i = 0;
        while (it.hasNext()) {
            res[i++] = new Pair<Sequence, BitSet[]>(it.next(), KMereStatistic.createBitSets(anz));
        }
        int d2 = 0;
        while (d2 < data.length) {
            int n = 0;
            while (n < anz[d2]) {
                Sequence seq = data[d2].getElementAt(n);
                i = 0;
                while (i < res.length) {
                    Sequence current = (Sequence)res[i].getFirstElement();
                    BitSet[] b = (BitSet[])res[i].getSecondElement();
                    if (KMereStatistic.contains(seq, current, maxMismatch, bothStrands)) {
                        b[d2].set(n);
                    }
                    ++i;
                }
                ++n;
            }
            ++d2;
        }
        return res;
    }

    private static boolean contains(Sequence seq, Sequence kmere, int maxMismatch, boolean bothStrands) throws WrongAlphabetException, OperationNotSupportedException {
        boolean res = seq.matches(maxMismatch, kmere);
        if (!res && bothStrands) {
            res = seq.matches(maxMismatch, kmere.reverseComplement());
        }
        return res;
    }

    public static Hashtable<Sequence, BitSet[]> merge(Hashtable<Sequence, BitSet[]> statistic, int maximalMissmatch, boolean bothStrands) throws OperationNotSupportedException, CloneNotSupportedException, WrongLengthException, WrongAlphabetException {
        Hashtable<Sequence, BitSet[]> res = new Hashtable<Sequence, BitSet[]>();
        Set<Map.Entry<Sequence, BitSet[]>> set = statistic.entrySet();
        Sequence rc = null;
        Map.Entry[] array = new Map.Entry[set.size()];
        set.toArray(array);
        int i = 0;
        while (i < array.length) {
            res.put((Sequence)array[i].getKey(), (BitSet[])ArrayHandler.clone((Cloneable[])((BitSet[])array[i].getValue())));
            ++i;
        }
        int arrayIndex1 = 0;
        while (arrayIndex1 < array.length) {
            Sequence s1 = (Sequence)array[arrayIndex1].getKey();
            BitSet[] o1 = (BitSet[])array[arrayIndex1].getValue();
            BitSet[] b1 = res.get(s1);
            if (bothStrands) {
                rc = s1.reverseComplement();
            }
            int arrayIndex2 = arrayIndex1 + 1;
            while (arrayIndex2 < array.length) {
                Sequence s2 = (Sequence)array[arrayIndex2].getKey();
                int d = s1.getHammingDistance(s2);
                if (bothStrands) {
                    d = Math.min(d, rc.getHammingDistance(s2));
                }
                if (d >= 0 && d <= maximalMissmatch) {
                    BitSet[] o2 = (BitSet[])array[arrayIndex2].getValue();
                    BitSet[] b2 = res.get(s2);
                    int idx = 0;
                    while (idx < b1.length) {
                        b1[idx].or(o2[idx]);
                        b2[idx].or(o1[idx]);
                        ++idx;
                    }
                }
                ++arrayIndex2;
            }
            ++arrayIndex1;
        }
        return res;
    }

    public static LinkedList<Sequence> getConservedPatterns(Hashtable<Sequence, BitSet[]> statistic, int dataSetIndex, int threshold) {
        Iterator<Map.Entry<Sequence, BitSet[]>> it = statistic.entrySet().iterator();
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        while (it.hasNext()) {
            Map.Entry<Sequence, BitSet[]> e = it.next();
            if (e.getValue()[dataSetIndex].cardinality() < threshold) continue;
            list.add(e.getKey());
        }
        return list;
    }

    public static Hashtable<Sequence, BitSet[]> removeBackground(Hashtable<Sequence, BitSet[]> statistic, int fgIndex, int bgIndex, double fgWeight, double bgWeight) {
        Hashtable<Sequence, BitSet[]> res = new Hashtable<Sequence, BitSet[]>();
        for (Map.Entry<Sequence, BitSet[]> e : statistic.entrySet()) {
            BitSet[] b = e.getValue();
            if (!((double)b[fgIndex].cardinality() * fgWeight > (double)b[bgIndex].cardinality() * bgWeight)) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    private static DataSet.WeightedDataSetFactory removeReverseComplements(DataSet.WeightedDataSetFactory wsf, int div, DataSet.WeightedDataSetFactory.SortOperation so) throws Exception {
        ArrayList<Sequence> seqs = new ArrayList<Sequence>();
        DoubleList weight = new DoubleList();
        int j = 0;
        while (j < wsf.getNumberOfElements()) {
            Sequence seq = wsf.getElementAt(j);
            if (seq.equals(seq.reverseComplement())) {
                seqs.add(seq);
                weight.add(wsf.getWeight(j) / (double)div);
            } else if (seq.compareTo(seq.reverseComplement()) < 0) {
                seqs.add(seq);
                weight.add(wsf.getWeight(j));
            }
            ++j;
        }
        return new DataSet.WeightedDataSetFactory(so, new DataSet(null, seqs.toArray(new Sequence[0])), weight.toArray());
    }
}

