/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;

public class ExpandableParameterSet
extends ParameterSet {
    protected ParameterSet template;
    protected String nameTemplate;
    protected String commentTemplate;
    private int count;
    protected int initCount;
    protected int minCount;
    protected int maxCount;

    public ExpandableParameterSet(ParameterSet template, String nameTemplate, String commentTemplate) throws CloneNotSupportedException {
        this(template, nameTemplate, commentTemplate, 1);
    }

    public ExpandableParameterSet(ParameterSet template, String nameTemplate, String commentTemplate, int initCount) throws CloneNotSupportedException {
        this(template, nameTemplate, commentTemplate, initCount, initCount, Integer.MAX_VALUE);
    }

    public ExpandableParameterSet(ParameterSet template, String nameTemplate, String commentTemplate, int initCount, int minCount, int maxCount) throws CloneNotSupportedException {
        this.template = template;
        this.nameTemplate = nameTemplate;
        this.commentTemplate = commentTemplate;
        this.count = 0;
        if (minCount >= maxCount) {
            throw new IllegalArgumentException("minCount < maxCount");
        }
        this.minCount = minCount;
        this.maxCount = maxCount;
        if (initCount < minCount || maxCount < initCount) {
            throw new IllegalArgumentException("minCount <= initCount &&  initCount <= maxCount");
        }
        this.initCount = initCount;
        int i = 0;
        while (i < initCount) {
            this.addParameterToSet();
            ++i;
        }
    }

    public ExpandableParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public ExpandableParameterSet(ParameterSet[] templateAndContent, String nameTemplate, String commentTemplate) throws CloneNotSupportedException {
        this(templateAndContent[0], nameTemplate, commentTemplate, 0);
        if (this.notAllGivenParameterSetsAreOfTemplateType(templateAndContent)) {
            throw new IllegalArgumentException("At least one of the given ParameterSets is not of the specified template-Type");
        }
        int i = 0;
        while (i < templateAndContent.length) {
            this.parameters.add(new Parameter[]{new ParameterSetContainer(String.valueOf(nameTemplate) + " no. " + (this.count + 1), commentTemplate, templateAndContent[i])});
            ++this.count;
            ++i;
        }
    }

    @Override
    public ExpandableParameterSet clone() throws CloneNotSupportedException {
        ExpandableParameterSet clone = (ExpandableParameterSet)super.clone();
        clone.template = this.template.clone();
        return clone;
    }

    public boolean addParameterToSet() throws CloneNotSupportedException {
        if (this.count < this.maxCount) {
            ParameterSetContainer simplePar = new ParameterSetContainer(String.valueOf(this.nameTemplate) + " no. " + ++this.count, this.commentTemplate, this.template.clone());
            this.parameters.add(new Parameter[]{simplePar});
            return true;
        }
        return false;
    }

    public boolean replaceContentWith(ParameterSet[] paramSetArray) {
        if (this.notAllGivenParameterSetsAreOfTemplateType(paramSetArray)) {
            return false;
        }
        this.initParameterList(paramSetArray.length);
        int i = 0;
        while (i < paramSetArray.length) {
            this.parameters.add(new Parameter[]{new ParameterSetContainer(String.valueOf(this.nameTemplate) + " no. " + (i + 1), this.commentTemplate, paramSetArray[i])});
            ++i;
        }
        this.count = paramSetArray.length;
        return true;
    }

    private boolean notAllGivenParameterSetsAreOfTemplateType(ParameterSet[] temp) {
        Class<?> clazz = this.template.getClass();
        int i = 0;
        while (i < temp.length) {
            if (temp[i].getClass() != clazz) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean parameterRemovable() {
        return this.count > this.minCount;
    }

    public boolean removeParameterFromSet() {
        if (this.count > this.minCount) {
            this.parameters.remove(this.parameters.size() - 1);
            --this.count;
            return true;
        }
        return false;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameters");
        XMLParser.appendObjectWithTags(buf, this.template, "template");
        XMLParser.appendObjectWithTags(buf, this.nameTemplate, "nameTemplate");
        XMLParser.appendObjectWithTags(buf, this.commentTemplate, "commentTemplate");
        XMLParser.appendObjectWithTags(buf, this.initCount, "initCount");
        XMLParser.appendObjectWithTags(buf, this.minCount, "minCount");
        XMLParser.appendObjectWithTags(buf, this.maxCount, "maxCount");
        XMLParser.addTags(buf, "expandableParameterSet");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "expandableParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        this.template = XMLParser.extractObjectForTags(representation, "template", ParameterSet.class);
        this.nameTemplate = XMLParser.extractObjectForTags(representation, "nameTemplate", String.class);
        this.commentTemplate = XMLParser.extractObjectForTags(representation, "commentTemplate", String.class);
        this.initCount = XMLParser.extractObjectForTags(representation, "initCount", Integer.TYPE);
        try {
            this.minCount = XMLParser.extractObjectForTags(representation, "minCount", Integer.TYPE);
            this.maxCount = XMLParser.extractObjectForTags(representation, "maxCount", Integer.TYPE);
        }
        catch (NonParsableException e) {
            this.minCount = 0;
            this.maxCount = Integer.MAX_VALUE;
        }
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine, int indentation) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + this.nameTemplate.replaceAll("\\s", "_");
        int nextIndentation = XMLParser.nextIndentation(indentation);
        int i = 0;
        while (i < this.getNumberOfParameters() - this.count) {
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).toGalaxy(String.valueOf(namePrefix) + "_ps", configPrefix, depth + 1, descBuffer, configBuffer, false, nextIndentation);
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        buf2.append("$len($" + configPrefix + namePrefix + ")");
        XMLParser.addTags(buf2, String.valueOf(namePrefix) + "_len");
        buf2.append("\n");
        buf2.append("#for $" + namePrefix + "_i, $" + namePrefix + "_run in enumerate($" + configPrefix + namePrefix + ")\n");
        this.template.toGalaxy(namePrefix, String.valueOf(namePrefix) + "_run.", depth + 1, buf, buf2, false, nextIndentation);
        buf2.append("#end for");
        XMLParser.addTagsAndAttributes(buf, "repeat", "name=\"" + namePrefix + "\" title=\"" + this.nameTemplate + "\" default=\"" + this.initCount + "\" min=\"" + this.minCount + "\" max=\"" + this.maxCount + "\"", indentation);
        buf.insert(0, "\n");
        buf.append("\n");
        descBuffer.append(buf);
        configBuffer.append(buf2);
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + this.nameTemplate.replaceAll("\\s", "_");
        while (this.removeParameterFromSet()) {
        }
        int num = XMLParser.extractObjectForTags(command, String.valueOf(namePrefix) + "_len", Integer.TYPE);
        while (this.getNumberOfParameters() < num && this.addParameterToSet()) {
        }
        int i = 0;
        while (i < this.getNumberOfParameters() - this.count) {
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).fromGalaxy(String.valueOf(namePrefix) + "_ps", command);
            ++i;
        }
        while (i < this.getNumberOfParameters()) {
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).fromGalaxy(namePrefix, command);
            ++i;
        }
    }

    @Override
    public void toGalaxyTest(String namePrefix, int depth, StringBuffer testBuffer, int indentation) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + this.nameTemplate.replaceAll("\\s", "_");
        int nextIndentation = XMLParser.nextIndentation(indentation);
        int i = 0;
        while (i < this.getNumberOfParameters()) {
            StringBuffer buf = new StringBuffer();
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).toGalaxyTest(namePrefix, depth + 1, buf, nextIndentation);
            if (buf.length() > 0) {
                XMLParser.addTagsAndAttributes(buf, "repeat", "name=\"" + namePrefix + "\"", indentation);
                testBuffer.append(buf);
            }
            ++i;
        }
    }
}

