/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools;

import de.jstacs.tools.Protocol;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProtocolOutputStream
extends OutputStream {
    private Protocol prot;
    boolean toWarning;
    StringBuffer buffer;
    Pattern pat;

    public ProtocolOutputStream(Protocol prot, boolean toWarning) {
        this(prot, toWarning, "([\\n\\s]|.)*");
    }

    public ProtocolOutputStream(Protocol prot, boolean toWarning, String regExp) {
        this.prot = prot;
        this.toWarning = toWarning;
        this.buffer = new StringBuffer();
        this.pat = Pattern.compile(regExp);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.append(new String(new byte[]{(byte)b}));
        Matcher m = this.pat.matcher(this.buffer);
        int end = 0;
        while (m.find()) {
            String gr = m.group(0);
            if (this.toWarning) {
                this.prot.appendWarning(gr);
            } else {
                this.prot.append(gr);
            }
            end = m.end();
        }
        this.buffer.delete(0, end);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.append(new String(b, off, len));
        Matcher m = this.pat.matcher(this.buffer);
        int end = 0;
        while (m.find()) {
            String gr = m.group(0);
            if (this.toWarning) {
                this.prot.appendWarning(gr);
            } else {
                this.prot.append(gr);
            }
            end = m.end();
        }
        this.buffer.delete(0, end);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

