/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Sam2CramRecordFactory {
    public static final String UNKNOWN_READ_GROUP_ID = "UNKNOWN";
    public static final String UNKNOWN_READ_GROUP_SAMPLE = "UNKNOWN";
    private static final byte QS_asciiOffset = 33;
    public static final byte unsetQualityScore = 32;
    public static final byte ignorePositionsWithQualityScore = -1;
    private byte[] refBases;
    private final Version version;
    private byte[] refSNPs;
    private final SAMFileHeader header;
    private static final Log log = Log.getInstance(Sam2CramRecordFactory.class);
    private final Map<String, Integer> readGroupMap = new HashMap<String, Integer>();
    private long landedRefMaskScores = 0L;
    private long landedTotalScores = 0L;
    public boolean captureAllTags = false;
    public boolean preserveReadNames = false;
    public final Set<String> captureTags = new TreeSet<String>();
    public final Set<String> ignoreTags = new TreeSet<String>();
    private final List<ReadTag> readTagList;
    private long baseCount;
    private long featureCount;

    public Sam2CramRecordFactory(byte[] refBases, SAMFileHeader samFileHeader, Version version) {
        this.ignoreTags.add(SAMTag.RG.name());
        this.readTagList = new ArrayList<ReadTag>();
        this.baseCount = 0L;
        this.featureCount = 0L;
        this.refBases = refBases;
        this.version = version;
        this.header = samFileHeader;
        List<SAMReadGroupRecord> readGroups = samFileHeader.getReadGroups();
        for (int i = 0; i < readGroups.size(); ++i) {
            SAMReadGroupRecord readGroupRecord = readGroups.get(i);
            this.readGroupMap.put(readGroupRecord.getId(), i);
        }
    }

    public CramCompressionRecord createCramRecord(SAMRecord record) {
        if (null == record.getHeader()) {
            record.setHeader(this.header);
        }
        CramCompressionRecord cramRecord = new CramCompressionRecord();
        if (record.getReadPairedFlag()) {
            cramRecord.mateAlignmentStart = record.getMateAlignmentStart();
            cramRecord.setMateUnmapped(record.getMateUnmappedFlag());
            cramRecord.setMateNegativeStrand(record.getMateNegativeStrandFlag());
            cramRecord.mateSequenceID = record.getMateReferenceIndex();
        } else {
            cramRecord.mateSequenceID = -1;
        }
        cramRecord.sequenceId = record.getReferenceIndex();
        cramRecord.readName = record.getReadName();
        cramRecord.alignmentStart = record.getAlignmentStart();
        cramRecord.setMultiFragment(record.getReadPairedFlag());
        cramRecord.setProperPair(record.getReadPairedFlag() && record.getProperPairFlag());
        cramRecord.setSegmentUnmapped(record.getReadUnmappedFlag());
        cramRecord.setNegativeStrand(record.getReadNegativeStrandFlag());
        cramRecord.setFirstSegment(record.getReadPairedFlag() && record.getFirstOfPairFlag());
        cramRecord.setLastSegment(record.getReadPairedFlag() && record.getSecondOfPairFlag());
        cramRecord.setSecondaryAlignment(record.getNotPrimaryAlignmentFlag());
        cramRecord.setVendorFiltered(record.getReadFailsVendorQualityCheckFlag());
        cramRecord.setDuplicate(record.getDuplicateReadFlag());
        cramRecord.setSupplementary(record.getSupplementaryAlignmentFlag());
        cramRecord.readLength = record.getReadLength();
        cramRecord.mappingQuality = record.getMappingQuality();
        cramRecord.setDuplicate(record.getDuplicateReadFlag());
        cramRecord.templateSize = record.getInferredInsertSize();
        SAMReadGroupRecord readGroup = record.getReadGroup();
        cramRecord.readGroupID = readGroup != null ? this.readGroupMap.get(readGroup.getId()) : -1;
        if (!record.getReadPairedFlag()) {
            cramRecord.setLastSegment(false);
        } else if (record.getFirstOfPairFlag()) {
            cramRecord.setLastSegment(false);
        } else if (record.getSecondOfPairFlag()) {
            cramRecord.setLastSegment(true);
        }
        cramRecord.readFeatures = !record.getReadUnmappedFlag() && record.getAlignmentStart() != 0 ? this.checkedCreateVariations(cramRecord, record) : Collections.emptyList();
        cramRecord.readBases = record.getReadBases();
        cramRecord.qualityScores = record.getBaseQualities();
        this.landedTotalScores += (long)cramRecord.readLength;
        if (this.version.compatibleWith(CramVersions.CRAM_v3)) {
            cramRecord.setUnknownBases(record.getReadBases() == SAMRecord.NULL_SEQUENCE);
        }
        this.readTagList.clear();
        if (this.captureAllTags) {
            List<SAMRecord.SAMTagAndValue> attributes = record.getAttributes();
            for (SAMRecord.SAMTagAndValue tagAndValue : attributes) {
                if (this.ignoreTags.contains(tagAndValue.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(tagAndValue.tag, tagAndValue.value));
            }
        } else if (!this.captureTags.isEmpty()) {
            List<SAMRecord.SAMTagAndValue> attributes = record.getAttributes();
            cramRecord.tags = new ReadTag[attributes.size()];
            for (SAMRecord.SAMTagAndValue tagAndValue : attributes) {
                if (!this.captureTags.contains(tagAndValue.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(tagAndValue.tag, tagAndValue.value));
            }
        }
        cramRecord.tags = this.readTagList.toArray(new ReadTag[this.readTagList.size()]);
        cramRecord.setVendorFiltered(record.getReadFailsVendorQualityCheckFlag());
        if (this.preserveReadNames) {
            cramRecord.readName = record.getReadName();
        }
        return cramRecord;
    }

    private List<ReadFeature> checkedCreateVariations(CramCompressionRecord cramRecord, SAMRecord samRecord) {
        try {
            return this.createVariations(cramRecord, samRecord);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error("Reference bases array length=" + this.refBases.length);
            log.error("Offensive CRAM record: " + cramRecord.toString());
            log.error("Offensive SAM record: " + samRecord.getSAMString());
            throw e;
        }
    }

    private List<ReadFeature> createVariations(CramCompressionRecord cramRecord, SAMRecord samRecord) {
        LinkedList<ReadFeature> features = new LinkedList<ReadFeature>();
        int zeroBasedPositionInRead = 0;
        int alignmentStartOffset = 0;
        List<CigarElement> cigarElements = samRecord.getCigar().getCigarElements();
        int cigarLen = 0;
        for (CigarElement cigarElement : cigarElements) {
            if (!cigarElement.getOperator().consumesReadBases()) continue;
            cigarLen += cigarElement.getLength();
        }
        byte[] bases = samRecord.getReadBases();
        if (bases.length == 0) {
            bases = new byte[cigarLen];
            Arrays.fill(bases, (byte)78);
        }
        byte[] qualityScore = samRecord.getBaseQualities();
        for (CigarElement cigarElement : cigarElements) {
            int cigarElementLength = cigarElement.getLength();
            CigarOperator operator = cigarElement.getOperator();
            switch (operator) {
                case D: {
                    features.add(new Deletion(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case N: {
                    features.add(new RefSkip(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case P: {
                    features.add(new Padding(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case H: {
                    features.add(new HardClip(zeroBasedPositionInRead + 1, cigarElementLength));
                    break;
                }
                case S: {
                    this.addSoftClip(features, zeroBasedPositionInRead, cigarElementLength, bases);
                    break;
                }
                case I: {
                    this.addInsertion(features, zeroBasedPositionInRead, cigarElementLength, bases);
                    break;
                }
                case M: 
                case X: 
                case EQ: {
                    this.addSubstitutionsAndMaskedBases(cramRecord, features, zeroBasedPositionInRead, alignmentStartOffset, cigarElementLength, bases, qualityScore);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported cigar operator: " + (Object)((Object)cigarElement.getOperator()));
                }
            }
            if (cigarElement.getOperator().consumesReadBases()) {
                zeroBasedPositionInRead += cigarElementLength;
            }
            if (!cigarElement.getOperator().consumesReferenceBases()) continue;
            alignmentStartOffset += cigarElementLength;
        }
        this.baseCount += (long)bases.length;
        this.featureCount += (long)features.size();
        return features;
    }

    private void addSoftClip(List<ReadFeature> features, int zeroBasedPositionInRead, int cigarElementLength, byte[] bases) {
        byte[] insertedBases = Arrays.copyOfRange(bases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        SoftClip softClip = new SoftClip(zeroBasedPositionInRead + 1, insertedBases);
        features.add(softClip);
    }

    private void addHardClip(List<ReadFeature> features, int zeroBasedPositionInRead, int cigarElementLength, byte[] bases) {
        byte[] insertedBases = Arrays.copyOfRange(bases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        HardClip hardClip = new HardClip(zeroBasedPositionInRead + 1, insertedBases.length);
        features.add(hardClip);
    }

    private void addInsertion(List<ReadFeature> features, int zeroBasedPositionInRead, int cigarElementLength, byte[] bases) {
        byte[] insertedBases = Arrays.copyOfRange(bases, zeroBasedPositionInRead, zeroBasedPositionInRead + cigarElementLength);
        for (int i = 0; i < insertedBases.length; ++i) {
            InsertBase insertBase = new InsertBase();
            insertBase.setPosition(zeroBasedPositionInRead + 1 + i);
            insertBase.setBase(insertedBases[i]);
            features.add(insertBase);
        }
    }

    private void addSubstitutionsAndMaskedBases(CramCompressionRecord cramRecord, List<ReadFeature> features, int fromPosInRead, int alignmentStartOffset, int nofReadBases, byte[] bases, byte[] qualityScore) {
        boolean noQS = qualityScore.length == 0;
        for (int i = 0; i < nofReadBases; ++i) {
            byte snpOrNot;
            int oneBasedPositionInRead = i + fromPosInRead + 1;
            int referenceCoordinates = cramRecord.alignmentStart + i + alignmentStartOffset - 1;
            boolean qualityAdded = false;
            byte refBase = referenceCoordinates >= this.refBases.length ? (byte)78 : this.refBases[referenceCoordinates];
            if (bases[i + fromPosInRead] != (refBase = Utils.normalizeBase(refBase))) {
                Substitution substitution = new Substitution();
                substitution.setPosition(oneBasedPositionInRead);
                substitution.setBase(bases[i + fromPosInRead]);
                substitution.setReferenceBase(refBase);
                features.add(substitution);
                if (noQS) continue;
            }
            if (noQS) continue;
            if (this.refSNPs != null && (snpOrNot = this.refSNPs[referenceCoordinates]) != 0) {
                byte score = (byte)(33 + qualityScore[i + fromPosInRead]);
                features.add(new BaseQualityScore(oneBasedPositionInRead, score));
                qualityAdded = true;
                ++this.landedRefMaskScores;
            }
            if (!qualityAdded) continue;
            ++this.landedTotalScores;
        }
    }

    public long getLandedRefMaskScores() {
        return this.landedRefMaskScores;
    }

    public long getLandedTotalScores() {
        return this.landedTotalScores;
    }

    public byte[] getRefBases() {
        return this.refBases;
    }

    public void setRefBases(byte[] refBases) {
        this.refBases = refBases;
    }

    public byte[] getRefSNPs() {
        return this.refSNPs;
    }

    public void setRefSNPs(byte[] refSNPs) {
        this.refSNPs = refSNPs;
    }

    public Map<String, Integer> getReadGroupMap() {
        return this.readGroupMap;
    }

    public long getBaseCount() {
        return this.baseCount;
    }

    public long getFeatureCount() {
        return this.featureCount;
    }
}

