/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Time;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import projects.dream2016.DataParser;

public class GenomeWideScan {
    public static void main(String[] args) throws Exception {
        int f;
        DataParser pars = new DataParser(args[0]);
        AlphabetContainer origCon = null;
        Object transCon = null;
        ArrayList<AbstractScoreBasedClassifier> cl = new ArrayList<AbstractScoreBasedClassifier>();
        int offset = 3;
        while (new File(args[offset]).exists()) {
            cl.add((AbstractScoreBasedClassifier)XMLParser.extractObjectForTags(FileManager.readFile(args[offset]), "classifier"));
            ++offset;
        }
        HashSet<String> chrs = null;
        if (!args[2].equals("?")) {
            chrs = new HashSet<String>();
            String[] chr = args[2].split(",");
            int i = 0;
            while (i < chr.length) {
                chrs.add(chr[i]);
                ++i;
            }
            System.out.println("Try to make predictions only for: " + chrs);
        }
        int windows = Integer.parseInt(args[offset++]);
        int c = 0;
        int start = 0;
        int last = -1;
        int a = -1;
        int p = -1000;
        String chr = null;
        int l = args.length - offset;
        BufferedReader[] reader = new BufferedReader[l];
        int f2 = 0;
        while (f2 < l) {
            GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[f2 + offset]));
            reader[f2] = new BufferedReader(new InputStreamReader(stream));
            ++f2;
        }
        Object[] line = new String[l];
        String[] li = new String[l];
        int[] remove = null;
        String[] split = null;
        double[] scores = new double[2];
        double ls = 0.0;
        boolean[] read = new boolean[l];
        Arrays.fill(read, true);
        Time t = Time.getTimeInstance(null);
        FileOutputStream output = new FileOutputStream(args[1]);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(output), "UTF-8"));
        w.append("#chr\tpos");
        int f3 = 3;
        while (f3 < offset) {
            w.append("\t" + args[f3]);
            ++f3;
        }
        w.newLine();
        boolean use = false;
        block4: while (true) {
            boolean any = false;
            f = 0;
            while (f < l) {
                if (read[f]) {
                    line[f] = reader[f].readLine();
                    boolean bl = read[f] = line[f] != null && ((String)line[f]).charAt(0) != '[';
                }
                if (!read[f]) {
                    int an;
                    int anzahl;
                    if (args[f + offset].endsWith("hg19.fa_other.txt.gz")) {
                        li[f] = "0.5\t0.125\t0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith("hg19.fa_tracts.txt.gz")) {
                        li[f] = "0\t0\t0\t0";
                    } else if (args[f + offset].endsWith("gencode.v19.types.txt.gz")) {
                        li[f] = String.valueOf(chr) + "\t" + start + "\t----------";
                    } else if (args[f + offset].endsWith(".bigwig-interval.txt.gz")) {
                        li[f] = "0\t0\t0\t0";
                    } else if (args[f + offset].endsWith(".xml_winscores2.txt.gz")) {
                        li[f] = "Inf\tInf\t0\t0\t..0";
                    } else if (args[f + offset].endsWith("_winscores2.txt.gz")) {
                        li[f] = "Inf\tInf\t0\t0\t..0";
                    } else if (args[f + offset].endsWith("hg19.genome.fa.seqs.gz")) {
                        li[f] = "CTTAGCGGAAATAGGAGAAACTGTACTAGACGTCCTTGATCGTTATTCGG";
                    } else if (args[f + offset].endsWith("expression-interval.txt.gz")) {
                        li[f] = "0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith("specific.txt.gz")) {
                        li[f] = "";
                        anzahl = args[f + offset].substring(args[f + offset].lastIndexOf("/") + 1).startsWith("qN-") ? 2 : 1;
                        an = 0;
                        while (an < anzahl) {
                            int n = f;
                            li[n] = String.valueOf(li[n]) + (an == 0 ? "" : "\t") + "0.0";
                            ++an;
                        }
                    } else if (args[f + offset].endsWith("conserved.txt.gz")) {
                        li[f] = "";
                        anzahl = args[f + offset].substring(args[f + offset].lastIndexOf("/") + 1).startsWith("dnase") ? 2 : 1;
                        an = 0;
                        while (an < anzahl) {
                            int n = f;
                            li[n] = String.valueOf(li[n]) + (an == 0 ? "" : "\t") + "0.0\t0.0";
                            ++an;
                        }
                    } else if (args[f + offset].endsWith("_bw.gz")) {
                        li[f] = "0.0\t0.0\t0.0\t0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith("DNase-peak2interval.txt.gz")) {
                        li[f] = "0.0\t0.0";
                    } else if (args[f + offset].endsWith("fc.signal.bigwig-interval-orange.txt.gz")) {
                        li[f] = "0.0\t0.0\t0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith("DNase-peakStat2interval.txt.gz")) {
                        li[f] = "0.0\t0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith(".nearest_tss.txt.gz")) {
                        li[f] = String.valueOf(chr) + "\t" + start + "\t1E6\t-1\t1E6\t-1\t1E6\t-1\t1E6\t-1";
                    } else {
                        System.out.println("WARNING: no default values for " + args[f + offset]);
                    }
                } else {
                    li[f] = line[f];
                }
                any |= read[f];
                ++f;
            }
            if (!any) {
                if (use) {
                    System.out.println("last window\t" + chr + "\t" + p + "\t" + (p + 50) + "\t" + t.getElapsedTime());
                }
                System.out.println(Arrays.toString(line));
                boolean changed = false;
                int f4 = 0;
                while (f4 < l) {
                    int n = 0;
                    while (line[f4] != null && (((String)line[f4]).charAt(0) != '[' || ((String)line[f4]).indexOf(95) >= 0)) {
                        line[f4] = reader[f4].readLine();
                        ++n;
                    }
                    changed |= n > 0;
                    if (line[f4] == null) break block4;
                    if (!((String)line[f4]).equals(line[0])) {
                        throw new Exception("Mismatch:\nFile 0: " + args[offset] + "\nLine: " + (String)line[0] + "\nFile " + f4 + ": " + args[f4 + offset] + "\nLine: " + (String)line[f4]);
                    }
                    read[f4] = true;
                    ++f4;
                }
                if (changed) {
                    System.out.println("=> " + Arrays.toString(line));
                }
                chr = ((String)line[0]).substring(1, ((String)line[0]).length() - 1);
                boolean bl = use = chrs != null ? chrs.contains(chr) : true;
                if (!use) {
                    System.out.println("skip " + chr);
                }
                c = 0;
                start = 0;
                p = -100000;
                continue;
            }
            if (!use) continue;
            if (remove == null) {
                remove = new int[l];
                f = 0;
                while (f < l) {
                    remove[f] = 0;
                    if (li[f].startsWith(String.valueOf(chr) + "\t")) {
                        int pos = li[f].indexOf(9) + 1;
                        li[f] = li[f].substring(pos);
                        int n = f;
                        remove[n] = remove[n] + 1;
                        if (li[f].startsWith(String.valueOf(start) + "\t")) {
                            pos = li[f].indexOf(9) + 1;
                            li[f] = li[f].substring(pos);
                            int n2 = f;
                            remove[n2] = remove[n2] + 1;
                        }
                    }
                    ++f;
                }
            } else {
                f = 0;
                while (f < l) {
                    int r = 0;
                    while (r < remove[f]) {
                        int pos = li[f].indexOf(9) + 1;
                        li[f] = li[f].substring(pos);
                        ++r;
                    }
                    ++f;
                }
            }
            ++c;
            p = (start += 50) - (windows + 1) / 2 * 50;
            if (split == null) {
                a = 0;
                f = 0;
                while (f < li.length) {
                    a += li[f].split("\t").length;
                    ++f;
                }
                split = new String[windows * a];
                last = a * (windows - 1);
            } else {
                System.arraycopy(split, a, split, 0, last);
            }
            f = 0;
            int b = last;
            while (f < l) {
                String[] help = li[f].split("\t");
                System.arraycopy(help, 0, split, b, help.length);
                b += help.length;
                ++f;
            }
            if (c < windows) continue;
            ArbitrarySequence s = pars.parse(origCon, split);
            if (origCon == null) {
                origCon = s.getAlphabetContainer();
            }
            w.append(String.valueOf(chr) + "\t" + p);
            int d = 0;
            while (d < cl.size()) {
                AbstractScoreBasedClassifier cla = (AbstractScoreBasedClassifier)cl.get(d);
                scores[0] = cla.getScore(s, 0);
                scores[1] = cla.getScore(s, 1);
                ls = Normalisation.getLogSum(scores);
                w.append("\t" + Math.exp(scores[0] - ls));
                ++d;
            }
            w.newLine();
        }
        System.out.println("elapsed time: " + t.getElapsedTime());
        w.close();
        f = 0;
        while (f < l) {
            reader[f].close();
            ++f;
        }
    }
}

