/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.data.DataSet;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.results.Result;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.OperationNotSupportedException;

public class RegionOtherScan2 {
    public static void main(String[] args) throws Exception {
        Pair<int[][], DataSet> seqs = null;
        StringBuffer lastHeader = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(args[0]));
        DecimalFormat nf = new DecimalFormat("#.####");
        DecimalFormatSymbols syms = nf.getDecimalFormatSymbols();
        syms.setInfinity("Inf");
        syms.setNaN("NaN");
        nf.setDecimalFormatSymbols(syms);
        PrintWriter wr = new PrintWriter(String.valueOf(args[0]) + "_other.txt");
        double[] score = null;
        int sl = 50;
        int currIdx = 0;
        int lastOff = 0;
        String lastId = null;
        Pair<HashMap<Sequence, Integer>, double[]> temp = RegionOtherScan2.getIndex(1);
        HashMap<Sequence, Integer> i1 = temp.getFirstElement();
        double[] c1 = temp.getSecondElement();
        double[] e1 = (double[])c1.clone();
        temp = RegionOtherScan2.getIndex(2);
        HashMap<Sequence, Integer> i2 = temp.getFirstElement();
        double[] c2 = temp.getSecondElement();
        double[] e2 = (double[])c2.clone();
        temp = RegionOtherScan2.getIndex(3);
        HashMap<Sequence, Integer> i3 = temp.getFirstElement();
        double[] c3 = temp.getSecondElement();
        double[] e3 = (double[])c3.clone();
        while ((seqs = RegionOtherScan2.readNextSequences(read, lastHeader)) != null) {
            DataSet ds = seqs.getSecondElement();
            int[][] idxs = seqs.getFirstElement();
            int i = 0;
            while (i < ds.getNumberOfElements()) {
                Sequence seq = ds.getElementAt(i);
                String id = seq.getSequenceAnnotationByType("id", 0).getIdentifier();
                if (!id.equals(lastId)) {
                    currIdx = 0;
                    lastOff = 0;
                    Arrays.fill(c1, 0.0);
                    Arrays.fill(c2, 0.0);
                    Arrays.fill(c3, 0.0);
                    wr.println("[" + id + "]");
                }
                int off = idxs[0][i];
                int j = lastOff;
                while (j < off) {
                    if (++currIdx == sl) {
                        score = RegionOtherScan2.getFeatures(null, j, i1, c1, i2, c2, i3, c3, e1, e2, e3);
                        RegionOtherScan2.print(wr, id, score, lastOff, j, currIdx);
                        Arrays.fill(c1, 0.0);
                        Arrays.fill(c2, 0.0);
                        Arrays.fill(c3, 0.0);
                        currIdx = 0;
                    }
                    ++j;
                }
                j = 0;
                while (j < seq.getLength()) {
                    RegionOtherScan2.addCounts(seq, j, i1, c1);
                    RegionOtherScan2.addCounts(seq, j, i2, c2);
                    RegionOtherScan2.addCounts(seq, j, i3, c3);
                    if (++currIdx == sl) {
                        score = RegionOtherScan2.getFeatures(seq, j, i1, c1, i2, c2, i3, c3, e1, e2, e3);
                        RegionOtherScan2.print(wr, id, score, off, j, currIdx);
                        Arrays.fill(c1, 0.0);
                        Arrays.fill(c2, 0.0);
                        Arrays.fill(c3, 0.0);
                        currIdx = 0;
                    }
                    lastOff = off + j + 1;
                    ++j;
                }
                lastId = id;
                ++i;
            }
        }
        read.close();
        wr.close();
    }

    private static Pair<HashMap<Sequence, Integer>, double[]> getIndex(int k) throws OperationNotSupportedException {
        DiscreteSequenceEnumerator en1 = new DiscreteSequenceEnumerator(DNAAlphabetContainer.SINGLETON, k, true);
        HashMap<Object, Integer> i1 = new HashMap<Object, Integer>();
        int idx = 0;
        while (en1.hasMoreElements()) {
            Object s = en1.nextElement();
            i1.put(s, idx);
            i1.put(((Sequence)s).reverseComplement(), idx);
            ++idx;
        }
        double[] c1 = new double[idx];
        en1.reset();
        while (en1.hasMoreElements()) {
            Object s = en1.nextElement();
            int n = (Integer)i1.get(s);
            c1[n] = c1[n] + 1.0;
            int n2 = (Integer)i1.get(((Sequence)s).reverseComplement());
            c1[n2] = c1[n2] + 1.0;
        }
        Normalisation.sumNormalisation(c1);
        return new Pair<HashMap<Sequence, Integer>, double[]>(i1, c1);
    }

    private static double[] getFeatures(Sequence seq, int j, HashMap<Sequence, Integer> i1, double[] c1, HashMap<Sequence, Integer> i2, double[] c2, HashMap<Sequence, Integer> i3, double[] c3, double[] e1, double[] e2, double[] e3) throws IllegalArgumentException, WrongAlphabetException {
        if (seq == null) {
            return new double[]{0.5, 0.125, 0.0, 0.0, 0.0};
        }
        double gc = c1[i1.get(Sequence.create(DNAAlphabetContainer.SINGLETON, "C"))];
        double at = c1[i1.get(Sequence.create(DNAAlphabetContainer.SINGLETON, "A"))];
        if ((gc /= gc + at) < 0.0 || gc > 1.0) {
            System.out.println(gc);
            System.out.println(Arrays.toString(c1));
            System.exit(1);
        }
        double cpg = c2[i2.get(Sequence.create(DNAAlphabetContainer.SINGLETON, "CG"))];
        double en1 = RegionOtherScan2.getKL(c1, e1);
        double en2 = RegionOtherScan2.getKL(c2, e2);
        double en3 = RegionOtherScan2.getKL(c3, e3);
        return new double[]{gc, cpg /= ToolBox.sum(c2), en1, en2, en3};
    }

    private static double getKL(double[] counts, double[] ref) {
        double n = ToolBox.sum(counts);
        double en = 0.0;
        int j = 0;
        while (j < counts.length) {
            if (counts[j] > 0.0) {
                en += counts[j] / n * (Math.log(counts[j] / n) - Math.log(ref[j]));
            }
            ++j;
        }
        return en;
    }

    private static void addCounts(Sequence seq, int j, HashMap<Sequence, Integer> indexes, double[] counts) {
        int sl = indexes.keySet().iterator().next().getLength();
        if (seq.getLength() - j >= sl) {
            Sequence sub = seq.getSubSequence(j, sl);
            if (j == 0 && sl == seq.getLength()) {
                sub = sub.annotate(false, null);
            }
            try {
                int n = indexes.get(sub);
                counts[n] = counts[n] + 1.0;
            }
            catch (NullPointerException ex) {
                System.out.println(String.valueOf(j) + " " + sl + " " + seq.getLength());
                System.out.println(seq.getSubSequence(j, sl));
                System.out.println(indexes);
                System.out.println(indexes.get(seq.getSubSequence(j, sl)));
                Sequence temp = seq.getSubSequence(j, sl);
                Sequence temp2 = indexes.keySet().toArray(new Sequence[0])[3];
                System.out.println(temp + " " + temp2 + " " + indexes.get(temp) + " " + indexes.get(temp2) + " " + temp.hashCode() + " " + temp2.hashCode() + " " + seq.hashCode());
                System.out.println(sub + " " + temp2 + " " + indexes.get(sub) + " " + indexes.get(temp2) + " " + sub.hashCode() + " " + temp2.hashCode() + " " + seq.hashCode());
                throw ex;
            }
        }
    }

    private static void print(PrintWriter wr, String id, double[] scores1, int off, int j, int end) {
        double en1 = scores1[2];
        double en2 = scores1[3];
        double en3 = scores1[4];
        double gc = scores1[0];
        double cpg = scores1[1];
        wr.println(String.valueOf(gc) + "\t" + cpg + "\t" + en1 + "\t" + en2 + "\t" + en3);
    }

    public static double getConsensusScore(double[][] pwm) {
        double score = 0.0;
        int i = 0;
        while (i < pwm.length) {
            score += ToolBox.max(pwm[i]);
            ++i;
        }
        return score;
    }

    public static Pair<int[][], DataSet> readNextSequences(BufferedReader read, StringBuffer lastHeader) throws Exception {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        int size = 0;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1).trim());
                }
                if (line.length() <= 0) continue;
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    SequenceAnnotation annotation = new SequenceAnnotation("id", header, (Result[][])new Result[0][]);
                    Sequence seq = Sequence.create(DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                    seq = seq.annotate(false, annotation);
                    seqs.add(seq);
                    size += end - start;
                    starts.add(start);
                }
                if (!((double)size > 1.0E7) && str != null) continue;
                boolean s = false;
                return new Pair<int[][], DataSet>(new int[][]{starts.toArray()}, new DataSet("", seqs));
            }
            line.append(str);
        }
        return null;
    }
}

