/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream;

import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;

public class AggregateMotifProfiles {
    public static void run(BufferedReader read, PrintStream out, int bin, String faiFile) throws IOException {
        BufferedReader faidx = new BufferedReader(new InputStreamReader(new FileInputStream(faiFile)));
        String str = null;
        HashMap<String, Integer> sizes = new HashMap<String, Integer>();
        while ((str = faidx.readLine()) != null) {
            String[] parts = str.split("\t");
            String chr = parts[0];
            int len = Integer.parseInt(parts[1]);
            sizes.put(chr, len);
        }
        String lastChr = "";
        str = null;
        DoubleList scores = new DoubleList();
        int start = 0;
        int last = 0;
        while ((str = read.readLine()) != null) {
            String[] parts = str.split("\t");
            if (parts.length != 4) continue;
            String chr = parts[0];
            if (!chr.equals(lastChr)) {
                last = start - start % bin;
                if (lastChr.length() > 0 && last + bin <= (Integer)sizes.get(lastChr)) {
                    AggregateMotifProfiles.print(lastChr, last, scores, out);
                }
                if (lastChr.length() > 0 && last + bin <= (Integer)sizes.get(lastChr)) {
                    AggregateMotifProfiles.print(lastChr, last + bin, (Integer)sizes.get(lastChr) - bin, bin, out);
                }
                scores.clear();
            }
            start = Integer.parseInt(parts[1]);
            double fwd = Double.parseDouble(parts[2]);
            double rev = Double.parseDouble(parts[3]);
            if (scores.length() == 0 && start > bin) {
                AggregateMotifProfiles.print(chr, 0, start - bin, bin, out);
                last = start;
            }
            if (start % bin == 0) {
                if (last + bin != start - bin) {
                    AggregateMotifProfiles.print(chr, last + bin, start - 2 * bin, bin, out);
                }
                last = start - bin;
                AggregateMotifProfiles.print(chr, last, scores, out);
                scores.clear();
            }
            scores.add(fwd);
            scores.add(rev);
            lastChr = chr;
        }
        last = start - (start % bin == 0 ? bin : start % bin);
        if (last + bin <= (Integer)sizes.get(lastChr)) {
            AggregateMotifProfiles.print(lastChr, last, scores, out);
        }
        if (last + bin <= (Integer)sizes.get(lastChr)) {
            AggregateMotifProfiles.print(lastChr, last + bin, (Integer)sizes.get(lastChr) - bin, bin, out);
        }
    }

    private static void print(String chr, int start, int end, int bin, PrintStream out) {
        int i = start;
        while (i <= end) {
            out.println(String.valueOf(chr) + "\t" + i + "\tNA\tNA");
            i += bin;
        }
    }

    private static void print(String chr, int off, DoubleList scores, PrintStream out) {
        if (scores.length() == 0) {
            return;
        }
        double[] temp = scores.toArray();
        double max = ToolBox.max(temp);
        double ls = Normalisation.getLogSum(temp);
        out.println(String.valueOf(chr) + "\t" + off + "\t" + max + "\t" + ls);
    }
}

