/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream;

import de.jstacs.utils.DoubleList;
import de.jstacs.utils.ToolBox;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;
import projects.encodedream.ObjectStream;
import projects.encodedream.Pileup;

public class Coverage {
    public static void main(String[] args) {
        ObjectStream<Pileup.CovPile> ps2 = new ObjectStream<Pileup.CovPile>(10000);
        new Thread(() -> {
            try {
                Pileup.pileup(args[0], ps2, false, true);
                ps2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        double lambdaBG = Coverage.estimateLambdaBG(ps2, args[0]);
        ObjectStream<Pileup.CovPile> ps = new ObjectStream<Pileup.CovPile>(10000);
        new Thread(() -> {
            try {
                Pileup.pileup(args[0], ps, false, true);
                ps.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        Coverage.coverage(ps, lambdaBG, args[0], System.out, 50);
    }

    public static double estimateLambdaBG(ObjectStream<Pileup.CovPile> ps, String bam) {
        SamReaderFactory srf = SamReaderFactory.makeDefault();
        srf.validationStringency(ValidationStringency.SILENT);
        SamReader sr = srf.open(new File(bam));
        SAMSequenceDictionary dict = sr.getFileHeader().getSequenceDictionary();
        double sum = 0.0;
        double n = 0.0;
        String lastChr = "";
        while (ps.hasNext()) {
            Pileup.CovPile pile = ps.next();
            String chr = pile.getChr();
            double count = pile.getFivePrime();
            if (!chr.equals(lastChr)) {
                n += (double)dict.getSequence(chr).getSequenceLength();
            }
            sum += count;
            lastChr = chr;
        }
        return sum / n;
    }

    public static void coverage(String faiFile, String bigwig, PrintStream out, int bin) throws NumberFormatException, IOException {
        BigWigAccessor bwa = new BigWigAccessor(bigwig);
        BufferedReader read = new BufferedReader(new FileReader(faiFile));
        String str = null;
        while ((str = read.readLine()) != null) {
            String[] parts = str.split("\t");
            String chr = parts[0];
            int len = Integer.parseInt(parts[1]);
            double[] orig = bwa.getProfileInRegion(chr, 0, len);
            double[][] temp = Coverage.aggregate(orig, bin);
            Coverage.print(chr, temp, out, bin);
        }
    }

    public static void coverageMeth(String faiFile, String bedFileGz, PrintStream out, int bin) throws NumberFormatException, FileNotFoundException, IOException {
        SortedBedAccessor sba = new SortedBedAccessor(bedFileGz);
        BufferedReader read = new BufferedReader(new FileReader(faiFile));
        String str = null;
        while ((str = read.readLine()) != null) {
            String[] parts = str.split("\t");
            String chr = parts[0];
            int len = Integer.parseInt(parts[1]);
            double[] orig = sba.getProfileForChromosome(chr, len);
            double[][] temp = Coverage.aggregateMeth(orig, bin);
            Coverage.print(chr, temp, out, bin);
        }
        read.close();
    }

    public static void coverage(ObjectStream<Pileup.CovPile> ps, double lambdaBG, String bam, PrintStream out, int bin) {
        SamReaderFactory srf = SamReaderFactory.makeDefault();
        srf.validationStringency(ValidationStringency.SILENT);
        SamReader sr = srf.open(new File(bam));
        SAMSequenceDictionary dict = sr.getFileHeader().getSequenceDictionary();
        double[] orig = null;
        String lastChr = "";
        while (ps.hasNext()) {
            Pileup.CovPile pile = ps.next();
            String chr = pile.getChr();
            int pos = pile.getPos();
            double count = pile.getFivePrime();
            if (!chr.equals(lastChr)) {
                if (orig != null) {
                    double[][] temp = Coverage.process(orig, lambdaBG, bin);
                    Coverage.print(lastChr, temp, out, bin);
                }
                if (lastChr.length() > 0 && dict.getSequenceIndex(chr) != dict.getSequenceIndex(lastChr) + 1) {
                    int k = dict.getSequenceIndex(lastChr) + 1;
                    while (k < dict.getSequenceIndex(chr)) {
                        orig = new double[dict.getSequence(k).getSequenceLength()];
                        double[][] temp = Coverage.process(orig, lambdaBG, bin);
                        Coverage.print(dict.getSequence(k).getSequenceName(), temp, out, bin);
                        ++k;
                    }
                }
                orig = new double[dict.getSequence(chr).getSequenceLength()];
            }
            orig[pos - 1] = count;
            lastChr = chr;
        }
        double[][] temp = Coverage.process(orig, lambdaBG, bin);
        Coverage.print(lastChr, temp, out, bin);
        int i = dict.getSequenceIndex(lastChr) + 1;
        while (i < dict.size()) {
            orig = new double[dict.getSequence(i).getSequenceLength()];
            temp = Coverage.process(orig, lambdaBG, bin);
            Coverage.print(dict.getSequence(i).getSequenceName(), temp, out, bin);
            ++i;
        }
    }

    private static void print(String chr, double[][] temp, PrintStream out, int bin) {
        int i = 0;
        while (i < temp.length) {
            out.print(chr);
            out.print("\t");
            out.print(i * bin);
            int j = 0;
            while (j < temp[i].length) {
                out.print("\t");
                out.print(temp[i][j]);
                ++j;
            }
            out.println();
            ++i;
        }
    }

    private static double[][] process(double[] orig, double lambdaBG, int bin) {
        double[] processed = new double[orig.length];
        double[] sum = new double[]{0.0, 0.0};
        double[] n = new double[]{0.0, 0.0};
        int[] l = new int[]{Math.min(5000, orig.length), Math.min(10000, orig.length)};
        int j = 0;
        while (j < sum.length) {
            int i = 0;
            while (i < l[j]) {
                int n2 = j;
                sum[n2] = sum[n2] + orig[i];
                int n3 = j;
                n[n3] = n[n3] + 1.0;
                ++i;
            }
            ++j;
        }
        int i = 0;
        while (i < orig.length) {
            int j2 = 0;
            while (j2 < l.length) {
                if (i + l[j2] < orig.length) {
                    int n4 = j2;
                    sum[n4] = sum[n4] + orig[i + l[j2]];
                } else {
                    int n5 = j2;
                    n[n5] = n[n5] - 1.0;
                }
                if (i - l[j2] - 1 >= 0) {
                    int n6 = j2;
                    sum[n6] = sum[n6] - orig[i - l[j2] - 1];
                } else {
                    int n7 = j2;
                    n[n7] = n[n7] + 1.0;
                }
                ++j2;
            }
            double lambda = lambdaBG;
            int j3 = 0;
            while (j3 < sum.length) {
                double temp = sum[j3] / n[j3];
                if (temp > lambda) {
                    lambda = temp;
                }
                ++j3;
            }
            processed[i] = orig[i] / lambda;
            ++i;
        }
        double sum2 = 0.0;
        double n8 = 0.0;
        int l2 = 75;
        int i2 = 0;
        while (i2 < l2) {
            sum2 += processed[i2];
            n8 += 1.0;
            ++i2;
        }
        i2 = 0;
        while (i2 < processed.length) {
            if (i2 + l2 < processed.length) {
                sum2 += processed[i2 + l2];
            } else {
                n8 -= 1.0;
            }
            if (i2 - l2 - 1 >= 0) {
                sum2 -= processed[i2 - l2 - 1];
            } else {
                n8 += 1.0;
            }
            orig[i2] = sum2 / n8;
            ++i2;
        }
        return Coverage.aggregate(orig, bin);
    }

    private static double[][] aggregateMeth(double[] orig, int bin) {
        int broad = 1000;
        DoubleList temp = new DoubleList(bin + 1);
        double[][] res = new double[orig.length / bin][];
        int i = 0;
        while (i + bin <= orig.length) {
            temp.clear();
            int j = i;
            while (j < i + bin) {
                if (!Double.isNaN(orig[j])) {
                    temp.add(orig[j]);
                }
                ++j;
            }
            double min = 0.0;
            double average = 0.0;
            double max = 0.0;
            if (temp.length() > 0) {
                min = temp.min(0, temp.length());
                average = temp.mean(0, temp.length());
                max = temp.max(0, temp.length());
            }
            double[] dArray = new double[8];
            res[i / bin] = dArray;
            dArray[0] = min;
            res[i / bin][1] = average;
            res[i / bin][2] = max;
            i += bin;
        }
        i = 0;
        while (i < orig.length) {
            if (Double.isNaN(orig[i])) {
                orig[i] = 0.0;
            }
            ++i;
        }
        i = 0;
        while (i + bin <= orig.length) {
            double mean = ToolBox.mean(i, i + bin, orig);
            int broadStart = Math.max(0, i - broad);
            int broadEnd = Math.min(orig.length, i + broad);
            double bMeanAfter = ToolBox.mean(i, broadEnd, orig);
            double bMeanBefore = ToolBox.mean(broadStart, i + 1, orig);
            double bMaxAfter = ToolBox.max(i, broadEnd, orig);
            double bMaxBefore = ToolBox.max(broadStart, i + 1, orig);
            res[i / bin][3] = mean;
            res[i / bin][4] = bMeanAfter;
            res[i / bin][5] = bMeanBefore;
            res[i / bin][6] = bMaxAfter;
            res[i / bin][7] = bMaxBefore;
            i += bin;
        }
        return res;
    }

    private static double[][] aggregate(double[] orig, int bin) {
        int broad = 1000;
        double[][] res = new double[orig.length / bin][];
        int i = 0;
        while (i + bin <= orig.length) {
            double min = ToolBox.min(i, i + bin, orig);
            double median = ToolBox.median(i, i + bin, orig);
            int broadStart = Math.max(0, i - broad);
            int broadEnd = Math.min(orig.length, i + broad);
            double bMinAfter = ToolBox.min(i, broadEnd, orig);
            double bMinBefore = ToolBox.min(broadStart, i + 1, orig);
            double bMaxAfter = ToolBox.max(i, broadEnd, orig);
            double bMaxBefore = ToolBox.max(broadStart, i + 1, orig);
            double orange = Coverage.orange(i, i + bin, orig);
            double stepsUp = Coverage.mostMonotonSteps(i, i + bin, orig, 1.0);
            double stepsDown = Coverage.mostMonotonSteps(i, i + bin, orig, -1.0);
            res[i / bin] = new double[]{min, median, bMinAfter, bMinBefore, bMaxAfter, bMaxBefore, orange, stepsUp, stepsDown};
            i += bin;
        }
        return res;
    }

    private static int orange(int start, int end, double[] profile) {
        int different = 0;
        start = Math.max(0, start);
        end = Math.min(profile.length, end);
        int s = start + 1;
        while (s < end) {
            if (profile[s - 1] != profile[s]) {
                ++different;
            }
            ++s;
        }
        return different;
    }

    private static int mostMonotonSteps(int start, int end, double[] profile, double vz) {
        int num = 0;
        int max = 0;
        start = Math.max(0, start);
        end = Math.min(profile.length, end);
        int s = start + 1;
        while (s < end) {
            if (vz * profile[s - 1] < vz * profile[s]) {
                ++num;
            } else if (vz * profile[s - 1] > vz * profile[s]) {
                if (num > max) {
                    max = num;
                }
                num = 0;
            }
            ++s;
        }
        return max;
    }

    private static class BigWigAccessor {
        private BBFileReader reader;

        public BigWigAccessor(String bigWigFile) throws IOException {
            this.reader = new BBFileReader(bigWigFile);
            BBFileHeader header = this.reader.getBBFileHeader();
            if (!header.isHeaderOK()) {
                throw new RuntimeException("Header not OK");
            }
            if (!header.isBigWig()) {
                throw new RuntimeException("No Bigwig");
            }
        }

        public double[] getProfileInRegion(String chr, int start, int end) {
            double[] res = new double[end - start];
            this.fillProfileInRegion(chr, start, end, res);
            return res;
        }

        public void fillProfileInRegion(String chr, int start, int end, double[] res) {
            BigWigIterator it = this.reader.getBigWigIterator(chr, start, chr, end, false);
            while (it.hasNext()) {
                WigItem item = it.next();
                Arrays.fill(res, Math.max(0, item.getStartBase() - start), Math.min(item.getEndBase(), end) - start, (double)item.getWigValue());
            }
        }
    }

    private static class SortedBedAccessor {
        private String bedFileGz;

        public SortedBedAccessor(String bedFileGz) {
            this.bedFileGz = bedFileGz;
        }

        public double[] getProfileForChromosome(String chr, int len) throws FileNotFoundException, IOException {
            double[] res = new double[len];
            Arrays.fill(res, Double.NaN);
            BufferedReader read = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.bedFileGz))));
            String chr2 = String.valueOf(chr) + "\t";
            String str = null;
            while ((str = read.readLine()) != null) {
                if (!str.startsWith(chr2)) continue;
                String[] parts = str.split("\t");
                if (!chr.equals(parts[0])) {
                    read.close();
                    throw new RuntimeException();
                }
                int pos = Integer.parseInt(parts[1]);
                double perc = Double.parseDouble(parts[10]) / 100.0;
                double n = Double.parseDouble(parts[9]);
                double methN = n * perc;
                res[pos] = methN / (n + 1.0) * 100.0;
            }
            read.close();
            return res;
        }
    }
}

