/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.zip.GZIPInputStream;

public class FeatureReader {
    private int numBins;
    private String labelsFile;
    private String dnaseFile;
    private String[] motifFiles;
    private BufferedReader labelsReader;
    private BufferedReader dnaseReader;
    private BufferedReader[] motifReaders;
    private LinkedList<Character> currLabels;
    private LinkedList<double[][]> currFeatures;
    private LinkedList<String[]> currLines;
    private Integer sequenceLength;
    private Integer motifsLength;
    private Integer dnaseLength;
    private AlphabetContainer alphabetContainer = new AlphabetContainer((Alphabet)new ContinuousAlphabet(true));

    public static HashMap<String, Integer> getSizes(String faiFile, int bin) throws NumberFormatException, IOException {
        BufferedReader faidx = new BufferedReader(new InputStreamReader(new FileInputStream(faiFile)));
        String str = null;
        HashMap<String, Integer> sizes = new HashMap<String, Integer>();
        while ((str = faidx.readLine()) != null) {
            String[] parts = str.split("\t");
            String chr = parts[0];
            int len = Integer.parseInt(parts[1]);
            sizes.put(chr, len / bin);
        }
        faidx.close();
        return sizes;
    }

    public FeatureReader(int numBins, String labelsFile, String dnaseFile, String ... motifFiles) {
        this.numBins = numBins;
        this.labelsFile = labelsFile;
        this.dnaseFile = dnaseFile;
        this.motifFiles = motifFiles;
        this.motifReaders = new BufferedReader[motifFiles.length];
    }

    public void reset() throws FileNotFoundException, IOException {
        this.close();
        this.labelsReader = this.labelsFile != null ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.labelsFile)))) : null;
        this.dnaseReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.dnaseFile))));
        int i = 0;
        while (i < this.motifFiles.length) {
            this.motifReaders[i] = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.motifFiles[i]))));
            ++i;
        }
        this.currLabels = new LinkedList();
        this.currFeatures = new LinkedList();
        this.currLines = new LinkedList();
    }

    public void close() throws IOException {
        if (this.labelsReader != null) {
            this.labelsReader.close();
        }
        if (this.dnaseReader != null) {
            this.dnaseReader.close();
        }
        int i = 0;
        while (i < this.motifReaders.length) {
            if (this.motifReaders[i] != null) {
                this.motifReaders[i].close();
            }
            ++i;
        }
    }

    public String[] readNextLines() throws IOException {
        Object[] temp = new String[2 + this.motifReaders.length];
        temp[0] = this.labelsReader != null ? this.labelsReader.readLine() : "";
        temp[1] = this.dnaseReader.readLine();
        int i = 0;
        while (i < this.motifReaders.length) {
            temp[2 + i] = this.motifReaders[i].readLine();
            ++i;
        }
        if (!this.check((String[])temp)) {
            System.err.println("Chromosomes do not match between input files.");
            System.err.println(Arrays.toString(temp));
            System.exit(1);
        }
        return temp;
    }

    public double[][] getFeatureValues(String[] lines) throws NumberFormatException {
        int num = 0;
        int numDnase = 0;
        int numMotifs = 0;
        double[][] feats = new double[lines.length - 1][];
        int i = 1;
        while (i < lines.length) {
            String[] parts = lines[i].split("\t");
            feats[i - 1] = new double[parts.length - 2];
            if (i - 1 == 0) {
                numDnase += feats[i - 1].length;
            } else {
                numMotifs += feats[i - 1].length;
            }
            num += feats[i - 1].length;
            int j = 2;
            while (j < parts.length) {
                feats[i - 1][j - 2] = parts[j].charAt(0) == 'N' ? Double.NaN : Double.parseDouble(parts[j]);
                ++j;
            }
            ++i;
        }
        if (this.sequenceLength == null) {
            this.sequenceLength = num * this.numBins;
            this.motifsLength = numMotifs * this.numBins;
            this.dnaseLength = numDnase * this.numBins;
        } else if (this.sequenceLength != num * this.numBins) {
            throw new NumberFormatException("Problem on input line " + Arrays.toString(lines));
        }
        return feats;
    }

    public boolean check(String[] lines) {
        if (lines[0] == null) {
            return true;
        }
        if (lines[1] == null) {
            return false;
        }
        String[] parts = lines[1].split("\t");
        String ref = String.valueOf(parts[0]) + "\t" + parts[1] + "\t";
        boolean check = true;
        int i = lines[0].length() > 0 ? 0 : 1;
        while (check && i < lines.length) {
            check &= lines[i] != null && lines[i].startsWith(ref);
            ++i;
        }
        return check;
    }

    public double getCurrentDNaseMedian() {
        return this.currFeatures.get((this.numBins + 1) / 2)[0][1];
    }

    public double getCurrentDNaseMin() {
        return this.currFeatures.get((this.numBins + 1) / 2)[0][0];
    }

    public double getCurrentMotifMax(int numMotif) {
        return this.currFeatures.get((this.numBins + 1) / 2)[numMotif + 1][0];
    }

    public double getDNaseMedian(String[] lines) {
        return Double.parseDouble(lines[1].split("\t")[3]);
    }

    public Character getLabel(String[] lines) {
        if (lines[0].length() == 0) {
            return null;
        }
        return Character.valueOf(lines[0].split("\t")[2].charAt(0));
    }

    public double[][] getPositiveHistogram() throws FileNotFoundException, IOException {
        this.reset();
        DoubleList values = new DoubleList();
        String[] temp = null;
        while ((temp = this.readNextLines())[0] != null) {
            char lab = this.getLabel(temp).charValue();
            if (lab != 'S') continue;
            values.add(this.getDNaseMedian(temp));
        }
        if (values.length() == 0) {
            throw new RuntimeException("Not a single bin with label 'S'. Please check input.");
        }
        double min = values.min(0, values.length());
        double max = values.max(0, values.length());
        double[] breaks = new double[20];
        double step = (max - min) / (double)breaks.length;
        breaks[0] = min + step;
        int i = 1;
        while (i < breaks.length) {
            breaks[i] = breaks[i - 1] + step;
            ++i;
        }
        double[] counts = new double[breaks.length];
        int i2 = 0;
        while (i2 < values.length()) {
            double curr = values.get(i2);
            int idx = Arrays.binarySearch(breaks, curr);
            if (idx < 0) {
                idx = -idx - 1;
            }
            if (idx >= breaks.length) {
                idx = breaks.length - 1;
            }
            int n = idx;
            counts[n] = counts[n] + 1.0;
            ++i2;
        }
        return new double[][]{breaks, counts};
    }

    public double[] getNegativeHistogram(double[] breaks) throws FileNotFoundException, IOException {
        double[] counts = new double[breaks.length];
        this.reset();
        String[] temp = null;
        while ((temp = this.readNextLines())[0] != null) {
            char lab = this.getLabel(temp).charValue();
            if (lab != 'U') continue;
            double curr = this.getDNaseMedian(temp);
            int idx = Arrays.binarySearch(breaks, curr);
            if (idx < 0) {
                idx = -idx - 1;
            }
            if (idx >= breaks.length) {
                idx = breaks.length - 1;
            }
            int n = idx;
            counts[n] = counts[n] + 1.0;
        }
        return counts;
    }

    public double[][] getSamplingProbsAndWeights(double[] posHist, double[] negHist) {
        double[] probs = new double[posHist.length];
        double[] weights = new double[posHist.length];
        int i = 0;
        while (i < posHist.length) {
            probs[i] = Math.min(posHist[i] * 4.0 / negHist[i], 1.0);
            weights[i] = probs[0] / probs[i];
            ++i;
        }
        return new double[][]{probs, weights};
    }

    public char getCurrentLabel() {
        return this.currLabels.get((this.numBins + 1) / 2).charValue();
    }

    public Sequence getCurrentSequence() throws WrongAlphabetException, WrongSequenceTypeException {
        double[] temp = new double[this.sequenceLength.intValue()];
        int k = 0;
        int i = 0;
        while (i < this.currFeatures.size()) {
            double[][] feat = this.currFeatures.get(i);
            int j = 0;
            while (j < feat.length) {
                int l = 0;
                while (l < feat[j].length) {
                    temp[k] = feat[j][l];
                    ++l;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new ArbitrarySequence(this.alphabetContainer, temp);
    }

    public Sequence getCurrentDNaseSequence() throws WrongAlphabetException, WrongSequenceTypeException {
        double[] temp = new double[this.dnaseLength.intValue()];
        int k = 0;
        int i = 0;
        while (i < this.currFeatures.size()) {
            double[][] feat = this.currFeatures.get(i);
            int l = 0;
            while (l < feat[0].length) {
                temp[k] = feat[0][l];
                ++l;
                ++k;
            }
            ++i;
        }
        return new ArbitrarySequence(this.alphabetContainer, temp);
    }

    public Sequence getCurrentMotifsSequence() throws WrongAlphabetException, WrongSequenceTypeException {
        double[] temp = new double[this.motifsLength.intValue()];
        int k = 0;
        int i = 0;
        while (i < this.currFeatures.size()) {
            double[][] feat = this.currFeatures.get(i);
            int j = 1;
            while (j < feat.length) {
                int l = 0;
                while (l < feat[j].length) {
                    temp[k] = feat[j][l];
                    ++l;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new ArbitrarySequence(this.alphabetContainer, temp);
    }

    public boolean readNextFeatureVector() throws IOException {
        while (this.currLabels.size() < (this.numBins - 1) / 2 - 1) {
            String[] temp = this.readNextLines();
            if (temp[0] == null) {
                return false;
            }
            this.currLabels.add(this.getLabel(temp));
            this.currFeatures.add(this.getFeatureValues(temp));
            this.currLines.add(temp);
        }
        Character lab = null;
        double[][] vals = null;
        String[] temp = null;
        while (vals == null) {
            temp = this.readNextLines();
            if (temp[0] == null) {
                return false;
            }
            lab = this.getLabel(temp);
            vals = this.getFeatureValues(temp);
        }
        this.currLabels.add(lab);
        this.currFeatures.add(vals);
        this.currLines.add(temp);
        while (this.currLabels.size() < this.numBins) {
            this.currLabels.addFirst(this.currLabels.getFirst());
            this.currFeatures.addFirst(this.currFeatures.getFirst());
            this.currLines.addFirst(this.currLines.getFirst());
        }
        if (this.currLabels.size() > this.numBins) {
            this.currLabels.removeFirst();
            this.currFeatures.removeFirst();
            this.currLines.removeFirst();
        }
        return true;
    }

    public boolean readNextFeatureVector2() throws IOException {
        while (this.currLabels.size() < (this.numBins - 1) / 2) {
            String[] temp = this.readNextLines();
            if (temp[0] == null) {
                return false;
            }
            this.currLabels.add(this.getLabel(temp));
            this.currFeatures.add(this.getFeatureValues(temp));
            this.currLines.add(temp);
        }
        Character lab = null;
        double[][] vals = null;
        String[] temp = null;
        while (vals == null) {
            temp = this.readNextLines();
            if (temp[0] == null) {
                return false;
            }
            lab = this.getLabel(temp);
            vals = this.getFeatureValues(temp);
        }
        while (this.currLabels.size() < this.numBins - 1) {
            this.currLabels.add(lab);
            this.currFeatures.add(vals);
            this.currLines.add(temp);
        }
        this.currLabels.add(lab);
        this.currFeatures.add(vals);
        this.currLines.add(temp);
        if (this.currLabels.size() > this.numBins) {
            this.currLabels.removeFirst();
            this.currFeatures.removeFirst();
            this.currLines.removeFirst();
        }
        return true;
    }

    public static DataSet replaceNaN(DataSet data) throws WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException {
        double[] means = new double[data.getElementLength()];
        Arrays.fill(means, Double.MAX_VALUE);
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            int j = 0;
            while (j < seq.getLength()) {
                if (!Double.isNaN(seq.continuousVal(j)) && seq.continuousVal(j) < means[j]) {
                    means[j] = seq.continuousVal(j);
                }
                ++j;
            }
            ++i;
        }
        double[] temp = new double[data.getElementLength()];
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        int i2 = 0;
        while (i2 < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i2);
            boolean replace = false;
            int j = 0;
            while (j < seq.getLength()) {
                if (Double.isNaN(seq.continuousVal(j))) {
                    replace = true;
                }
                ++j;
            }
            if (replace) {
                j = 0;
                while (j < seq.getLength()) {
                    temp[j] = Double.isNaN(seq.continuousVal(j)) ? means[j] : seq.continuousVal(j);
                    ++j;
                }
                seqs.add(new ArbitrarySequence(seq.getAlphabetContainer(), temp));
            } else {
                seqs.add(seq);
            }
            ++i2;
        }
        return new DataSet("", seqs);
    }

    public Pair<DataSet[], double[][]> getInitialData(HashSet<String> chromosomes) throws FileNotFoundException, IOException, WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException {
        double[][] hist = this.getPositiveHistogram();
        double[] negh = this.getNegativeHistogram(hist[0]);
        double[][] sw = this.getSamplingProbsAndWeights(hist[1], negh);
        double[] breaks = hist[0];
        double posSum = ToolBox.sum(hist[1]);
        double negSum = ToolBox.sum(negh);
        double pUnif = posSum * 10.0 / negSum;
        ArrayList<Sequence> pos = new ArrayList<Sequence>();
        DoubleList posw = new DoubleList();
        ArrayList<Sequence> neg = new ArrayList<Sequence>();
        DoubleList negw = new DoubleList();
        Random r = new Random(131L);
        this.reset();
        while (this.readNextFeatureVector()) {
            double dnase;
            int idx;
            char label = this.getCurrentLabel();
            if (chromosomes != null && !chromosomes.contains(this.getCurrentChromosome())) continue;
            if (label == 'S') {
                Sequence seq = this.getCurrentSequence();
                pos.add(seq);
                posw.add(1.0);
                continue;
            }
            if (label != 'U') continue;
            double p = r.nextDouble();
            if (p < pUnif) {
                Sequence seq = this.getCurrentSequence();
                neg.add(seq);
                negw.add(1.0);
            }
            if ((idx = Arrays.binarySearch(breaks, dnase = this.getCurrentDNaseMedian())) < 0) {
                idx = -idx - 1;
            }
            if (idx >= breaks.length) {
                idx = breaks.length - 1;
            }
            if (!(p < sw[0][idx])) continue;
            Sequence seq = this.getCurrentSequence();
            neg.add(seq);
            negw.add(sw[1][idx]);
        }
        return new Pair<DataSet[], double[][]>(new DataSet[]{FeatureReader.replaceNaN(new DataSet("", pos)), FeatureReader.replaceNaN(new DataSet("", neg))}, new double[][]{posw.toArray(), negw.toArray()});
    }

    public int getNumBins() {
        return this.numBins;
    }

    public String getCurrentChromosome() {
        String temp = this.currLines.get((this.numBins + 1) / 2)[1];
        return temp.substring(0, temp.indexOf("\t"));
    }

    public boolean findChr(String chr) throws IOException {
        while (this.currLines.size() == 0 || !chr.equals(this.getCurrentChromosome())) {
            if (!this.readNextFeatureVector()) break;
        }
        if (!chr.equals(this.getCurrentChromosome())) {
            this.reset();
            while (this.currLines.size() == 0 || !chr.equals(this.getCurrentChromosome())) {
                if (!this.readNextFeatureVector()) break;
            }
        }
        return chr.equals(this.getCurrentChromosome());
    }

    public int getCurrentStart() {
        String temp = this.currLines.get((this.numBins + 1) / 2)[1];
        temp = temp.substring(temp.indexOf("\t") + 1);
        temp = temp.substring(0, temp.indexOf("\t"));
        return Integer.parseInt(temp);
    }
}

