/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream.tools;

import de.jstacs.DataType;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.zip.GZIPOutputStream;
import projects.encodedream.Coverage;

public class MethylationLevels
implements JstacsTool {
    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> pars = new LinkedList<Parameter>();
        try {
            pars.add(new FileParameter("Input Bed.gz", "The bedMethyl file (gzipped) containing the methylation levels", "bed.gz", true));
            pars.add(new FileParameter("FastA index", "The genome index", "fai", true));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            pars.add(new SimpleParameter(DataType.INT, "Bin width", "The width of the genomic bins considered", true));
        }
        catch (SimpleParameter.DatatypeNotValidException e) {
            e.printStackTrace();
        }
        return new ToolParameterSet(this.getShortName(), pars.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        File out = File.createTempFile("methyl", ".temp.gz", new File("."));
        out.deleteOnExit();
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(out));
        String methFile = ((FileParameter)parameters.getParameterAt(0)).getFileContents().getFilename();
        int bin = (Integer)parameters.getParameterAt(2).getValue();
        String faiFile = ((FileParameter)parameters.getParameterAt(1)).getFileContents().getFilename();
        Coverage.coverageMeth(faiFile, methFile, new PrintStream(os), bin);
        os.close();
        TextResult tr = new TextResult("Methylation levels", "Features computed from methylation levels", new FileParameter.FileRepresentation(out.getAbsolutePath()), "tsv.gz", this.getToolName(), null, true);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(tr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "Methylation levels";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "methyl";
    }

    @Override
    public String getDescription() {
        return "computes methylation level features";
    }

    @Override
    public String getHelpText() {
        return "";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

