/*
 * Decompiled with CFR 0.152.
 */
package projects.talen;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.tools.ui.galaxy.MultilineSimpleParameter;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;
import projects.talen.GFFParser;
import projects.talen.InfixMatchFinder;
import projects.talen.InfixTALENTargetFinder;
import projects.talen.LimitedSortedList;
import projects.talen.MatchFinder;
import projects.tals.TALgetterDiffSM;

public class FastTALENScanner {
    public static String[] filters = new String[]{"Loose (q=0.35)", "Medium-Loose (q=0.375)", "Medium (q=0.4)", "Medium-Strict (q=0.45)", "Strict (q=0.5)", "Custom"};
    private static String[] archs = new String[]{"Cermak et al., NAR, 2011: 15-24 bp", "Li et al., NAR, 2011: 16-31 bp", "Miller et al., NBT, 2011, +28: 12-20 bp", "Miller et al., NBT, 2011, +63: 12-24 bp", "Mussolino et al., NAR, 2011: 12-20 bp", "Christian et al., PONE, 2012, +18: 13-17 bp", "Christian et al., PONE, 2012, full length: 15-24 bp", "Custom"};
    private static LinkedList<Integer> available;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ListResult[] scan(TALgetterDiffSM model, FastTALENScannerParameterSet params, BufferedReader dsRead, GFFParser.GFFList gff, int numThreads) throws Exception {
        block39: {
            block38: {
                if (!params.hasDefaultOrIsSet()) {
                    System.err.println("Some of the required parameters are not specified.");
                    System.exit(1);
                }
                alphabetsRVD = model.getRVDAlphabet();
                talLeft = Sequence.create(alphabetsRVD, params.getLeftTALSequence(), "-");
                talRight = Sequence.create(alphabetsRVD, params.getRightTALSequence(), "-");
                minDist = params.getMinimumDistance();
                maxDist = params.getMaximumDistance();
                rl = new ResultList(params.getN());
                rl2 = new ListResult("", "", null, new ResultSet[0]);
                lastHeader = new StringBuffer();
                curr = null;
                singleFind = new InfixMatchFinder(null, Math.min(8, Math.min(talLeft.getLength(), talRight.getLength()) + 1), model);
                finder = new InfixTALENTargetFinder(null, model, singleFind);
                bestTotal = model.getBestPossibleScore(talLeft, null) + model.getBestPossibleScore(talRight, null);
                th = params.getFilter();
                totalThresh = model.getBestPossibleScore(talLeft, null) / (double)(talLeft.getLength() + 1) + model.getBestPossibleScore(talRight, null) / (double)(talRight.getLength() + 1) + 2.0 * Math.log(th);
                singleThresh1 = model.getBestPossibleScore(talLeft, null) / (double)(talLeft.getLength() + 1) + Math.log(th * 0.9);
                singleThresh2 = model.getBestPossibleScore(talRight, null) / (double)(talRight.getLength() + 1) + Math.log(th * 0.9);
                singleFind.getPreps(talLeft, singleThresh1 * (double)(talLeft.getLength() + 1));
                singleFind.getPreps(talRight, singleThresh2 * (double)(talRight.getLength() + 1));
                if (numThreads != 1) break block38;
                worker = new Worker(this, finder.clone(), talLeft, talRight, totalThresh, singleThresh1, singleThresh2, minDist, maxDist, params.getNTerm1(), params.getNTerm2(), params.getHeteroOnly(), params.getN(), model, gff, params.getOutput(), 0);
                while ((curr = this.readNextSequences(numThreads, null, dsRead, lastHeader)) != null) {
                    worker.setData(curr);
                    Worker.access$0(worker);
                }
                rl3 = Worker.access$1(worker);
                j = 0;
                while (j < rl3.getNumberOfResults()) {
                    rl.add(ResultList.access$0(rl3)[j].getElement(), -((Double)ResultList.access$0(rl3)[j].getWeight()).doubleValue());
                    ++j;
                }
                break block39;
            }
            FastTALENScanner.available = new LinkedList<E>();
            size = 0L;
            workers = new Worker[numThreads <= 2 ? 1 : numThreads - 2];
            i = 0;
            while (i < workers.length) {
                workers[i] = new Worker(this, finder.clone(), talLeft, talRight, totalThresh, singleThresh1, singleThresh2, minDist, maxDist, params.getNTerm1(), params.getNTerm2(), params.getHeteroOnly(), params.getN(), model, gff, params.getOutput(), i);
                temp = new Thread(workers[i]);
                temp.setDaemon(true);
                temp.start();
                FastTALENScanner.available.add(i);
                ++i;
            }
            parser = null;
            if (numThreads > 1) {
                parser = new SequenceParser(this);
                temp = new Thread(parser);
                temp.setDaemon(true);
                temp.start();
            }
            while ((curr = this.readNextSequences(numThreads, parser, dsRead, lastHeader)) != null) {
                a = 0;
                var32_34 = FastTALENScanner.available;
                synchronized (var32_34) {
                    a = FastTALENScanner.available.size();
                    // MONITOREXIT @DISABLED, blocks:[0, 9, 27] lbl62 : MonitorExitStatement: MONITOREXIT : var32_34
                    if (true) ** GOTO lbl82
                }
                do {
                    var32_34 = this;
                    synchronized (var32_34) {
                        this.wait(1000L);
                    }
                    var32_34 = FastTALENScanner.available;
                    synchronized (var32_34) {
                        a = FastTALENScanner.available.size();
                    }
lbl82:
                    // 2 sources

                } while (a == 0);
                idx = 0;
                var33_37 = FastTALENScanner.available;
                synchronized (var33_37) {
                    idx = FastTALENScanner.available.pop();
                    if (Worker.access$2(workers[idx])) {
                        throw new RuntimeException("Exception in one of the threads.");
                    }
                }
                workers[idx].setData(curr);
                if (numThreads > 2) continue;
                var33_37 = this;
                synchronized (var33_37) {
                    this.wait();
                }
            }
            a = 0;
            idx = FastTALENScanner.available;
            synchronized (idx) {
                a = FastTALENScanner.available.size();
                // MONITOREXIT @DISABLED, blocks:[5, 8] lbl115 : MonitorExitStatement: MONITOREXIT : idx
                if (true) ** GOTO lbl126
            }
            do {
                idx = this;
                synchronized (idx) {
                    this.wait(1000L);
                }
                idx = FastTALENScanner.available;
                synchronized (idx) {
                    a = FastTALENScanner.available.size();
                }
lbl126:
                // 2 sources

            } while (a < workers.length);
            if (numThreads > 1) {
                parser.stop();
            }
            i = 0;
            while (i < workers.length) {
                workers[i].stop();
                rl3 = Worker.access$1(workers[i]);
                j = 0;
                while (j < rl3.getNumberOfResults()) {
                    rl.add(ResultList.access$0(rl3)[j].getElement(), -((Double)ResultList.access$0(rl3)[j].getWeight()).doubleValue());
                    ++j;
                }
                size += Worker.access$3(workers[i]);
                ++i;
            }
        }
        if (params.getOutput() != Output.NONE) {
            rl2 = rl.gffToList().toListResult("Off target predictions (" + params.getOutput().name() + ")", "", params.getOutput() == Output.GFF3);
        }
        res = new Result[params.getNumberOfParameters() - 2];
        i = 0;
        while (i < res.length) {
            res[i] = new CategoricalResult(params.getParameterAt(i + 2).getName(), params.getParameterAt(i + 2).getComment(), params.getParameterAt(i + 2).getValue() == null ? "NA" : (i == 5 ? "min=" + params.getMinimumDistance() + ", max=" + params.getMaximumDistance() : (i == 6 ? "q=" + params.getFilter() : params.getParameterAt(i + 2).getValue().toString().replaceAll("\n", "; "))));
            ++i;
        }
        return new ListResult[]{new ListResult("Off target predictions", "The off targets predicted for TALENs " + params.getLeftTALSequence() + " and " + params.getRightTALSequence() + " with distance between " + params.getMinimumDistance() + " and " + params.getMaximumDistance(), new ResultSet(new Result[][]{res}), rl.resultsToArray()), rl2};
    }

    private static String getFeatString(String id, int start, int end, GFFParser.GFFList gff) {
        GFFParser.GFFList sub;
        String featString = "";
        if (gff != null && (sub = gff.getSubList(id)) != null) {
            ArrayList<GFFParser.GFFEntry> feats = sub.getEntriesOverlapping(start, end);
            ArrayList<GFFParser.GFFEntry> feats2 = new ArrayList<GFFParser.GFFEntry>();
            if (feats != null) {
                ArrayList<GFFParser.GFFEntry> parents = new ArrayList<GFFParser.GFFEntry>();
                LinkedList<GFFParser.GFFEntry> stack = new LinkedList<GFFParser.GFFEntry>();
                int j = 0;
                while (j < feats.size()) {
                    LinkedList<GFFParser.GFFEntry> temp = feats.get(j).getParents();
                    if (temp != null) {
                        stack.addAll(temp);
                    }
                    ++j;
                }
                while (stack.size() > 0) {
                    GFFParser.GFFEntry temp = (GFFParser.GFFEntry)stack.pop();
                    parents.add(temp);
                    LinkedList<GFFParser.GFFEntry> temp2 = temp.getParents();
                    if (temp2 == null) continue;
                    stack.addAll(temp2);
                }
                j = 0;
                while (j < feats.size()) {
                    if (!parents.contains(feats.get(j)) && feats.get(j).getParsedType() != GFFParser.GFFEntry.GFFType.chromosome) {
                        feats2.add(feats.get(j));
                    }
                    ++j;
                }
                if (feats2.size() > 0) {
                    featString = feats2.toString();
                    featString = featString.substring(1, featString.length() - 1);
                }
            }
        }
        return featString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Pair<int[][], DataSet> readNextSequences(int numThreads, SequenceParser parser, BufferedReader read, StringBuffer lastHeader) throws Exception {
        str = null;
        line = new StringBuffer();
        starts = new IntList();
        ends = new IntList();
        seqs = new LinkedList<Sequence>();
        if (parser != null) {
            parser.setList(seqs);
        }
        acgt = Pattern.compile("[ACGT]+", 2);
        con = DNAAlphabetContainer.SINGLETON;
        size = 0;
        while ((str = read.readLine()) != null || line.length() > 0) {
            block18: {
                block19: {
                    if (str != null) {
                        str = str.trim();
                    }
                    if (str != null && !str.startsWith(">")) break block18;
                    header = lastHeader.toString();
                    if (str != null) {
                        lastHeader.delete(0, lastHeader.length());
                        lastHeader.append(str.substring(1));
                    }
                    if (line.length() <= 0) continue;
                    seqStr = line.toString();
                    line.delete(0, line.length());
                    match = acgt.matcher(seqStr);
                    while (match.find()) {
                        start = match.start();
                        end = match.end();
                        if (parser != null) {
                            parser.add(header, seqStr.substring(start, end));
                        } else {
                            annotation = new SequenceAnnotation("unparsed comment line", "unparsed comment line", new CategoricalResult("unparsed comment", "unparsed comment", header));
                            seq /* !! */  = new SparseSequence((AlphabetContainer)DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                            seq /* !! */  = seq /* !! */ .annotate(false, new SequenceAnnotation[]{annotation});
                            seqs.add(seq /* !! */ );
                        }
                        size += end - start;
                        starts.add(start);
                        ends.add(seqStr.length() - end);
                    }
                    if (!((double)size > 1.0E7) && str != null) continue;
                    s = 0;
                    if (parser == null) break block19;
                    var17_18 = seqs;
                    synchronized (var17_18) {
                        s = starts.length() - seqs.size();
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 9] lbl48 : MonitorExitStatement: MONITOREXIT : var17_18
                        if (true) ** GOTO lbl69
                    }
                    do {
                        if (SequenceParser.access$0(parser)) {
                            throw new RuntimeException("Exception in parser thread");
                        }
                        var17_18 = this;
                        synchronized (var17_18) {
                            this.wait();
                        }
                        var17_18 = seqs;
                        synchronized (var17_18) {
                            s = starts.length() - seqs.size();
                        }
lbl69:
                        // 2 sources

                    } while (s != 0);
                }
                return new Pair<int[][], DataSet>(new int[][]{starts.toArray(), ends.toArray()}, new DataSet("", seqs));
            }
            line.append(str);
        }
        return null;
    }

    private static HashSet<Sequence> makeHash(DataSet d) {
        HashSet<Sequence> set = new HashSet<Sequence>();
        int i = 0;
        while (i < d.getNumberOfElements()) {
            set.add(d.getElementAt(i));
            ++i;
        }
        return set;
    }

    public static class FastTALENScannerParameterSet
    extends ParameterSet {
        public FastTALENScannerParameterSet() throws Exception {
            this.parameters.add(new Parameter[]{new SelectionParameter(DataType.PARAMETERSET, new String[]{"Use a previously uploaded file", "Paste sequences in FastA format"}, new ParameterSet[]{new SimpleParameterSet(new FileParameter("FastA file", "The sequences to scan for TAL effector target sites, FastA format", "fasta", true)), new SimpleParameterSet(new MultilineSimpleParameter("FastA sequences", "The sequences to scan for TAL effector target sites, FastA format", true))}, "Input sequences", "The DNA input sequences that are scanned for TALEN off targets. You can either use a previously uploaded file (see task &quot;GetData&quot; -&gt; &quot;Upload File&quot;), files from a data library (see &quot;Data Libraries&quot; of the menu item &quot;Shared Data&quot; on top of this page) or paste in sequences in FastA format", true)});
            this.parameters.add(new Parameter[]{new FileParameter("Annotation file", "A file containing genomic annotations (e.g., genes, mRNAs, exons) in GFF, GTF, or UCSC known genes BED format", "gff,gtf,txt", false)});
            this.parameters.add(new Parameter[]{new MultilineSimpleParameter("First RVD sequence", "The sequence of RVDs of the first TALEN monomer, seperated by '-'", true, "NI-HD-HD-NG-NN-NK-NK")});
            this.parameters.add(new Parameter[]{new MultilineSimpleParameter("Second RVD sequence", "The sequence of RVDs of the second TALEN monomer, seperated by '-'", true, "NI-HD-HD-NG-NN-NK-NK")});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "N-Terminal first", "For the first RVD sequence, consider the architecture, where the endonuclease domain is used to the N-terminus instead of the standard C-terminal architecture", true, false)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "N-Terminal second", "For the second RVD sequence, consider the architecture, where the endonuclease domain is used to the N-terminus instead of the standard C-terminal architecture", true, false)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "Hetero-dimers only", "Consider only hetero-dimers of TALEN monomers instead of the standard search for TALEN hetero and homo-dimers", true, false)});
            SimpleParameter min = new SimpleParameter(DataType.INT, "Minimum distance", "Minimum distance between TALEN monomer target sites", true, new NumberValidator<Integer>(0, 100), 12);
            SimpleParameter max = new SimpleParameter(DataType.INT, "Maximum distance", "Maximum distance between TALEN monomer target sites", true, new NumberValidator<Integer>(0, 100), 24);
            SelectionParameter architecture = new SelectionParameter(DataType.PARAMETERSET, archs, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(min, max)}, "Architecture", "Select a pre-defined set of minimum and maximum distance between monomer target sites, i.e. spacer lengths, or enter custom values.", true);
            architecture.setDefault("Custom");
            this.parameters.add(new Parameter[]{architecture});
            SelectionParameter filter = new SelectionParameter(DataType.PARAMETERSET, filters, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new SimpleParameter(DataType.DOUBLE, "q", "The parameter q that defines the score that must be gained by an off-target site relative to the best-matching site", true, new NumberValidator<Double>(0.35, 1.0), 0.4))}, "Filter", "Filter off-targets using different thresholds on the score relative to the best-matching site", true);
            filter.setDefault("Medium (q=0.4)");
            this.parameters.add(new Parameter[]{filter});
            this.parameters.add(new Parameter[]{new MultilineSimpleParameter("RVD specificities", "Set RVD specificities for additional RVDs or override existing RVD specificities. Details in help text.", false)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Maximum number of targets", "Limits the total number of reported targets in all input sequences, ranked by their score", true, new NumberValidator<Integer>(1, 100000), 100)});
            this.parameters.add(new Parameter[]{new EnumParameter(Output.class, "Create an additional output file in GFF3 or GFF2 format that can be viewed in your favourite genome browser", true)});
        }

        public double getFilter() {
            SelectionParameter filter = (SelectionParameter)this.parameters.get("Filter");
            int sel = filter.getSelected();
            switch (sel) {
                case 0: {
                    return 0.35;
                }
                case 1: {
                    return 0.375;
                }
                case 2: {
                    return 0.4;
                }
                case 3: {
                    return 0.45;
                }
                case 4: {
                    return 0.5;
                }
                case 5: {
                    return (Double)((SimpleParameterSet)filter.getValue()).getParameterAt(0).getValue();
                }
            }
            throw new RuntimeException("Filter not defined");
        }

        public Parameter[] getAllParameters() {
            return (Parameter[])this.parameters.toArray(new Parameter[0]);
        }

        public void addParameter(int i, Parameter par) {
            this.parameters.add(i, par);
        }

        public String getLeftTALSequence() {
            return (String)((Parameter)this.parameters.get("First RVD sequence")).getValue();
        }

        public String getRightTALSequence() {
            return (String)((Parameter)this.parameters.get("Second RVD sequence")).getValue();
        }

        public boolean getNTerm1() {
            return (Boolean)((Parameter)this.parameters.get("N-Terminal first")).getValue();
        }

        public boolean getNTerm2() {
            return (Boolean)((Parameter)this.parameters.get("N-Terminal second")).getValue();
        }

        public boolean getHeteroOnly() {
            return (Boolean)((Parameter)this.parameters.get("Hetero-dimers only")).getValue();
        }

        public int getMinimumDistance() {
            SelectionParameter arch = (SelectionParameter)this.parameters.get("Architecture");
            int sel = arch.getSelected();
            switch (sel) {
                case 0: {
                    return 15;
                }
                case 1: {
                    return 16;
                }
                case 2: {
                    return 12;
                }
                case 3: {
                    return 12;
                }
                case 4: {
                    return 12;
                }
                case 5: {
                    return 13;
                }
                case 6: {
                    return 15;
                }
                case 7: {
                    return (Integer)((SimpleParameterSet)arch.getValue()).getParameterAt(0).getValue();
                }
            }
            throw new RuntimeException("Architecture not defined");
        }

        public int getMaximumDistance() {
            SelectionParameter arch = (SelectionParameter)this.parameters.get("Architecture");
            int sel = arch.getSelected();
            switch (sel) {
                case 0: {
                    return 24;
                }
                case 1: {
                    return 31;
                }
                case 2: {
                    return 20;
                }
                case 3: {
                    return 24;
                }
                case 4: {
                    return 20;
                }
                case 5: {
                    return 17;
                }
                case 6: {
                    return 24;
                }
                case 7: {
                    return (Integer)((SimpleParameterSet)arch.getValue()).getParameterAt(1).getValue();
                }
            }
            throw new RuntimeException("Architecture not defined");
        }

        public void setInputPath(String path) throws Exception {
            ((SelectionParameter)this.parameters.get("Input sequences")).setValue("Use a previously uploaded file");
            ((FileParameter)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0)).setValue(new FileParameter.FileRepresentation(path));
        }

        public BufferedReader getInputSequences() throws Exception {
            if (((SelectionParameter)this.parameters.get("Input sequences")).getSelected() == 0) {
                String filename = (String)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0).getValue();
                return new BufferedReader(new FileReader(filename));
            }
            String content = (String)((SimpleParameterSet)((SelectionParameter)this.parameters.get("Input sequences")).getValue()).getParameterAt(0).getValue();
            return new BufferedReader(new StringReader(content));
        }

        public GFFParser.GFFList getAnnotation() throws IOException {
            if (((Parameter)this.parameters.get("Annotation file")).isSet()) {
                FileParameter par = (FileParameter)this.parameters.get("Annotation file");
                FileParameter.FileRepresentation rep = par.getFileContents();
                return GFFParser.parse(rep.getFilename(), rep.getExtension());
            }
            return null;
        }

        public int getN() {
            return (Integer)((Parameter)this.parameters.get("Maximum number of targets")).getValue();
        }

        public void setAnnotationPath(String value) throws Exception {
            ((Parameter)this.parameters.get("Annotation file")).setValue(new FileParameter.FileRepresentation(value));
        }

        public Output getOutput() {
            return (Output)((Object)((Parameter)this.parameters.get(Output.class.getSimpleName())).getValue());
        }

        public void setRVDSpecificities(String filename) throws IOException, SimpleParameter.IllegalValueException {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String line = null;
            StringBuffer temp = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                temp.append(line);
                temp.append("\n");
            }
            reader.close();
            ((Parameter)this.parameters.get("RVD specificities")).setValue(temp.toString());
        }

        public Pair<String[], double[][][]> getSpecificities() throws WrongAlphabetException {
            String str = (String)((Parameter)this.parameters.get("RVD specificities")).getValue();
            if (str == null || str.trim().length() == 0) {
                return null;
            }
            String[] lines = str.split("\n");
            LinkedList<String> rvdList = new LinkedList<String>();
            LinkedList<double[]> specList = new LinkedList<double[]>();
            double[] fp = null;
            DNAAlphabet dna = DNAAlphabet.SINGLETON;
            int i = 0;
            while (i < lines.length) {
                String[] parts1 = lines[i].split(":");
                String[] rvds = parts1[0].split(",");
                String[] specs = parts1[1].split(",");
                int j = 0;
                while (j < rvds.length) {
                    rvds[j] = rvds[j].trim();
                    ++j;
                }
                double[] specd = new double[4];
                int j2 = 0;
                while (j2 < specs.length) {
                    specs[j2] = specs[j2].trim();
                    if (dna.isSymbol(specs[j2])) {
                        specd[((DiscreteAlphabet)dna).getCode((String)specs[j2])] = 1.0;
                    } else {
                        specd[j2] = Double.parseDouble(specs[j2]);
                    }
                    ++j2;
                }
                Normalisation.sumNormalisation(specd);
                j2 = 0;
                while (j2 < rvds.length) {
                    if ("0".equals(rvds[j2])) {
                        fp = specd;
                    } else {
                        rvdList.add(rvds[j2]);
                        specList.add(specd);
                    }
                    ++j2;
                }
                ++i;
            }
            return new Pair<String[], double[][][]>(rvdList.toArray(new String[0]), new double[][][]{(double[][])specList.toArray((T[])new double[0][]), new double[][]{fp}});
        }
    }

    public static enum Output {
        NONE,
        GFF3,
        GFF2;

    }

    public static class ResultList {
        private ComparableElement<Object, Double>[] list;
        private int curr;

        public ResultList(int n) {
            this.list = new ComparableElement[n];
            this.curr = 0;
        }

        public boolean better(double value) {
            if (this.list[this.curr] == null) {
                return true;
            }
            return -value < this.list[this.curr].getWeight();
        }

        public void add(Object res, double value) {
            if (this.list[this.curr] == null) {
                this.list[this.curr] = new ComparableElement<Object, Double>(res, -value);
                if (this.curr < this.list.length - 1) {
                    ++this.curr;
                    Arrays.sort(this.list, 0, this.curr);
                } else {
                    Arrays.sort(this.list);
                }
            } else if (-value < this.list[this.curr].getWeight()) {
                this.list[this.curr] = new ComparableElement<Object, Double>(res, -value);
                Arrays.sort(this.list);
            }
        }

        public ResultSet[] resultsToArray() {
            ResultSet[] res = new ResultSet[this.getNumberOfResults()];
            int i = 0;
            while (i < res.length) {
                res[i] = this.list[i].getElement() instanceof Object[] ? (ResultSet)((Object[])this.list[i].getElement())[0] : (ResultSet)this.list[i].getElement();
                ++i;
            }
            return res;
        }

        public GFFParser.GFFList gffToList() {
            LinkedList<GFFParser.GFFEntry> ens = new LinkedList<GFFParser.GFFEntry>();
            int i = 0;
            while (i < this.getNumberOfResults()) {
                if (this.list[i].getElement() instanceof Object[]) {
                    GFFParser.GFFEntry[] en = (GFFParser.GFFEntry[])((Object[])this.list[i].getElement())[1];
                    int j = 0;
                    while (j < en.length) {
                        ens.add(en[j]);
                        ++j;
                    }
                } else {
                    return null;
                }
                ++i;
            }
            return new GFFParser.GFFList(ens);
        }

        public double getBestScore() {
            if (this.list[0] == null) {
                return Double.NEGATIVE_INFINITY;
            }
            return -this.list[0].getWeight().doubleValue();
        }

        public double getWorstScore() {
            if (this.curr == 0 && this.list[this.curr] == null) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.list[this.curr] == null) {
                return -this.list[this.curr - 1].getWeight().doubleValue();
            }
            return -this.list[this.curr].getWeight().doubleValue();
        }

        public int getNumberOfResults() {
            if (this.list[this.curr] == null) {
                return this.curr;
            }
            return this.curr + 1;
        }

        static /* synthetic */ ComparableElement[] access$0(ResultList resultList) {
            return resultList.list;
        }
    }

    private static class SequenceParser
    implements Runnable {
        private LinkedList<Sequence> list;
        private FastTALENScanner caller;
        private LinkedList<String> headers = new LinkedList();
        private LinkedList<String> seqStrs = new LinkedList();
        private boolean stop;
        private boolean exception;

        public SequenceParser(FastTALENScanner caller) {
            this.caller = caller;
        }

        public void setList(LinkedList<Sequence> list) {
            this.list = list;
        }

        public synchronized void stop() {
            this.stop = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String header, String seqStr) {
            Object object = this.seqStrs;
            synchronized (object) {
                this.seqStrs.add(seqStr);
            }
            object = this.headers;
            synchronized (object) {
                this.headers.add(header);
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.exception = false;
            while (!this.stop) {
                Object seqStr;
                int s = 0;
                Object object = this.headers;
                synchronized (object) {
                    s = this.headers.size();
                }
                if (s > 0) {
                    try {
                        String header = null;
                        LinkedList<String> linkedList = this.headers;
                        synchronized (linkedList) {
                            header = this.headers.pop();
                        }
                        seqStr = null;
                        LinkedList<String> linkedList2 = this.seqStrs;
                        synchronized (linkedList2) {
                            seqStr = this.seqStrs.pop();
                        }
                        SequenceAnnotation annotation = new SequenceAnnotation("unparsed comment line", "unparsed comment line", new CategoricalResult("unparsed comment", "unparsed comment", header));
                        Sequence seq = new SparseSequence((AlphabetContainer)DNAAlphabetContainer.SINGLETON, (String)seqStr);
                        seq = seq.annotate(false, annotation);
                        LinkedList<Sequence> linkedList3 = this.list;
                        synchronized (linkedList3) {
                            this.list.add(seq);
                            continue;
                        }
                    }
                    catch (Exception e) {
                        this.exception = true;
                        e.printStackTrace();
                        throw new RuntimeException();
                    }
                }
                object = this;
                synchronized (object) {
                    seqStr = this.caller;
                    synchronized (seqStr) {
                        this.caller.notify();
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        static /* synthetic */ boolean access$0(SequenceParser sequenceParser) {
            return sequenceParser.exception;
        }
    }

    private static class Worker
    implements Runnable {
        private FastTALENScanner caller;
        private long size = 0L;
        private Pair<int[][], DataSet> curr;
        private InfixTALENTargetFinder finder;
        private Sequence talLeft;
        private Sequence talRight;
        private double totalThresh;
        private double singleThresh1;
        private double singleThresh2;
        private int minDist;
        private int maxDist;
        private int N;
        private ResultList rl;
        private TALgetterDiffSM model;
        private Output output;
        private GFFParser.GFFList gff;
        private boolean nTerm1Ext;
        private boolean nTerm2Ext;
        private boolean onlyhetero;
        private boolean stop;
        private boolean exception;
        private int index;

        public Worker(FastTALENScanner caller, InfixTALENTargetFinder finder, Sequence talLeft, Sequence talRight, double totalThresh, double singleThresh1, double singleThresh2, int minDist, int maxDist, boolean nTerm1, boolean nTerm2, boolean onlyhetero, int N, TALgetterDiffSM model, GFFParser.GFFList gff, Output output, int index) {
            this.finder = finder;
            this.talLeft = talLeft;
            this.talRight = talRight;
            this.totalThresh = totalThresh;
            this.singleThresh1 = singleThresh1;
            this.singleThresh2 = singleThresh2;
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.nTerm1Ext = nTerm1;
            this.nTerm2Ext = nTerm2;
            this.onlyhetero = onlyhetero;
            this.N = N;
            this.model = model;
            this.gff = gff;
            this.index = index;
            this.rl = new ResultList(N);
            this.output = output;
            this.caller = caller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setData(Pair<int[][], DataSet> data) {
            Worker worker = this;
            synchronized (worker) {
                this.curr = data;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Worker worker;
            try {
                worker = this;
                synchronized (worker) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (!this.stop) {
                this.compute();
                if (this.exception) {
                    return;
                }
                worker = this;
                synchronized (worker) {
                    Object object = available;
                    synchronized (object) {
                        available.add(this.index);
                    }
                    try {
                        object = this.caller;
                        synchronized (object) {
                            this.caller.notify();
                        }
                    }
                    catch (IllegalMonitorStateException ex) {
                        ex.printStackTrace();
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.stop = true;
            Worker worker = this;
            synchronized (worker) {
                this.notify();
            }
        }

        private void compute() {
            this.exception = false;
            int[][] offsets = this.curr.getFirstElement();
            DataSet dat = this.curr.getSecondElement();
            int i = 0;
            while (i < dat.getNumberOfElements()) {
                this.size += (long)dat.getElementAt(i).getLength();
                ++i;
            }
            this.finder.setDataSet(dat);
            try {
                LimitedSortedList<InfixTALENTargetFinder.TALENMatch> list = this.finder.getTALENMatches(this.talLeft, this.talRight, this.totalThresh, this.singleThresh1, this.singleThresh2, this.minDist, this.maxDist, this.N, true, this.nTerm1Ext, this.nTerm2Ext, this.onlyhetero);
                ComparableElement<InfixTALENTargetFinder.TALENMatch, Double>[] matches = list.getSortedList();
                int i2 = matches.length - 1;
                while (i2 >= 0 && this.rl.better(matches[i2].getWeight())) {
                    InfixTALENTargetFinder.TALENMatch match = matches[i2].getElement();
                    double score = matches[i2].getWeight();
                    Sequence tal1 = match.getTal1();
                    Sequence tal2 = match.getTal2();
                    MatchFinder.Match match1 = match.getMatch1();
                    MatchFinder.Match match2 = match.getMatch2();
                    Sequence seq1 = dat.getElementAt(match1.getSeqIdx());
                    Sequence seq2 = dat.getElementAt(match2.getSeqIdx());
                    int pos1 = match1.getSeqPos();
                    int pos2 = match2.getSeqPos();
                    String id = (String)seq1.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
                    int space = (id = id.trim()).indexOf(32);
                    if (space >= 0) {
                        id = id.substring(0, space);
                    }
                    int start = pos1 + offsets[0][match1.getSeqIdx()] + 1;
                    int end = pos2 + tal2.getLength() + offsets[0][match2.getSeqIdx()] + 1;
                    if (pos1 > pos2) {
                        start = pos2 + offsets[0][match2.getSeqIdx()] + 1;
                        end = pos1 + tal1.getLength() + offsets[0][match1.getSeqIdx()] + 1;
                    }
                    byte cat = match.getCat();
                    String featString = null;
                    featString = FastTALENScanner.getFeatString(id, start, end, this.gff);
                    String archString = String.valueOf(tal1.equals(this.talLeft) ? "first" : "second") + "-" + (tal2.equals(this.talLeft) ? "first" : "second");
                    int dist = pos2 - (pos1 + tal1.getLength() + 1);
                    if (cat == 3) {
                        dist = -(pos1 - pos2 - (tal2.getLength() + 1));
                    }
                    Sequence sub1 = seq1.getSubSequence(pos1, tal1.getLength() + 1);
                    Sequence sub2 = seq2.reverseComplement().getSubSequence(seq2.getLength() - pos2 - (tal2.getLength() + 1), tal2.getLength() + 1);
                    Sequence between = null;
                    if (cat == 3) {
                        between = seq1.getSubSequence(pos2 + tal2.getLength() + 1, -dist);
                    } else if (cat == 1 || cat == 2) {
                        if (match1.isRc()) {
                            sub1 = seq1.reverseComplement().getSubSequence(seq1.getLength() - pos1 - tal1.getLength() - 1, tal1.getLength() + 1);
                            dist = -pos1 + pos2 - tal2.getLength() - 1;
                        }
                        if (!match2.isRc()) {
                            sub2 = seq2.getSubSequence(pos2, tal2.getLength() + 1);
                            dist = pos2 - (pos1 + tal1.getLength() + 1);
                        }
                        between = seq1.getSubSequence(pos1 + tal1.getLength() + 1, dist);
                    } else {
                        between = seq1.getSubSequence(pos1 + tal1.getLength() + 1, dist);
                    }
                    String site = null;
                    site = cat == 3 ? String.valueOf(sub2.reverseComplement().toString().toUpperCase()) + between.toString().toLowerCase() + sub1.toString().toUpperCase() : (cat == 1 || cat == 2 ? (match1.isRc() ? String.valueOf(sub1.reverseComplement().toString().toUpperCase()) + between.toString().toLowerCase() + sub2.reverseComplement().toString().toUpperCase() : String.valueOf(sub1.toString().toUpperCase()) + between.toString().toLowerCase() + sub2.toString().toUpperCase()) : String.valueOf(sub1.toString().toUpperCase()) + between.toString().toLowerCase() + sub2.reverseComplement().toString().toUpperCase());
                    String str1 = this.model.getMatchString(tal1, sub1);
                    String str2 = this.model.getMatchString(tal2, sub2);
                    Result[] tr = new Result[]{new CategoricalResult("ID", "", id), new NumericalResult("Position 1", "", pos1 + offsets[0][match1.getSeqIdx()]), new NumericalResult("Position 2", "", pos2 + offsets[0][match2.getSeqIdx()]), new NumericalResult("Distance", "", dist), new CategoricalResult("Sequence 1", "", sub1.toString()), new CategoricalResult("Matches 1", "", str1), new CategoricalResult("Sequence 2", "", sub2.toString()), new CategoricalResult("Matches 2", "", str2), new CategoricalResult("Architecture", "", archString), new CategoricalResult("Full site", "", site), new NumericalResult("Score", "", score), new CategoricalResult("Features", "", featString)};
                    if (this.output != Output.NONE) {
                        String predId = String.valueOf(id) + "_" + start + "_" + end + "_" + archString;
                        GFFParser.GFFEntry[] ens = new GFFParser.GFFEntry[]{new GFFParser.GFFEntry(id, "TALoffer", "TALEN_dimer_target", start, end, score, StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN, -1, "ID=" + predId + "; group=" + predId), new GFFParser.GFFEntry(id, "TALoffer", "TALEN_monomer_target", pos1 + offsets[0][match1.getSeqIdx()] + 1, pos1 + offsets[0][match1.getSeqIdx()] + tal1.getLength() + 1, score, match1.isRc() ? StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE : StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD, -1, "Parent=" + predId + "; group=" + predId + "f"), new GFFParser.GFFEntry(id, "TALoffer", "TALEN_monomer_target", pos2 + offsets[0][match2.getSeqIdx()] + 1, pos2 + offsets[0][match2.getSeqIdx()] + tal2.getLength() + 1, score, match1.isRc() ? StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE : StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD, -1, "Parent=" + predId + "; group=" + predId + "r")};
                        this.rl.add(new Object[]{new ResultSet(new Result[][]{tr}), ens}, score);
                    } else {
                        this.rl.add(new ResultSet(new Result[][]{tr}), score);
                    }
                    --i2;
                }
                if (this.rl.getWorstScore() > this.totalThresh) {
                    this.totalThresh = this.rl.getWorstScore();
                }
            }
            catch (Exception e) {
                this.exception = true;
                e.printStackTrace();
                throw new RuntimeException();
            }
        }

        static /* synthetic */ void access$0(Worker worker) {
            worker.compute();
        }

        static /* synthetic */ ResultList access$1(Worker worker) {
            return worker.rl;
        }

        static /* synthetic */ boolean access$2(Worker worker) {
            return worker.exception;
        }

        static /* synthetic */ long access$3(Worker worker) {
            return worker.size;
        }
    }
}

