/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import projects.tals.TALgetterRVDDependentComponent;

public class TAL_A_NSFMap
extends TALgetterRVDDependentComponent {
    private int[] map;

    public TAL_A_NSFMap(AlphabetContainer alphabets, AlphabetContainer alphabetsRVD, int length, double ess, double[] priorImp, double[][] priorPrefs) throws Exception {
        super(alphabets, alphabetsRVD, length, ess, priorImp, priorPrefs);
    }

    @Override
    public TAL_A_NSFMap clone() throws CloneNotSupportedException {
        TAL_A_NSFMap clone = (TAL_A_NSFMap)super.clone();
        if (this.map != null) {
            clone.map = (int[])this.map.clone();
        }
        return clone;
    }

    private static int[] buildMap(AlphabetContainer con) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while ((double)i < con.getAlphabetLengthAt(0)) {
            String sym = con.getSymbol(0, i).toUpperCase();
            String last = sym.substring(1);
            set.add(last);
            ++i;
        }
        try {
            DiscreteAlphabet da = new DiscreteAlphabet(true, set.toArray(new String[0]));
            int[] map = new int[(int)con.getAlphabetLengthAt(0)];
            int i2 = 0;
            while ((double)i2 < con.getAlphabetLengthAt(0)) {
                String sym = con.getSymbol(0, i2).toUpperCase();
                String last = sym.substring(1);
                map[i2] = da.getCode(last);
                ++i2;
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected int getNumberOfSymbols(AlphabetContainer con) {
        if (this.map == null) {
            this.map = TAL_A_NSFMap.buildMap(con);
        }
        int max = -1;
        int i = 0;
        while (i < this.map.length) {
            if (this.map[i] > max) {
                max = this.map[i];
            }
            ++i;
        }
        return max + 1;
    }

    @Override
    protected int getMappedIndex(AlphabetContainer con, int original) {
        if (this.map == null) {
            this.map = TAL_A_NSFMap.buildMap(con);
        }
        return this.map[original];
    }

    @Override
    public AlphabetContainer addAndSet(String[] rvds, double[][] specs) throws WrongAlphabetException, IllegalArgumentException, DoubleSymbolException {
        DiscreteAlphabet alph = (DiscreteAlphabet)this.alphabetsRVD.getAlphabetAt(0);
        int[] map = new int[rvds.length];
        Arrays.fill(map, -1);
        int n = 0;
        int i = 0;
        while (i < rvds.length) {
            if (alph.isSymbol(rvds[i])) {
                map[i] = alph.getCode(rvds[i]);
            } else {
                ++n;
            }
            ++i;
        }
        if (n > 0) {
            String[] newAlph = new String[(int)alph.length() + n];
            int i2 = 0;
            while ((double)i2 < alph.length()) {
                newAlph[i2] = alph.getSymbolAt(i2);
                ++i2;
            }
            int j = 0;
            while (j < map.length) {
                if (map[j] == -1) {
                    newAlph[i2] = rvds[j];
                    ++i2;
                }
                ++j;
            }
            alph = new DiscreteAlphabet(true, newAlph);
            this.alphabetsRVD = new AlphabetContainer((Alphabet)alph);
            this.map = TAL_A_NSFMap.buildMap(this.alphabetsRVD);
            n = this.getNumberOfSymbols(this.alphabetsRVD);
            HomogeneousMMDiffSM[] temp_c = new HomogeneousMMDiffSM[n];
            System.arraycopy(this.hmm_c, 0, temp_c, 0, this.hmm_c.length);
            i2 = this.hmm_c.length;
            while (i2 < n) {
                temp_c[i2] = new HomogeneousMMDiffSM(this.alphabets, 0, this.ess / (double)temp_c.length, this.priorLength);
                temp_c[i2].initializeFunctionRandomly(false);
                ++i2;
            }
            this.hmm_c = temp_c;
        }
        i = 0;
        while (i < rvds.length) {
            int idx = this.getMappedIndex(this.alphabetsRVD, alph.getCode(rvds[i]));
            double[] temp = (double[])specs[i].clone();
            int j = 0;
            while (j < temp.length) {
                temp[j] = Math.log(temp[j]);
                ++j;
            }
            this.hmm_c[idx].setParameters(temp, 0);
            ++i;
        }
        return this.alphabetsRVD;
    }

    public TAL_A_NSFMap(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((double)i < this.alphabetsRVD.getAlphabetLengthAt(0)) {
            sb.append(String.valueOf(this.alphabetsRVD.getSymbol(0, i)) + "\t");
            sb.append(this.hmm_c[this.getMappedIndex(this.alphabetsRVD, i)] + "\n");
            ++i;
        }
        return sb.toString();
    }
}

