/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NormalizePileupOutput
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new NormalizePileupOutput());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter pileupFile = new FileParameter("Pileup output file", "Pileup output file.", "tsv.gz,tsv,txt", true);
        return new ToolParameterSet(this.getShortName(), pileupFile);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        progress.setLast(1.0);
        progress.setCurrent(0.0);
        String pileupFile = parameters.getParameterAt(0).getValue().toString();
        BufferedReader BR = null;
        BR = pileupFile.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(pileupFile))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(pileupFile))));
        File out = File.createTempFile("pileup.normalized", ".temp.tsv.gz", new File("."));
        out.deleteOnExit();
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(out));
        PrintStream os_ps = new PrintStream(os);
        String line = "";
        HashMap<Integer, Integer> tempCov = null;
        String chrom_before = "";
        String chrom = "";
        int pos = 0;
        boolean first = true;
        while ((line = BR.readLine()) != null) {
            if (!line.matches("Chr([\\d]+)\\t([\\d]+)\\t([\\d]+)")) continue;
            String[] splitLine = line.split("\t");
            chrom = splitLine[0];
            pos = Integer.parseInt(splitLine[1]);
            if (chrom.equals(chrom_before)) {
                tempCov.put(pos, Integer.parseInt(splitLine[2]));
            } else {
                if (first) {
                    first = false;
                } else {
                    this.normalizeChrom(chrom_before, os_ps, tempCov);
                }
                tempCov = new HashMap<Integer, Integer>();
                tempCov.put(pos, Integer.parseInt(splitLine[2]));
            }
            chrom_before = chrom;
        }
        this.normalizeChrom(chrom_before, os_ps, tempCov);
        BR.close();
        os.close();
        TextResult tr = new TextResult("Normalized pileup file", "Normalized pileup file", new FileParameter.FileRepresentation(out.getAbsolutePath()), "tsv.gz", this.getToolName(), null, true);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(tr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    private void normalizeChrom(String chrom, PrintStream os_ps, HashMap<Integer, Integer> tempCov) {
        double window = 10000.0;
        int half = (int)(window / 2.0);
        Object[] tempPileupCovKeySetArray = new Integer[tempCov.keySet().size()];
        tempCov.keySet().toArray(tempPileupCovKeySetArray);
        Arrays.sort(tempPileupCovKeySetArray);
        Object lastPos = tempPileupCovKeySetArray[tempPileupCovKeySetArray.length - 1];
        Object[] originalCov = new Double[((Integer)lastPos).intValue()];
        Object[] normalizeCov = new Double[((Integer)lastPos).intValue()];
        Arrays.fill(originalCov, (Object)0.0);
        Arrays.fill(normalizeCov, (Object)0.0);
        int i = 0;
        while (i < originalCov.length) {
            if (tempCov.containsKey(i)) {
                originalCov[i] = tempCov.get(i).doubleValue();
            }
            ++i;
        }
        double tempSum = 0.0;
        boolean isFirst = true;
        int i2 = 0;
        while (i2 < originalCov.length) {
            int windowend;
            int windowStart = i2 - half < 0 ? 0 : i2 - half;
            int n = windowend = i2 + half > (Integer)lastPos ? (Integer)lastPos : i2 + half;
            if (isFirst) {
                int j = windowStart;
                while (j < windowend) {
                    tempSum += ((Double)originalCov[j]).doubleValue();
                    ++j;
                }
                isFirst = false;
            } else {
                tempSum -= ((Double)originalCov[windowStart]).doubleValue();
                tempSum += ((Double)originalCov[windowend - 1]).doubleValue();
            }
            normalizeCov[i2] = (Double)originalCov[i2] - tempSum / (double)(windowend - windowStart + 1);
            if (tempCov.containsKey(i2) && (Double)normalizeCov[i2] > 0.0) {
                os_ps.print(String.valueOf(chrom) + "\t" + i2 + "\t" + normalizeCov[i2] + "\n");
            }
            ++i2;
        }
    }

    @Override
    public String getToolName() {
        return "NormalizePileupOutput";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "normpileup";
    }

    @Override
    public String getDescription() {
        return "Normalizes pileup output";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(NormalizePileupOutput.class.getClassLoader().getResourceAsStream("projects/tals/epigenetic/toolHelpFiles/NormalizePileupOutput.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

