/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.linear;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;
import java.util.Arrays;
import projects.tals.RVDSequence;

public class LF0Conditional
extends AbstractDifferentiableSequenceScore {
    private double[][] beta;
    private int[] indexMap;
    private AlphabetContainer rvds;
    private double[] prior;

    public LF0Conditional(AlphabetContainer rvds, String[] specific, double[] priorProbs) throws IllegalArgumentException {
        super(DNAAlphabetContainer.SINGLETON, 1);
        this.beta = new double[specific.length + 1][(int)this.getAlphabetContainer().getAlphabetLengthAt(1)];
        int k = 1;
        this.indexMap = new int[(int)rvds.getAlphabetLengthAt(0)];
        int i = 0;
        while ((double)i < rvds.getAlphabetLengthAt(0)) {
            String curr = rvds.getSymbol(0, i);
            int j = 0;
            while (j < specific.length) {
                if (curr.equals(specific[j])) {
                    this.indexMap[i] = k++;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.rvds = rvds;
        this.prior = new double[priorProbs.length];
        i = 0;
        while (i < this.prior.length) {
            this.prior[i] = Math.log(priorProbs[i]);
            ++i;
        }
    }

    @Override
    public LF0Conditional clone() throws CloneNotSupportedException {
        LF0Conditional clone = (LF0Conditional)super.clone();
        clone.beta = (double[][])ArrayHandler.clone((Cloneable[])this.beta);
        clone.indexMap = (int[])this.indexMap.clone();
        return clone;
    }

    public LF0Conditional(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.initializeFunctionRandomly(freeParams);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int j = 0;
        while (j < this.beta[0].length) {
            this.beta[0][j] = Math.random() * 2.0 - 1.0;
            ++j;
        }
        int i = 1;
        while (i < this.beta.length) {
            System.arraycopy(this.beta[0], 0, this.beta[i], 0, this.beta[0].length);
            ++i;
        }
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int idx = seq.discreteVal(start);
        ReferenceSequenceAnnotation data_anno = (ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0);
        RVDSequence rvd_seq = (RVDSequence)data_anno.getReferenceSequence();
        int index_tj = this.indexMap[rvd_seq.discreteVal(start)];
        double bet = this.beta[0][idx] + this.beta[index_tj][idx];
        indices.add(index_tj * this.beta[0].length + idx);
        partialDer.add(1.0);
        indices.add(idx);
        partialDer.add(1.0);
        return this.prior[seq.discreteVal(start)] + bet;
    }

    @Override
    public int getNumberOfParameters() {
        return this.beta.length * this.beta[0].length;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] params = new double[this.getNumberOfParameters()];
        int i = 0;
        int k = 0;
        while (i < this.beta.length) {
            int j = 0;
            while (j < this.beta[i].length) {
                params[k] = this.beta[i][j];
                ++j;
                ++k;
            }
            ++i;
        }
        return params;
    }

    @Override
    public void setParameters(double[] params, int start) {
        int i = 0;
        int k = 0;
        while (i < this.beta.length) {
            int j = 0;
            while (j < this.beta[i].length) {
                this.beta[i][j] = params[k + start];
                ++j;
                ++k;
            }
            ++i;
        }
    }

    @Override
    public String getInstanceName() {
        return "LF0Conditional";
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        ReferenceSequenceAnnotation data_anno = (ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0);
        RVDSequence rvd_seq = (RVDSequence)data_anno.getReferenceSequence();
        int index_tj = this.indexMap[rvd_seq.discreteVal(start)];
        return this.prior[seq.discreteVal(start)] + this.beta[0][seq.discreteVal(start)] + this.beta[index_tj][seq.discreteVal(start)];
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer();
        sb.append("OT: " + Arrays.toString(this.beta[0]) + "\n");
        int i = 0;
        while (i < this.indexMap.length) {
            if (this.indexMap[i] > 0) {
                sb.append(String.valueOf(this.rvds.getSymbol(0, i)) + ": " + Arrays.toString(this.beta[this.indexMap[i]]) + "\n");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.beta, "beta");
        XMLParser.appendObjectWithTags(sb, this.indexMap, "indexMap");
        XMLParser.appendObjectWithTags(sb, this.rvds, "rvds");
        XMLParser.appendObjectWithTags(sb, this.prior, "prior");
        XMLParser.addTags(sb, "LF0Conditional");
        return sb;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        this.alphabets = DNAAlphabetContainer.SINGLETON;
        this.length = 1;
        xml = XMLParser.extractForTag(xml, "LF0Conditional");
        this.beta = (double[][])XMLParser.extractObjectForTags(xml, "beta");
        this.indexMap = (int[])XMLParser.extractObjectForTags(xml, "indexMap");
        this.rvds = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "rvds");
        this.prior = (double[])XMLParser.extractObjectForTags(xml, "prior");
    }

    public double[] getSpecs(Sequence rvds) {
        int index_tj = this.indexMap[rvds.discreteVal(0)];
        double[] specs = new double[(int)this.alphabets.getAlphabetLengthAt(0)];
        int i = 0;
        while (i < specs.length) {
            specs[i] = this.prior[i] + this.beta[0][i] + this.beta[index_tj][i];
            ++i;
        }
        return specs;
    }
}

