/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.training;

import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.FileManager;
import de.jstacs.utils.SafeOutputStream;
import projects.tals.RVDSequence;
import projects.tals.linear.LF0Conditional;
import projects.tals.linear.LFModularConditional9C;
import projects.tals.linear.LFPosition_mixture;
import projects.tals.linear.LFSpecificity_parallel_cond9C;
import projects.tals.linear.MSDFunction;
import projects.tals.training.CachingRVDReferenceSequenceAnnotationParser;

public class PrediTALE_Training_for_Test {
    public static void main(String[] args) throws Exception {
        String TrainData = args[0];
        int numberOfStarts = 200;
        String[] empty = new String[]{};
        boolean firstSep = Boolean.parseBoolean(args[1]);
        boolean dependencies = Boolean.parseBoolean(args[2]);
        boolean usePos = Boolean.parseBoolean(args[3]);
        boolean useRVDs = Boolean.parseBoolean(args[4]);
        boolean zeroCond = Boolean.parseBoolean(args[5]);
        String[] firstPos = new String[]{"D", "N", "G", "I"};
        if (!firstSep) {
            firstPos = empty;
        }
        String[] condRVDs = new String[]{"HD", "NN", "NG", "NI"};
        if (!dependencies) {
            condRVDs = empty;
        }
        LFPosition_mixture pos = new LFPosition_mixture();
        if (!usePos) {
            pos = null;
        }
        String[] sepRVDs = new String[]{"HD", "NN", "NG", "HG", "NI", "NK"};
        if (!useRVDs) {
            sepRVDs = empty;
        }
        String[] pos0 = new String[]{"HD", "NN", "NG", "NI", "NS"};
        if (!zeroCond) {
            pos0 = empty;
        }
        String FileXML = String.valueOf(args[0]) + "_first" + firstSep + "_deps" + dependencies + "_pos" + usePos + "_rvds" + useRVDs + "_zero" + zeroCond + ".xml";
        AlphabetContainer alphabet12 = new AlphabetContainer((Alphabet)new DiscreteAlphabet(false, "A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V"));
        AlphabetContainer alphabet13 = new AlphabetContainer((Alphabet)new DiscreteAlphabet(false, "A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "*"));
        double con = 0.1;
        LFSpecificity_parallel_cond9C spec = new LFSpecificity_parallel_cond9C(alphabet12, alphabet13, RVDSequence.getContainerRVD(alphabet12, alphabet13), firstPos, condRVDs, sepRVDs);
        DNADataSet ds = new DNADataSet(TrainData, '>', new CachingRVDReferenceSequenceAnnotationParser("seq", ":", ",", alphabet12, alphabet13));
        int threads = 8;
        DataSet[] dss = MSDFunction.splitByTagAndSort(threads, ds, "group", "signal", "globalWeight", false, true);
        double[][] gw = new double[dss.length][];
        int i = 0;
        while (i < dss.length) {
            gw[i] = new double[dss[i].getNumberOfElements()];
            int j = 0;
            while (j < gw[i].length) {
                gw[i][j] = Double.parseDouble(dss[i].getElementAt(j).getSequenceAnnotationByType("globalWeight", 0).getIdentifier());
                ++j;
            }
            ++i;
        }
        System.out.println("groups: " + dss.length);
        LFModularConditional9C model = new LFModularConditional9C(new LF0Conditional(RVDSequence.getContainerRVD(alphabet12, alphabet13), pos0, new double[]{0.05, 0.3, 0.05, 0.6}), spec, pos, dss.length);
        double bestResult = Double.POSITIVE_INFINITY;
        double[] bestVals = null;
        AbstractMultiThreadedOptimizableFunction fun = null;
        int i2 = 0;
        while (i2 < numberOfStarts) {
            System.out.println("Start: " + (i2 + 1));
            model.initializeFunctionRandomly(false);
            System.out.println(model);
            fun = new MSDFunction(con, false, model, threads, dss, gw, dss.length * 2, "signal");
            ((MSDFunction)fun).reset();
            double[] vals = fun.getParameters(OptimizableFunction.KindOfParameter.LAST);
            Optimizer.optimize((byte)20, fun, vals, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-10), 1.0E-10, new ConstantStartDistance(1.0E-10), SafeOutputStream.getSafeOutputStream(System.out));
            fun.setParams(vals);
            double aktResult = fun.evaluateFunction(vals);
            if (aktResult < bestResult) {
                bestResult = aktResult;
                bestVals = vals;
            }
            System.out.println("current result (Start: " + (i2 + 1) + "):" + aktResult);
            System.out.println(model);
            ++i2;
        }
        fun.setParams(bestVals);
        System.out.println(fun.evaluateFunction(bestVals));
        System.out.println(model);
        FileManager.writeFile(FileXML, (CharSequence)model.toXML());
    }
}

