/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.Singleton;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import projects.xanthogenomes.Tools;

public final class RVDAlphabetContainer
extends AlphabetContainer
implements Singleton {
    public static final RVDAlphabetContainer SINGLETON = RVDAlphabetContainer.get();

    private RVDAlphabetContainer() throws IllegalArgumentException, DoubleSymbolException {
        super((Alphabet)new DiscreteAlphabet(true, RVDAlphabetContainer.getRVDs()));
    }

    private static String[] getRVDs() {
        AlphabetContainer prot = Tools.Translator.DEFAULT.getProteinAlphabet();
        String[] rvds = new String[(int)(prot.getAlphabetLengthAt(0) * prot.getAlphabetLengthAt(0))];
        int k = 0;
        int i = 0;
        while ((double)i < prot.getAlphabetLengthAt(0)) {
            int j = 0;
            while ((double)j < prot.getAlphabetLengthAt(0)) {
                rvds[k] = String.valueOf(prot.getSymbol(0, i)) + prot.getSymbol(0, j);
                ++j;
                ++k;
            }
            ++i;
        }
        return rvds;
    }

    private static RVDAlphabetContainer get() {
        try {
            RVDAlphabetContainer RVDAlphabet = new RVDAlphabetContainer();
            return RVDAlphabet;
        }
        catch (Exception e) {
            return null;
        }
    }
}

