/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.Singleton;
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.MatrixCosts;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.utils.IntList;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class Tools {
    public static DataSet extractRVDs(DataSet tales) throws EmptyDataSetException, WrongAlphabetException {
        Sequence[] seqs = new Sequence[tales.getNumberOfElements()];
        int i = 0;
        while (i < tales.getNumberOfElements()) {
            seqs[i] = tales.getElementAt(i).getSubSequence(11, 2);
            ++i;
        }
        return new DataSet("", seqs);
    }

    public static Sequence[] translate(Sequence[] tales, Translator t) throws WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException, IllegalArgumentException, IOException, DoubleSymbolException {
        Sequence[] seqs = new Sequence[tales.length];
        int i = 0;
        while (i < tales.length) {
            seqs[i] = t.translate(tales[i], 0);
            ++i;
        }
        return seqs;
    }

    public static Sequence getConsensusSequence(DataSet alignment) throws WrongAlphabetException, WrongSequenceTypeException {
        AlphabetContainer prot = alignment.getAlphabetContainer();
        double[][] pfm = PFMComparator.getPFM(alignment);
        IntList il = new IntList();
        int i = 0;
        while (i < pfm.length) {
            int idx = ToolBox.getMaxIndex(pfm[i]);
            if (!"-".equals(prot.getSymbol(0, idx))) {
                il.add(idx);
            }
            ++i;
        }
        return new IntSequence(prot, il.toArray());
    }

    public static class Aligner {
        public static Aligner DEFAULT;
        private Alignment align;
        private double[][] matrix;

        static {
            try {
                DEFAULT = new Aligner(Aligner.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/BLOSUM62.txt"), Translator.DEFAULT.getProteinAlphabet());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public double[][] getMatrix() throws CloneNotSupportedException {
            return (double[][])ArrayHandler.clone((Cloneable[])this.matrix);
        }

        public Aligner(String blosum, AlphabetContainer prot) throws NumberFormatException, FileNotFoundException, IOException, WrongAlphabetException, CloneNotSupportedException {
            this(new FileInputStream(blosum), prot);
        }

        public Aligner(InputStream blosum, AlphabetContainer prot) throws IOException, NumberFormatException, WrongAlphabetException, CloneNotSupportedException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(blosum));
            String str = null;
            String[] header = null;
            this.matrix = null;
            while ((str = reader.readLine()) != null) {
                if (str.startsWith("#")) continue;
                if (header == null) {
                    str = str.trim();
                    header = str.split("\\s+");
                    this.matrix = new double[header.length][header.length];
                    continue;
                }
                String[] pars = str.split("\\s+");
                int i = 1;
                while (i < pars.length) {
                    this.matrix[(int)prot.getCode((int)0, (String)pars[0].trim())][(int)prot.getCode((int)0, (String)header[i - 1].trim())] = -Double.parseDouble(pars[i]);
                    ++i;
                }
            }
            reader.close();
            AffineCosts cost = new AffineCosts(3.0, new MatrixCosts(this.matrix, 1.0));
            this.align = new Alignment(cost);
        }

        public PairwiseStringAlignment align(Sequence tale1, Sequence tale2, Alignment.AlignmentType type) {
            PairwiseStringAlignment alignment = this.align.getAlignment(type, tale1, tale2);
            return alignment;
        }
    }

    public static class ProteinAlphabetContainer
    extends AlphabetContainer
    implements Singleton {
        public static final ProteinAlphabetContainer SINGLETON = ProteinAlphabetContainer.get();

        private static ProteinAlphabetContainer get() {
            ProteinAlphabetContainer res = null;
            try {
                res = new ProteinAlphabetContainer();
            }
            catch (Exception doesnothappen) {
                doesnothappen.printStackTrace();
            }
            return res;
        }

        private ProteinAlphabetContainer() throws IllegalArgumentException, DoubleSymbolException {
            super((Alphabet)new DiscreteAlphabet(false, "I", "L", "V", "F", "M", "C", "A", "G", "P", "T", "S", "Y", "W", "Q", "N", "H", "E", "D", "K", "R", "*", "B", "Z", "X", "-"));
        }
    }

    public static class Translator {
        public static Translator DEFAULT;
        private AlphabetContainer prot;
        private int[][][] codonMap;

        static {
            try {
                DEFAULT = new Translator(Translator.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/genetic_code.txt"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Translator(String genCode) throws IllegalArgumentException, FileNotFoundException, IOException, DoubleSymbolException, WrongAlphabetException {
            this(new FileInputStream(genCode));
        }

        public Translator(InputStream genCode) throws IOException, IllegalArgumentException, DoubleSymbolException, WrongAlphabetException {
            DNAAlphabetContainer dna = DNAAlphabetContainer.SINGLETON;
            BufferedReader reader = new BufferedReader(new InputStreamReader(genCode));
            String str = null;
            HashMap<String, String[]> list = new HashMap<String, String[]>();
            while ((str = reader.readLine()) != null) {
                String[] code = str.split("\t");
                String[] vals = code[1].split(",\\s+");
                list.put(code[0], vals);
            }
            list.put("B", new String[0]);
            list.put("Z", new String[0]);
            list.put("X", new String[0]);
            list.put("-", new String[0]);
            String[] key = list.keySet().toArray(new String[0]);
            this.prot = ProteinAlphabetContainer.SINGLETON;
            this.codonMap = new int[(int)dna.getAlphabetLengthAt(0)][(int)dna.getAlphabetLengthAt(0)][(int)dna.getAlphabetLengthAt(0)];
            int i = 0;
            while (i < key.length) {
                int sym = (int)this.prot.getCode(0, key[i]);
                String[] vals = (String[])list.get(key[i]);
                int j = 0;
                while (j < vals.length) {
                    Sequence val = Sequence.create(dna, vals[j].trim());
                    this.codonMap[val.discreteVal((int)0)][val.discreteVal((int)1)][val.discreteVal((int)2)] = sym;
                    ++j;
                }
                ++i;
            }
            reader.close();
        }

        public AlphabetContainer getProteinAlphabet() {
            return this.prot;
        }

        public Sequence translate(Sequence dna, int readingFrame) throws WrongAlphabetException, WrongSequenceTypeException {
            int[] prot = new int[(dna.getLength() - readingFrame) / 3];
            int i = readingFrame;
            while (i + 2 < dna.getLength()) {
                prot[i / 3] = this.codonMap[dna.discreteVal(i)][dna.discreteVal(i + 1)][dna.discreteVal(i + 2)];
                i += 3;
            }
            return new IntSequence(this.prot, prot);
        }

        public static void main(String[] args) throws IllegalArgumentException, WrongAlphabetException, WrongSequenceTypeException, IOException, DoubleSymbolException {
            Sequence dna = Sequence.create(DNAAlphabetContainer.SINGLETON, "ATGGTGCTGATCTAG");
            Translator trans = new Translator("projects/xcvgenomes/genetic_code.txt");
            System.out.println(trans.translate(dna, 0));
        }
    }
}

