/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes.tools;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.Pair;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.tals.ScanForTBSCLI;
import projects.tals.TALgetterDiffSM;
import projects.xanthogenomes.BuildFamilies;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEFamilyBuilder;
import projects.xanthogenomes.tools.ClassBuilderTool;

public class ClassAssignmentTool
implements JstacsTool {
    private static LinkedList<String> alreadyGiven = new LinkedList();
    private static NumberFormat format = DecimalFormat.getInstance(Locale.US);
    private static NumberFormat formatE = new DecimalFormat("0.##E0");

    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter builderFile = new FileParameter("Class builder", "TALE class builder definition", "xml", true);
        builderFile.setExtendedType(TALEFamilyBuilder.class.getName());
        FileParameter fp = new FileParameter("TALE sequences", "The sequences of the TALEs (DNA or protein), or \"TALE DNA parts\" or \"TALE Protein parts\" output of \"TALE Analysis\", or RVD sequences.", "fasta,fa,fas", true);
        fp.setExtendedType("fasta/dna");
        SimpleParameter sp = null;
        SimpleParameter ap = null;
        try {
            sp = new SimpleParameter(DataType.STRING, "Strain", "The name of the strain.", false);
            ap = new SimpleParameter(DataType.STRING, "Accession", "The accesion number of the genome (if applicable).", false);
        }
        catch (SimpleParameter.DatatypeNotValidException e) {
            e.printStackTrace();
        }
        return new ToolParameterSet(this.getShortName(), builderFile, fp, sp, ap);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        String accession;
        progress.setLast(1.0);
        progress.setCurrent(0.0);
        TALEFamilyBuilder builder = new TALEFamilyBuilder(new StringBuffer(((FileParameter)parameters.getParameterAt(0)).getFileContents().getContent()));
        TALE[] newttales = null;
        try {
            newttales = ClassBuilderTool.readProteinTALEs(((FileParameter)parameters.getParameterAt(1)).getFileContents(), protocol);
        }
        catch (Exception e) {
            protocol.appendWarning("TALE sequence could not be read. Please make sure that the input is indeed a FastA containing TALE sequences or TALE parts.\n");
            protocol.appendThrowable(e);
            throw e;
        }
        String orgSuff = (String)parameters.getParameterAt(2).getValue();
        if (orgSuff != null && orgSuff.trim().length() == 0) {
            orgSuff = null;
        }
        if ((accession = (String)parameters.getParameterAt(3).getValue()) != null && accession.trim().length() == 0) {
            accession = null;
        }
        double cut = builder.getCut();
        builder.setToOld();
        TALEFamilyBuilder.TALEFamily[] fams = builder.getFamilies();
        LinkedList<Result> topLevel = new LinkedList<Result>();
        LinkedList<Result> ress = new LinkedList<Result>();
        ArrayList<TALE> notAssigned = new ArrayList<TALE>();
        boolean[] added = new boolean[fams.length];
        protocol.append("Assigning TALE...\n");
        SchemaFamilyIdGenerator gen = new SchemaFamilyIdGenerator(orgSuff, accession);
        int i = 0;
        while (i < newttales.length) {
            protocol.append(String.valueOf(newttales[i].getId()) + "\n");
            newttales[i].setIsNew(true);
            StringBuffer report = new StringBuffer();
            report.append("New TALE: " + newttales[i].getId() + "\n");
            if (newttales[i].getNumberOfRepeats() > 3) {
                Pair<Integer, Double> idx = builder.getClosestFamilyIndex(newttales[i], null);
                if (idx.getSecondElement() < cut) {
                    report.append("Assigned to class " + fams[idx.getFirstElement()].getFamilyId() + ".\n");
                    double p2 = fams[idx.getFirstElement()].getSignificance(newttales[i], null, null, builder);
                    report.append("distance " + format.format(idx.getSecondElement()) + ", (p=" + formatE.format(Math.pow(10.0, p2)) + ")\n");
                    LinkedList<TALE> temp = new LinkedList<TALE>();
                    temp.add(newttales[i]);
                    LinkedList ass = new LinkedList();
                    ass.add(new Pair(idx.getFirstElement(), temp));
                    builder.addTALEsToFamilies(ass.toArray(new Pair[0]), new TALE[0], gen);
                    fams[idx.getFirstElement().intValue()] = builder.getFamily(idx.getFirstElement());
                    newttales[i].setIsNew(false);
                    added[idx.getFirstElement().intValue()] = true;
                } else {
                    report.append("Not assigned to any class.\n");
                    notAssigned.add(newttales[i]);
                    idx = new Pair<Integer, Object>(-1, null);
                }
                report.append("Other families with significant matches:\n");
                boolean found = false;
                int j = 0;
                while (j < fams.length) {
                    double p;
                    if (j != idx.getFirstElement() && (p = fams[j].getSignificance(newttales[i], null, null, builder)) < Math.log10(0.001)) {
                        double d = fams[j].getDistance(newttales[i], null, builder);
                        report.append("Class " + fams[j].getFamilyId() + ": distance " + format.format(d) + ", (p=" + formatE.format(Math.pow(10.0, p)) + "),\n");
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    report.append("none\n");
                }
                report.append("\nPlease note that numbers within TALE classes are assigned successively and may change when TALEs are included into the official AnnoTALE database later.\n");
                ress.add(new TextResult("Report for " + newttales[i].getId(), "", new FileParameter.FileRepresentation("", report.toString()), "txt", "TALE Class Assignment", null, false));
            } else {
                report.append("Not assigned to a class, because it has less than 4 repeats.\n");
                protocol.appendWarning("TALE " + newttales[i].getId() + " not assigned to a class, because it has less than 4 repeats.\n");
                ress.add(new TextResult("Report for " + newttales[i].getId(), "", new FileParameter.FileRepresentation("", report.toString()), "txt", "TALE Class Assignment", null, false));
            }
            progress.setCurrent((double)i / (double)newttales.length / 2.0);
            ++i;
        }
        topLevel.add(new ResultSetResult("Reports", "Assignment reports for new TALEs", null, new ResultSet(new Result[][]{ress.toArray(new Result[0])})));
        ress.clear();
        builder.addTALEsToFamilies(new Pair[0], notAssigned.toArray(new TALE[0]), gen);
        progress.setCurrent(0.75);
        i = 0;
        while (i < newttales.length) {
            newttales[i].setIsNew(true);
            ++i;
        }
        TALEFamilyBuilder.TALEFamily[] newFams = builder.getFamilies();
        Object[] ces = new ComparableElement[added.length];
        int i2 = 0;
        while (i2 < added.length) {
            ces[i2] = new ComparableElement<Boolean, TALEFamilyBuilder.TALEFamily>(added[i2], newFams[i2]);
            ++i2;
        }
        Arrays.sort(ces);
        i2 = 0;
        while (i2 < added.length) {
            added[i2] = (Boolean)((ComparableElement)ces[i2]).getElement();
            newFams[i2] = (TALEFamilyBuilder.TALEFamily)((ComparableElement)ces[i2]).getWeight();
            ++i2;
        }
        TALgetterDiffSM model = (TALgetterDiffSM)XMLParser.extractObjectForTags(FileManager.readInputStream(ScanForTBSCLI.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/talfinder_obg2_hyp_bg.xml")), "model");
        int i3 = 0;
        while (i3 < added.length) {
            if (added[i3]) {
                PlotGeneratorResult pgr = new PlotGeneratorResult("Class tree for " + newFams[i3].getFamilyId(), "Plot of the tree of the TALEs in this class", newFams[i3], true);
                TextResult fileres = new TextResult("Class report for " + newFams[i3].getFamilyId(), "Report for class " + newFams[i3].getFamilyId(), new FileParameter.FileRepresentation("", newFams[i3].toString(model, builder)), "txt", "TALE Class Assignment", null, false);
                ResultSetResult rsr = new ResultSetResult("Modified class " + newFams[i3].getFamilyId(), "Collection of results for class " + newFams[i3].getFamilyId(), null, new ResultSet(new Result[][]{{fileres, pgr}}));
                ress.add(rsr);
            }
            ++i3;
        }
        if (notAssigned.size() > 0) {
            protocol.append("Creating new classes...\n");
            Object[] res2 = BuildFamilies.getFamilyResults(newFams, builder.getPVal(), builder, added.length);
            Arrays.sort(res2);
            protocol.append("... found " + res2.length + " new classes.\n");
            int i4 = 0;
            while (i4 < res2.length) {
                PlotGeneratorResult pgr = new PlotGeneratorResult("Class tree for " + ((BuildFamilies.FamilyResult)res2[i4]).getFamily().getFamilyId(), "Plot of the tree of the TALEs in this class", ((BuildFamilies.FamilyResult)res2[i4]).getFamily(), true);
                TextResult fileres = new TextResult("Class report for " + ((BuildFamilies.FamilyResult)res2[i4]).getFamily().getFamilyId(), "Report for class " + ((BuildFamilies.FamilyResult)res2[i4]).getFamily().getFamilyId(), new FileParameter.FileRepresentation("", ((BuildFamilies.FamilyResult)res2[i4]).getFamily().toString(model, builder)), "txt", "TALE Class Assignment", null, false);
                ResultSetResult rsr = new ResultSetResult("New class " + ((BuildFamilies.FamilyResult)res2[i4]).getFamily().getFamilyId(), "Collection of results for class " + ((BuildFamilies.FamilyResult)res2[i4]).getFamily().getFamilyId(), null, new ResultSet(new Result[][]{{fileres, pgr}}));
                ress.add(rsr);
                ++i4;
            }
        }
        topLevel.add(new ResultSetResult("Classes", "Modified and new TALE classes", null, new ResultSet(new Result[][]{ress.toArray(new Result[0])})));
        ress.clear();
        protocol.append("\nProposing TALE names...\n");
        StringBuffer summary = new StringBuffer();
        LinkedList<ResultSet> props = new LinkedList<ResultSet>();
        String[][] map = gen.lastNameMap;
        summary.append("The " + map.length + " TALEs have been assigned to the following classes:\n");
        int i5 = 0;
        while (i5 < map.length) {
            props.add(new ResultSet(new Result[][]{{new CategoricalResult("Old name", "", map[i5][0]), new CategoricalResult("New name", "", map[i5][1])}}));
            String clazz = map[i5][1];
            String temp = clazz.replaceAll("\\s.*$", "");
            clazz = temp.replaceAll("[0-9]+$", "");
            int num = Integer.parseInt(temp.substring(clazz.length()));
            summary.append("- " + map[i5][0] + " has been assigned to " + (num == 1 ? "new" : "existing") + " class " + clazz + " with name " + map[i5][1] + "\n");
            ++i5;
        }
        String oss = orgSuff == null ? "" : " (" + orgSuff + ")";
        summary.append("\nPlease note that numbers within TALE classes are assigned successively and may change when TALEs are included into the official AnnoTALE database later.\n");
        summary.append("\n\nA detailed assignment report for each individual TALE can be found under \"Reports\".\n\nClass reports and class trees for all classes that have been created or \nmodified due to class assignment of these TALEs are available under \"Classes\".\n\nThe systematic names proposed for these TALEs based on the class assignment are \navailable as \"TALE names" + oss + "\".\n" + "This file can also be used for the \"Rename TALEs in File\" module of AnnoTALE.\n\n" + "A class builder that may be used in successive runs of the \"TALE Class Assignment\" \n" + "module is provided as \"" + "Augmented class builder" + oss + "\".\n\n" + "Renamed TALE DNA and protein sequences are provided under \"" + "Renamed TALE protein sequences" + oss + "\".");
        topLevel.addFirst(new TextResult("Summary of class assignment", "A summary of the class assignment", new FileParameter.FileRepresentation("", summary.toString()), "txt", "TALE Class Builder", TALEFamilyBuilder.class.getName(), true));
        ListResult lr = new ListResult("TALE names" + oss, "Proposed TALE names based on class assignment", null, props.toArray(new ResultSet[0]));
        topLevel.add(lr);
        topLevel.add(new TextResult("Augmented class builder" + oss, "TALE class builder definition", new FileParameter.FileRepresentation("", builder.toXML().toString()), "xml", "TALE Class Builder", TALEFamilyBuilder.class.getName(), true));
        StringBuffer dna = new StringBuffer();
        StringBuffer prot = new StringBuffer();
        protocol.append("Writing FastA outputs.\n");
        int i6 = 0;
        while (i6 < newttales.length) {
            int j;
            TALE dnaTALE = newttales[i6].getDnaOriginal();
            if (dnaTALE != null) {
                dna.append(">" + dnaTALE.getId() + "\n");
                dna.append(dnaTALE.getStart());
                j = 0;
                while (j < dnaTALE.getNumberOfRepeats()) {
                    dna.append(dnaTALE.getRepeat(j).getRepeat());
                    ++j;
                }
                dna.append(newttales[i6].getDnaOriginal().getEnd() + "\n");
            }
            prot.append(">" + newttales[i6].getId() + "\n");
            prot.append(newttales[i6].getStart());
            j = 0;
            while (j < newttales[i6].getNumberOfRepeats()) {
                prot.append(newttales[i6].getRepeat(j).getRepeat());
                ++j;
            }
            prot.append(newttales[i6].getEnd() + "\n");
            ++i6;
        }
        TextResult fres4 = new TextResult("Renamed TALE protein sequences" + oss, "The protein sequences of the assigned TALEs using the proposed names", new FileParameter.FileRepresentation("", prot.toString()), "fasta", "Class Assignment", "fasta/as", true);
        ResultSetResult seqs = null;
        if (dna.length() > 0) {
            TextResult fres3 = new TextResult("Renamed TALE DNA sequences" + oss, "The DNA sequences of the assigned TALEs using the proposed names", new FileParameter.FileRepresentation("", dna.toString()), "fasta", "Class Assignment", "fasta/dna", true);
            seqs = new ResultSetResult("Renamed TALE sequences" + oss, "The sequences of the assigned TALEs using the proposed names", null, new ResultSet(new Result[][]{{fres3, fres4}}));
        } else {
            seqs = new ResultSetResult("Renamed TALE sequences" + oss, "The sequences of the assigned TALEs using the proposed names", null, new ResultSet(new Result[][]{{fres4}}));
        }
        topLevel.add(seqs);
        progress.setCurrent(1.0);
        ResultSet set = new ResultSet(new Result[][]{topLevel.toArray(new Result[0])});
        return new ToolResult("Result of " + this.getToolName() + oss, String.valueOf(this.getToolName()) + " on " + ((FileParameter)parameters.getParameterAt(1)).getFileContents().getFilename(), null, set, parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "TALE Class Assignment";
    }

    @Override
    public String getShortName() {
        return "assign";
    }

    @Override
    public String getDescription() {
        return "Assigns TALEs to a TALE class and proposes names";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(ClassAssignmentTool.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/tools/ClassAssignmentTool.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getToolVersion() {
        return "1.4.1";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return new String[]{"@article{grau16annotale,\n\ttitle = {{AnnoTALE}: bioinformatics tools for identification, annotation, and nomenclature of {TALEs} from \\emph{Xanthomonas} genomic sequences},\n\tauthor = {Grau, Jan and Reschke, Maik and Erkes, Annett and Streubel, Jana and Morgan, Richard D. and Wilson, Geoffrey G. and Koebnik, Ralf and Boch, Jens},\n\tjournal = {Scientific Reports},\n\tyear = {2016},\n\tvolume = {6},\n\tpages = {21077},\n\tdoi = {10.1038/srep21077}\n\t}\n"};
    }

    public static class SchemaFamilyIdGenerator
    implements TALEFamilyBuilder.FamilyIdGenerator {
        private String orgSuff;
        private String accession;
        private String[][] lastNameMap;

        public SchemaFamilyIdGenerator(String orgSuff, String accession) {
            this.orgSuff = orgSuff;
            this.accession = accession;
            this.lastNameMap = new String[0][2];
        }

        public static String[] getFamIDs() {
            String[] temp = new String[676];
            int i = 65;
            int k = 0;
            while (i < 91) {
                int j = 65;
                while (j < 91) {
                    temp[k] = "Tal" + (char)i + (char)j;
                    ++j;
                    ++k;
                }
                ++i;
            }
            return temp;
        }

        @Override
        public void setFamilyIDs(TALEFamilyBuilder.TALEFamily[] families, TALEFamilyBuilder builder) {
            LinkedList<String[]> nameMap = new LinkedList<String[]>();
            HashSet<String> reserved = new HashSet<String>();
            reserved.addAll(alreadyGiven);
            String[] re = builder.getReservedNames();
            if (re != null) {
                int i = 0;
                while (i < re.length) {
                    reserved.add(re[i]);
                    ++i;
                }
            }
            String regex = "^Tal[A-Z]{2}[0-9]+";
            Pattern pat = Pattern.compile(regex);
            int i = 0;
            while (i < families.length) {
                String famId = families[i].getFamilyId();
                if (famId != null) {
                    reserved.add(famId);
                    TALE[] mems = families[i].getFamilyMembers();
                    int j = 0;
                    while (j < mems.length) {
                        Matcher matcher;
                        String id;
                        if (!mems[j].isNew() && (id = mems[j].getId()).matches(String.valueOf(regex) + ".*") && (matcher = pat.matcher(id)).find()) {
                            reserved.add(matcher.group());
                        }
                        ++j;
                    }
                }
                ++i;
            }
            String[] syms = SchemaFamilyIdGenerator.getFamIDs();
            int off = 0;
            while (reserved.contains(syms[off])) {
                ++off;
            }
            int i2 = 0;
            while (i2 < families.length) {
                String tid;
                int j;
                TALE[] mems;
                String famId = families[i2].getFamilyId();
                if (famId == null) {
                    while (reserved.contains(syms[off])) {
                        ++off;
                    }
                    famId = syms[off];
                    families[i2].setFamilyId(famId);
                    reserved.add(famId);
                    alreadyGiven.add(famId);
                    mems = families[i2].getFamilyMembers();
                    j = 0;
                    while (j < mems.length) {
                        tid = String.valueOf(famId) + (j + 1);
                        reserved.add(tid);
                        tid = String.valueOf(tid) + (this.orgSuff == null ? "" : " " + this.orgSuff);
                        String oldId = mems[j].getId();
                        if (this.orgSuff != null) {
                            mems[j].setStrain(this.orgSuff);
                        }
                        if (this.accession != null) {
                            mems[j].setAccession(this.accession);
                        }
                        nameMap.add(new String[]{oldId, tid});
                        if (!mems[j].getId().contains("tempTALE")) {
                            tid = String.valueOf(tid) + " (" + mems[j].getId() + ")";
                        } else if (mems[j].getId().contains("Pseudo") || mems[j].getId().contains("pseudo")) {
                            tid = String.valueOf(tid) + " (Pseudo)";
                        }
                        mems[j].setId(tid);
                        ++j;
                    }
                } else {
                    mems = families[i2].getFamilyMembers();
                    j = 0;
                    while (j < mems.length) {
                        if (mems[j].isNew()) {
                            tid = families[i2].getFamilyId();
                            int k = 1;
                            String temp = String.valueOf(tid) + k;
                            while (reserved.contains(temp)) {
                                temp = String.valueOf(tid) + ++k;
                            }
                            tid = temp;
                            reserved.add(tid);
                            tid = String.valueOf(tid) + (this.orgSuff == null ? "" : " " + this.orgSuff);
                            String oldId = mems[j].getId();
                            if (this.orgSuff != null) {
                                mems[j].setStrain(this.orgSuff);
                            }
                            if (this.accession != null) {
                                mems[j].setAccession(this.accession);
                            }
                            nameMap.add(new String[]{oldId, tid});
                            if (!mems[j].getId().contains("tempTALE")) {
                                tid = String.valueOf(tid) + " (" + mems[j].getId() + ")";
                            } else if (mems[j].getId().contains("Pseudo") || mems[j].getId().contains("pseudo")) {
                                tid = String.valueOf(tid) + " (Pseudo)";
                            }
                            mems[j].setId(tid);
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            String[][] temp = (String[][])nameMap.toArray((T[])new String[0][0]);
            String[][] temp2 = new String[temp.length + this.lastNameMap.length][];
            System.arraycopy(this.lastNameMap, 0, temp2, 0, this.lastNameMap.length);
            System.arraycopy(temp, 0, temp2, this.lastNameMap.length, temp.length);
            this.lastNameMap = temp2;
        }
    }
}

