/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes.tools;

import de.jstacs.DataType;
import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import projects.tals.ScanForTBSCLI;
import projects.tals.TALgetterDiffSM;
import projects.xanthogenomes.FamilyGroupPlotter;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEFamilyBuilder;

public class LoadAndViewClassesTool
implements JstacsTool {
    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter builderFile = new FileParameter("Class builder", "TALE class builder definition", "xml", true);
        builderFile.setExtendedType(TALEFamilyBuilder.class.getName());
        try {
            SelectionParameter sp = new SelectionParameter(DataType.PARAMETERSET, new String[]{"Download current definition", "Load from local file"}, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(builderFile)}, "Class definition source", "Download current class definition (requires internet connection) or load definition from local file", true);
            return new ToolParameterSet(this.getShortName(), sp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        progress.setLast(2.0);
        progress.setCurrent(0.0);
        SelectionParameter sp = (SelectionParameter)parameters.getParameterAt(0);
        TALEFamilyBuilder builder = null;
        TALgetterDiffSM model = (TALgetterDiffSM)XMLParser.extractObjectForTags(FileManager.readInputStream(ScanForTBSCLI.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/talfinder_obg2_hyp_bg.xml")), "model");
        LinkedList<Result> ress = new LinkedList<Result>();
        if (sp.getSelected() == 0) {
            protocol.append("Downloading current class definition...\n");
            InputStream is = new URL("http://www.jstacs.de/downloads/class_definitions_current2.xml.gz").openStream();
            GZIPInputStream gzis = new GZIPInputStream(is);
            Scanner scan = new Scanner(gzis);
            String text = scan.useDelimiter("\\A").next();
            scan.close();
            protocol.append("...finished.\n\nRe-building class builder...\n");
            builder = new TALEFamilyBuilder(new StringBuffer(text));
            ress.add(new TextResult("Class builder download", "TALE class builder definition", new FileParameter.FileRepresentation("", text), "xml", "Downloaded", TALEFamilyBuilder.class.getName(), true));
            protocol.append("...finished.\n\n");
        } else {
            ParameterSet ps = (ParameterSet)sp.getValue();
            protocol.append("Loading class builder...\n");
            builder = new TALEFamilyBuilder(new StringBuffer(((FileParameter)ps.getParameterAt(0)).getFileContents().getContent()));
            protocol.append("...finished.\n\n");
        }
        progress.setCurrent(1.0);
        builder.setToOld();
        ClusterTree<TALEFamilyBuilder.TALEFamily> famTree = builder.clusterFamilies();
        Object[] fams = builder.getFamilies();
        Arrays.sort(fams);
        TALE[] tales = builder.getAllTALEs();
        LinkedList<Result> reports = new LinkedList<Result>();
        StringBuffer allTales = new StringBuffer();
        int i = 0;
        while (i < tales.length) {
            allTales.append(">" + tales[i].getId() + " " + tales[i].annotationToString() + "\n");
            allTales.append(tales[i].getStart());
            int j = 0;
            while (j < tales[i].getNumberOfRepeats()) {
                allTales.append(tales[i].getRepeat(j).getRepeat());
                ++j;
            }
            allTales.append(tales[i].getEnd());
            allTales.append("\n");
            ++i;
        }
        reports.add(new TextResult("All TALE protein sequences", "Sequences of all TALEs in the class builder", new FileParameter.FileRepresentation("", allTales.toString()), "fasta", "LoadAndViewClasses", "fasta/as", true));
        HashMap<String, StringBuffer> talesByStrain = new HashMap<String, StringBuffer>();
        allTales = new StringBuffer();
        int i2 = 0;
        while (i2 < tales.length) {
            TALE dna = tales[i2].getDnaOriginal();
            if (dna != null) {
                StringBuffer temp = new StringBuffer();
                temp.append(">" + dna.getId() + " " + dna.annotationToString() + "\n");
                temp.append(dna.getStart());
                int j = 0;
                while (j < dna.getNumberOfRepeats()) {
                    temp.append(dna.getRepeat(j).getRepeat());
                    ++j;
                }
                temp.append(dna.getEnd());
                temp.append("\n");
                allTales.append(temp);
                String strain = String.valueOf(dna.getStrain());
                if (!talesByStrain.containsKey(strain)) {
                    talesByStrain.put(strain, new StringBuffer());
                }
                ((StringBuffer)talesByStrain.get(strain)).append(temp);
            }
            ++i2;
        }
        reports.add(new TextResult("All TALE DNA sequences", "Sequences of all TALEs in the class builder", new FileParameter.FileRepresentation("", allTales.toString()), "fasta", "LoadAndViewClasses", "fasta/dna", true));
        LinkedList<TextResult> byStrainList = new LinkedList<TextResult>();
        for (String strain : talesByStrain.keySet()) {
            String strainn = "null".equals(strain) ? "unknown" : strain;
            byStrainList.add(new TextResult("TALE DNA sequences (" + strainn + ")", "Sequences of all TALEs for strain " + strainn, new FileParameter.FileRepresentation("", ((StringBuffer)talesByStrain.get(strain)).toString()), "fasta", "LoadAndViewClasses", "fasta/dna", true));
        }
        reports.add(new ResultSetResult("TALEs by strain", "The TALE sequences of all strains", null, new ResultSet(byStrainList)));
        LinkedList<ResultSet> taleList = new LinkedList<ResultSet>();
        HashMap<String, String[]> strainMap = new HashMap<String, String[]>();
        LinkedList<ResultSet> strainRes = new LinkedList<ResultSet>();
        int woStrain = 0;
        int i3 = 0;
        while (i3 < tales.length) {
            taleList.add(tales[i3].annotationToResultSet());
            String strain = tales[i3].getStrain();
            if (strain != null) {
                String acc = tales[i3].getAccession();
                if (acc == null) {
                    acc = "";
                }
                if (strainMap.containsKey(acc)) {
                    String[] cont = (String[])strainMap.get(acc);
                    if (!cont[1].equals(acc)) {
                        strainRes.add(new ResultSet(new Result[][]{{new CategoricalResult("Strain", "", strain), new CategoricalResult("Accession", "", acc)}}));
                    }
                } else {
                    strainRes.add(new ResultSet(new Result[][]{{new CategoricalResult("Strain", "", strain), new CategoricalResult("Accession", "", acc)}}));
                    strainMap.put(acc, new String[]{strain, acc});
                }
            } else {
                ++woStrain;
            }
            ++i3;
        }
        if (woStrain > 0) {
            strainRes.add(new ResultSet(new Result[][]{{new CategoricalResult("Strain", "", "No strain annotation"), new CategoricalResult("Accession", "", String.valueOf(woStrain) + " TALEs")}}));
        }
        ListResult lr = new ListResult("List of TALEs", "The list of all TALEs in the class builder", null, taleList.toArray(new ResultSet[0]));
        reports.add(lr);
        ListResult lr2 = new ListResult("List of strains", "The list of all strains in the class builder", null, strainRes.toArray(new ResultSet[0]));
        reports.add(lr2);
        StringBuffer familyReport = new StringBuffer();
        int i4 = 0;
        while (i4 < fams.length) {
            familyReport.append(((TALEFamilyBuilder.TALEFamily)fams[i4]).toString(model, builder));
            familyReport.append("\n\n#####################################################\n\n");
            ++i4;
        }
        reports.add(new TextResult("List of classes", "The list of all TALEs classes and corresponding distance trees", new FileParameter.FileRepresentation("", familyReport.toString()), "txt", "LoadAndViewClasses", "txt", true));
        ResultSet repSet = new ResultSet(new Result[][]{reports.toArray(new Result[0])});
        ress.add(new ResultSetResult("Lists of classes, strains and TALEs", "Details on the classes, strains and TALEs in the current class builder", null, repSet));
        ress.add(new PlotGeneratorResult("Tree of classes", "The tree of class similarities", new FamilyGroupPlotter.FamilyGroupPlotGenerator(famTree), true));
        LinkedList<PlotGeneratorResult> classTrees = new LinkedList<PlotGeneratorResult>();
        protocol.append("Creating class plots for...\n");
        int i5 = 0;
        while (i5 < fams.length) {
            protocol.append(String.valueOf(((TALEFamilyBuilder.TALEFamily)fams[i5]).getFamilyId()) + "\n");
            PlotGeneratorResult pgr = new PlotGeneratorResult("Class " + ((TALEFamilyBuilder.TALEFamily)fams[i5]).getFamilyId(), "Plot of the tree of the TALEs in this class", (PlotGeneratorResult.PlotGenerator)fams[i5], true);
            classTrees.add(pgr);
            progress.setCurrent(1.0 + (double)i5 / (double)fams.length);
            ++i5;
        }
        ress.add(new ResultSetResult("Class trees", "Trees of all TALE classes", null, new ResultSet(classTrees)));
        ResultSet set = new ResultSet(new Result[][]{ress.toArray(new Result[0])});
        return new ToolResult("Result of " + this.getToolName(), "", null, set, parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "Load and View TALE Classes";
    }

    @Override
    public String getShortName() {
        return "loadAndView";
    }

    @Override
    public String getDescription() {
        return "Downloads and displays current TALE class definition";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(LoadAndViewClassesTool.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/tools/LoadAndViewClassesTool.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getToolVersion() {
        return "1.4.1";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

