/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes.tools;

import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.cost.SimpleCosts;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.tools.ClassBuilderTool;
import projects.xanthogenomes.tools.TALEAnalysisTool;

public class TALEComparisonTool
implements JstacsTool {
    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter tales = new FileParameter("TALE sequences", "TALE sequences, either as complete DNA or AS sequences (e.g., output of TALE Prediction).", "fasta,fa,fas", true);
        return new ToolParameterSet(this.getShortName(), tales);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        TALE[] input = ClassBuilderTool.readProteinTALEs(((FileParameter)parameters.getParameterAt(0)).getFileContents(), protocol);
        TALE[] tales = null;
        tales = input.length == 1 ? new TALE[]{input[0], input[0]} : input;
        LinkedList<PlotGeneratorResult> ress = new LinkedList<PlotGeneratorResult>();
        int i = 0;
        while (i < tales.length) {
            int j = 0;
            while (j <= i) {
                TALE tal1 = tales[i];
                TALE tal2 = tales[j];
                PlotGeneratorResult pgr = this.compareTALEs(tal1, tal2);
                ress.add(pgr);
                ++j;
            }
            ++i;
        }
        ResultSet set = new ResultSet(new Result[][]{ress.toArray(new Result[0])});
        return new ToolResult("Result of " + this.getToolName(), String.valueOf(this.getToolName()) + " on \"" + ((FileParameter)parameters.getParameterAt(0)).getFileContents().getFilename() + "\"", null, set, parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    private PlotGeneratorResult compareTALEs(TALE tal1, TALE tal2) {
        Alignment al = new Alignment(new SimpleCosts(0.0, 1.0, 1.0));
        TALE to1 = tal1;
        TALE to2 = tal2;
        if (tal1.getDnaOriginal() != null && tal2.getDnaOriginal() != null) {
            tal1 = tal1.getDnaOriginal();
            tal2 = tal2.getDnaOriginal();
        }
        double[][] dist = new double[tal1.getNumberOfRepeats()][tal2.getNumberOfRepeats()];
        int i = 0;
        while (i < dist.length) {
            int j = 0;
            while (j < dist[i].length) {
                TALE.Repeat r1 = tal1.getRepeat(i);
                TALE.Repeat r2 = tal2.getRepeat(j);
                Sequence s1 = r1.getRepeat();
                Sequence s2 = r2.getRepeat();
                dist[i][j] = al.getAlignment(Alignment.AlignmentType.GLOBAL, s1, s2).getCost();
                ++j;
            }
            ++i;
        }
        RepeatPlotGenerator gen = new RepeatPlotGenerator(to1, to2, dist);
        return new PlotGeneratorResult("Repeat difference of " + tal1.getId() + (tal1.getId().equals(tal2.getId()) ? "" : " and " + tal2.getId()), "Pairwise edit distance of TALE repeats", gen, true);
    }

    @Override
    public String getToolName() {
        return "TALE Repeat Differences";
    }

    @Override
    public String getToolVersion() {
        return "1.0";
    }

    @Override
    public String getShortName() {
        return "repdiff";
    }

    @Override
    public String getDescription() {
        return "Compares TALE repeats on the level of DNA or AA sequences";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(TALEAnalysisTool.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/tools/TALEComparisonTool.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return new String[]{"@article{grau16annotale,\n\ttitle = {{AnnoTALE}: bioinformatics tools for identification, annotation, and nomenclature of {TALEs} from \\emph{Xanthomonas} genomic sequences},\n\tauthor = {Grau, Jan and Reschke, Maik and Erkes, Annett and Streubel, Jana and Morgan, Richard D. and Wilson, Geoffrey G. and Koebnik, Ralf and Boch, Jens},\n\tjournal = {Scientific Reports},\n\tyear = {2016},\n\tvolume = {6},\n\tpages = {21077},\n\tdoi = {10.1038/srep21077}\n\t}\n", "@article{erkes17evolution,\n\ttitle = {Evolution of Transcription Activator-Like Effectors in \\emph{Xanthomonas oryzae}},\n\tauthor = {Erkes, Annett and Reschke, Maik and Boch, Jens and Grau, Jan},\n\tjournal = {Genome Biology and Evolution},\n\tyear = {2017},\n\tvolume = {9},\n\tnumber = {6},\n\tpages = {1599-1615},\n\tdoi = {10.1093/gbe/evx108}\n\t}\n"};
    }

    private static class RepeatPlotGenerator
    implements PlotGeneratorResult.PlotGenerator {
        private TALE t1;
        private TALE t2;
        double[][] dist;

        public RepeatPlotGenerator(StringBuffer xml) throws NonParsableException {
            xml = XMLParser.extractForTag(xml, "RPG");
            this.t1 = (TALE)XMLParser.extractObjectForTags(xml, "t1");
            this.t2 = (TALE)XMLParser.extractObjectForTags(xml, "t2");
            this.dist = (double[][])XMLParser.extractObjectForTags(xml, "dist");
        }

        public RepeatPlotGenerator(TALE t1, TALE t2, double[][] dist) {
            this.t1 = t1;
            this.t2 = t2;
            this.dist = dist;
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.t1, "t1");
            XMLParser.appendObjectWithTags(xml, this.t2, "t2");
            XMLParser.appendObjectWithTags(xml, this.dist, "dist");
            XMLParser.addTags(xml, "RPG");
            return xml;
        }

        @Override
        public void generatePlot(GraphicsAdaptor ga) throws Exception {
            Rectangle2D dim;
            int j;
            int margMain = 130;
            int margLeft = 70;
            int margTop = 70;
            int repHeight = 30;
            int height = margMain + margTop + (this.t1.getNumberOfRepeats() + 1) * repHeight;
            int width = margLeft + (this.t2.getNumberOfRepeats() + 1) * repHeight;
            Graphics2D g = ga.getGraphics(width, height);
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            g.setColor(Color.BLACK);
            int offx = margLeft;
            int offy = margMain + margTop;
            double maxDist = this.dist[this.dist.length - 1][this.dist[this.dist.length - 1].length - 1];
            int i = 0;
            while (i < this.dist.length - 1) {
                j = 0;
                while (j < this.dist[i].length - 1) {
                    if (this.dist[i][j] > maxDist) {
                        maxDist = this.dist[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.dist.length) {
                j = 0;
                while (j < this.dist[i].length) {
                    Color c;
                    if (i < this.dist.length - 1 && j < this.dist[i].length - 1 || i == this.dist.length - 1 && j == this.dist[i].length - 1) {
                        c = Color.WHITE;
                        if (this.dist[i][j] > 0.0) {
                            float mix = (float)(this.dist[i][j] / maxDist);
                            c = new Color((float)Color.YELLOW.getRed() / 255.0f * (1.0f - mix) + 1.0f * mix, (float)Color.YELLOW.getGreen() / 255.0f * (1.0f - mix), (float)Color.YELLOW.getBlue() / 255.0f * (1.0f - mix));
                        }
                        g.setColor(c);
                        g.fillRect(offx + j * repHeight, offy + i * repHeight, repHeight, repHeight);
                        g.setColor(Color.BLACK);
                    } else {
                        c = new Color(0.9f, 0.9f, 0.9f);
                        g.setColor(c);
                        g.fillRect(offx + j * repHeight, offy + i * repHeight, repHeight, repHeight);
                        g.setColor(Color.BLACK);
                    }
                    ++j;
                }
                ++i;
            }
            g.setFont(new Font("SansSerif", 0, repHeight / 2));
            i = 0;
            while (i < this.t1.getNumberOfRepeats()) {
                String str = String.valueOf(i + 1);
                dim = g.getFontMetrics().getStringBounds(str, g);
                int x = margLeft - margLeft / 10 - (int)dim.getWidth();
                int y = offy + i * repHeight + repHeight - (repHeight - (int)dim.getHeight()) / 2;
                g.drawString(str, x, y);
                str = this.t1.getRepeat(i).getRvd();
                if (i < this.t1.getNumberOfRepeats() - 1) {
                    if (this.t1.getRepeat(i).getType() == TALE.Type.LONG) {
                        g.setColor(Color.RED);
                    } else if (this.t1.getRepeat(i).getType() == TALE.Type.SHORT) {
                        g.setColor(Color.GREEN);
                    } else if (this.t1.getRepeat(i).getType() == TALE.Type.THIRTYFIVE) {
                        g.setColor(Color.GRAY);
                    }
                }
                dim = g.getFontMetrics().getStringBounds(str, g);
                x = margLeft - margLeft / 2 - (int)dim.getWidth();
                y = offy + i * repHeight + repHeight - (repHeight - (int)dim.getHeight()) / 2;
                g.drawString(str, x, y);
                g.setColor(Color.BLACK);
                ++i;
            }
            i = 0;
            while (i < this.t2.getNumberOfRepeats()) {
                String str = String.valueOf(i + 1);
                dim = g.getFontMetrics().getStringBounds(str, g);
                g.drawString(str, offx + i * repHeight + (repHeight - (int)dim.getWidth()) / 2, margMain + margTop - margTop / 10);
                str = this.t2.getRepeat(i).getRvd();
                if (i < this.t2.getNumberOfRepeats() - 1) {
                    if (this.t2.getRepeat(i).getType() == TALE.Type.LONG) {
                        g.setColor(Color.RED);
                    } else if (this.t2.getRepeat(i).getType() == TALE.Type.SHORT) {
                        g.setColor(Color.GREEN);
                    } else if (this.t2.getRepeat(i).getType() == TALE.Type.THIRTYFIVE) {
                        g.setColor(Color.GRAY);
                    }
                }
                dim = g.getFontMetrics().getStringBounds(str, g);
                g.drawString(str, offx + i * repHeight + (repHeight - (int)dim.getWidth()) / 2, margMain + margTop - margTop / 2);
                g.setColor(Color.BLACK);
                ++i;
            }
            String[] temp = null;
            temp = this.t1.getId().equals(this.t2.getId()) ? new String[]{"Difference of repeats of", this.t1.getId()} : new String[]{"Difference of repeats of", String.valueOf(this.t1.getId()) + " and", this.t2.getId()};
            double sumHeight = 0.0;
            double maxWidth = 0.0;
            int i2 = 0;
            while (i2 < temp.length) {
                Rectangle2D dim2 = g.getFontMetrics().getStringBounds(temp[i2], g);
                if (dim2.getWidth() > maxWidth) {
                    maxWidth = dim2.getWidth();
                }
                sumHeight += dim2.getHeight() * 1.5;
                ++i2;
            }
            int step = (int)((double)(margMain - repHeight) / maxDist);
            int i3 = 1;
            while ((double)i3 < maxDist) {
                float mix = (float)((double)i3 / maxDist);
                Color c = new Color((float)Color.YELLOW.getRed() / 255.0f * (1.0f - mix) + 1.0f * mix, (float)Color.YELLOW.getGreen() / 255.0f * (1.0f - mix), (float)Color.YELLOW.getBlue() / 255.0f * (1.0f - mix));
                g.setColor(c);
                g.fillRect(margLeft, repHeight / 2 + (int)((maxDist - (double)i3 - 1.0) * (double)step), repHeight, step);
                g.setColor(Color.BLACK);
                ++i3;
            }
            g.drawLine((int)((double)margLeft * 0.9), repHeight / 2 + step / 2, margLeft - 1, repHeight / 2 + step / 2);
            Rectangle2D dim3 = g.getFontMetrics().getStringBounds(String.valueOf((int)maxDist), g);
            g.drawString(String.valueOf((int)maxDist), (int)((double)margLeft * 0.8 - dim3.getWidth()), (int)((double)(repHeight / 2 + step / 2) + dim3.getHeight() / 2.0));
            g.drawLine((int)((double)margLeft * 0.9), (int)((double)(repHeight / 2) + maxDist * (double)step - (double)(step / 2)), margLeft - 1, (int)((double)(repHeight / 2) + maxDist * (double)step - (double)(step / 2)));
            dim3 = g.getFontMetrics().getStringBounds("0", g);
            g.drawString("0", (int)((double)margLeft * 0.8 - dim3.getWidth()), (int)((double)(repHeight / 2) + maxDist * (double)step - (double)(step / 2) + dim3.getHeight() / 2.0));
            g.drawLine(margLeft - 1, repHeight / 2 + step / 2, margLeft - 1, (int)((double)(repHeight / 2) + maxDist * (double)step - (double)(step / 2)));
            double scaleHeight = (double)margMain / sumHeight;
            double scaleWidth = (double)(width - margLeft - 2 * repHeight) / maxWidth;
            double scale = Math.min(2.0, Math.min(scaleHeight, scaleWidth));
            g.setFont(new Font("SansSerif", 0, (int)((double)g.getFont().getSize() * scale)));
            int i4 = 0;
            while (i4 < temp.length) {
                dim3 = g.getFontMetrics().getStringBounds(temp[i4], g);
                g.drawString(temp[i4], (float)(margLeft + repHeight) + (float)((double)width - dim3.getWidth() - (double)margLeft - (double)(2 * repHeight)) / 2.0f, (float)(sumHeight * scale * 0.9 / (double)temp.length * (double)(i4 + 1)));
                ++i4;
            }
        }
    }
}

