/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import umontreal.iro.lecuyer.charts.Axis;
import umontreal.iro.lecuyer.charts.SSJXYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleDatasetChart {
    protected ArrayList<SSJXYSeriesCollection> datasetList;
    protected Axis XAxis;
    protected Axis YAxis;
    protected JFreeChart chart;
    protected boolean latexDocFlag = true;
    protected boolean autoRange = true;
    protected double[] manualRange;
    protected boolean grid = false;
    protected double xstepGrid;
    protected double ystepGrid;

    public MultipleDatasetChart() {
        this.chart = ChartFactory.createXYLineChart((String)" ", (String)" ", (String)" ", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.datasetList = new ArrayList();
        this.XAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getDomainAxis(), true);
        this.YAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getRangeAxis(), false);
    }

    public MultipleDatasetChart(String title, String XLabel, String YLabel) {
        this.chart = ChartFactory.createXYLineChart((String)title, (String)XLabel, (String)YLabel, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.datasetList = new ArrayList();
        this.XAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getDomainAxis(), true);
        this.YAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getRangeAxis(), false);
    }

    public JFreeChart getJFreeChart() {
        return this.chart;
    }

    public Axis getXAxis() {
        return this.XAxis;
    }

    public Axis getYAxis() {
        return this.YAxis;
    }

    public String getTitle() {
        return this.chart.getTitle().getText();
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void setAutoRange() {
        int i;
        this.autoRange = true;
        double[][] temp = new double[2][this.datasetList.size()];
        for (i = 0; i < this.datasetList.size(); ++i) {
            temp[0][i] = this.datasetList.get(i).getDomainBounds()[0];
            temp[1][i] = this.datasetList.get(i).getDomainBounds()[1];
        }
        this.XAxis.getAxis().setLowerBound(MultipleDatasetChart.min(temp[0]));
        this.XAxis.getAxis().setUpperBound(MultipleDatasetChart.max(temp[1]));
        for (i = 0; i < this.datasetList.size(); ++i) {
            temp[0][i] = this.datasetList.get(i).getRangeBounds()[0];
            temp[1][i] = this.datasetList.get(i).getRangeBounds()[1];
        }
        this.YAxis.getAxis().setLowerBound(MultipleDatasetChart.min(temp[0]));
        this.YAxis.getAxis().setUpperBound(MultipleDatasetChart.max(temp[1]));
    }

    public void setManualRange(double[] axisRange) {
        if (axisRange.length != 4) {
            throw new IllegalArgumentException("axisRange must share the format: [xmin, xmax, ymin, ymax]");
        }
        this.autoRange = false;
        this.XAxis.getAxis().setLowerBound(axisRange[0]);
        this.XAxis.getAxis().setUpperBound(axisRange[1]);
        this.YAxis.getAxis().setLowerBound(axisRange[2]);
        this.YAxis.getAxis().setUpperBound(axisRange[3]);
    }

    public int add(SSJXYSeriesCollection dataset) {
        ((XYPlot)this.chart.getPlot()).setDataset(this.datasetList.size(), dataset.getSeriesCollection());
        ((XYPlot)this.chart.getPlot()).setRenderer(this.datasetList.size(), dataset.getRenderer());
        this.datasetList.add(dataset);
        if (this.datasetList.size() == 1) {
            this.XAxis.setLabelsAuto();
            this.YAxis.setLabelsAuto();
        }
        return this.datasetList.size() - 1;
    }

    public SSJXYSeriesCollection get() {
        return this.datasetList.get(0);
    }

    public void set(SSJXYSeriesCollection dataset) {
        ((XYPlot)this.chart.getPlot()).setDataset(dataset.getSeriesCollection());
        ((XYPlot)this.chart.getPlot()).setRenderer(dataset.getRenderer());
        this.datasetList.set(0, dataset);
    }

    public SSJXYSeriesCollection get(int datasetNum) {
        return this.datasetList.get(datasetNum);
    }

    public void set(int datasetNum, SSJXYSeriesCollection dataset) {
        ((XYPlot)this.chart.getPlot()).setDataset(datasetNum, dataset.getSeriesCollection());
        ((XYPlot)this.chart.getPlot()).setRenderer(datasetNum, dataset.getRenderer());
        this.datasetList.add(datasetNum, dataset);
    }

    public ArrayList<SSJXYSeriesCollection> getList() {
        return this.datasetList;
    }

    public JFrame view(int width, int height) {
        JFrame myFrame = this.chart.getTitle() != null ? new JFrame("MultipleDatasetChart from SSJ : " + this.chart.getTitle().getText()) : new JFrame("MultipleDatasetChart from SSJ");
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(width, height));
        myFrame.setContentPane((Container)chartPanel);
        myFrame.pack();
        myFrame.setDefaultCloseOperation(2);
        myFrame.setLocationRelativeTo(null);
        myFrame.setVisible(true);
        return myFrame;
    }

    public void enableGrid(double xstep, double ystep) {
        this.grid = true;
        this.xstepGrid = xstep;
        this.ystepGrid = ystep;
    }

    public void disableGrid() {
        this.grid = false;
    }

    public String toLatex(double width, double height) {
        double[] save = new double[4];
        if (this.datasetList.size() == 0) {
            throw new IllegalArgumentException("Empty chart");
        }
        double XScale = this.computeXScale(this.XAxis.getTwinAxisPosition());
        double YScale = this.computeYScale(this.YAxis.getTwinAxisPosition());
        double xunit = width / (Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition()) * XScale - Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition()) * XScale);
        double yunit = height / (Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition()) * YScale - Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition()) * YScale);
        Formatter formatter = new Formatter(Locale.US);
        if (this.latexDocFlag) {
            formatter.format("\\documentclass[twoside,12pt]{article}%n%n", new Object[0]);
            formatter.format("\\usepackage{tikz}%n\\usepackage{pgflibraryplotmarks}%n\\begin{document}%n%n", new Object[0]);
        }
        if (this.chart.getTitle() != null) {
            formatter.format("%% PGF/TikZ picture from SSJ : %s%n", this.chart.getTitle().getText());
        } else {
            formatter.format("%% PGF/TikZ picture from SSJ %n", new Object[0]);
        }
        formatter.format("%% XScale = %s,  YScale = %s,  XShift = %s,  YShift = %s%n", XScale, YScale, this.XAxis.getTwinAxisPosition(), this.YAxis.getTwinAxisPosition());
        formatter.format("%% Therefore, thisFileXValue = (originalSeriesXValue+XShift)*XScale%n", new Object[0]);
        formatter.format("%%        and thisFileYValue = (originalSeriesYValue+YShift)*YScale%n%n", new Object[0]);
        formatter.format("\\begin{center}%n", new Object[0]);
        formatter.format("\\begin{tikzpicture}[x=%scm, y=%scm]%n", xunit, yunit);
        formatter.format("\\footnotesize%n", new Object[0]);
        if (this.grid) {
            formatter.format("\\draw[color=lightgray] (%s, %s) grid[xstep = %s, ystep=%s] (%s, %s);%n", (Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition()) - this.XAxis.getTwinAxisPosition()) * XScale, (Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition()) - this.YAxis.getTwinAxisPosition()) * YScale, this.xstepGrid * XScale, this.ystepGrid * YScale, (Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition()) - this.XAxis.getTwinAxisPosition()) * XScale, (Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition()) - this.YAxis.getTwinAxisPosition()) * YScale);
        }
        formatter.format("%s", this.XAxis.toLatex(XScale));
        formatter.format("%s", this.YAxis.toLatex(YScale));
        for (int i = 0; i < this.datasetList.size(); ++i) {
            formatter.format("%s", this.datasetList.get(i).toLatex(XScale, YScale, this.XAxis.getTwinAxisPosition(), this.YAxis.getTwinAxisPosition(), this.XAxis.getAxis().getLowerBound(), this.XAxis.getAxis().getUpperBound(), this.YAxis.getAxis().getLowerBound(), this.YAxis.getAxis().getUpperBound()));
        }
        formatter.format("\\end{tikzpicture}%n", new Object[0]);
        formatter.format("\\end{center}%n", new Object[0]);
        if (this.latexDocFlag) {
            formatter.format("\\end{document}%n", new Object[0]);
        }
        return formatter.toString();
    }

    public void setLatexDocFlag(boolean flag) {
        this.latexDocFlag = flag;
    }

    protected double computeXScale(double position) {
        double[] bounds = new double[]{this.XAxis.getAxis().getLowerBound(), this.XAxis.getAxis().getUpperBound()};
        if (position < bounds[0]) {
            bounds[0] = position;
        }
        if (position > bounds[1]) {
            bounds[1] = position;
        }
        bounds[0] = bounds[0] - position;
        bounds[1] = bounds[1] - position;
        return this.computeScale(bounds);
    }

    protected double computeYScale(double position) {
        double[] bounds = new double[]{this.YAxis.getAxis().getLowerBound(), this.YAxis.getAxis().getUpperBound()};
        if (position < bounds[0]) {
            bounds[0] = position;
        }
        if (position > bounds[1]) {
            bounds[1] = position;
        }
        bounds[0] = bounds[0] - position;
        bounds[1] = bounds[1] - position;
        return this.computeScale(bounds);
    }

    protected double computeScale(double[] bounds) {
        int tenPowerRatio = 0;
        while (bounds[1] > 1000.0 || bounds[0] < -1000.0) {
            bounds[1] = bounds[1] / 10.0;
            bounds[0] = bounds[0] / 10.0;
            ++tenPowerRatio;
        }
        while (bounds[1] < 100.0 && bounds[0] > -100.0) {
            bounds[1] = bounds[1] * 10.0;
            bounds[0] = bounds[0] * 10.0;
            --tenPowerRatio;
        }
        return 1.0 / Math.pow(10.0, tenPowerRatio);
    }

    private static double max(double[] t) {
        double aux = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (!(t[i] > aux)) continue;
            aux = t[i];
        }
        return aux;
    }

    private static double min(double[] t) {
        double aux = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (!(t[i] < aux)) continue;
            aux = t[i];
        }
        return aux;
    }
}

