/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.ExtremeValueDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ExtremeValueGen
extends RandomVariateGen {
    protected double alpha = -1.0;
    protected double lambda = -1.0;

    public ExtremeValueGen(RandomStream s, double alpha, double lambda) {
        super(s, new ExtremeValueDist(alpha, lambda));
        this.setParams(alpha, lambda);
    }

    public ExtremeValueGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public ExtremeValueGen(RandomStream s, ExtremeValueDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getLambda());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double lambda) {
        return ExtremeValueDist.inverseF(alpha, lambda, s.nextDouble());
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.lambda = lambda;
        this.alpha = alpha;
    }
}

