/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.hierachical;

import de.jstacs.Storable;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import java.util.Arrays;
import java.util.LinkedList;

public class ClusterTree<T>
implements Storable {
    private double distance;
    private T[] elements;
    private ClusterTree<T>[] subTrees;
    private int originalIndex;
    private int[][][] pred;

    public ClusterTree(T leaf, int originalIndex) {
        this.elements = ArrayHandler.cast(new Object[]{leaf});
        this.distance = Double.NEGATIVE_INFINITY;
        this.originalIndex = originalIndex;
    }

    public ClusterTree(double distance, int originalIndex, ClusterTree<T> ... subTrees) {
        this.distance = distance;
        this.subTrees = (ClusterTree[])subTrees.clone();
        this.originalIndex = originalIndex;
        this.setElements();
    }

    public ClusterTree(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "ClusterTree");
        this.originalIndex = XMLParser.extractObjectForTags(xml, "originalIndex", Integer.class);
        this.distance = (Double)XMLParser.extractObjectForTags(xml, "distance");
        this.subTrees = (ClusterTree[])XMLParser.extractObjectForTags(xml, "subTrees");
        if (this.subTrees == null) {
            this.elements = (Object[])XMLParser.extractObjectForTags(xml, "elements");
        } else {
            this.setElements();
        }
    }

    public ClusterTree<Integer> getIndexTree() {
        if (this.subTrees == null) {
            return new ClusterTree<Integer>(this.originalIndex, this.originalIndex);
        }
        ClusterTree[] newSubs = new ClusterTree[this.subTrees.length];
        int i = 0;
        while (i < this.subTrees.length) {
            newSubs[i] = this.subTrees[i].getIndexTree();
            ++i;
        }
        return new ClusterTree<Integer>(this.distance, this.originalIndex, newSubs);
    }

    public void leafOrder(double[][] dmat) {
        Pair<double[][], int[]> pair = this.forward(dmat);
        double[][] M = pair.getFirstElement();
        double min = Double.POSITIVE_INFINITY;
        int mini = -1;
        int minj = -1;
        int i = 0;
        while (i < M.length) {
            int j = 0;
            while (j < M[i].length) {
                if (M[i][j] < min) {
                    min = M[i][j];
                    mini = i;
                    minj = j;
                }
                ++j;
            }
            ++i;
        }
        this.backtrace(mini, minj);
    }

    private boolean backtrace(int mini, int minj) {
        if (this.pred == null) {
            return false;
        }
        int predLeft = this.pred[0][mini][minj];
        int predRight = this.pred[1][mini][minj];
        boolean turn = mini > minj;
        int oneoff = this.subTrees[0].getNumberOfElements();
        if (turn) {
            int temp = mini -= oneoff;
            mini = predRight;
            predRight = temp;
            temp = minj;
            minj = predLeft;
            predLeft = temp;
        } else {
            minj -= oneoff;
        }
        boolean turnedLeft = super.backtrace(mini, predLeft);
        boolean turnedRight = super.backtrace(predRight, minj);
        if (turn) {
            this.reverseOrder();
        } else if (turnedLeft || turnedRight) {
            this.setElements();
        }
        this.pred = null;
        return turn || turnedLeft || turnedRight;
    }

    private Pair<double[][], int[]> forward(double[][] dmat) {
        if (this.subTrees == null) {
            this.pred = null;
            return new Pair<double[][], int[]>(new double[][]{{0.0}}, new int[]{this.originalIndex});
        }
        Pair<double[][], int[]> pairLeft = super.forward(dmat);
        Pair<double[][], int[]> pairRight = super.forward(dmat);
        double[][] w = pairLeft.getFirstElement();
        double[][] x = pairRight.getFirstElement();
        int[] leftIdx = pairLeft.getSecondElement();
        int[] rightIdx = pairRight.getSecondElement();
        double[][] M = new double[this.getNumberOfElements()][this.getNumberOfElements()];
        this.pred = new int[2][M.length][M.length];
        int i = 0;
        while (i < M.length) {
            Arrays.fill(M[i], Double.POSITIVE_INFINITY);
            Arrays.fill(this.pred[0][i], -1);
            Arrays.fill(this.pred[1][i], -1);
            ++i;
        }
        int[] origIdx = new int[M.length];
        System.arraycopy(leftIdx, 0, origIdx, 0, leftIdx.length);
        System.arraycopy(rightIdx, 0, origIdx, leftIdx.length, rightIdx.length);
        int oneoff = this.subTrees[0].getNumberOfElements();
        int i2 = 0;
        while (i2 < w.length) {
            double temp;
            double[] tempil = new double[x.length];
            int[] minil = new int[x.length];
            int l = 0;
            while (l < tempil.length) {
                tempil[l] = Double.POSITIVE_INFINITY;
                int h = 0;
                while (h < w[i2].length) {
                    temp = w[i2][h] + dmat[Math.max(leftIdx[h], rightIdx[l])][Math.min(leftIdx[h], rightIdx[l])];
                    if (temp < tempil[l]) {
                        tempil[l] = temp;
                        minil[l] = h;
                    }
                    ++h;
                }
                ++l;
            }
            l = 0;
            while (l < x.length) {
                int j = 0;
                while (j < x[l].length) {
                    temp = tempil[l] + x[l][j];
                    if (temp < M[i2][oneoff + j]) {
                        M[i2][oneoff + j] = temp;
                        M[oneoff + j][i2] = temp;
                        this.pred[0][i2][oneoff + j] = minil[l];
                        this.pred[1][i2][oneoff + j] = l;
                        this.pred[0][oneoff + j][i2] = l;
                        this.pred[1][oneoff + j][i2] = minil[l];
                    }
                    ++j;
                }
                ++l;
            }
            ++i2;
        }
        return new Pair<double[][], int[]>(M, origIdx);
    }

    public int getOriginalIndex() {
        return this.originalIndex;
    }

    public void reverseOrder() {
        if (this.subTrees == null || this.subTrees.length == 1) {
            return;
        }
        ClusterTree[] temp = new ClusterTree[this.subTrees.length];
        int i = 0;
        while (i < this.subTrees.length) {
            temp[i] = this.subTrees[this.subTrees.length - 1 - i];
            ++i;
        }
        this.subTrees = temp;
        this.setElements();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.originalIndex, "originalIndex");
        XMLParser.appendObjectWithTags(sb, this.distance, "distance");
        XMLParser.appendObjectWithTags(sb, this.subTrees, "subTrees");
        if (this.subTrees == null) {
            XMLParser.appendObjectWithTags(sb, this.elements, "elements");
        }
        XMLParser.addTags(sb, "ClusterTree");
        return sb;
    }

    public void setElements() {
        int num = 0;
        int i = 0;
        while (i < this.subTrees.length) {
            num += this.subTrees[i].elements.length;
            ++i;
        }
        Object[] elements = new Object[num];
        int i2 = 0;
        int k = 0;
        while (i2 < this.subTrees.length) {
            int j = 0;
            while (j < this.subTrees[i2].elements.length) {
                elements[k] = this.subTrees[i2].elements[j];
                ++j;
                ++k;
            }
            ++i2;
        }
        this.elements = ArrayHandler.cast(elements);
    }

    public ClusterTree<T>[] getSubTrees() {
        return this.subTrees;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getMaximumDistance() {
        return this.distance;
    }

    public double getMinimumDistance() {
        if (this.getNumberOfElements() == 1) {
            return 0.0;
        }
        double min = this.getDistance();
        int i = 0;
        while (i < this.subTrees.length) {
            double temp = this.subTrees[i].getMinimumDistance();
            if (temp < min) {
                min = temp;
            }
            ++i;
        }
        return min;
    }

    public T[] getClusterElements() {
        return this.elements;
    }

    public int getNumberOfElements() {
        return this.elements.length;
    }

    public String toString() {
        if (this.subTrees == null) {
            return Arrays.toString(this.elements);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("dist: " + this.distance + "\n");
        int i = 0;
        while (i < this.subTrees.length) {
            sb.append(String.valueOf(i) + "( [" + this.originalIndex + "]\n");
            sb.append(String.valueOf(this.subTrees[i].toString()) + "\n");
            sb.append(String.valueOf(i) + ")\n");
            ++i;
        }
        return sb.toString();
    }

    public int getMinimumOriginalIndex() {
        if (this.subTrees == null) {
            return this.originalIndex;
        }
        int min = this.originalIndex;
        int i = 0;
        while (i < this.subTrees.length) {
            if (this.subTrees[i].getOriginalIndex() < min) {
                min = this.subTrees[i].getOriginalIndex();
            }
            ++i;
        }
        return min;
    }

    public boolean isLeaf() {
        return this.subTrees == null;
    }

    public ClusterTree<T>[] getLeaves() {
        if (this.subTrees == null) {
            return new ClusterTree[]{this};
        }
        LinkedList<ClusterTree<T>> list = new LinkedList<ClusterTree<T>>();
        int i = 0;
        while (i < this.subTrees.length) {
            ClusterTree<T>[] temp = this.subTrees[i].getLeaves();
            int j = 0;
            while (j < temp.length) {
                list.add(temp[j]);
                ++j;
            }
            ++i;
        }
        return list.toArray(new ClusterTree[0]);
    }

    public <S> ClusterTree<S> dropBelow(IntList rootOriginalIndexes, S[] newElements) {
        int idx = rootOriginalIndexes.contains(this.originalIndex);
        if (idx > -1) {
            S el = newElements[idx];
            return new ClusterTree<S>(el, this.originalIndex);
        }
        ClusterTree[] newSubs = new ClusterTree[this.subTrees.length];
        int i = 0;
        while (i < this.subTrees.length) {
            newSubs[i] = this.subTrees[i].dropBelow(rootOriginalIndexes, newElements);
            ++i;
        }
        return new ClusterTree<T>(this.getDistance(), this.originalIndex, newSubs);
    }

    public String toNewick() {
        return String.valueOf(this.toNewick("")) + ";";
    }

    private String toNewick(String indent) {
        if (this.subTrees == null) {
            return String.valueOf(indent) + this.elements[0].toString();
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.subTrees.length) {
            if (i > 0) {
                sb.append(String.valueOf(indent) + ",");
            }
            sb.append(String.valueOf(indent) + super.toNewick(String.valueOf(indent) + "\t") + ":" + this.distance);
            ++i;
        }
        return String.valueOf(indent) + "(\n" + sb.toString() + indent + "\n)";
    }

    public void setOriginalIndex(int used) {
        this.originalIndex = used;
    }
}

