/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.continuous;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.random.RandomNumberGenerator;
import java.text.NumberFormat;
import umontreal.ssj.util.Num;

public class PoissonDiffSM
extends AbstractDifferentiableStatisticalModel {
    private double llambda;
    private double lambda;
    private double ess;

    public PoissonDiffSM(double ess) throws IllegalArgumentException {
        super(new AlphabetContainer((Alphabet)new ContinuousAlphabet(0.0, 2.147483647E9)), 1);
        this.ess = ess;
        this.lambda = -1.0;
    }

    public PoissonDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public PoissonDiffSM clone() throws CloneNotSupportedException {
        PoissonDiffSM clone = (PoissonDiffSM)super.clone();
        return clone;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return 0.0;
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.initializeFunctionRandomly(freeParams);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        this.llambda = rng.nextGammaLog(1.0, 1.0);
        this.lambda = Math.exp(this.lambda);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double v = seq.continuousVal(start);
        indices.add(0);
        partialDer.add(v - this.lambda);
        return v * this.llambda - Num.lnGamma(v + 1.0) - this.lambda;
    }

    @Override
    public int getNumberOfParameters() {
        return 1;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[]{this.llambda};
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.llambda = params[start];
        this.lambda = Math.exp(this.llambda);
    }

    @Override
    public String getInstanceName() {
        return "Poisson";
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double v = seq.continuousVal(start);
        return v * this.llambda - Num.lnGamma(v + 1.0) - this.lambda;
    }

    @Override
    public boolean isInitialized() {
        return this.lambda >= 0.0;
    }

    @Override
    public String toString(NumberFormat nf) {
        return "Poisson(" + nf.format(this.lambda) + ")";
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.llambda, "llambda");
        XMLParser.appendObjectWithTags(sb, this.ess, "ess");
        XMLParser.addTags(sb, "Poisson");
        return sb;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        this.alphabets = new AlphabetContainer((Alphabet)new ContinuousAlphabet(0.0, Double.MAX_VALUE));
        this.length = 1;
        xml = XMLParser.extractForTag(xml, "Poisson");
        this.llambda = (Double)XMLParser.extractObjectForTags(xml, "llambda");
        this.lambda = Math.exp(this.llambda);
        this.ess = (Double)XMLParser.extractObjectForTags(xml, "ess");
    }
}

