/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures;

import de.jstacs.DataType;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.Measure;

public class InhomogeneousMarkov
extends Measure {
    public InhomogeneousMarkov(int order) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        this(new InhomogeneousMarkovParameterSet(order));
    }

    public InhomogeneousMarkov(InhomogeneousMarkovParameterSet parameters) throws CloneNotSupportedException {
        super(parameters);
    }

    public InhomogeneousMarkov(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    public int getOrder() {
        return ((InhomogeneousMarkovParameterSet)this.parameters).getOrder();
    }

    @Override
    public InhomogeneousMarkov clone() throws CloneNotSupportedException {
        return (InhomogeneousMarkov)super.clone();
    }

    @Override
    public String getInstanceName() {
        return "Inhomogeneous Markov model of order " + this.getOrder();
    }

    @Override
    public int[][] getParents(DataSet fg, DataSet bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        int[][] parents = new int[length][];
        int order = this.getOrder();
        int i = 0;
        while (i < parents.length) {
            parents[i] = new int[(order < i ? order : i) + 1];
            int j = i;
            while (j >= i - order && j >= 0) {
                parents[i][parents[i].length - (i - j) - 1] = j;
                --j;
            }
            ++i;
        }
        return parents;
    }

    @Override
    public boolean isShiftable() {
        return true;
    }

    @Override
    public String getXMLTag() {
        return "inhomogeneousMarkov";
    }

    public static class InhomogeneousMarkovParameterSet
    extends Measure.MeasureParameterSet {
        public InhomogeneousMarkovParameterSet() {
            super((Class<? extends Measure>)InhomogeneousMarkov.class);
            try {
                this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Order", "The order of the Markov model.", true)});
            }
            catch (SimpleParameter.DatatypeNotValidException doesnothappen) {
                throw new RuntimeException(doesnothappen);
            }
        }

        public InhomogeneousMarkovParameterSet(int order) throws SimpleParameter.IllegalValueException {
            this();
            ((Parameter)this.parameters.get(0)).setValue(order);
        }

        public InhomogeneousMarkovParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        public String getInstanceComment() {
            return "Inhomogeneous Markov model structure";
        }

        @Override
        public String getInstanceName() {
            return "Inhomogeneous Markov model";
        }

        public int getOrder() {
            return (Integer)((Parameter)this.parameters.get(0)).getValue();
        }
    }
}

