/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.ArrayHandler;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.DifferentiableHigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.SimpleState;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.SilentEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.UniformEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.AbstractConditionalDiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.DiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.DiscreteMatchMismatchEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.PhyloDiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.ReferenceSequenceDiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.HMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.MaxHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.NumericalHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.TransitionElement;
import de.jstacs.sequenceScores.statisticalModels.trainable.phylo.PhyloTree;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HMMFactory {
    private static AbstractHMM getHMM(HMMTrainingParameterSet hMMTrainingParameterSet, String[] stringArray, int[] nArray, boolean[] blArray, Emission[] emissionArray, TransitionElement[] transitionElementArray, double d, boolean bl) throws Exception {
        throw new Error("Unresolved compilation problem: \n\tThe constructor DifferentiableHigherOrderHMM(MaxHMMTrainingParameterSet, String[], int[], boolean[], ArrayHandler.cast(DifferentiableEmission.class, emission), boolean, double, TransitionElement[]) is undefined\n");
    }

    private static void addTransitions(int[] states, double ess, double selfTranistionPart, int o, AbstractList<TransitionElement> list) {
        int[] context = new int[o];
        SequenceIterator it = new SequenceIterator(o);
        Arrays.fill(context, states.length);
        it.setBounds(context);
        double[] hyperParams = new double[states.length];
        double e = ess * (1.0 - selfTranistionPart) / (double)(states.length - 1);
        Arrays.fill(hyperParams, e);
        do {
            int i = 0;
            while (i < context.length) {
                context[i] = it.discreteValAt(i);
                ++i;
            }
            hyperParams[context[o - 1]] = ess * selfTranistionPart;
            list.add(new TransitionElement(context, states, hyperParams));
            hyperParams[context[o - 1]] = e;
        } while (it.next());
    }

    public static AbstractHMM createErgodicHMM(HMMTrainingParameterSet pars, int order, double ess, double selfTranistionPart, double expectedSequenceLength, Emission ... emission) throws Exception {
        int n = emission.length;
        String[] name = new String[n];
        int[] states = new int[n];
        int i = 0;
        while (i < n) {
            name[i] = "" + i;
            states[i] = i;
            if (emission[i] instanceof SilentEmission) {
                throw new IllegalArgumentException("An ergodic HMM can not contain silent states.");
            }
            ++i;
        }
        double[] hyperParams = new double[n];
        LinkedList<TransitionElement> list = new LinkedList<TransitionElement>();
        double e = ess / (double)n;
        Arrays.fill(hyperParams, e);
        list.add(new TransitionElement(null, states, hyperParams));
        int o = 1;
        while (o < order) {
            HMMFactory.addTransitions(states, e, selfTranistionPart, o, list);
            e /= (double)n;
            ++o;
        }
        HMMFactory.addTransitions(states, ess * (expectedSequenceLength - (double)order), selfTranistionPart, order, list);
        return HMMFactory.getHMM(pars, name, null, null, emission, list.toArray(new TransitionElement[0]), ess, true);
    }

    public static AbstractHMM createPseudoErgodicHMM(HMMTrainingParameterSet pars, double ess, double selfTranistionPart, double finalTranistionPart, AlphabetContainer con, int numStates, boolean insertUniform) throws Exception {
        Emission[] emission = new Emission[numStates + 1];
        String[] name = new String[numStates + 1];
        ArrayList<PseudoTransitionElement> list = new ArrayList<PseudoTransitionElement>();
        int[] states = new int[numStates];
        int i = 0;
        while (i < states.length) {
            states[i] = i;
            ++i;
        }
        double[] hyperParams = new double[states.length];
        double e = ess / (double)hyperParams.length;
        Arrays.fill(hyperParams, e);
        list.add(new PseudoTransitionElement(null, states, hyperParams));
        states = new int[numStates + 1];
        int i2 = 0;
        while (i2 < states.length) {
            states[i2] = i2;
            ++i2;
        }
        hyperParams = new double[states.length];
        e = (1.0 - selfTranistionPart - finalTranistionPart) * ess / (double)(hyperParams.length - 2);
        Arrays.fill(hyperParams, e);
        hyperParams[numStates] = finalTranistionPart * ess;
        i2 = 0;
        while (i2 < numStates) {
            hyperParams[i2] = selfTranistionPart * ess;
            list.add(new PseudoTransitionElement(new int[]{i2}, states, hyperParams));
            hyperParams[i2] = e;
            ++i2;
        }
        name[numStates] = "F";
        states[numStates] = numStates - 1;
        emission[numStates] = new SilentEmission();
        Pair<double[][], double[]> p = HMMFactory.propagateESS(ess, list);
        double[] stateEss = p.getSecondElement();
        int i3 = 0;
        while (i3 < numStates) {
            name[i3] = "" + i3;
            emission[i3] = insertUniform ? new UniformEmission(con) : new DiscreteEmission(con, stateEss[i3]);
            ++i3;
        }
        return HMMFactory.getHMM(pars, name, null, null, emission, HMMFactory.createTransition(p.getFirstElement(), list), ess, false);
    }

    public static AbstractHMM createSunflowerHMM(HMMTrainingParameterSet pars, AlphabetContainer con, double ess, int expectedSequenceLength, boolean startCentral, int ... motifLength) throws Exception {
        return HMMFactory.createSunflowerHMM(pars, con, ess, expectedSequenceLength, startCentral, null, null, motifLength);
    }

    public static AbstractHMM createSunflowerHMM(HMMTrainingParameterSet pars, AlphabetContainer con, double ess, int expectedSequenceLength, boolean startCentral, PhyloTree[] t, double[] motifProb, int[] motifLength) throws Exception {
        int[] children;
        double[] hyperParams;
        if (motifProb == null) {
            motifProb = new double[motifLength.length];
            Arrays.fill(motifProb, 0.1 / (double)motifLength.length);
        }
        int anz = 1;
        int[] states = new int[1 + motifLength.length];
        int i = 0;
        while (i < motifLength.length) {
            states[1 + i] = anz;
            anz += motifLength[i];
            ++i;
        }
        Emission[] e = t == null ? new Emission[anz] : new PhyloDiscreteEmission[anz];
        String[] name = new String[anz];
        LinkedList<TransitionElement> list = new LinkedList<TransitionElement>();
        double[][] hyperNext = new double[motifLength.length + 1][];
        double self = 0.0;
        int i2 = 0;
        while (i2 < motifLength.length) {
            hyperNext[i2] = new double[motifLength[i2]];
            self += motifProb[i2];
            ++i2;
        }
        self = 1.0 - self;
        hyperNext[motifLength.length] = new double[1];
        double[][] stateESS = (double[][])ArrayHandler.clone((Cloneable[])hyperNext);
        if (startCentral) {
            hyperNext[motifLength.length][0] = ess;
            hyperParams = new double[]{ess};
        } else {
            hyperNext[motifLength.length][0] = ess * self;
            hyperParams = new double[anz];
            hyperParams[0] = hyperNext[motifLength.length][0];
            int i3 = 0;
            while (i3 < motifLength.length) {
                Arrays.fill(hyperNext[i3], motifProb[i3] * ess / (double)hyperNext[i3].length);
                Arrays.fill(hyperParams, states[1 + i3], states[1 + i3] + motifLength[i3], hyperNext[i3][0]);
                ++i3;
            }
        }
        if (startCentral) {
            children = new int[1];
        } else {
            children = new int[anz];
            int i4 = 0;
            while (i4 < anz) {
                children[i4] = i4;
                ++i4;
            }
        }
        list.add(new TransitionElement(null, children, hyperParams));
        hyperParams = new double[motifLength.length + 1];
        int l = 0;
        while (l < expectedSequenceLength) {
            double d = 0.0;
            int i5 = 0;
            while (i5 < motifLength.length) {
                d += hyperNext[i5][motifLength[i5] - 1];
                int j = motifLength[i5] - 1;
                while (j > 0) {
                    double[] dArray = stateESS[i5];
                    int n = j;
                    dArray[n] = dArray[n] + hyperNext[i5][j];
                    hyperNext[i5][j] = hyperNext[i5][j - 1];
                    --j;
                }
                double[] dArray = stateESS[i5];
                int n = j;
                dArray[n] = dArray[n] + hyperNext[i5][j];
                hyperNext[i5][j] = motifProb[i5] * hyperNext[motifLength.length][j];
                int n2 = 1 + i5;
                hyperParams[n2] = hyperParams[n2] + hyperNext[i5][j];
                ++i5;
            }
            double[] dArray = stateESS[i5];
            dArray[0] = dArray[0] + hyperNext[i5][0];
            hyperParams[0] = hyperParams[0] + self * hyperNext[i5][0];
            hyperNext[i5][0] = d + self * hyperNext[i5][0];
            ++l;
        }
        e[0] = HMMFactory.getEmission(con, stateESS[motifLength.length][0], t == null ? null : t[0]);
        name[0] = "bg";
        list.add(new TransitionElement(new int[1], states, hyperParams));
        int idx = 1;
        hyperParams = new double[1];
        int m = 0;
        while (m < motifLength.length) {
            hyperParams[0] = ess;
            int p = 0;
            while (p < motifLength[m]) {
                e[idx] = HMMFactory.getEmission(con, stateESS[m][p], t == null ? null : t[1]);
                name[idx] = "motif " + m + " position " + p;
                if (p == motifLength[m] - 1) {
                    list.add(new TransitionElement(new int[]{idx}, new int[1], hyperParams));
                } else {
                    list.add(new TransitionElement(new int[]{idx}, new int[]{idx + 1}, hyperParams));
                }
                ++p;
                ++idx;
            }
            ++m;
        }
        return HMMFactory.getHMM(pars, name, null, null, e, list.toArray(new TransitionElement[0]), ess, true);
    }

    private static Emission getEmission(AlphabetContainer con, double ess, PhyloTree t) throws WrongAlphabetException {
        if (t != null) {
            return new PhyloDiscreteEmission(con, ess, t);
        }
        return new DiscreteEmission(con, ess);
    }

    public static Pair<AbstractHMM, HomogeneousMMDiffSM> parseProfileHMMFromHMMer(Reader hmmReader, StringBuffer consensus, LinkedList<Integer> matchStates, LinkedList<Integer> silentStates) throws Exception {
        return HMMFactory.parseProfileHMMFromHMMer(hmmReader, consensus, matchStates, silentStates, false);
    }

    public static Pair<AbstractHMM, HomogeneousMMDiffSM> parseProfileHMMFromHMMer(Reader hmmReader, StringBuffer consensus, LinkedList<Integer> matchStates, LinkedList<Integer> silentStates, boolean likelihood) throws Exception {
        BufferedReader read = new BufferedReader(hmmReader);
        String str = null;
        while ((str = read.readLine()) != null) {
            if (str.startsWith("HMM ")) break;
        }
        String[] alph = str.replaceAll("^HMM", "").trim().split("\\s+");
        DiscreteAlphabet alph2 = new DiscreteAlphabet(true, alph);
        AlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        if (!alph2.checkConsistency(DNAAlphabet.SINGLETON)) {
            con = new AlphabetContainer((Alphabet)alph2);
        }
        int al = (int)con.getAlphabetLengthAt(0);
        read.readLine();
        str = read.readLine();
        String[] hom = str.replaceAll(".*COMPO", "").trim().split("\\s+");
        DoubleList emissionPars = new DoubleList();
        DoubleList transitionPars = new DoubleList();
        str = read.readLine();
        String[] i0 = str.trim().split("\\s+");
        HMMFactory.addParameters(emissionPars, i0, al);
        str = read.readLine();
        String[] t0 = str.trim().split("\\s+");
        transitionPars.add(0.0);
        double BI0 = Math.exp(-HMMFactory.parseDouble(t0[1]));
        transitionPars.add(Math.log(1.0 - BI0));
        transitionPars.add(Math.log(BI0));
        double BM1 = Math.exp(-HMMFactory.parseDouble(t0[0]));
        double BD1 = Math.exp(-HMMFactory.parseDouble(t0[2]));
        transitionPars.add(Math.log(BD1 / (BD1 + BM1)));
        transitionPars.add(Math.log(BM1 / (BD1 + BM1)));
        double I0M1 = -HMMFactory.parseDouble(t0[3]);
        double I0I0 = -HMMFactory.parseDouble(t0[4]);
        transitionPars.add(I0I0);
        transitionPars.add(I0M1);
        int l = 0;
        while (!"//".equals(str = read.readLine())) {
            String[] me = str.replaceFirst("\\s+[0-9]+\\s+", "").trim().split("\\s+");
            str = read.readLine();
            String[] ie = str.trim().split("\\s+");
            HMMFactory.addParameters(emissionPars, ie, al);
            HMMFactory.addParameters(emissionPars, me, al);
            consensus.append(me[al + 1]);
            str = read.readLine();
            String[] tr = str.trim().split("\\s+");
            double mm = -HMMFactory.parseDouble(tr[0]);
            double mi = -HMMFactory.parseDouble(tr[1]);
            double md = -HMMFactory.parseDouble(tr[2]);
            double im = -HMMFactory.parseDouble(tr[3]);
            double ii = -HMMFactory.parseDouble(tr[4]);
            double dm = -HMMFactory.parseDouble(tr[5]);
            double dd = -HMMFactory.parseDouble(tr[6]);
            transitionPars.add(dd);
            transitionPars.add(dm);
            transitionPars.add(mi);
            transitionPars.add(md);
            transitionPars.add(mm);
            transitionPars.add(ii);
            transitionPars.add(im);
            ++l;
        }
        read.close();
        HMMFactory.addParameters(emissionPars, hom, al);
        HMMFactory.addParameters(emissionPars, hom, al);
        HMMFactory.addParameters(emissionPars, hom, al);
        transitionPars.add(0.0);
        transitionPars.add(0.0);
        transitionPars.add(0.0);
        transitionPars.add(Double.NEGATIVE_INFINITY);
        transitionPars.add(Double.NEGATIVE_INFINITY);
        transitionPars.add(Math.log(0.99));
        transitionPars.add(Math.log(0.01));
        NumericalHMMTrainingParameterSet trainingParameterSet = new NumericalHMMTrainingParameterSet(1, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), 1, 20, 1.0E-4, 1.0E-4, NumericalHMMTrainingParameterSet.TrainingType.LIKELIHOOD, false);
        int numLayers = l + 2;
        double ess = 16.0;
        DifferentiableHigherOrderHMM hmm = (DifferentiableHigherOrderHMM)HMMFactory.createProfileHMM(trainingParameterSet, HMMType.PLAN7, likelihood, 1, numLayers, con, ess, MState.UNCONDITIONAL, false, null);
        if (matchStates != null) {
            int i = 0;
            while (i < hmm.states.length) {
                if (hmm.states[i] instanceof SimpleState) {
                    String state = ((SimpleState)hmm.states[i]).getName();
                    if (state.matches("M[0-9]+")) {
                        matchStates.add(i);
                    }
                    if (hmm.states[i].isSilent()) {
                        silentStates.add(i);
                    }
                }
                ++i;
            }
            matchStates.removeLast();
        }
        double[] pars = hmm.getCurrentParameterValues();
        int i = 0;
        while (i < emissionPars.length()) {
            pars[i] = emissionPars.get(i);
            ++i;
        }
        i = 0;
        while (i < transitionPars.length()) {
            pars[i + emissionPars.length()] = transitionPars.get(i);
            ++i;
        }
        hmm.setParameters(pars, 0);
        HomogeneousMMDiffSM homo = new HomogeneousMMDiffSM(con, 0, 16.0, numLayers);
        homo.initializeFunctionRandomly(false);
        DoubleList homPars = new DoubleList();
        HMMFactory.addParameters(homPars, hom, al);
        homo.setParameters(homPars.toArray(), 0);
        return new Pair<AbstractHMM, HomogeneousMMDiffSM>(hmm, homo);
    }

    private static double parseDouble(String arg) {
        if ("*".equals(arg)) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.parseDouble(arg);
    }

    private static void addParameters(DoubleList emissionPars, String[] str, int al) {
        int i = 0;
        while (i < al) {
            emissionPars.add(-HMMFactory.parseDouble(str[i]));
            ++i;
        }
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, HMMType type, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, MState mState, boolean closeCircle, double[][] conditionInitProbs) throws Exception {
        double[][] initFromTo = HMMFactory.getInitFromTo(type, ess);
        return HMMFactory.createProfileHMM(trainingParameterSet, initFromTo, likelihood, order, numLayers, con, ess, mState, closeCircle, conditionInitProbs, false);
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, double[][] initFromTo, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, MState mState, boolean closeCircle, double[][] conditionInitProbs, boolean insertUniform) throws Exception {
        return HMMFactory.createProfileHMM(trainingParameterSet, initFromTo, likelihood, order, numLayers, con, ess, mState, closeCircle ? 1 : 0, conditionInitProbs, insertUniform);
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, double[][] initFromTo, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, MState mState, int joiningStates, double[][] conditionInitProbs, boolean insertUniform) throws Exception {
        return HMMFactory.createProfileHMM(trainingParameterSet, initFromTo, likelihood, order, numLayers, con, ess, new MState[]{mState}, joiningStates, conditionInitProbs, insertUniform);
    }

    public static AbstractHMM createProfileHMM(MaxHMMTrainingParameterSet trainingParameterSet, double[][] initFromTo, boolean likelihood, int order, int numLayers, AlphabetContainer con, double ess, MState[] mState, int joiningStates, double[][] conditionInitProbs, boolean insertUniform) throws Exception {
        PseudoTransitionElement[] coreTransitionTemplate = null;
        LinkedList<Class<? extends DifferentiableEmission>> emList = new LinkedList<Class<? extends DifferentiableEmission>>();
        ArrayList<PseudoTransitionElement> list = new ArrayList<PseudoTransitionElement>();
        LinkedList<String> nameList = new LinkedList<String>();
        Class insertClass = insertUniform ? UniformEmission.class : DiscreteEmission.class;
        int[] endContext = new int[order];
        int i = 0;
        while (i < order) {
            ((AbstractList)nameList).add("E" + i);
            ((AbstractList)emList).add(SilentEmission.class);
            endContext[i] = i;
            ++i;
        }
        int[] startContext = new int[order];
        int i2 = 0;
        while (i2 < order) {
            ((AbstractList)nameList).add("S" + i2);
            ((AbstractList)emList).add(SilentEmission.class);
            int[] context = new int[i2];
            int k = 0;
            while (k < i2) {
                context[k] = order + k;
                ++k;
            }
            list.add(new PseudoTransitionElement(context, new int[]{order + i2}, new double[]{ess}));
            startContext[i2] = order + i2;
            ++i2;
        }
        ArrayList<int[]> lastLayer = new ArrayList<int[]>();
        int lastStartNodeIndex = ((AbstractCollection)emList).size() - 1;
        int offset = ((AbstractCollection)emList).size();
        HMMFactory.createProfileHMMCore(numLayers, lastLayer, initFromTo, order, emList, nameList, list, offset, lastStartNodeIndex, mState, coreTransitionTemplate, "", insertClass);
        int[] states = new int[6];
        Arrays.fill(states, -1);
        states[3] = ((AbstractCollection)emList).size() - 1;
        ArrayList<int[]> newLayer = new ArrayList<int[]>();
        int i3 = 0;
        while (i3 < order) {
            HMMFactory.shiftContext(states, 3);
            states[3] = i3++;
            HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
        }
        ((AbstractList)nameList).add("F");
        ((AbstractList)emList).add(SilentEmission.class);
        if (joiningStates > 0) {
            int e = ((AbstractCollection)emList).size();
            list.add(new PseudoTransitionElement(endContext, new int[]{e - 1, e}, new double[]{ess / 2.0, ess / 2.0}));
            int i4 = 0;
            while (i4 < joiningStates) {
                ((AbstractList)nameList).add("J" + i4);
                ((AbstractList)emList).add(insertClass);
                ++i4;
            }
            int[] myContext = (int[])endContext.clone();
            System.arraycopy(myContext, 1, myContext, 0, order - 1);
            myContext[order - 1] = e;
            ContextContainer[] possible = new ContextContainer[joiningStates];
            int i5 = 0;
            while (i5 < joiningStates) {
                possible[i5] = new ContextContainer();
                ++i5;
            }
            possible[0].addConditional(myContext);
            ContextContainer extra = new ContextContainer();
            double[] hyperParams = new double[]{ess / 3.0, ess / 3.0, ess / 3.0};
            int f = e;
            int j = 0;
            while (j < joiningStates) {
                int[] children;
                if (j + 1 == joiningStates) {
                    children = new int[]{f, order};
                    hyperParams = new double[]{ess / 2.0, ess / 2.0};
                } else {
                    children = new int[]{f, f + 1, order};
                }
                int k = 0;
                while (k < possible[j].size()) {
                    myContext = (int[])possible[j].get(k);
                    list.add(new PseudoTransitionElement(myContext, children, hyperParams));
                    int l = 0;
                    while (l < children.length) {
                        int[] next = (int[])myContext.clone();
                        System.arraycopy(next, 1, next, 0, order - 1);
                        next[order - 1] = children[l];
                        if (children[l] == order) {
                            extra.addConditional(next);
                        } else {
                            possible[children[l] - e].addConditional(next);
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
                ++f;
            }
            int k = 0;
            while (k < extra.size()) {
                myContext = (int[])((int[])extra.get(k)).clone();
                int i6 = 0;
                while (i6 < order - 1) {
                    list.add(new PseudoTransitionElement(myContext, new int[]{order + i6 + 1}, new double[]{ess}));
                    System.arraycopy(myContext, 1, myContext, 0, order - 1);
                    myContext[order - 1] = order + i6 + 1;
                    ++i6;
                }
                ++k;
            }
        } else {
            list.add(new PseudoTransitionElement(endContext, new int[]{((AbstractCollection)emList).size() - 1}, new double[]{ess}));
        }
        Pair<double[][], double[]> p = HMMFactory.propagateESS(ess, list);
        return HMMFactory.getHMM(trainingParameterSet, ((AbstractCollection)nameList).toArray(new String[0]), null, null, HMMFactory.getEmissions(nameList, emList, p.getSecondElement(), con, conditionInitProbs), HMMFactory.createTransition(p.getFirstElement(), list), ess, likelihood);
    }

    private static double[][] getInitFromTo(HMMType type, double ess) {
        double[][] initFromTo = new double[3][];
        if (type == HMMType.PLAN9) {
            initFromTo[0] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[1] = (double[])initFromTo[0].clone();
            initFromTo[2] = (double[])initFromTo[1].clone();
        } else if (type == HMMType.PLAN7) {
            initFromTo[0] = new double[]{Double.NaN, Double.NaN, Double.NaN, ess / 2.0, Double.NaN, ess / 2.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 2.0, Double.NaN, Double.NaN, Double.NaN, ess / 2.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        } else if (type == HMMType.PLAN8I) {
            initFromTo[0] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 2.0, Double.NaN, Double.NaN, Double.NaN, ess / 2.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        } else if (type == HMMType.PLAN8D) {
            initFromTo[0] = new double[]{Double.NaN, Double.NaN, Double.NaN, ess / 2.0, Double.NaN, ess / 2.0};
            initFromTo[1] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
            initFromTo[2] = new double[]{Double.NaN, ess / 3.0, Double.NaN, ess / 3.0, Double.NaN, ess / 3.0};
        }
        return initFromTo;
    }

    private static DifferentiableEmission[] getEmissions(AbstractList<String> nameList, AbstractList<Class<? extends DifferentiableEmission>> emList, double[] ess, AlphabetContainer con, double[][] conditionInitAPrioriProbs) throws Exception {
        DifferentiableEmission[] em = new DifferentiableEmission[emList.size()];
        Iterator<Class<? extends DifferentiableEmission>> it = emList.iterator();
        Iterator<String> n = nameList.iterator();
        int i = 0;
        int refIdx = 0;
        DiscreteMatchMismatchEmission ref = null;
        while (it.hasNext()) {
            Class<? extends DifferentiableEmission> cl = it.next();
            String name = n.next();
            if (cl == SilentEmission.class) {
                em[i] = new SilentEmission();
            } else if (AbstractConditionalDiscreteEmission.class.isAssignableFrom(cl)) {
                if (ReferenceSequenceDiscreteEmission.class.isAssignableFrom(cl)) {
                    if (cl == ReferenceSequenceDiscreteEmission.class) {
                        if (conditionInitAPrioriProbs != null) {
                            double[][] conditionInitHyperpars = (double[][])ArrayHandler.clone((Cloneable[])conditionInitAPrioriProbs);
                            int j = 0;
                            while (j < conditionInitHyperpars.length) {
                                int k = 0;
                                while (k < conditionInitHyperpars[j].length) {
                                    double[] dArray = conditionInitHyperpars[j];
                                    int n2 = k++;
                                    dArray[n2] = dArray[n2] * ess[i];
                                }
                                ++j;
                            }
                            em[i] = new ReferenceSequenceDiscreteEmission(con, con, refIdx, ess[i], conditionInitHyperpars);
                        } else {
                            em[i] = new ReferenceSequenceDiscreteEmission(con, con, refIdx, ess[i]);
                        }
                    } else if (cl == DiscreteMatchMismatchEmission.class) {
                        DiscreteEmission e = new DiscreteEmission(con, ess[i]);
                        DifferentiableEmission[] emi = new DifferentiableEmission[]{e, e};
                        if (refIdx == 0) {
                            ref = new DiscreteMatchMismatchEmission(con, refIdx, ess[i], emi);
                            em[i] = ref;
                        } else {
                            em[i] = new DiscreteMatchMismatchEmission(con, refIdx, ess[i], ref);
                        }
                    } else {
                        em[i] = cl.getConstructor(AlphabetContainer.class, Integer.TYPE, Double.TYPE).newInstance(con, refIdx, ess[i]);
                    }
                    ++refIdx;
                } else {
                    em[i] = cl.getConstructor(AlphabetContainer.class, Double.TYPE).newInstance(con, ess[i]);
                }
                String shape = name.charAt(0) == 'M' ? "rect" : "diamond";
                ((AbstractConditionalDiscreteEmission)em[i]).setShape(shape);
            } else {
                Constructor<?>[] cons = cl.getConstructors();
                int j = 0;
                while (em[i] == null && j < cons.length) {
                    Class<?>[] pars = cons[j].getParameterTypes();
                    switch (pars.length) {
                        case 1: {
                            if (pars[0] != AlphabetContainer.class) break;
                            em[i] = (DifferentiableEmission)cons[j].newInstance(con);
                            break;
                        }
                        case 2: {
                            if (pars[0] != AlphabetContainer.class || pars[1] != Double.TYPE) break;
                            em[i] = (DifferentiableEmission)cons[j].newInstance(con, ess[i]);
                        }
                    }
                    ++j;
                }
                if (em[i] == null) {
                    throw new Exception("Unsupported emission class.");
                }
            }
            ++i;
        }
        return em;
    }

    private static void shiftContext(int[] context) {
        HMMFactory.shiftContext(context, 1);
    }

    private static void shiftContext(int[] context, int s) {
        System.arraycopy(context, s, context, 0, context.length - s);
    }

    private static void createProfileHMMCore(int numLayers, ArrayList<int[]> lastLayer, double[][] initFromTo, int order, AbstractList<Class<? extends DifferentiableEmission>> emList, AbstractList<String> nameList, AbstractList<PseudoTransitionElement> list, int totalOffset, int lastStartNodeIndex, MState[] mState, PseudoTransitionElement[] coreTransitionTemplate, String suffix, Class<? extends DifferentiableEmission> insertClass) {
        if (order < 1) {
            throw new IllegalArgumentException("The order of a profile HMM has to be at least 1.");
        }
        ArrayList<int[]> newLayer = new ArrayList<int[]>();
        emList.add(SilentEmission.class);
        nameList.add("D0" + suffix);
        emList.add(insertClass);
        nameList.add("I0" + suffix);
        int[] context = new int[order];
        int i = 0;
        while (i < order) {
            context[i] = lastStartNodeIndex - order + i + 1;
            ++i;
        }
        if (Double.isNaN(initFromTo[0][1])) {
            list.add(new PseudoTransitionElement(context, new int[]{emList.size() - 2, emList.size() - 1}, new double[]{0.5, 0.5}));
        } else {
            list.add(new PseudoTransitionElement(context, new int[]{emList.size() - 2}, new double[]{1.0}));
        }
        lastLayer.clear();
        HMMFactory.shiftContext(context);
        context[order - 1] = emList.size() - 2;
        lastLayer.add((int[])context.clone());
        if (Double.isNaN(initFromTo[0][1])) {
            context[order - 1] = emList.size() - 1;
            lastLayer.add(context);
        }
        int[] states = new int[]{-1, -1, -1, totalOffset, totalOffset + 1, -1};
        boolean[] createStates = new boolean[3];
        Arrays.fill(createStates, true);
        int i2 = 0;
        while (i2 < numLayers) {
            if (i2 == numLayers - 1) {
                int j = 0;
                while (j < createStates.length) {
                    createStates[j] = !Double.isNaN(initFromTo[j][3]);
                    ++j;
                }
            }
            int last = emList.size();
            HMMFactory.createEmissions(createStates, emList, nameList, i2 + 1, mState[mState.length == 1 ? 0 : i2], suffix, insertClass);
            HMMFactory.shiftContext(states, 3);
            int j = 3;
            while (j < states.length) {
                states[j] = createStates[j - 3] ? last++ : -1;
                ++j;
            }
            HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
            ++i2;
        }
        emList.add(SilentEmission.class);
        nameList.add("D" + (numLayers + 1) + suffix);
        HMMFactory.shiftContext(states, 3);
        states[3] = emList.size() - 1;
        states[4] = -1;
        states[5] = -1;
        HMMFactory.addProfileTransitions(initFromTo, order, states, list, lastLayer, newLayer);
    }

    private static void addProfileTransitions(double[][] initFromTo, int order, int[] states, List<PseudoTransitionElement> allTE, List<int[]> lastLayer, List<int[]> newLayer) {
        DoubleList hyper = new DoubleList();
        DoubleList weights = new DoubleList();
        IntList children = new IntList();
        int o = order - 1;
        int s = 0;
        while (s < lastLayer.size()) {
            int[] current = lastLayer.get(s);
            int k = 0;
            while (current[o] != states[k]) {
                ++k;
            }
            hyper.clear();
            weights.clear();
            children.clear();
            int a = 0;
            int j = 0;
            while (j < initFromTo[k].length) {
                if (!Double.isNaN(initFromTo[k][j]) && states[j] >= 0) {
                    hyper.add(initFromTo[k][j]);
                    children.add(states[j]);
                    if (j < 3) {
                        weights.add(1000.0);
                        a = children.length();
                    } else {
                        weights.add(1.0);
                    }
                }
                ++j;
            }
            if (children.length() > 0) {
                allTE.add(new PseudoTransitionElement(current, children.toArray(), hyper.toArray(), weights.toArray()));
            }
            int[] next = (int[])current.clone();
            HMMFactory.shiftContext(next);
            j = 0;
            while (j < children.length()) {
                next[o] = children.get(j);
                HMMFactory.addConditional(next, j < a ? lastLayer : newLayer);
                ++j;
            }
            ++s;
        }
        lastLayer.clear();
        lastLayer.addAll(newLayer);
        newLayer.clear();
    }

    private static boolean addConditional(int[] context, List<int[]> list) {
        int i = 0;
        while (i < list.size()) {
            int[] current = list.get(i);
            int j = 0;
            while (j < context.length && current[j] == context[j]) {
                ++j;
            }
            if (j == context.length) {
                return false;
            }
            ++i;
        }
        list.add((int[])context.clone());
        return true;
    }

    private static int createEmissions(boolean[] createState, AbstractList<Class<? extends DifferentiableEmission>> emList, AbstractList<String> nameList, int offset, MState mState, String suffix, Class<? extends DifferentiableEmission> insertClass) {
        int i = 0;
        int a = 0;
        if (createState[i]) {
            emList.add(SilentEmission.class);
            nameList.add("D" + offset + suffix);
            ++a;
        }
        if (createState[++i]) {
            emList.add(insertClass);
            nameList.add("I" + offset + suffix);
            ++a;
        }
        if (createState[++i]) {
            Class de;
            switch (mState) {
                case UNIFORM: {
                    de = UniformEmission.class;
                    break;
                }
                case UNCONDITIONAL: {
                    de = DiscreteEmission.class;
                    break;
                }
                case REFERENCE: {
                    de = ReferenceSequenceDiscreteEmission.class;
                    break;
                }
                case MISMATCH: {
                    de = DiscreteMatchMismatchEmission.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown MState: " + (Object)((Object)mState));
                }
            }
            emList.add(de);
            nameList.add("M" + offset + suffix);
            ++a;
        }
        return a;
    }

    public static TransitionElement[] createTransition(double[][] hyperParams, ArrayList<PseudoTransitionElement> list) {
        TransitionElement[] t = new TransitionElement[list.size()];
        int i = 0;
        while (i < list.size()) {
            PseudoTransitionElement current = list.get(i);
            t[i] = new TransitionElement(current.context, current.states, hyperParams[i], current.weights);
            ++i;
        }
        return t;
    }

    public static Pair<double[][], double[]> propagateESS(double ess, ArrayList<PseudoTransitionElement> list) {
        int maxOrder = 0;
        int max = 0;
        int startIdx = -1;
        IntList end = new IntList();
        int i = 0;
        while (i < list.size()) {
            int[] current = list.get(i).states;
            int j = 0;
            while (j < current.length) {
                max = Math.max(max, current[j]);
                ++j;
            }
            if (list.get(i).context.length == 0) {
                if (startIdx >= 0) {
                    throw new IllegalArgumentException("Multiple start transitions!");
                }
                startIdx = i;
            } else {
                maxOrder = Math.max(maxOrder, list.get(i).context.length);
            }
            ++i;
        }
        int t = 0;
        while (t < list.size()) {
            PseudoTransitionElement te = list.get(t);
            if (te.states.length == 0) {
                end.add(t);
            }
            int child = 0;
            while (child < te.states.length) {
                int[] nextContext = new int[Math.min(maxOrder, te.context.length + 1)];
                nextContext[nextContext.length - 1] = te.states[child];
                int k = 1;
                int j = nextContext.length - 2;
                while (j >= 0) {
                    nextContext[j] = te.context[te.context.length - k];
                    --j;
                    ++k;
                }
                int s = 0;
                while (s < list.size()) {
                    PseudoTransitionElement te2 = list.get(s);
                    if (nextContext.length == te2.context.length) {
                        int c = 0;
                        while (c < nextContext.length && nextContext[c] == te2.context[c]) {
                            ++c;
                        }
                        if (c == nextContext.length) {
                            ((PseudoTransitionElement)te).child[child] = s;
                            s = list.size();
                        }
                    }
                    ++s;
                }
                if (te.child[child] == -1) {
                    if (maxOrder == 0) {
                        ((PseudoTransitionElement)te).child[child] = 0;
                    } else {
                        ((PseudoTransitionElement)te).child[child] = list.size();
                        list.add(new PseudoTransitionElement(nextContext, null, null));
                    }
                }
                ++child;
            }
            ++t;
        }
        if (end.length() == 0) {
            throw new IllegalArgumentException("No absorbing state!");
        }
        double eps = 1.0E-12;
        double sum = 0.0;
        double[] cumulatedHyper = new double[list.size()];
        double[] currentHyper = new double[list.size()];
        double[] nextHyper = new double[list.size()];
        currentHyper[startIdx] = ess;
        do {
            int t2 = 0;
            while (t2 < list.size()) {
                PseudoTransitionElement te = list.get(t2);
                int child = 0;
                while (child < te.states.length) {
                    int n = te.child[child];
                    nextHyper[n] = nextHyper[n] + te.prob[child] * currentHyper[t2];
                    ++child;
                }
                ++t2;
            }
            int i2 = 0;
            while (i2 < cumulatedHyper.length) {
                int n = i2;
                cumulatedHyper[n] = cumulatedHyper[n] + currentHyper[i2];
                currentHyper[i2] = nextHyper[i2];
                nextHyper[i2] = 0.0;
                ++i2;
            }
            sum = 0.0;
            i2 = 0;
            while (i2 < currentHyper.length) {
                sum += currentHyper[i2];
                ++i2;
            }
        } while (sum > eps);
        double[][] t3 = new double[list.size()][];
        double[] stateESS = new double[max + 1];
        int i3 = 0;
        while (i3 < list.size()) {
            PseudoTransitionElement current = list.get(i3);
            t3[i3] = new double[current.prob.length];
            int j = 0;
            while (j < t3[i3].length) {
                t3[i3][j] = cumulatedHyper[i3] * current.prob[j];
                ++j;
            }
            if (current.context.length > 0) {
                int n = current.context[current.context.length - 1];
                stateESS[n] = stateESS[n] + cumulatedHyper[i3];
            }
            ++i3;
        }
        return new Pair<double[][], double[]>(t3, stateESS);
    }

    public static HashMap<String, String> getHashMap() {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("J.*", "min");
        hash.put("[EFIS].*", "same");
        hash.put("M.*", "same");
        hash.put("D.*", "max");
        return hash;
    }

    private static class ContextContainer
    extends ArrayList<int[]> {
        private ContextContainer() {
        }

        public boolean addConditional(int[] newContext) {
            int i = 0;
            while (i < this.size()) {
                int[] test = (int[])this.get(i);
                int j = 0;
                while (j < newContext.length && newContext[j] == test[j]) {
                    ++j;
                }
                if (j == newContext.length) {
                    return false;
                }
                ++i;
            }
            this.add(newContext);
            return true;
        }
    }

    public static enum HMMType {
        PLAN7,
        PLAN9,
        PLAN8I,
        PLAN8D;

    }

    public static enum MState {
        UNIFORM,
        UNCONDITIONAL,
        REFERENCE,
        MISMATCH;

    }

    public static class PseudoTransitionElement {
        private int[] context;
        private int[] states;
        private int[] child;
        private double[] prob;
        private double[] weights;

        public PseudoTransitionElement(int[] context, int[] states, double[] posScore) {
            this(context, states, posScore, null);
        }

        public PseudoTransitionElement(int[] context, int[] states, double[] posScore, double[] weights) {
            this.context = context == null ? new int[]{} : (int[])context.clone();
            this.states = states == null ? new int[]{} : (int[])states.clone();
            this.prob = new double[this.states.length];
            if (posScore == null) {
                Arrays.fill(this.prob, 1.0 / (double)this.states.length);
            } else {
                Normalisation.sumNormalisation(posScore, this.prob, 0);
            }
            if (weights == null) {
                this.weights = new double[this.states.length];
                Arrays.fill(this.weights, 1.0);
            } else {
                this.weights = weights;
            }
            this.child = new int[this.states.length];
            Arrays.fill(this.child, -1);
        }

        public String toString() {
            String str = "";
            String cont = "";
            int i = 0;
            while (i < this.context.length - 1) {
                cont = String.valueOf(cont) + this.context[i] + ", ";
                ++i;
            }
            if (this.context.length > 0) {
                cont = String.valueOf(cont) + this.context[this.context.length - 1];
            }
            i = 0;
            while (i < this.states.length) {
                str = String.valueOf(str) + "P(" + this.states[i] + "|" + cont + ")\t= " + this.prob[i] + (i == this.states.length - 1 ? "\n" : "\t");
                ++i;
            }
            return str;
        }
    }
}

