/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.alphabets.IUPACDNAAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sampling.SamplingFromStatistic;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.AbstractConditionalDiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.ReferenceSequenceDiscreteEmission;
import java.text.NumberFormat;
import javax.naming.OperationNotSupportedException;

public class DiscreteMatchMismatchEmission
extends ReferenceSequenceDiscreteEmission {
    private static IUPACDNAAlphabet iupac = IUPACDNAAlphabet.SINGLETON;
    private static AlphabetContainer dummyRefCon;
    private DiscreteMatchMismatchEmission ref;
    private DifferentiableEmission[] e;

    static {
        try {
            dummyRefCon = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "."));
        }
        catch (DoubleSymbolException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public DiscreteMatchMismatchEmission(AlphabetContainer con, int refIdx, double ess, DifferentiableEmission[] e) throws IllegalArgumentException, CloneNotSupportedException, WrongAlphabetException {
        this(con, refIdx, DiscreteMatchMismatchEmission.getHyperParams(ess, 1, 2), null, null, e);
    }

    public DiscreteMatchMismatchEmission(AlphabetContainer con, int refIdx, double ess, DiscreteMatchMismatchEmission ref) throws IllegalArgumentException, CloneNotSupportedException, WrongAlphabetException {
        this(con, refIdx, DiscreteMatchMismatchEmission.getHyperParams(ess, 1, 2), null, ref, null);
    }

    @Override
    public DiscreteMatchMismatchEmission clone() throws CloneNotSupportedException {
        DiscreteMatchMismatchEmission clone = (DiscreteMatchMismatchEmission)super.clone();
        if (this.refIdx == 0) {
            clone.e = (DifferentiableEmission[])ArrayHandler.clone((Cloneable[])this.e);
            this.ref = clone;
        } else {
            clone.setReference(this.ref.ref);
        }
        return clone;
    }

    private DiscreteMatchMismatchEmission(AlphabetContainer con, int refIdx, double[][] hyperParams, double[][] initHyperParams, DiscreteMatchMismatchEmission ref, DifferentiableEmission[] e) throws IllegalArgumentException, CloneNotSupportedException, WrongAlphabetException {
        super(con, dummyRefCon, refIdx, hyperParams, initHyperParams == null ? hyperParams : initHyperParams);
        if (hyperParams.length != 1 || hyperParams[0].length != 2) {
            throw new IllegalArgumentException("hyperParams has to be double[1][2]");
        }
        if (ref == null) {
            this.e = (DifferentiableEmission[])ArrayHandler.clone((Cloneable[])e);
        } else {
            this.setReference(ref);
        }
    }

    public void setReference(DiscreteMatchMismatchEmission ref) throws CloneNotSupportedException {
        this.ref = ref;
        this.e = (DifferentiableEmission[])ArrayHandler.clone((Cloneable[])ref.e);
    }

    public DiscreteMatchMismatchEmission(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        super.appendFurtherInformation(xml);
        if (this.refIdx == 0) {
            XMLParser.appendObjectWithTags(xml, this.e, "emission");
        }
    }

    @Override
    protected int getConditionIndex(boolean forward, int seqPos, Sequence seq) {
        return 0;
    }

    @Override
    protected int getIndex(int seqPos, Sequence seq) {
        return seq.discreteVal(seqPos) == DiscreteMatchMismatchEmission.getReferenceSequence(seq).discreteVal(this.refIdx) ? 0 : 1;
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer();
        sb.append("P(R_" + this.refIdx + "=Match) = " + nf.format(this.probs[0][0]) + "\tP(R_" + this.refIdx + "=Mismatch) = " + nf.format(this.probs[0][1]) + "\n\n");
        int i = 0;
        while (i < this.e.length) {
            if (this.e[i] != null) {
                sb.append(String.valueOf(i == 0 ? "Match" : "Mismatch") + ":\n" + this.e[i].toString(nf) + "\n");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void initializeFunctionRandomly() {
        super.initializeFunctionRandomly();
        if (this.refIdx == 0) {
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    this.e[i].initializeFunctionRandomly();
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    this.e[i].setParameters(this.ref.e[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        int e;
        int s;
        Sequence current;
        if (forward) {
            current = seq;
            s = startPos;
            e = endPos;
        } else {
            current = seq.reverseComplement();
            int len = current.getLength();
            s = len - endPos - 1;
            e = len - startPos - 1;
        }
        while (s <= e) {
            int condIdx = this.getConditionIndex(forward, s, seq);
            int index = this.getIndex(s, current);
            double[] dArray = this.statistic[condIdx];
            int n = index;
            dArray[n] = dArray[n] + weight;
            if (this.e[index] != null) {
                this.e[index].addToStatistic(true, s, s, weight, current);
            }
            ++s;
        }
    }

    @Override
    public void estimateFromStatistic() {
        super.estimateFromStatistic();
        if (this.refIdx == 0) {
            try {
                int i = 0;
                while (i < this.e.length) {
                    if (this.e[i] != null) {
                        AbstractConditionalDiscreteEmission a = (AbstractConditionalDiscreteEmission)this.e[i];
                        double d = (a.statistic[0][0] + a.statistic[0][3]) / 2.0;
                        a.statistic[0][3] = d;
                        a.statistic[0][0] = d;
                        double d2 = (a.statistic[0][1] + a.statistic[0][2]) / 2.0;
                        a.statistic[0][2] = d2;
                        a.statistic[0][1] = d2;
                        this.e[i].estimateFromStatistic();
                    }
                    ++i;
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        } else {
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    this.e[i].setParameters(this.ref.e[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public void drawParametersFromStatistic() {
        super.drawParametersFromStatistic();
        if (this.refIdx == 0) {
            try {
                int i = 0;
                while (i < this.e.length) {
                    if (this.e[i] != null) {
                        ((SamplingFromStatistic)((Object)this.e[i])).drawParametersFromStatistic();
                    }
                    ++i;
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        } else {
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    this.e[i].setParameters(this.ref.e[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public double getLogPosteriorFromStatistic() {
        double res = super.getLogPosteriorFromStatistic();
        if (this.refIdx == 0) {
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    ((SamplingFromStatistic)((Object)this.e[i])).getLogPosteriorFromStatistic();
                }
                ++i;
            }
        }
        return res;
    }

    @Override
    public void resetStatistic() {
        super.resetStatistic();
        int i = 0;
        while (i < this.e.length) {
            if (this.e[i] != null) {
                this.e[i].resetStatistic();
            }
            ++i;
        }
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
        super.joinStatistics(emissions);
        Emission[] sub = new Emission[emissions.length + (this.refIdx == 0 ? 0 : 1)];
        int i = 0;
        while (i < this.e.length) {
            if (this.e[i] != null) {
                int j = 0;
                while (j < emissions.length) {
                    sub[j] = ((DiscreteMatchMismatchEmission)emissions[j]).e[i];
                    ++j;
                }
                if (this.refIdx != 0) {
                    sub[emissions.length] = this.ref.e[i];
                }
                this.e[i].joinStatistics(sub);
            }
            ++i;
        }
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        super.setParameters(t);
        int i = 0;
        while (i < this.e.length) {
            if (this.e[i] != null) {
                this.e[i].setParameters(((DiscreteMatchMismatchEmission)t).e[i]);
            }
            ++i;
        }
    }

    @Override
    public double getLogPriorTerm() {
        double res = super.getLogPriorTerm();
        if (this.refIdx == 0) {
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    res += this.e[i].getLogPriorTerm();
                }
                ++i;
            }
        }
        return res;
    }

    @Override
    public int getNumberOfParameters() {
        int n = super.getNumberOfParameters();
        if (this.refIdx == 0) {
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    n += this.e[i].getNumberOfParameters();
                }
                ++i;
            }
        }
        return n;
    }

    @Override
    public void setParameter(double[] params, int offset) {
        super.setParameter(params, offset);
        if (this.refIdx == 0) {
            offset += super.getNumberOfParameters();
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    this.e[i].setParameter(params, offset);
                    offset += this.e[i].getNumberOfParameters();
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.e.length) {
                if (this.e[i] != null) {
                    this.e[i].setParameters(this.ref.e[i]);
                }
                ++i;
            }
        }
    }
}

