/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.InputResource;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;

class UrlInputResource
extends InputResource {
    final URL urlResource;
    final Lazy<SeekableStream> lazySeekableStream = new Lazy<SeekableStream>(new Lazy.LazyInitializer<SeekableStream>(){

        @Override
        public SeekableStream make() {
            try {
                return SeekableStreamFactory.getInstance().getStreamFor(UrlInputResource.this.urlResource);
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
        }
    });

    UrlInputResource(URL urlResource) {
        super(InputResource.Type.URL);
        this.urlResource = urlResource;
    }

    @Override
    public File asFile() {
        return null;
    }

    @Override
    public Path asPath() {
        try {
            return Paths.get(this.urlResource.toURI());
        }
        catch (IllegalArgumentException | SecurityException | URISyntaxException | FileSystemNotFoundException e) {
            return null;
        }
    }

    @Override
    public URL asUrl() {
        return this.urlResource;
    }

    @Override
    public SeekableStream asUnbufferedSeekableStream() {
        return this.lazySeekableStream.get();
    }

    @Override
    public InputStream asUnbufferedInputStream() {
        return this.asUnbufferedSeekableStream();
    }

    @Override
    public SRAAccession asSRAAccession() {
        return null;
    }
}

