/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.DuplicateReadFilter;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SecondaryOrSupplementaryFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListReferenceSequenceMask;
import htsjdk.samtools.util.Locus;
import htsjdk.samtools.util.LocusComparator;
import htsjdk.samtools.util.LocusImpl;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ReferenceSequenceMask;
import htsjdk.samtools.util.SamRecordIntervalIteratorFactory;
import htsjdk.samtools.util.WholeGenomeReferenceSequenceMask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SamLocusIterator
implements Iterable<LocusInfo>,
CloseableIterator<LocusInfo> {
    private static final Log LOG = Log.getInstance(SamLocusIterator.class);
    private final SamReader samReader;
    private final ReferenceSequenceMask referenceSequenceMask;
    private PeekableIterator<SAMRecord> samIterator;
    private List<SamRecordFilter> samFilters = Arrays.asList(new SecondaryOrSupplementaryFilter(), new DuplicateReadFilter());
    private final List<Interval> intervals;
    private final boolean useIndex;
    private final ArrayList<LocusInfo> complete = new ArrayList(100);
    private final ArrayList<LocusInfo> accumulator = new ArrayList(100);
    private int qualityScoreCutoff = Integer.MIN_VALUE;
    private int mappingQualityScoreCutoff = Integer.MIN_VALUE;
    private boolean includeNonPfReads = true;
    private boolean emitUncoveredLoci = true;
    private int maxReadsToAccumulatePerLocus = Integer.MAX_VALUE;
    private boolean enforcedAccumulationLimit = false;
    private boolean includeIndels = false;
    private int lastReferenceSequence = 0;
    private int lastPosition = 0;
    private boolean finishedAlignedReads = false;
    private final LocusComparator<Locus> locusComparator = new LocusComparator();

    public SamLocusIterator(SamReader samReader) {
        this(samReader, null);
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList) {
        this(samReader, intervalList, samReader.hasIndex());
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList, boolean useIndex) {
        if (samReader.getFileHeader().getSortOrder() == null || samReader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.unsorted) {
            LOG.warn("SamLocusIterator constructed with samReader that has SortOrder == unsorted.  ", "Assuming SAM is coordinate sorted, but exceptions may occur if it is not.");
        } else if (samReader.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException("SamLocusIterator cannot operate on a SAM file that is not coordinate sorted.");
        }
        this.samReader = samReader;
        this.useIndex = useIndex;
        if (intervalList != null) {
            this.intervals = intervalList.uniqued().getIntervals();
            this.referenceSequenceMask = new IntervalListReferenceSequenceMask(intervalList);
        } else {
            this.intervals = null;
            this.referenceSequenceMask = new WholeGenomeReferenceSequenceMask(samReader.getFileHeader());
        }
    }

    @Override
    public Iterator<LocusInfo> iterator() {
        if (this.samIterator != null) {
            throw new IllegalStateException("Cannot call iterator() more than once on SamLocusIterator");
        }
        CloseableIterator<SAMRecord> tempIterator = this.intervals != null ? new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(this.samReader, this.intervals, this.useIndex) : this.samReader.iterator();
        if (this.samFilters != null) {
            tempIterator = new FilteringSamIterator(tempIterator, new AggregateFilter(this.samFilters));
        }
        this.samIterator = new PeekableIterator<SAMRecord>(tempIterator);
        return this;
    }

    @Override
    public void close() {
        this.samIterator.close();
    }

    private boolean samHasMore() {
        return !this.finishedAlignedReads && this.samIterator.peek() != null;
    }

    @Override
    public boolean hasNext() {
        if (this.samIterator == null) {
            this.iterator();
        }
        while (this.complete.isEmpty() && (!this.accumulator.isEmpty() || this.samHasMore() || this.hasRemainingMaskBases())) {
            LocusInfo locusInfo = this.next();
            if (locusInfo == null) continue;
            this.complete.add(0, locusInfo);
        }
        return !this.complete.isEmpty();
    }

    private boolean hasRemainingMaskBases() {
        if (!this.emitUncoveredLoci) {
            return false;
        }
        return this.lastReferenceSequence < this.referenceSequenceMask.getMaxSequenceIndex() || this.lastReferenceSequence == this.referenceSequenceMask.getMaxSequenceIndex() && this.lastPosition < this.referenceSequenceMask.nextPosition(this.lastReferenceSequence, this.lastPosition);
    }

    @Override
    public LocusInfo next() {
        while (this.complete.isEmpty() && this.samHasMore()) {
            SAMRecord rec = this.samIterator.peek();
            if (rec.getReferenceIndex() == -1) {
                this.finishedAlignedReads = true;
                continue;
            }
            if (rec.getReadUnmappedFlag() || rec.getMappingQuality() < this.mappingQualityScoreCutoff || !this.includeNonPfReads && rec.getReadFailsVendorQualityCheckFlag()) {
                this.samIterator.next();
                continue;
            }
            int start = rec.getAlignmentStart();
            if (this.includeIndels && start != 1 && SamLocusIterator.startWithInsertion(rec.getCigar())) {
                --start;
            }
            LocusImpl alignmentStart = new LocusImpl(rec.getReferenceIndex(), start);
            while (!this.accumulator.isEmpty() && this.locusComparator.compare(this.accumulator.get(0), alignmentStart) < 0) {
                LocusInfo first = this.accumulator.get(0);
                this.populateCompleteQueue(alignmentStart);
                if (!this.complete.isEmpty()) {
                    return this.complete.remove(0);
                }
                if (this.accumulator.isEmpty() || first != this.accumulator.get(0)) continue;
                throw new SAMException("Stuck in infinite loop");
            }
            if (!(this.accumulator.isEmpty() || this.accumulator.get(0).getSequenceIndex() == rec.getReferenceIndex().intValue() && this.accumulator.get(0).position == start)) {
                throw new IllegalStateException("accumulator should be empty or aligned with current SAMRecord");
            }
            if (!this.surpassedAccumulationThreshold()) {
                this.accumulateSamRecord(rec);
                if (this.includeIndels) {
                    this.accumulateIndels(rec);
                }
            }
            this.samIterator.next();
        }
        LocusImpl endLocus = new LocusImpl(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (this.complete.isEmpty() && !this.samHasMore()) {
            while (!this.accumulator.isEmpty()) {
                this.populateCompleteQueue(endLocus);
                if (this.complete.isEmpty()) continue;
                return this.complete.remove(0);
            }
        }
        if (!this.complete.isEmpty()) {
            return this.complete.remove(0);
        }
        if (this.emitUncoveredLoci) {
            LocusImpl afterLastMaskPositionLocus = new LocusImpl(this.referenceSequenceMask.getMaxSequenceIndex(), this.referenceSequenceMask.getMaxPosition() + 1);
            return this.createNextUncoveredLocusInfo(afterLastMaskPositionLocus);
        }
        return null;
    }

    private boolean surpassedAccumulationThreshold() {
        boolean surpassesThreshold;
        boolean bl = surpassesThreshold = !this.accumulator.isEmpty() && this.accumulator.get(0).recordAndOffsets.size() >= this.maxReadsToAccumulatePerLocus;
        if (surpassesThreshold && !this.enforcedAccumulationLimit) {
            LOG.warn("We have encountered greater than " + this.maxReadsToAccumulatePerLocus + " reads at position " + this.accumulator.get(0).toString() + " and will ignore the remaining reads at this position.  Note that further warnings will be suppressed.");
            this.enforcedAccumulationLimit = true;
        }
        return surpassesThreshold;
    }

    private static boolean startWithInsertion(Cigar cigar) {
        for (CigarElement element : cigar.getCigarElements()) {
            if (element.getOperator() == CigarOperator.I) {
                return true;
            }
            if (!element.getOperator().consumesReferenceBases()) continue;
        }
        return false;
    }

    private void accumulateSamRecord(SAMRecord rec) {
        int accOffset = this.getAccumulatorOffset(rec);
        int minQuality = this.getQualityScoreCutoff();
        boolean dontCheckQualities = minQuality == 0;
        byte[] baseQualities = dontCheckQualities ? null : rec.getBaseQualities();
        for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
            int readStart = alignmentBlock.getReadStart();
            int refStart = alignmentBlock.getReferenceStart();
            int blockLength = alignmentBlock.getLength();
            for (int i = 0; i < blockLength; ++i) {
                int readOffset = readStart + i - 1;
                if (!dontCheckQualities && baseQualities.length != 0 && baseQualities[readOffset] < minQuality) continue;
                int refOffset = refStart + i - accOffset;
                this.accumulator.get(refOffset).add(rec, readOffset);
            }
        }
    }

    private void accumulateIndels(SAMRecord rec) {
        List<CigarElement> cigar = rec.getCigar().getCigarElements();
        int readBase = 0;
        int refBase = rec.getAlignmentStart() - this.getAccumulatorOffset(rec);
        for (int elementIndex = 0; elementIndex < cigar.size(); ++elementIndex) {
            CigarElement e = cigar.get(elementIndex);
            CigarOperator operator = e.getOperator();
            if (operator.equals((Object)CigarOperator.I)) {
                System.err.println("");
                this.accumulator.get(refBase - 1).addInserted(rec, readBase);
                readBase += e.getLength();
                continue;
            }
            if (operator.equals((Object)CigarOperator.D)) {
                for (int i = 0; i < e.getLength(); ++i) {
                    this.accumulator.get(refBase + i).addDeleted(rec, readBase - 1);
                }
                refBase += e.getLength();
                continue;
            }
            if (operator.consumesReadBases()) {
                readBase += e.getLength();
            }
            if (!operator.consumesReferenceBases()) continue;
            refBase += e.getLength();
        }
    }

    private LocusInfo createNextUncoveredLocusInfo(Locus stopBeforeLocus) {
        while (this.lastReferenceSequence <= stopBeforeLocus.getSequenceIndex() && this.lastReferenceSequence <= this.referenceSequenceMask.getMaxSequenceIndex()) {
            if (this.lastReferenceSequence == stopBeforeLocus.getSequenceIndex() && this.lastPosition + 1 >= stopBeforeLocus.getPosition()) {
                return null;
            }
            int nextbit = this.referenceSequenceMask.nextPosition(this.lastReferenceSequence, this.lastPosition);
            if (nextbit == -1) {
                if (this.lastReferenceSequence == stopBeforeLocus.getSequenceIndex()) {
                    this.lastPosition = stopBeforeLocus.getPosition();
                    return null;
                }
                ++this.lastReferenceSequence;
                this.lastPosition = 0;
                continue;
            }
            if (this.lastReferenceSequence < stopBeforeLocus.getSequenceIndex() || nextbit < stopBeforeLocus.getPosition()) {
                this.lastPosition = nextbit;
                return new LocusInfo(this.getReferenceSequence(this.lastReferenceSequence), this.lastPosition);
            }
            if (nextbit < stopBeforeLocus.getPosition()) continue;
            return null;
        }
        return null;
    }

    private void populateCompleteQueue(Locus stopBeforeLocus) {
        LocusInfo zeroCoverage;
        while (!this.accumulator.isEmpty() && this.accumulator.get(0).isEmpty() && this.locusComparator.compare(this.accumulator.get(0), stopBeforeLocus) < 0) {
            this.accumulator.remove(0);
        }
        if (this.accumulator.isEmpty()) {
            return;
        }
        LocusInfo locusInfo = this.accumulator.get(0);
        if (this.locusComparator.compare(stopBeforeLocus, locusInfo) <= 0) {
            return;
        }
        if (this.emitUncoveredLoci && (zeroCoverage = this.createNextUncoveredLocusInfo(locusInfo)) != null) {
            this.complete.add(zeroCoverage);
            return;
        }
        this.accumulator.remove(0);
        int sequenceIndex = locusInfo.getSequenceIndex();
        if (this.referenceSequenceMask.get(locusInfo.getSequenceIndex(), locusInfo.getPosition())) {
            this.complete.add(locusInfo);
        }
        this.lastReferenceSequence = sequenceIndex;
        this.lastPosition = locusInfo.getPosition();
    }

    private int getAccumulatorOffset(SAMRecord rec) {
        int insOffset;
        SAMSequenceRecord ref = this.getReferenceSequence(rec.getReferenceIndex());
        int alignmentStart = rec.getAlignmentStart();
        int alignmentEnd = rec.getAlignmentEnd();
        int alignmentLength = alignmentEnd - alignmentStart;
        int n = insOffset = this.includeIndels && SamLocusIterator.startWithInsertion(rec.getCigar()) ? 1 : 0;
        if (insOffset == 1 && this.accumulator.isEmpty()) {
            this.accumulator.add(new LocusInfo(ref, alignmentStart - 1));
        }
        for (int i = this.accumulator.size(); i <= alignmentLength + insOffset; ++i) {
            this.accumulator.add(new LocusInfo(ref, alignmentStart + i - insOffset));
        }
        return alignmentStart - insOffset;
    }

    private SAMSequenceRecord getReferenceSequence(int referenceSequenceIndex) {
        return this.samReader.getFileHeader().getSequence(referenceSequenceIndex);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    public void setSamFilters(List<SamRecordFilter> samFilters) {
        this.samFilters = samFilters;
    }

    public int getQualityScoreCutoff() {
        return this.qualityScoreCutoff;
    }

    public void setQualityScoreCutoff(int qualityScoreCutoff) {
        this.qualityScoreCutoff = qualityScoreCutoff;
    }

    public int getMappingQualityScoreCutoff() {
        return this.mappingQualityScoreCutoff;
    }

    public void setMappingQualityScoreCutoff(int mappingQualityScoreCutoff) {
        this.mappingQualityScoreCutoff = mappingQualityScoreCutoff;
    }

    public boolean isIncludeNonPfReads() {
        return this.includeNonPfReads;
    }

    public void setIncludeNonPfReads(boolean includeNonPfReads) {
        this.includeNonPfReads = includeNonPfReads;
    }

    public boolean isEmitUncoveredLoci() {
        return this.emitUncoveredLoci;
    }

    public void setEmitUncoveredLoci(boolean emitUncoveredLoci) {
        this.emitUncoveredLoci = emitUncoveredLoci;
    }

    public int getMaxReadsToAccumulatePerLocus() {
        return this.maxReadsToAccumulatePerLocus;
    }

    public void setMaxReadsToAccumulatePerLocus(int maxReadsToAccumulatePerLocus) {
        this.maxReadsToAccumulatePerLocus = maxReadsToAccumulatePerLocus;
    }

    public boolean isIncludeIndels() {
        return this.includeIndels;
    }

    public void setIncludeIndels(boolean includeIndels) {
        this.includeIndels = includeIndels;
    }

    public static final class LocusInfo
    implements Locus {
        private final SAMSequenceRecord referenceSequence;
        private final int position;
        private final List<RecordAndOffset> recordAndOffsets = new ArrayList<RecordAndOffset>(100);
        private List<RecordAndOffset> deletedInRecord = null;
        private List<RecordAndOffset> insertedInRecord = null;

        LocusInfo(SAMSequenceRecord referenceSequence, int position) {
            this.referenceSequence = referenceSequence;
            this.position = position;
        }

        public void add(SAMRecord read, int position) {
            this.recordAndOffsets.add(new RecordAndOffset(read, position));
        }

        public void addDeleted(SAMRecord read, int previousPosition) {
            if (this.deletedInRecord == null) {
                this.deletedInRecord = new ArrayList<RecordAndOffset>();
            }
            this.deletedInRecord.add(new RecordAndOffset(read, previousPosition));
        }

        public void addInserted(SAMRecord read, int firstPosition) {
            if (this.insertedInRecord == null) {
                this.insertedInRecord = new ArrayList<RecordAndOffset>();
            }
            this.insertedInRecord.add(new RecordAndOffset(read, firstPosition));
        }

        @Override
        public int getSequenceIndex() {
            return this.referenceSequence.getSequenceIndex();
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        public List<RecordAndOffset> getRecordAndPositions() {
            return Collections.unmodifiableList(this.recordAndOffsets);
        }

        public String getSequenceName() {
            return this.referenceSequence.getSequenceName();
        }

        public String toString() {
            return this.referenceSequence.getSequenceName() + ":" + this.position;
        }

        public int getSequenceLength() {
            return this.referenceSequence.getSequenceLength();
        }

        public List<RecordAndOffset> getDeletedInRecord() {
            return this.deletedInRecord == null ? Collections.emptyList() : Collections.unmodifiableList(this.deletedInRecord);
        }

        public List<RecordAndOffset> getInsertedInRecord() {
            return this.insertedInRecord == null ? Collections.emptyList() : Collections.unmodifiableList(this.insertedInRecord);
        }

        public boolean isEmpty() {
            return !(!this.recordAndOffsets.isEmpty() || this.deletedInRecord != null && !this.deletedInRecord.isEmpty() || this.insertedInRecord != null && !this.insertedInRecord.isEmpty());
        }
    }

    public static class RecordAndOffset {
        private final SAMRecord record;
        private final int offset;

        public RecordAndOffset(SAMRecord record, int offset) {
            this.offset = offset;
            this.record = record;
        }

        public int getOffset() {
            return this.offset;
        }

        public SAMRecord getRecord() {
            return this.record;
        }

        public byte getReadBase() {
            return this.record.getReadBases()[this.offset];
        }

        public byte getBaseQuality() {
            return this.record.getBaseQualities()[this.offset];
        }
    }
}

