/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantJEXLContext;
import java.util.HashMap;
import java.util.Map;

public class GenotypeJEXLContext
extends VariantJEXLContext {
    private Genotype g;
    private static Map<String, AttributeGetter> attributes = new HashMap<String, AttributeGetter>();

    public GenotypeJEXLContext(VariantContext vc, Genotype g) {
        super(vc);
        this.g = g;
    }

    @Override
    public Object get(String name) {
        if (attributes.containsKey(name)) {
            return attributes.get(name).get(this.g);
        }
        if (this.g.hasAnyAttribute(name)) {
            return this.g.getAnyAttribute(name);
        }
        if (this.g.getFilters().contains(name)) {
            return "1";
        }
        return super.get(name);
    }

    static {
        attributes.put("g", g -> g);
        attributes.put("GT", Genotype::getGenotypeString);
        attributes.put("isHom", g -> g.isHom() ? "1" : "0");
        attributes.put("isHomRef", g -> g.isHomRef() ? "1" : "0");
        attributes.put("isHet", g -> g.isHet() ? "1" : "0");
        attributes.put("isHomVar", g -> g.isHomVar() ? "1" : "0");
        attributes.put("isCalled", g -> g.isCalled() ? "1" : "0");
        attributes.put("isNoCall", g -> g.isNoCall() ? "1" : "0");
        attributes.put("isMixed", g -> g.isMixed() ? "1" : "0");
        attributes.put("isAvailable", g -> g.isAvailable() ? "1" : "0");
        attributes.put("isPassFT", g -> g.isFiltered() ? "0" : "1");
        attributes.put("FT", g -> g.isFiltered() ? g.getFilters() : "PASS");
        attributes.put("GQ", Genotype::getGQ);
    }

    private static interface AttributeGetter {
        public Object get(Genotype var1);
    }
}

