/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.AbstractGenericSVGHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.pdf.PDFRendererContextConstants;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFBridgeContext;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.fop.util.QName;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;

public class PDFSVGHandler
extends AbstractGenericSVGHandler
implements PDFRendererContextConstants {
    private static Log log = LogFactory.getLog(class$org$apache$fop$render$pdf$PDFSVGHandler == null ? (class$org$apache$fop$render$pdf$PDFSVGHandler = PDFSVGHandler.class$("org.apache.fop.render.pdf.PDFSVGHandler")) : class$org$apache$fop$render$pdf$PDFSVGHandler);
    static /* synthetic */ Class class$org$apache$fop$render$pdf$PDFSVGHandler;

    public static PDFInfo getPDFInfo(RendererContext context) {
        PDFInfo pdfi = new PDFInfo();
        pdfi.pdfDoc = (PDFDocument)context.getProperty("pdfDoc");
        pdfi.outputStream = (OutputStream)context.getProperty("outputStream");
        pdfi.pdfState = (PDFState)context.getProperty("pdfState");
        pdfi.pdfPage = (PDFPage)context.getProperty("pdfPage");
        pdfi.pdfContext = (PDFResourceContext)context.getProperty("pdfContext");
        pdfi.currentStream = (PDFStream)context.getProperty("pdfStream");
        pdfi.width = (Integer)context.getProperty("width");
        pdfi.height = (Integer)context.getProperty("height");
        pdfi.fi = (FontInfo)context.getProperty("fontInfo");
        pdfi.currentFontName = (String)context.getProperty("fontName");
        pdfi.currentFontSize = (Integer)context.getProperty("fontSize");
        pdfi.currentXPosition = (Integer)context.getProperty("xpos");
        pdfi.currentYPosition = (Integer)context.getProperty("ypos");
        pdfi.cfg = (Configuration)context.getProperty("cfg");
        Map foreign = (Map)context.getProperty("foreign-attributes");
        QName qName = new QName("http://xmlgraphics.apache.org/fop/extensions", null, "conversion-mode");
        if (foreign != null && "bitmap".equalsIgnoreCase((String)foreign.get(qName))) {
            pdfi.paintAsBitmap = true;
        }
        return pdfi;
    }

    protected void renderSVGDocument(RendererContext context, Document doc) {
        GraphicsNode root;
        PDFRenderer renderer = (PDFRenderer)context.getRenderer();
        PDFInfo pdfInfo = PDFSVGHandler.getPDFInfo(context);
        if (pdfInfo.paintAsBitmap) {
            try {
                super.renderSVGDocument(context, doc);
            }
            catch (IOException ioe) {
                log.error("I/O error while rendering SVG graphic: " + ioe.getMessage(), ioe);
            }
            return;
        }
        int xOffset = pdfInfo.currentXPosition;
        int yOffset = pdfInfo.currentYPosition;
        log.debug("Generating SVG at " + context.getUserAgent().getTargetResolution() + "dpi.");
        float deviceResolution = context.getUserAgent().getTargetResolution();
        float uaResolution = context.getUserAgent().getSourceResolution();
        SVGUserAgent ua = new SVGUserAgent(25.4f / uaResolution, new AffineTransform());
        double s = uaResolution / deviceResolution;
        AffineTransform resolutionScaling = new AffineTransform();
        resolutionScaling.scale(s, s);
        GVTBuilder builder = new GVTBuilder();
        boolean strokeText = false;
        Configuration cfg = pdfInfo.cfg;
        if (cfg != null) {
            strokeText = cfg.getChild("stroke-text", true).getValueAsBoolean(strokeText);
        }
        PDFBridgeContext ctx = new PDFBridgeContext((UserAgent)ua, strokeText ? null : pdfInfo.fi, new AffineTransform());
        try {
            root = builder.build((BridgeContext)ctx, doc);
            builder = null;
        }
        catch (Exception e) {
            log.error("svg graphic could not be built: " + e.getMessage(), e);
            return;
        }
        float w = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
        float h = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
        float sx = (float)pdfInfo.width / w;
        float sy = (float)pdfInfo.height / h;
        AffineTransform scaling = new AffineTransform(sx, 0.0f, 0.0f, sy, (float)xOffset / 1000.0f, (float)yOffset / 1000.0f);
        AffineTransform imageTransform = new AffineTransform();
        imageTransform.concatenate(scaling);
        imageTransform.concatenate(resolutionScaling);
        pdfInfo.currentStream.add("%SVG setup\n");
        renderer.saveGraphicsState();
        renderer.setColor(Color.black, false, null);
        renderer.setColor(Color.black, true, null);
        if (!scaling.isIdentity()) {
            pdfInfo.currentStream.add("%viewbox\n");
            pdfInfo.currentStream.add(CTMHelper.toPDFString(scaling, false) + " cm\n");
        }
        if (pdfInfo.pdfContext == null) {
            pdfInfo.pdfContext = pdfInfo.pdfPage;
        }
        PDFGraphics2D graphics = new PDFGraphics2D(true, pdfInfo.fi, pdfInfo.pdfDoc, pdfInfo.pdfContext, pdfInfo.pdfPage.referencePDF(), pdfInfo.currentFontName, pdfInfo.currentFontSize);
        graphics.setGraphicContext(new GraphicContext());
        if (!resolutionScaling.isIdentity()) {
            pdfInfo.currentStream.add("%resolution scaling for " + uaResolution + " -> " + deviceResolution + "\n");
            pdfInfo.currentStream.add(CTMHelper.toPDFString(resolutionScaling, false) + " cm\n");
            graphics.scale(1.0 / s, 1.0 / s);
        }
        pdfInfo.currentStream.add("%SVG start\n");
        pdfInfo.pdfState.push();
        pdfInfo.pdfState.concatenate(imageTransform);
        PDFAElementBridge aBridge = (PDFAElementBridge)ctx.getBridge("http://www.w3.org/2000/svg", "a");
        aBridge.getCurrentTransform().setTransform(pdfInfo.pdfState.getTransform());
        graphics.setPDFState(pdfInfo.pdfState);
        graphics.setOutputStream(pdfInfo.outputStream);
        try {
            root.paint(graphics);
            pdfInfo.currentStream.add(graphics.getString());
        }
        catch (Exception e) {
            log.error("svg graphic could not be rendered: " + e.getMessage(), e);
        }
        pdfInfo.pdfState.pop();
        renderer.restoreGraphicsState();
        pdfInfo.currentStream.add("%SVG end\n");
    }

    public boolean supportsRenderer(Renderer renderer) {
        return renderer instanceof PDFRenderer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PDFInfo {
        public PDFDocument pdfDoc;
        public OutputStream outputStream;
        public PDFState pdfState;
        public PDFPage pdfPage;
        public PDFResourceContext pdfContext;
        public PDFStream currentStream;
        public int width;
        public int height;
        public FontInfo fi;
        public String currentFontName;
        public int currentFontSize;
        public int currentXPosition;
        public int currentYPosition;
        public Configuration cfg;
        public boolean paintAsBitmap;
    }
}

