/*
 * Decompiled with CFR 0.152.
 */
package projects.dimont.hts;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.ToolBox;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.OperationNotSupportedException;

public enum HTS_KmerRanking {
    Z_SCORE,
    DIMONT_SCORE,
    WEIGHTED_FREQUENCY;


    static ComparableElement<String, Double>[] compute(int k, DataSet data, double[] weights, HTS_KmerRanking type) throws Exception {
        ComparableElement[] kmersWithWeights;
        block9: {
            Iterator<Map.Entry<String, double[]>> it;
            block10: {
                block8: {
                    Sequence seq;
                    kmersWithWeights = null;
                    if (type != Z_SCORE) break block8;
                    HomogeneousMM hmm = TrainableStatisticalModelFactory.createHomogeneousMarkovModel(data.getAlphabetContainer(), 4.0, (byte)2);
                    hmm.train(data);
                    Hashtable<String, Double> weightedKmerCounts = new Hashtable<String, Double>();
                    String[] s = new String[2];
                    int n = 0;
                    while (n < weights.length) {
                        if (weights[n] != 0.0) {
                            seq = data.getElementAt(n);
                            s[0] = seq.toString();
                            s[1] = seq.reverseComplement().toString();
                            int lastStart = seq.getLength() - k;
                            int startPosition = 0;
                            while (startPosition <= lastStart) {
                                String revComplKmer;
                                String kmer = s[0].substring(startPosition, startPosition + k);
                                String string = kmer = kmer.compareTo(revComplKmer = s[1].substring(s[0].length() - k - startPosition, s[0].length() - startPosition)) < 0 ? kmer : revComplKmer;
                                if (!weightedKmerCounts.containsKey(kmer)) {
                                    weightedKmerCounts.put(kmer, weights[n]);
                                } else {
                                    weightedKmerCounts.put(kmer, (Double)weightedKmerCounts.get(kmer) + weights[n]);
                                }
                                ++startPosition;
                            }
                        }
                        ++n;
                    }
                    kmersWithWeights = new ComparableElement[weightedKmerCounts.size()];
                    Iterator it2 = weightedKmerCounts.entrySet().iterator();
                    double numberOfPatterns = ToolBox.sum(weights) * (double)(data.getElementAt(0).getLength() - k + 1);
                    int i = 0;
                    while (i < kmersWithWeights.length) {
                        Map.Entry weightedKmerCount = it2.next();
                        String key = (String)weightedKmerCount.getKey();
                        seq = Sequence.create(data.getAlphabetContainer(), key);
                        double value = (Double)weightedKmerCount.getValue();
                        double expectedValue_bg = numberOfPatterns * (Math.exp(hmm.getLogProbFor(seq)) + Math.exp(hmm.getLogProbFor(seq.reverseComplement())));
                        kmersWithWeights[i] = new ComparableElement<String, Double>(key, (value - expectedValue_bg) / Math.sqrt(expectedValue_bg));
                        ++i;
                    }
                    break block9;
                }
                Hashtable<String, double[]> weightedKmerCounts = HTS_KmerRanking.getWeightedKmerCounts(k, data, weights);
                kmersWithWeights = new ComparableElement[weightedKmerCounts.size()];
                it = weightedKmerCounts.entrySet().iterator();
                if (type != WEIGHTED_FREQUENCY) break block10;
                int i = 0;
                while (i < kmersWithWeights.length) {
                    Map.Entry<String, double[]> weightedKmerCount = it.next();
                    kmersWithWeights[i] = new ComparableElement<String, Double>(weightedKmerCount.getKey(), weightedKmerCount.getValue()[0]);
                    ++i;
                }
                break block9;
            }
            if (type != DIMONT_SCORE) break block9;
            int i = 0;
            while (i < kmersWithWeights.length) {
                Map.Entry<String, double[]> weightedKmerCount = it.next();
                double[] val = weightedKmerCount.getValue();
                kmersWithWeights[i] = new ComparableElement<String, Double>(weightedKmerCount.getKey(), Math.log(val[0] + 1.0) * (val[0] + 1.0) / (val[1] + 1.0));
                ++i;
            }
        }
        return kmersWithWeights;
    }

    private static Hashtable<String, double[]> getWeightedKmerCounts(int k, DataSet data, double[] weights) throws WrongAlphabetException, OperationNotSupportedException {
        AlphabetContainer con = data.getAlphabetContainer();
        if (!con.isSimple() || !con.isDiscrete()) {
            throw new WrongAlphabetException();
        }
        Hashtable<String, double[]> weightedKmerCounts = new Hashtable<String, double[]>();
        HashSet<String> kmersOfSingleSequence = new HashSet<String>();
        String[] s = new String[2];
        int n = 0;
        while (n < weights.length) {
            Sequence seq = data.getElementAt(n);
            s[0] = seq.toString();
            s[1] = seq.reverseComplement().toString();
            int lastStart = seq.getLength() - k;
            kmersOfSingleSequence.clear();
            int startPosition = 0;
            while (startPosition <= lastStart) {
                String revComplKmer;
                String kmer = s[0].substring(startPosition, startPosition + k);
                String string = kmer = kmer.compareTo(revComplKmer = s[1].substring(s[0].length() - k - startPosition, s[0].length() - startPosition)) < 0 ? kmer : revComplKmer;
                if (!kmersOfSingleSequence.contains(kmer)) {
                    kmersOfSingleSequence.add(kmer);
                }
                ++startPosition;
            }
            Iterator it = kmersOfSingleSequence.iterator();
            while (it.hasNext()) {
                s[0] = (String)it.next();
                if (weightedKmerCounts.containsKey(s[0])) {
                    double[] kmerCount = weightedKmerCounts.get(s[0]);
                    kmerCount[0] = kmerCount[0] + weights[n];
                    kmerCount[1] = kmerCount[1] + (1.0 - weights[n]);
                    continue;
                }
                weightedKmerCounts.put(s[0], new double[]{weights[n], 1.0 - weights[n]});
            }
            ++n;
        }
        return weightedKmerCounts;
    }
}

