/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DNaseBroadWindows {
    public static void main(String[] args) throws IOException {
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[0]));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(String.valueOf(args[0]) + "_bw" + args[1] + ".gz"));
        PrintWriter wr = new PrintWriter(os);
        int bins = Integer.parseInt(args[1]);
        double[] minProfile = new double[2 * bins + 1];
        double[] maxProfile = new double[2 * bins + 1];
        int end = 0;
        String str = null;
        while (true) {
            if ((str = reader.readLine()) == null || str.startsWith("[")) {
                if (end > 0) {
                    --end;
                }
                while (end > bins) {
                    double minVal = ToolBox.min(minProfile.length - end, minProfile.length, minProfile);
                    double maxVal = ToolBox.max(maxProfile.length - end, maxProfile.length, maxProfile);
                    double minBefore = ToolBox.min(minProfile.length - end, minProfile.length - end + bins, minProfile);
                    double minAfter = 0.0;
                    if (-end + bins + 1 < 0) {
                        minAfter = ToolBox.min(minProfile.length - end + bins + 1, minProfile.length, minProfile);
                    }
                    double maxBefore = ToolBox.max(maxProfile.length - end, maxProfile.length - end + bins, maxProfile);
                    double maxAfter = 0.0;
                    if (-end + bins + 1 < 0) {
                        maxAfter = ToolBox.max(maxProfile.length - end + bins + 1, maxProfile.length, maxProfile);
                    }
                    wr.println(String.valueOf(minVal) + "\t" + maxVal + "\t" + minBefore + "\t" + minAfter + "\t" + maxBefore + "\t" + maxAfter);
                    --end;
                }
                if (str == null) break;
                wr.println(str);
                Arrays.fill(minProfile, 0.0);
                Arrays.fill(maxProfile, 0.0);
                end = 0;
                continue;
            }
            String[] parts = str.split("\t");
            double min = Double.parseDouble(parts[0]);
            double max = Double.parseDouble(parts[2]);
            if (end < minProfile.length) {
                minProfile[end] = min;
                maxProfile[end] = max;
                ++end;
            } else {
                int i = 0;
                while (i < minProfile.length - 1) {
                    minProfile[i] = minProfile[i + 1];
                    maxProfile[i] = maxProfile[i + 1];
                    ++i;
                }
                minProfile[minProfile.length - 1] = min;
                maxProfile[maxProfile.length - 1] = max;
            }
            if (end <= bins) continue;
            double minVal = ToolBox.min(0, end, minProfile);
            double maxVal = ToolBox.max(0, end, maxProfile);
            double minBefore = 0.0;
            double minAfter = ToolBox.min(Math.min(bins, end - bins - 1) + 1, end, minProfile);
            if (end > bins + 1) {
                minBefore = ToolBox.min(0, Math.min(bins, end - bins - 1), minProfile);
            }
            double maxBefore = 0.0;
            double maxAfter = ToolBox.max(Math.min(bins, end - bins - 1) + 1, end, maxProfile);
            if (end > bins + 1) {
                maxBefore = ToolBox.max(0, Math.min(bins, end - bins - 1), maxProfile);
            }
            wr.println(String.valueOf(minVal) + "\t" + maxVal + "\t" + minBefore + "\t" + minAfter + "\t" + maxBefore + "\t" + maxAfter);
        }
        reader.close();
        wr.close();
    }
}

