/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma.JunitTest;

import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import projects.gemoma.AnnotationEvidence;
import projects.gemoma.AnnotationFinalizer;
import projects.gemoma.CheckIntrons;
import projects.gemoma.CompareTranscripts;
import projects.gemoma.DenoiseIntrons;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemoma.Extractor;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaAnnotationFilter;
import projects.gemoma.GeMoMaPipeline;

@RunWith(value=Parameterized.class)
public class GeMoMaJUnitTest {
    private JstacsTool tool;
    private ToolResult tr;
    private static Protocol protocol = new CLI.SysProtocol();
    private static ProgressUpdater progress = new ProgressUpdater();

    public GeMoMaJUnitTest(JstacsTool tool, ToolResult tr) {
        this.tool = tool;
        this.tr = tr;
    }

    public static ArrayList<Object[]> testCases() {
        int maxSize = -1;
        long timeOut = 3600L;
        long maxTimeOut = 604800L;
        JstacsTool[] jt = new JstacsTool[]{new GeMoMaPipeline(), new ExtractRNAseqEvidence(), new CheckIntrons(), new DenoiseIntrons(), new Extractor(maxSize), new GeMoMa(maxSize, timeOut, maxTimeOut), new GeMoMaAnnotationFilter(), new AnnotationFinalizer(), new AnnotationEvidence(), new CompareTranscripts()};
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        JstacsTool[] jstacsToolArray = jt;
        int n = jt.length;
        int n2 = 0;
        while (n2 < n) {
            JstacsTool t = jstacsToolArray[n2];
            ToolResult[] tr = t.getTestCases(".");
            if (tr != null) {
                int i = 0;
                while (i < tr.length) {
                    tests.add(new Object[]{t, tr[i]});
                    ++i;
                }
            }
            ++n2;
        }
        return tests;
    }

    @Test
    public void test() {
        int i = 0;
        while (i < 150) {
            protocol.append("=");
            ++i;
        }
        protocol.append("\n");
        protocol.append("Test for " + this.tr.getToolName() + "\n");
        boolean eq = false;
        try {
            this.tool.clear();
            eq = this.tr.equals(this.tool.run(this.tr.getToolParameters(), protocol, progress, 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)eq);
    }
}

