/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import projects.gemoma.Tools;

public class SAMRecordFilter {
    private int minQuality;
    private int positionsAroundSpliceSite;
    private int maxMismatches;
    private HashMap<String, String> genome;

    public SAMRecordFilter(int minQuality, int positionsAroundSpliceSite, int maxMismatches, String targetGenome) throws Exception {
        this.minQuality = minQuality;
        this.positionsAroundSpliceSite = positionsAroundSpliceSite;
        this.maxMismatches = maxMismatches;
        if (targetGenome != null) {
            this.genome = Tools.getFasta(targetGenome, 20, ".*");
        }
    }

    public boolean accept(SAMRecord read) {
        if (read.getMappingQuality() < this.minQuality) {
            return false;
        }
        List<AlignmentBlock> blockLi = read.getAlignmentBlocks();
        Iterator<AlignmentBlock> blockIt = blockLi.iterator();
        if (this.genome != null && blockLi.size() > 1) {
            String chr = this.genome.get(read.getReferenceName());
            String rs = read.getReadString();
            int nmm = 0;
            while (blockIt.hasNext()) {
                AlignmentBlock block = blockIt.next();
                int l = block.getLength();
                int c = block.getReferenceStart() - 1;
                int r = block.getReadStart() - 1;
                int i = 0;
                while (i < l / 2 && i < this.positionsAroundSpliceSite) {
                    if (chr.charAt(c + i) != rs.charAt(r + i)) {
                        ++nmm;
                    }
                    ++i;
                }
                i = l - 1;
                while (i >= l / 2 && i > l - this.positionsAroundSpliceSite - 1) {
                    if (chr.charAt(c + i) != rs.charAt(r + i)) {
                        ++nmm;
                    }
                    --i;
                }
            }
            if (nmm > this.maxMismatches) {
                return false;
            }
        }
        return true;
    }
}

