/*
 * Decompiled with CFR 0.152.
 */
package projects.gemorna;

import de.jstacs.utils.IntList;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMRecord;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import projects.gemoma.ReadStats;
import projects.gemorna.Genome;

public class ReadGraph {
    String chrom;
    int regionStart;
    private int minIntronLength;
    private int lastIdx;
    Node[] nodes;
    LinkedList<Edge> edges;

    public ReadGraph(String chrom, int regionStart, int regionEnd, int minIntronLength) {
        this.chrom = chrom;
        this.regionStart = regionStart;
        this.nodes = new Node[regionEnd - regionStart + 1];
        int i = 0;
        while (i < this.nodes.length) {
            this.nodes[i] = new Node();
            ++i;
        }
        this.edges = new LinkedList();
        this.minIntronLength = minIntronLength;
    }

    public void finalizeGaps(int maximumGapFilled) {
        int nzero = -1;
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i].getNumberOfReads() > 0 || this.nodes[i].getNumberOfIncomingEdges() > 0 || this.nodes[i].getNumberOfOutgoingEdges() > 0) {
                if (nzero > 0 && nzero < maximumGapFilled) {
                    Edge e;
                    int j = i - nzero;
                    while (j < i) {
                        Edge e2;
                        Node node = this.nodes[j];
                        node.nReads = node.nReads + 1;
                        Node node2 = this.nodes[j];
                        node2.nDummy = node2.nDummy + 1;
                        Edge edge = e2 = this.nodes[j].addOutgoing(j, j + 1, this.edges, this.nodes);
                        edge.nReads = edge.nReads + 1;
                        ++j;
                    }
                    Edge edge = e = this.nodes[i - nzero - 1].addOutgoing(i - nzero - 1, i - nzero, this.edges, this.nodes);
                    edge.nReads = edge.nReads + 1;
                }
                nzero = 0;
            } else if (nzero >= 0) {
                ++nzero;
            }
            ++i;
        }
    }

    public void condense() {
        int off = 0;
        while (this.nodes[off].nOut == 0 && this.nodes[off].nIn == 0) {
            ++off;
        }
        int end = this.nodes.length - 1;
        while (this.nodes[end].nIn == 0 && this.nodes[end].nOut == 0) {
            --end;
        }
        if ((double)off > (double)this.nodes.length * 0.5 || (double)end < (double)this.nodes.length * 0.5) {
            Node[] temp = new Node[end - off + 1];
            System.arraycopy(this.nodes, off, temp, 0, temp.length);
            this.nodes = temp;
            this.regionStart += off;
            Iterator iterator = this.edges.iterator();
            while (iterator.hasNext()) {
                Edge e;
                Edge edge = e = (Edge)iterator.next();
                edge.relStart = edge.relStart - off;
                Edge edge2 = e;
                edge2.relEnd = edge2.relEnd - off;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Edge e : this.edges) {
            if (e.getLength() <= 1) continue;
            sb.append(String.valueOf(e.toString(this.regionStart)) + "\n");
        }
        int i = 0;
        while (i < this.nodes.length) {
            sb.append("node" + i + ": " + this.nodes[i].nReads + " (" + this.nodes[i].nDummy + ") {");
            for (Edge edge : this.nodes[i].getOutgoingEdges()) {
                sb.append(String.valueOf(edge.toString(this.regionStart)) + ", ");
            }
            sb.append("}\n");
            ++i;
        }
        return sb.toString();
    }

    public void addRead(SAMRecord read, int maxMM) {
        int i;
        AlignmentBlock block;
        boolean isDummy = "dummy".equals(read.getReadName());
        List<AlignmentBlock> blockLi = read.getAlignmentBlocks();
        Iterator<AlignmentBlock> blockIt = blockLi.iterator();
        if (blockLi.size() > 1) {
            char[] chr = Genome.genome.getChromosome(this.chrom);
            char[] rs = read.getReadString().toCharArray();
            int nmm = 0;
            while (blockIt.hasNext()) {
                block = blockIt.next();
                int l = block.getLength();
                int c = block.getReferenceStart() - 1;
                int r = block.getReadStart() - 1;
                i = 0;
                while (i < l / 2 && i < 10) {
                    if (chr[c + i] != rs[r + i]) {
                        ++nmm;
                    }
                    ++i;
                }
                i = l - 1;
                while (i >= l / 2 && i > l - 11) {
                    if (chr[c + i] != rs[r + i]) {
                        ++nmm;
                    }
                    --i;
                }
            }
            if (nmm > maxMM) {
                return;
            }
            blockIt = blockLi.iterator();
        }
        Cigar cigar = read.getCigar();
        Iterator<CigarElement> cigIt = cigar.getCigarElements().iterator();
        int lastRelEnd = -1;
        while (blockIt.hasNext()) {
            block = blockIt.next();
            CigarElement el = cigIt.next();
            CigarElement prev = null;
            while (el.getLength() != block.getLength() || !el.getOperator().isAlignment()) {
                prev = el;
                el = cigIt.next();
            }
            int relStart = block.getReferenceStart() - this.regionStart;
            if (lastRelEnd > -1) {
                boolean isSplit = true;
                if (relStart != lastRelEnd + 1) {
                    boolean bl = isSplit = prev.getOperator().isIndelOrSkippedRegion() && !prev.getOperator().isIndel();
                }
                if (relStart - lastRelEnd < this.minIntronLength || !isSplit) {
                    int i2 = lastRelEnd + 1;
                    while (i2 <= relStart) {
                        Edge e;
                        Edge edge = e = this.nodes[i2 - 1].addOutgoing(i2 - 1, i2, this.edges, this.nodes);
                        edge.nReads = edge.nReads + 1;
                        ++i2;
                    }
                } else {
                    Edge e;
                    Edge edge = e = this.nodes[lastRelEnd].addOutgoing(lastRelEnd, relStart, this.edges, this.nodes);
                    edge.nReads = edge.nReads + 1;
                }
            }
            i = 0;
            while (i < block.getLength()) {
                Node node = this.nodes[relStart + i];
                node.nReads = node.nReads + 1;
                if (isDummy) {
                    Node node2 = this.nodes[relStart + i];
                    node2.nDummy = node2.nDummy + 1;
                }
                if (i > 0) {
                    Edge e;
                    Edge edge = e = this.nodes[relStart + i - 1].addOutgoing(relStart + i - 1, relStart + i, this.edges, this.nodes);
                    edge.nReads = edge.nReads + 1;
                }
                ++i;
            }
            lastRelEnd = relStart + block.getLength() - 1;
        }
    }

    private void remove(Collection<Edge> toRemove) {
        for (Edge e : toRemove) {
            int start = e.relStart;
            int end = e.relEnd;
            this.nodes[start].removeOutgoing(end);
            this.nodes[end].removeIncoming(start);
        }
        this.edges.removeAll(toRemove);
    }

    public void pruneByAbsoluteNumberOfReads(double minNum, boolean onlyIntrons) {
        Iterator it = this.edges.iterator();
        LinkedList<Edge> toRemove = new LinkedList<Edge>();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (onlyIntrons && e.getLength() < this.minIntronLength || !((double)e.getNumberOfReads() < minNum)) continue;
            toRemove.add(e);
        }
        this.remove(toRemove);
    }

    public void pruneBySplitLength(ReadStats stats) {
        Iterator it = this.edges.iterator();
        LinkedList<Edge> toRemove = new LinkedList<Edge>();
        while (it.hasNext()) {
            int num;
            Edge e = (Edge)it.next();
            int start = e.relStart;
            int end = e.relEnd;
            if (stats.isOK(end - start + 1, num = e.getNumberOfReads())) continue;
            toRemove.add(e);
        }
        this.remove(toRemove);
    }

    public void pruneByRelativeNumberOfReads(double percent, boolean onlyIntrons) {
        Iterator it = this.edges.iterator();
        LinkedList<Edge> toRemove = new LinkedList<Edge>();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            int start = e.relStart;
            int end = e.relEnd;
            double maxNum = Math.max(this.nodes[start].getNumberOfReads(), this.nodes[end].getNumberOfReads());
            if (onlyIntrons && e.getLength() < this.minIntronLength || !((double)e.getNumberOfReads() < maxNum * percent)) continue;
            toRemove.add(e);
        }
        this.remove(toRemove);
    }

    public void pruneAlternativeIntronsLong(int maxDist) {
        Iterator it = this.edges.iterator();
        LinkedList<Edge> toRemove = new LinkedList<Edge>();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (e.getLength() < this.minIntronLength) continue;
            int max = 0;
            int start = e.relStart;
            int i = Math.max(0, start - maxDist);
            while (i < Math.min(this.nodes.length, start + maxDist)) {
                for (Edge second : this.nodes[i].getOutgoingEdges()) {
                    if (second.relEnd != e.relEnd || second.nReads <= max) continue;
                    max = second.nReads;
                }
                ++i;
            }
            int end = e.relEnd;
            int i2 = Math.max(0, end - maxDist);
            while (i2 < Math.min(this.nodes.length, end + maxDist)) {
                for (Edge second : this.nodes[i2].getIncomingEdges()) {
                    if (second.relStart != e.relStart || second.nReads <= max) continue;
                    max = second.nReads;
                }
                ++i2;
            }
            if (e.nReads * 5 >= max) continue;
            toRemove.add(e);
        }
        this.remove(toRemove);
    }

    public int[] proposeSplitByCoverageOnly(int minTranscriptLength, int minExonSize) {
        double[] covBefore = new double[this.nodes.length];
        double[] covAfter = new double[this.nodes.length];
        double[] nBefore = new double[this.nodes.length];
        double[] nAfter = new double[this.nodes.length];
        int i = 0;
        while (i < this.nodes.length) {
            double n = 0.0;
            for (Edge edge : this.nodes[i].getIncomingEdges()) {
                int s = edge.relStart;
                n += (double)edge.getNumberOfReads();
                int n2 = i;
                covBefore[n2] = covBefore[n2] + (covBefore[s] + (double)this.nodes[s].getNumberOfReads()) * (double)edge.getNumberOfReads();
                int n3 = i;
                nBefore[n3] = nBefore[n3] + (nBefore[s] + 1.0) * (double)edge.getNumberOfReads();
            }
            if (n > 0.0) {
                int n4 = i;
                covBefore[n4] = covBefore[n4] / n;
                int n5 = i;
                nBefore[n5] = nBefore[n5] / n;
            }
            ++i;
        }
        i = this.nodes.length - 1;
        while (i >= 0) {
            int n = 0;
            for (Edge e : this.nodes[i].getOutgoingEdges()) {
                int s = e.relEnd;
                n += e.getNumberOfReads();
                int n6 = i;
                covAfter[n6] = covAfter[n6] + (covAfter[s] + (double)this.nodes[s].getNumberOfReads()) * (double)e.getNumberOfReads();
                int n7 = i;
                nAfter[n7] = nAfter[n7] + (nAfter[s] + 1.0) * (double)e.getNumberOfReads();
            }
            if (n > 0) {
                int n8 = i;
                covAfter[n8] = covAfter[n8] / (double)n;
                int n9 = i;
                nAfter[n9] = nAfter[n9] / (double)n;
            }
            --i;
        }
        i = 0;
        while (i < this.nodes.length) {
            if (nBefore[i] > 0.0) {
                int n = i;
                covBefore[n] = covBefore[n] / nBefore[i];
            }
            if (nAfter[i] > 0.0) {
                int n = i;
                covAfter[n] = covAfter[n] / nAfter[i];
            }
            ++i;
        }
        double[] sliwin = new double[this.nodes.length];
        int l = 50;
        sliwin[0] = 0.0;
        int i2 = 0;
        while (i2 < Math.min(this.nodes.length, l)) {
            sliwin[0] = sliwin[0] + (double)this.nodes[i2].getNumberOfReads();
            ++i2;
        }
        int i3 = 1;
        while (i3 < this.nodes.length) {
            int n = Math.max(0, i3 - l);
            int le = Math.min(this.nodes.length - 1, i3 + l - 1);
            sliwin[i3] = sliwin[i3 - 1];
            if (n - 1 >= 0) {
                int n10 = i3;
                sliwin[n10] = sliwin[n10] - (double)this.nodes[n - 1].getNumberOfReads();
            }
            if (le <= this.nodes.length - 1) {
                int n11 = i3;
                sliwin[n11] = sliwin[n11] + (double)this.nodes[le].getNumberOfReads();
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.nodes.length) {
            int n = Math.max(0, i3 - l);
            int le = Math.min(this.nodes.length - 1, i3 + l - 1);
            int n12 = i3;
            sliwin[n12] = sliwin[n12] / (double)(le - n + 1);
            int n13 = i3;
            sliwin[n13] = sliwin[n13] - (double)(i3 * (this.nodes.length - i3)) / (double)(this.nodes.length * this.nodes.length);
            ++i3;
        }
        int start = 0;
        boolean bl = false;
        IntList locs = new IntList();
        int i32 = 0;
        while (i32 < this.nodes.length) {
            int n;
            if (this.nodes[i32].getNumberOfOutgoingEdges() == 1 && this.nodes[i32].getOutgoingEdges().iterator().next().getRelEnd() == i32 + 1 && this.nodes[i32 + 1].getNumberOfIncomingEdges() == 1) {
                n = i32;
            } else {
                if (start > minTranscriptLength && this.nodes.length - n > minTranscriptLength && this.nodes[i32].getNumberOfIncomingEdges() > 0 && this.nodes[i32].getNumberOfOutgoingEdges() > 0) {
                    int[] regCov = new int[n - start + 1];
                    int cov = 0;
                    int j = start;
                    while (j <= n) {
                        regCov[j - start] = cov += this.nodes[j].getNumberOfReads();
                        ++j;
                    }
                    double locMinCoverage = Double.POSITIVE_INFINITY;
                    int locMinCoverageIdx = -1;
                    int j2 = start + minExonSize;
                    while (j2 < n - minExonSize) {
                        double covBeforeLoc = covBefore[j2];
                        double covAfterLoc = covAfter[j2];
                        double covLocal = sliwin[j2];
                        if (covBeforeLoc > 0.0 && covAfterLoc > 0.0 && (Math.abs(Math.log(covBeforeLoc) - Math.log(covAfterLoc)) / Math.log(2.0) > 2.0 && covLocal * 2.0 < Math.min(covBeforeLoc, covAfterLoc) || covLocal / Math.min(covBeforeLoc, covAfterLoc) < 0.2) && covLocal / Math.min(covBeforeLoc, covAfterLoc) < locMinCoverage) {
                            locMinCoverageIdx = j2;
                            locMinCoverage = covLocal / Math.min(covBeforeLoc, covAfterLoc);
                        }
                        ++j2;
                    }
                    if (locMinCoverageIdx > -1) {
                        locs.add(locMinCoverageIdx + this.regionStart);
                    }
                }
                start = i32;
                n = i32;
            }
            ++i32;
        }
        int[] temp = locs.toArray();
        Arrays.sort(temp);
        return temp;
    }

    private static double[] sliwin(int l, int[] cov) {
        int le;
        int ls;
        double[] sliwin = new double[cov.length];
        sliwin[0] = 0.0;
        int i = 0;
        while (i < Math.min(cov.length, l)) {
            sliwin[0] = sliwin[0] + (double)cov[i];
            ++i;
        }
        i = 1;
        while (i < cov.length) {
            ls = Math.max(0, i - l);
            le = Math.min(cov.length - 1, i + l - 1);
            sliwin[i] = sliwin[i - 1];
            if (ls - 1 >= 0) {
                int n = i;
                sliwin[n] = sliwin[n] - (double)cov[ls - 1];
            }
            if (le <= cov.length - 1) {
                int n = i;
                sliwin[n] = sliwin[n] + (double)cov[le];
            }
            ++i;
        }
        i = 0;
        while (i < cov.length) {
            ls = Math.max(0, i - l);
            le = Math.min(cov.length - 1, i + l - 1);
            int n = i;
            sliwin[n] = sliwin[n] / (double)(le - ls + 1);
            int n2 = i;
            sliwin[n2] = sliwin[n2] - (double)(i * (cov.length - i)) / (double)(cov.length * cov.length);
            ++i;
        }
        return sliwin;
    }

    public int[] proposeSplitByReadCoverage(int minTranscriptLength, int minExonSize) {
        int[] cov = new int[this.nodes.length];
        int i = 0;
        while (i < this.nodes.length) {
            int n = i;
            cov[n] = cov[n] + (this.nodes[i].getNumberOfReads() - this.nodes[i].getNumberOfDummyReads());
            ++i;
        }
        for (Edge e : this.edges) {
            int start = e.relStart;
            int end = e.relEnd;
            int ec = e.nReads;
            int i2 = start + 1;
            while (i2 < end) {
                int n = i2++;
                cov[n] = cov[n] + ec;
            }
        }
        double[] sliwin = ReadGraph.sliwin(50, cov);
        int l2 = 1000;
        double[] sliwin2 = ReadGraph.sliwin(l2, cov);
        int lastNode = this.nodes.length;
        while (lastNode > 0 && this.nodes[lastNode - 1].getNumberOfOutgoingEdges() == 0) {
            --lastNode;
        }
        int start = 0;
        int end = 0;
        IntList locs = new IntList();
        int i3 = 0;
        while (i3 < this.nodes.length) {
            if (this.nodes[i3].getNumberOfOutgoingEdges() == 1 && this.nodes[i3].getOutgoingEdges().iterator().next().getRelEnd() == i3 + 1 && this.nodes[i3 + 1].getNumberOfIncomingEdges() == 1) {
                end = i3;
            } else {
                if (this.nodes[i3].getNumberOfIncomingEdges() > 0 && this.nodes[i3].getNumberOfOutgoingEdges() > 0 || i3 == lastNode) {
                    LinkedList<Integer> locMinCoverageIdx = new LinkedList<Integer>();
                    LinkedList<Double> locMinCoverage = new LinkedList<Double>();
                    LinkedList<Integer> locMaxFcIdx = new LinkedList<Integer>();
                    LinkedList<Double> locMaxFc = new LinkedList<Double>();
                    int j = Math.max(start + minExonSize, minTranscriptLength);
                    while (j < Math.min(end - minExonSize, this.nodes.length - minTranscriptLength)) {
                        double covBeforeLoc = sliwin2[Math.max(0, j - l2)];
                        double covAfterLoc = sliwin2[Math.min(this.nodes.length - 1, j + l2)];
                        double covLocal = sliwin[j];
                        if (covBeforeLoc > 0.0 && covAfterLoc > 0.0) {
                            double fc = Math.abs(Math.log(covBeforeLoc + 1.0) - Math.log(covAfterLoc + 1.0)) / Math.log(2.0);
                            if (fc > 2.0) {
                                if (locMaxFcIdx.size() == 0 || j - minTranscriptLength * 2 > (Integer)locMaxFcIdx.getLast()) {
                                    locMaxFcIdx.add(j);
                                    locMaxFc.add(fc);
                                } else if (fc > (Double)locMaxFc.getLast()) {
                                    locMaxFc.set(locMaxFc.size() - 1, fc);
                                    locMaxFcIdx.set(locMaxFcIdx.size() - 1, j);
                                }
                            }
                            if ((covLocal + 1.0) / Math.min(covBeforeLoc + 1.0, covAfterLoc + 1.0) < 0.2) {
                                if (locMinCoverageIdx.size() == 0 || j - minTranscriptLength * 2 > (Integer)locMinCoverageIdx.getLast()) {
                                    locMinCoverageIdx.add(j);
                                    locMinCoverage.add(covLocal);
                                } else if (covLocal < (Double)locMinCoverage.getLast()) {
                                    locMinCoverage.set(locMinCoverage.size() - 1, covLocal);
                                    locMinCoverageIdx.set(locMinCoverageIdx.size() - 1, j);
                                }
                            }
                        }
                        ++j;
                    }
                    if (locMinCoverageIdx.size() > 0) {
                        int k = 0;
                        while (k < locMinCoverageIdx.size()) {
                            locs.addConditional((Integer)locMinCoverageIdx.get(k) + this.regionStart);
                            ++k;
                        }
                    }
                    if (locMaxFcIdx.size() > 0) {
                        double t = Double.NEGATIVE_INFINITY;
                        if (locMaxFcIdx.size() > 3) {
                            Object[] temp = locMaxFc.toArray(new Double[0]);
                            Arrays.sort(temp);
                            t = (Double)temp[temp.length - 3];
                        }
                        Iterator it = locMaxFcIdx.iterator();
                        Iterator it2 = locMaxFc.iterator();
                        while (it.hasNext()) {
                            double fc;
                            double covAfterLoc;
                            double covBeforeLoc;
                            int locIdx = (Integer)it.next();
                            double val = (Double)it2.next();
                            if (!(val > t) || locIdx <= -1) continue;
                            while (locIdx > minTranscriptLength && sliwin[locIdx - 1] < sliwin[locIdx]) {
                                covBeforeLoc = sliwin2[Math.max(0, locIdx - 1 - l2)];
                                covAfterLoc = sliwin2[Math.min(this.nodes.length - 1, locIdx - 1 + l2)];
                                fc = Math.abs(Math.log(covBeforeLoc + 1.0) - Math.log(covAfterLoc + 1.0)) / Math.log(2.0);
                                if (!(fc > 2.0)) break;
                                --locIdx;
                            }
                            while (locIdx < this.nodes.length - minTranscriptLength && sliwin[locIdx + 1] < sliwin[locIdx]) {
                                covBeforeLoc = sliwin2[Math.max(0, locIdx + 1 - l2)];
                                covAfterLoc = sliwin2[Math.min(this.nodes.length - 1, locIdx + 1 + l2)];
                                fc = Math.abs(Math.log(covBeforeLoc + 1.0) - Math.log(covAfterLoc + 1.0)) / Math.log(2.0);
                                if (!(fc > 2.0)) break;
                                ++locIdx;
                            }
                            locs.addConditional(locIdx + this.regionStart);
                        }
                    }
                }
                start = i3;
                end = i3;
            }
            ++i3;
        }
        int[] temp = locs.toArray();
        Arrays.sort(temp);
        return temp;
    }

    public int[] proposeSplitsByLocalCoverage(int minExonSize, int minTranscriptLength, double logCoverageFC, double percentLocalCoverageDrop, double minCoverage) {
        int start = 0;
        int end = 0;
        IntList locs = new IntList();
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i].getNumberOfOutgoingEdges() == 1 && this.nodes[i].getOutgoingEdges().iterator().next().getRelEnd() == i + 1 && this.nodes[i + 1].getNumberOfIncomingEdges() == 1) {
                end = i;
            } else {
                if (start > minTranscriptLength && this.nodes.length - end > minTranscriptLength && end - minExonSize > start + minExonSize) {
                    int[] regCov = new int[end - start + 1];
                    int cov = 0;
                    int j = start;
                    while (j <= end) {
                        regCov[j - start] = cov += this.nodes[j].getNumberOfReads();
                        ++j;
                    }
                    double locMinCoverage = Double.POSITIVE_INFINITY;
                    double minBefore = 0.0;
                    double minAfter = 0.0;
                    int locMinCoverageIdx = -1;
                    int j2 = start + minExonSize;
                    while (j2 < end - minExonSize) {
                        double covBefore = (double)regCov[j2 - start] / (double)(j2 - start);
                        double covAfter = (double)(cov - regCov[j2 - start]) / (double)(end - j2 - 1);
                        double covLocal = this.nodes[j2].getNumberOfReads();
                        if (covBefore > minCoverage && covAfter > minCoverage && (Math.abs(Math.log(covBefore) - Math.log(covAfter)) / Math.log(2.0) > logCoverageFC && covLocal * 2.0 < Math.min(covBefore, covAfter) || covLocal / Math.min(covBefore, covAfter) < percentLocalCoverageDrop) && covLocal / Math.min(covBefore, covAfter) < locMinCoverage) {
                            locMinCoverageIdx = j2;
                            locMinCoverage = covLocal / Math.min(covBefore, covAfter);
                            minBefore = covBefore;
                            minAfter = covAfter;
                        }
                        ++j2;
                    }
                    if (locMinCoverageIdx > -1) {
                        locs.add(locMinCoverageIdx + this.regionStart);
                    }
                }
                start = i;
                end = i;
            }
            ++i;
        }
        return locs.toArray();
    }

    public void pruneByLocalCoverage(int minExonSize, int minTranscriptLength, double logCoverageFC, double percentLocalCoverageDrop, double minCoverage) {
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i].getNumberOfOutgoingEdges() == 1 && this.nodes[i].getOutgoingEdges().iterator().next().getRelEnd() == i + 1 && this.nodes[i + 1].getNumberOfIncomingEdges() == 1) {
                end = i;
            } else {
                if (start > minTranscriptLength && this.nodes.length - end > minTranscriptLength && end - minExonSize > start + minExonSize) {
                    int[] regCov = new int[end - start + 1];
                    int cov = 0;
                    int j = start;
                    while (j <= end) {
                        regCov[j - start] = cov += this.nodes[j].getNumberOfReads();
                        ++j;
                    }
                    double locMinCoverage = Double.POSITIVE_INFINITY;
                    double minBefore = 0.0;
                    double minAfter = 0.0;
                    int locMinCoverageIdx = -1;
                    int j2 = start + minExonSize;
                    while (j2 < end - minExonSize) {
                        double covBefore = (double)regCov[j2 - start] / (double)(j2 - start);
                        double covAfter = (double)(cov - regCov[j2 - start]) / (double)(end - j2 - 1);
                        double covLocal = this.nodes[j2].getNumberOfReads();
                        if (covBefore > minCoverage && covAfter > minCoverage && (Math.abs(Math.log(covBefore) - Math.log(covAfter)) / Math.log(2.0) > logCoverageFC && covLocal * 2.0 < Math.min(covBefore, covAfter) || covLocal / Math.min(covBefore, covAfter) < percentLocalCoverageDrop) && covLocal / Math.min(covBefore, covAfter) < locMinCoverage) {
                            locMinCoverageIdx = j2;
                            locMinCoverage = covLocal / Math.min(covBefore, covAfter);
                            minBefore = covBefore;
                            minAfter = covAfter;
                        }
                        ++j2;
                    }
                    if (locMinCoverageIdx > -1) {
                        Collection<Edge> es = this.nodes[locMinCoverageIdx].getOutgoingEdges();
                        if (es.size() > 1) {
                            throw new RuntimeException("should not happen");
                        }
                        this.remove(es);
                    }
                }
                start = i;
                end = i;
            }
            ++i;
        }
    }

    public ReadGraph nextSplit() {
        ReadGraph g = new ReadGraph(this.chrom, this.regionStart, this.regionStart + this.nodes.length - 1, this.minIntronLength);
        int idx = -1;
        int i = this.lastIdx;
        while (i < this.nodes.length) {
            if (this.nodes[i] != null && this.nodes[i].getNumberOfOutgoingEdges() > 0) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == -1) {
            return null;
        }
        this.lastIdx = idx;
        LinkedList<Integer> stack = new LinkedList<Integer>();
        stack.add(idx);
        HashSet<Edge> removeEdges = new HashSet<Edge>();
        while (stack.size() > 0) {
            int curr = (Integer)stack.removeFirst();
            if (this.nodes[curr] == null) continue;
            g.nodes[curr] = this.nodes[curr];
            Collection<Edge> out = this.nodes[curr].getOutgoingEdges();
            Collection<Edge> in = this.nodes[curr].getIncomingEdges();
            for (Edge edge : out) {
                if (this.nodes[edge.relEnd] != null) {
                    stack.add(edge.relEnd);
                }
                g.edges.add(edge);
            }
            for (Edge edge : in) {
                if (this.nodes[edge.relStart] == null) continue;
                stack.add(edge.relStart);
            }
            removeEdges.addAll(out);
            removeEdges.addAll(in);
            this.nodes[curr] = null;
        }
        this.edges = this.edges.stream().filter(e -> !removeEdges.contains(e)).collect(Collectors.toCollection(LinkedList::new));
        return g;
    }

    public LinkedList<Edge> getIntronEdges() {
        return this.edges.stream().filter(e -> e.getRelEnd() - e.getRelStart() >= this.minIntronLength).collect(Collectors.toCollection(LinkedList::new));
    }

    public static class Edge {
        private int relStart;
        private int relEnd;
        private int nReads;

        public Edge(int relStart, int relEnd) {
            this.relStart = relStart;
            this.relEnd = relEnd;
            this.nReads = 0;
        }

        public Edge(int relStart, int relEnd, int nReads) {
            this(relStart, relEnd);
            this.nReads = nReads;
        }

        public Edge clone() throws CloneNotSupportedException {
            Edge clone = (Edge)super.clone();
            clone.relStart = this.relStart;
            clone.relEnd = this.relEnd;
            clone.nReads = this.nReads;
            return clone;
        }

        public int getNumberOfReads() {
            return this.nReads;
        }

        public String toString(int regionStart) {
            return String.valueOf(regionStart + this.relStart) + " <-> " + (regionStart + this.relEnd) + ": " + this.nReads;
        }

        public int getRelStart() {
            return this.relStart;
        }

        public int getRelEnd() {
            return this.relEnd;
        }

        public int getLength() {
            return this.relEnd - this.relStart - 1;
        }
    }

    public static class Node {
        private HashMap<Integer, Edge> outgoing = new HashMap();
        private HashMap<Integer, Edge> incoming = new HashMap();
        private int nOut = 0;
        private int nIn = 0;
        private int nReads = 0;
        private int nDummy = 0;

        public int getNumberOfReads() {
            return this.nReads;
        }

        public int getNumberOfDummyReads() {
            return this.nDummy;
        }

        public void removeOutgoing(int relEnd) {
            if (this.outgoing.remove(relEnd) != null) {
                --this.nOut;
            }
        }

        public void removeIncoming(int relStart) {
            if (this.incoming.remove(relStart) != null) {
                --this.nIn;
            }
        }

        public Edge addOutgoing(int relStart, int relEnd, LinkedList<Edge> list, Node[] nodes) {
            if (this.outgoing.containsKey(relEnd)) {
                return this.outgoing.get(relEnd);
            }
            Edge newEdge = new Edge(relStart, relEnd);
            this.outgoing.put(relEnd, newEdge);
            ++this.nOut;
            nodes[relEnd].incoming.put(relStart, newEdge);
            ++nodes[relEnd].nIn;
            list.add(newEdge);
            return newEdge;
        }

        public int getNumberOfOutgoingEdges() {
            return this.nOut;
        }

        public int getNumberOfIncomingEdges() {
            return this.nIn;
        }

        public Collection<Edge> getOutgoingEdges() {
            return this.outgoing.values();
        }

        public Collection<Edge> getIncomingEdges() {
            return this.incoming.values();
        }
    }
}

