/*
 * Decompiled with CFR 0.152.
 */
package projects.gemorna;

import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.TerminationException;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.io.ArrayHandler;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.ToolBox;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import projects.gemoma.Analyzer;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemoma.Tools;
import projects.gemorna.Genome;
import projects.gemorna.ReadGraph;
import projects.gemorna.Region;

public class SplicingGraph {
    private static NumberFormat df = DecimalFormat.getInstance(Locale.ENGLISH);
    private static int SHORTEXON;
    ContiguousRegion[] contRegs;
    LinkedList<ComparableElement<Integer, Integer>>[] adjList;
    private double[][] adjCounts;
    Intron[] introns;
    private String chromosome;
    private int regionStart;
    private HashMap<Integer, Character> strands;

    static {
        df.setMaximumFractionDigits(3);
        df.setGroupingUsed(false);
        SHORTEXON = 10;
    }

    private static int[] intersectSortedArrays(int[] edge, int[] left) {
        int i = 0;
        int j = 0;
        IntList res = new IntList();
        while (i < edge.length && j < left.length) {
            if (left[j] == edge[i]) {
                res.add(left[j]);
                ++i;
                ++j;
                continue;
            }
            if (left[j] < edge[i]) {
                ++j;
                continue;
            }
            if (left[j] <= edge[i]) continue;
            ++i;
        }
        return res.toArray();
    }

    private static void unionSortedArrays(int[] res, int[] edge, int[] left) {
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < edge.length && edge[i] > -1 && j < left.length && left[j] > -1) {
            if (left[j] == edge[i]) {
                res[k] = left[j];
                ++k;
                ++i;
                ++j;
                continue;
            }
            if (left[j] < edge[i]) {
                res[k] = left[j];
                ++k;
                ++j;
                continue;
            }
            if (left[j] <= edge[i]) continue;
            res[k] = edge[i];
            ++k;
            ++i;
        }
        while (i < edge.length && edge[i] > -1) {
            res[k] = edge[i];
            ++k;
            ++i;
        }
        while (j < left.length && left[j] > -1) {
            res[k] = left[j];
            ++k;
            ++j;
        }
        res[k] = -1;
    }

    private static int[] setdiff(int[] ref, int[] diff) {
        int i = 0;
        int j = 0;
        IntList res = new IntList();
        while (i < ref.length && ref[i] > -1 && j < diff.length && diff[j] > -1) {
            if (diff[j] == ref[i]) {
                ++i;
                ++j;
                continue;
            }
            if (diff[j] < ref[i]) {
                ++j;
                continue;
            }
            if (diff[j] <= ref[i]) continue;
            res.add(ref[i]);
            ++i;
        }
        while (i < ref.length && ref[i] > -1) {
            res.add(ref[i]);
            ++i;
        }
        return res.toArray();
    }

    public SplicingGraph(ReadGraph graph, Region reg, int minIntronLength, int[] proposedSplits) throws CloneNotSupportedException {
        this.chromosome = graph.chrom;
        this.regionStart = graph.regionStart;
        LinkedList<ContiguousRegion> contRegs = new LinkedList<ContiguousRegion>();
        LinkedList<Object> introns = new LinkedList<Object>();
        ContiguousRegion[] regs = new ContiguousRegion[graph.nodes.length];
        IntList currNodes = new IntList();
        int i = 0;
        while (i < graph.nodes.length) {
            if (graph.nodes[i].getNumberOfIncomingEdges() == 0 && graph.nodes[i].getNumberOfOutgoingEdges() == 0) {
                currNodes.clear();
            } else {
                if (currNodes.contains(i) == -1) {
                    currNodes.add(i);
                }
                if (graph.nodes[i].getNumberOfOutgoingEdges() == 1 && graph.nodes[i].getOutgoingEdges().iterator().next().getRelEnd() == i + 1 && graph.nodes[i + 1].getNumberOfIncomingEdges() == 1 && Arrays.binarySearch(proposedSplits, i + 1 + this.regionStart) < 0) {
                    currNodes.add(i + 1);
                } else {
                    if (currNodes.length() > 0) {
                        ContiguousRegion region = new ContiguousRegion(currNodes.get(0), currNodes.get(currNodes.length() - 1), SplicingGraph.getNodes(graph.nodes, currNodes));
                        contRegs.add(region);
                        if (regs[region.regionStart] != null || regs[region.regionEnd] != null) {
                            throw new RuntimeException("Overlapping contregs");
                        }
                        ContiguousRegion contiguousRegion = region;
                        regs[((ContiguousRegion)region).regionEnd] = contiguousRegion;
                        regs[((ContiguousRegion)region).regionStart] = contiguousRegion;
                    }
                    currNodes.clear();
                    if (i + 1 < graph.nodes.length) {
                        currNodes.add(i + 1);
                    }
                }
            }
            ++i;
        }
        if (currNodes.length() > 0) {
            ContiguousRegion region = new ContiguousRegion(currNodes.get(0), currNodes.get(currNodes.length() - 1), SplicingGraph.getNodes(graph.nodes, currNodes));
            contRegs.add(region);
        }
        for (ReadGraph.Edge e : graph.edges) {
            int start = e.getRelStart();
            int end = e.getRelEnd();
            if (regs[start] == null || regs[end] == null || regs[start] == regs[end]) continue;
            Intron intron = new Intron(regs[start], regs[end], e);
            regs[start].right.add(intron);
            regs[end].left.add(intron);
            introns.add(intron);
        }
        LinkedList<ContiguousRegion> crRemove = new LinkedList<ContiguousRegion>();
        LinkedList<Intron> inRemove = new LinkedList<Intron>();
        block2: for (ContiguousRegion region : contRegs) {
            if (region.regionEnd - region.regionStart + 1 <= SHORTEXON) {
                if (region.left.size() == 0 && region.regionEnd + 1 < regs.length && regs[region.regionEnd + 1] != null && regs[region.regionEnd + 1].left.size() > 1) {
                    crRemove.add(region);
                    inRemove.addAll(region.right);
                }
                if (region.right.size() == 0 && region.regionStart - 1 >= 0 && regs[region.regionStart - 1] != null && regs[region.regionStart - 1].right.size() > 1) {
                    crRemove.add(region);
                    inRemove.addAll(region.left);
                }
            }
            if (region.left.size() != 0 || region.right.size() != 0) continue;
            int start = region.regionStart;
            int end = region.regionEnd;
            for (Intron intron : introns) {
                if (intron.left.regionEnd >= start || intron.right.regionStart <= end || !((double)intron.edge.getNumberOfReads() * 0.5 > (double)region.getNumberOfReads())) continue;
                crRemove.add(region);
                continue block2;
            }
        }
        for (ContiguousRegion region : crRemove) {
            regs[((ContiguousRegion)region).regionEnd] = null;
            regs[((ContiguousRegion)region).regionStart] = null;
        }
        for (ContiguousRegion region : contRegs) {
            region.left.removeAll(inRemove);
            region.right.removeAll(inRemove);
        }
        contRegs.removeAll(crRemove);
        introns.removeAll(inRemove);
        this.contRegs = contRegs.toArray(new ContiguousRegion[0]);
        this.introns = introns.toArray(new Intron[0]);
        this.addReads(reg, minIntronLength);
        crRemove.clear();
        inRemove.clear();
        int i2 = 0;
        while (i2 < this.contRegs.length) {
            if (this.contRegs[i2].readIdxs.length == 0) {
                crRemove.add(this.contRegs[i2]);
                inRemove.addAll(this.contRegs[i2].left);
                inRemove.addAll(this.contRegs[i2].right);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.introns.length) {
            if (this.introns[i3].readIdxs.length == 0 || this.introns[i3].getLength() > 0 && !this.introns[i3].isCanonical(minIntronLength)) {
                inRemove.add(this.introns[i3]);
                int j = 0;
                while (j < this.contRegs.length) {
                    this.contRegs[j].left.remove(this.introns[i3]);
                    this.contRegs[j].right.remove(this.introns[i3]);
                    ++j;
                }
            }
            ++i3;
        }
        for (ContiguousRegion region : crRemove) {
            regs[((ContiguousRegion)region).regionEnd] = null;
            regs[((ContiguousRegion)region).regionStart] = null;
        }
        contRegs.removeAll(crRemove);
        introns.removeAll(inRemove);
        this.contRegs = contRegs.toArray(new ContiguousRegion[0]);
        this.introns = introns.toArray(new Intron[0]);
        this.adjCounts = new double[this.contRegs.length][this.contRegs.length];
        this.adjList = (LinkedList[])ArrayHandler.createArrayOf(new LinkedList(), (int)this.contRegs.length);
        i = 0;
        while (i < this.introns.length) {
            int leftIdx = contRegs.indexOf(this.introns[i].left);
            int rightIdx = contRegs.indexOf(this.introns[i].right);
            this.adjList[leftIdx].add(new ComparableElement<Integer, Integer>(rightIdx, i));
            ++i;
        }
        i = 0;
        while (i < this.adjList.length) {
            Collections.sort(this.adjList[i], new Comparator<ComparableElement<Integer, Integer>>(){

                @Override
                public int compare(ComparableElement<Integer, Integer> o1, ComparableElement<Integer, Integer> o2) {
                    return Integer.compare(SplicingGraph.this.introns[o2.getWeight()].readIdxs.length, SplicingGraph.this.introns[o1.getWeight()].readIdxs.length);
                }
            });
            ++i;
        }
    }

    SplicingGraph(Analyzer.Transcript t) {
        this.chromosome = t.getChromosome();
        this.regionStart = t.getMin();
        this.contRegs = new ContiguousRegion[t.getNumberOfParts()];
        int idx = 0;
        while (idx < t.getNumberOfParts()) {
            int[] part = t.getPart(idx);
            this.contRegs[idx] = new ContiguousRegion(part[0] - this.regionStart, part[1] - this.regionStart, new LinkedList<ReadGraph.Node>());
            ++idx;
        }
        Arrays.sort(this.contRegs, new Comparator<ContiguousRegion>(){

            @Override
            public int compare(ContiguousRegion o1, ContiguousRegion o2) {
                return Integer.compare(o1.regionStart, o2.regionStart);
            }
        });
        this.introns = new Intron[this.contRegs.length - 1];
        int i = 1;
        while (i < this.contRegs.length) {
            this.introns[i - 1] = new Intron(this.contRegs[i - 1], this.contRegs[i], new ReadGraph.Edge(this.contRegs[i - 1].regionEnd, this.contRegs[i].regionStart));
            ++i;
        }
    }

    Transcript createTranscript(Analyzer.Transcript t) {
        LinkedList<Integer> exons = new LinkedList<Integer>();
        LinkedList<Integer> introns = new LinkedList<Integer>();
        int i = 0;
        while (i < t.getNumberOfParts()) {
            exons.add(i);
            if (i < this.introns.length) {
                introns.add(i);
            }
            ++i;
        }
        Transcript t2 = new Transcript(exons, introns);
        t2.id = t.getID();
        t2.geneID = t.getParent();
        t2.strand = t.getStrand();
        t2.attributes = t.getInfos();
        return t2;
    }

    private void addReads(Region reg, int minIntronLength) throws CloneNotSupportedException {
        int len = reg.getRegionEnd() - this.regionStart + 1;
        int[] regions = new int[len];
        IntList[] regReads = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)this.contRegs.length);
        IntList[] firstReads = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)this.contRegs.length);
        IntList[] lastReads = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)this.contRegs.length);
        IntList[] intronReads = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)this.introns.length);
        HashMap<IntronKey, Integer> intronMap = new HashMap<IntronKey, Integer>();
        int i = 0;
        while (i < this.introns.length) {
            IntronKey key = new IntronKey(this.introns[i].edge.getRelStart(), this.introns[i].edge.getRelEnd());
            intronMap.put(key, i);
            ++i;
        }
        Arrays.fill(regions, -1);
        i = 0;
        while (i < this.contRegs.length) {
            int j = this.contRegs[i].regionStart;
            while (j <= this.contRegs[i].regionEnd) {
                if (regions[j] > -1) {
                    throw new RuntimeException();
                }
                regions[j] = i;
                ++j;
            }
            ++i;
        }
        LinkedList<SAMRecord> list = reg.getReads();
        HashMap<String, Integer> idMap = reg.getIDMap();
        this.strands = reg.getStrands();
        for (SAMRecord sr : list) {
            if (sr.getAlignmentEnd() < this.regionStart || sr.getAlignmentStart() > this.regionStart + this.contRegs[this.contRegs.length - 1].regionEnd) continue;
            String name = sr.getReadName();
            int idx = idMap.get(name);
            this.addRead(sr, idx, minIntronLength, intronReads, intronMap, regions, regReads, firstReads, lastReads);
        }
        int i2 = 0;
        while (i2 < this.contRegs.length) {
            regReads[i2].sortAndMakeUnique();
            firstReads[i2].sortAndMakeUnique();
            lastReads[i2].sortAndMakeUnique();
            this.contRegs[i2].setSortedReads(regReads[i2].toArray(), firstReads[i2].toArray(), lastReads[i2].toArray());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.introns.length) {
            intronReads[i2].sortAndMakeUnique();
            this.introns[i2].readIdxs = intronReads[i2].toArray();
            ++i2;
        }
    }

    private void addRead(SAMRecord read, int readIdx, int minIntronLength, IntList[] intronReads, HashMap<IntronKey, Integer> intronMap, int[] regions, IntList[] regReads, IntList[] firstReads, IntList[] lastReads) {
        Iterator<AlignmentBlock> blockIt = read.getAlignmentBlocks().iterator();
        int lastRelEnd = -1;
        int lastRegion = -1;
        IntronKey key = new IntronKey(0, 0);
        while (blockIt.hasNext()) {
            int i;
            AlignmentBlock block = blockIt.next();
            int relStart = block.getReferenceStart() - this.regionStart;
            if (lastRelEnd > -1 && relStart >= 0) {
                if (relStart - lastRelEnd < minIntronLength) {
                    i = lastRelEnd + 1;
                    while (i <= relStart) {
                        key.setStartEnd(i - 1, i);
                        if (intronMap.containsKey(key)) {
                            int idx = intronMap.get(key);
                            intronReads[idx].add(readIdx);
                        }
                        ++i;
                    }
                } else {
                    key.setStartEnd(lastRelEnd, relStart);
                    if (intronMap.containsKey(key)) {
                        int idx = intronMap.get(key);
                        intronReads[idx].add(readIdx);
                    }
                }
            }
            i = Math.max(0, -relStart);
            while (i < block.getLength() && relStart + i < regions.length) {
                int regionIdx = regions[relStart + i];
                if (regionIdx > -1) {
                    if (regionIdx != lastRegion) {
                        regReads[regionIdx].add(readIdx);
                    }
                    if (relStart + i == this.contRegs[regionIdx].regionStart) {
                        firstReads[regionIdx].add(readIdx);
                    }
                    if (relStart + i == this.contRegs[regionIdx].regionEnd) {
                        lastReads[regionIdx].add(readIdx);
                    }
                    lastRegion = regionIdx;
                }
                if (i > 0) {
                    key.setStartEnd(relStart + i - 1, relStart + i);
                    if (intronMap.containsKey(key)) {
                        int idx = intronMap.get(key);
                        intronReads[idx].add(readIdx);
                    }
                }
                ++i;
            }
            lastRelEnd = relStart + block.getLength() - 1;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Object[] objectArray = this.contRegs;
        int n = this.contRegs.length;
        int n2 = 0;
        while (n2 < n) {
            ContiguousRegion region = objectArray[n2];
            sb.append(String.valueOf(region.toString(this.regionStart)) + "\n");
            ++n2;
        }
        objectArray = this.introns;
        n = this.introns.length;
        n2 = 0;
        while (n2 < n) {
            Object intron = objectArray[n2];
            sb.append(String.valueOf(((Intron)intron).toString(this.regionStart)) + "\n");
            ++n2;
        }
        return sb.toString();
    }

    public void getIntersections() {
        int n;
        int j;
        int i = 0;
        while (i < this.contRegs.length) {
            j = 0;
            while (j < this.contRegs.length) {
                n = SplicingGraph.intersectSortedArrays(this.contRegs[i].readIdxs, this.contRegs[j].readIdxs).length;
                System.out.print(String.valueOf(n) + "\t");
                ++j;
            }
            j = 0;
            while (j < this.introns.length) {
                n = SplicingGraph.intersectSortedArrays(this.contRegs[i].readIdxs, this.introns[j].readIdxs).length;
                System.out.print(String.valueOf(n) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
        i = 0;
        while (i < this.introns.length) {
            j = 0;
            while (j < this.contRegs.length) {
                n = SplicingGraph.intersectSortedArrays(this.introns[i].readIdxs, this.contRegs[j].readIdxs).length;
                System.out.print(String.valueOf(n) + "\t");
                ++j;
            }
            j = 0;
            while (j < this.introns.length) {
                n = SplicingGraph.intersectSortedArrays(this.introns[i].readIdxs, this.introns[j].readIdxs).length;
                System.out.print(String.valueOf(n) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private static LinkedList<ReadGraph.Node> getNodes(ReadGraph.Node[] nodes, IntList nodeIdxs) {
        LinkedList<ReadGraph.Node> li = new LinkedList<ReadGraph.Node>();
        int i = 0;
        while (i < nodeIdxs.length()) {
            li.add(nodes[nodeIdxs.get(i)]);
            ++i;
        }
        return li;
    }

    public LinkedList<Gene> finalize(LinkedList<Transcript> list, String geneBase, int firstID, double minReadsPerGene, int minProteinLength) {
        if (list.size() == 0) {
            return new LinkedList<Gene>();
        }
        Collections.sort(list);
        for (Transcript t : list) {
            t.addStrandAndCDS(true, minProteinLength, false);
        }
        LinkedList<Transcript> gene = new LinkedList<Transcript>();
        LinkedList<Gene> allGenes = new LinkedList<Gene>();
        Transcript curr = null;
        for (Transcript t : list) {
            if (curr == null) {
                curr = t;
                gene.add(t);
                continue;
            }
            if (t.getStart() <= curr.getEnd()) {
                if (t.getEnd() > curr.getEnd()) {
                    curr = t;
                }
                gene.add(t);
                continue;
            }
            firstID = this.addGenes(allGenes, geneBase, firstID, gene, minReadsPerGene);
            gene.clear();
            gene.add(t);
            curr = t;
        }
        firstID = this.addGenes(allGenes, geneBase, firstID, gene, minReadsPerGene);
        return allGenes;
    }

    private Gene getGene(String geneBase, int firstID, LinkedList<Transcript> gene, char strand, double minReadsPerGene) {
        LinkedList<Transcript> sub = new LinkedList<Transcript>();
        int j = 1;
        double reads = 0.0;
        for (Transcript t : gene) {
            if (t.strand != strand) continue;
            t.setGene(String.valueOf(geneBase) + firstID);
            t.setId(String.valueOf(geneBase) + firstID + "." + j);
            ++j;
            sub.add(t);
            reads += t.getAbundance();
        }
        if (sub.size() == 0 || reads < minReadsPerGene) {
            return null;
        }
        return new Gene(String.valueOf(geneBase) + firstID, sub, strand);
    }

    private int addGenes(LinkedList<Gene> allGenes, String geneBase, int firstID, LinkedList<Transcript> gene, double minReadsPerGene) {
        Gene none;
        Gene minus;
        Gene plus = this.getGene(geneBase, firstID, gene, '+', minReadsPerGene);
        if (plus != null) {
            allGenes.add(plus);
            ++firstID;
        }
        if ((minus = this.getGene(geneBase, firstID, gene, '-', minReadsPerGene)) != null) {
            allGenes.add(minus);
            ++firstID;
        }
        if ((none = this.getGene(geneBase, firstID, gene, '.', minReadsPerGene)) != null) {
            allGenes.add(none);
            ++firstID;
        }
        return firstID;
    }

    private int len(int[] diff) {
        int l = 0;
        while (l < diff.length && diff[l] > -1) {
            ++l;
        }
        return l;
    }

    public LinkedList<Transcript> quantify(LinkedList<Transcript> original, double percentExplained, double minReadsPerTranscript, double maxFraction, double percentAbundance, double scaleIntronReads, double delta, int nIterations, double scale, int minIntronLength, boolean longReads) throws CloneNotSupportedException {
        int j;
        double num;
        int k;
        if (original.size() == 0) {
            return original;
        }
        boolean[][] inoutExons = new boolean[original.size()][this.contRegs.length];
        boolean[][] inoutIntrons = new boolean[original.size()][this.introns.length];
        int i = 0;
        for (Transcript t : original) {
            for (Integer j2 : t.exons) {
                inoutExons[i][j2.intValue()] = true;
            }
            for (Integer j2 : t.introns) {
                inoutIntrons[i][j2.intValue()] = true;
            }
            ++i;
        }
        int totalNumReads = 0;
        i = 0;
        while (i < this.contRegs.length) {
            int num2 = this.contRegs[i].readIdxs[this.contRegs[i].readIdxs.length - 1];
            if (num2 > totalNumReads) {
                totalNumReads = num2;
            }
            ++i;
        }
        i = 0;
        while (i < this.introns.length) {
            int num3;
            if (this.introns[i].readIdxs.length == 0) {
                System.out.println(Arrays.toString(this.contRegs));
                System.out.println(Arrays.toString(this.introns));
                System.out.println(String.valueOf(this.introns[i].edge.getRelStart()) + " " + this.introns[i].edge.getRelEnd() + " " + this.regionStart);
            }
            if ((num3 = this.introns[i].readIdxs[this.introns[i].readIdxs.length - 1]) > totalNumReads) {
                totalNumReads = num3;
            }
            ++i;
        }
        if (totalNumReads == 0) {
            return new LinkedList<Transcript>();
        }
        ++totalNumReads;
        boolean[][] isAlternative = new boolean[this.contRegs.length][this.introns.length];
        i = 0;
        while (i < this.contRegs.length) {
            int startContReg = this.contRegs[i].regionStart;
            int endContReg = this.contRegs[i].regionEnd;
            int j3 = 0;
            while (j3 < this.introns.length) {
                int intronEnd;
                int intronStart = this.introns[j3].getStart();
                if (intronStart + 1 < (intronEnd = this.introns[j3].getEnd()) && (intronStart >= startContReg && intronStart < endContReg || startContReg >= intronStart && startContReg < intronEnd)) {
                    isAlternative[i][j3] = true;
                }
                ++j3;
            }
            ++i;
        }
        double[] readWeights = new double[totalNumReads];
        double[] readNs = new double[totalNumReads];
        Arrays.fill(readWeights, 1.0);
        i = 0;
        while (i < this.introns.length) {
            if (this.introns[i].getStart() + 1 < this.introns[i].getEnd()) {
                double maxNum = 1.0;
                k = 0;
                while (k < this.contRegs.length) {
                    if (isAlternative[k][i] && (num = (double)this.contRegs[k].readIdxs.length) > maxNum) {
                        maxNum = num;
                    }
                    ++k;
                }
                double fac = 2.0 * (double)this.introns[i].readIdxs.length / (maxNum + (double)this.introns[i].readIdxs.length);
                j = 0;
                while (j < this.introns[i].readIdxs.length) {
                    int n = this.introns[i].readIdxs[j];
                    readWeights[n] = readWeights[n] * fac;
                    int n2 = this.introns[i].readIdxs[j];
                    readNs[n2] = readNs[n2] + 1.0;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.contRegs.length) {
            double maxNum = 1.0;
            k = 0;
            while (k < this.introns.length) {
                if (isAlternative[i][k] && (num = (double)this.introns[k].readIdxs.length) > maxNum) {
                    maxNum = num;
                }
                ++k;
            }
            double fac = 2.0 * (double)this.contRegs[i].readIdxs.length / (maxNum + (double)this.contRegs[i].readIdxs.length);
            j = 0;
            while (j < this.contRegs[i].readIdxs.length) {
                int n = this.contRegs[i].readIdxs[j];
                readWeights[n] = readWeights[n] * fac;
                int n3 = this.contRegs[i].readIdxs[j];
                readNs[n3] = readNs[n3] + 1.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < readWeights.length) {
            readWeights[i] = readNs[i] > 0.0 ? Math.pow(readWeights[i], 1.0 / readNs[i]) : 0.0;
            ++i;
        }
        if (longReads) {
            int[] intronNs = new int[readNs.length];
            i = 0;
            while (i < this.introns.length) {
                if (this.introns[i].getStart() + minIntronLength < this.introns[i].getEnd()) {
                    int j4 = 0;
                    while (j4 < this.introns[i].readIdxs.length) {
                        int n = this.introns[i].readIdxs[j4];
                        intronNs[n] = intronNs[n] + 1;
                        ++j4;
                    }
                }
                ++i;
            }
            int maxIN = 0;
            i = 0;
            while (i < intronNs.length) {
                if (intronNs[i] > maxIN) {
                    maxIN = intronNs[i];
                }
                ++i;
            }
            double[] facs = new double[maxIN + 1];
            facs[0] = 1.0;
            if (maxIN > 0) {
                facs[1] = scaleIntronReads;
            }
            double rat = 1.5;
            i = 2;
            while (i < facs.length) {
                facs[i] = facs[i - 1] * (1.0 + (scaleIntronReads - 1.0) / rat);
                rat *= 1.5;
                ++i;
            }
            i = 0;
            while (i < readNs.length) {
                int n = i;
                readWeights[n] = readWeights[n] * facs[intronNs[i]];
                ++i;
            }
        } else {
            i = 0;
            while (i < this.introns.length) {
                if (this.introns[i].getStart() + minIntronLength < this.introns[i].getEnd()) {
                    int j5 = 0;
                    while (j5 < this.introns[i].readIdxs.length) {
                        int n = this.introns[i].readIdxs[j5];
                        readWeights[n] = readWeights[n] * scaleIntronReads;
                        ++j5;
                    }
                }
                ++i;
            }
        }
        boolean[][] readsTimesTranscripts = new boolean[totalNumReads][original.size()];
        i = 0;
        while (i < original.size()) {
            int[] temp;
            int nUnion = 1;
            int nDiff = 1;
            int j6 = 0;
            while (j6 < inoutExons[i].length) {
                if (inoutExons[i][j6]) {
                    nUnion += this.contRegs[j6].readIdxs.length;
                } else {
                    nDiff += this.contRegs[j6].readIdxs.length;
                }
                ++j6;
            }
            j6 = 0;
            while (j6 < inoutIntrons[i].length) {
                if (inoutIntrons[i][j6]) {
                    nUnion += this.introns[j6].readIdxs.length;
                } else {
                    nDiff += this.introns[j6].readIdxs.length;
                }
                ++j6;
            }
            int[] tempUnion = new int[nUnion];
            int[] union = new int[nUnion];
            tempUnion[0] = -1;
            union[0] = -1;
            int[] tempDiff = new int[nDiff];
            int[] diff = new int[nDiff];
            tempDiff[0] = -1;
            diff[0] = -1;
            int j7 = 0;
            while (j7 < inoutExons[i].length) {
                if (inoutExons[i][j7]) {
                    SplicingGraph.unionSortedArrays(tempUnion, union, this.contRegs[j7].readIdxs);
                    temp = tempUnion;
                    tempUnion = union;
                    union = temp;
                } else {
                    SplicingGraph.unionSortedArrays(tempDiff, diff, this.contRegs[j7].readIdxs);
                    temp = tempDiff;
                    tempDiff = diff;
                    diff = temp;
                }
                ++j7;
            }
            j7 = 0;
            while (j7 < inoutIntrons[i].length) {
                if (inoutIntrons[i][j7]) {
                    SplicingGraph.unionSortedArrays(tempUnion, union, this.introns[j7].readIdxs);
                    temp = tempUnion;
                    tempUnion = union;
                    union = temp;
                } else {
                    SplicingGraph.unionSortedArrays(tempDiff, diff, this.introns[j7].readIdxs);
                    temp = tempDiff;
                    tempDiff = diff;
                    diff = temp;
                }
                ++j7;
            }
            int[] compatibleReads = SplicingGraph.setdiff(union, diff);
            int j8 = 0;
            while (j8 < compatibleReads.length) {
                readsTimesTranscripts[compatibleReads[j8]][i] = true;
                ++j8;
            }
            ++i;
        }
        double[] relTranscriptLen = new double[inoutExons.length];
        Arrays.fill(relTranscriptLen, 1.0);
        double[] intronWeights = new double[inoutIntrons.length];
        Arrays.fill(intronWeights, 1.0);
        double[] cdsWeights = this.getCDSWeights(original);
        boolean[][] rTT_back = readsTimesTranscripts;
        double[] rW_back = readWeights;
        Pair<boolean[][], double[]> pair = SplicingGraph.makeUnique(readsTimesTranscripts, readWeights);
        readsTimesTranscripts = pair.getFirstElement();
        readWeights = pair.getSecondElement();
        double nReads = 0.0;
        double[] aPrioriTranscripts = new double[original.size()];
        double[][] gamma = new double[readsTimesTranscripts.length][original.size()];
        i = 0;
        while (i < gamma.length) {
            boolean found = false;
            int j9 = 0;
            while (j9 < gamma[i].length) {
                if (readsTimesTranscripts[i][j9]) {
                    gamma[i][j9] = 1.0 / relTranscriptLen[j9] * intronWeights[j9] * cdsWeights[j9];
                    found = true;
                }
                ++j9;
            }
            if (found) {
                Normalisation.sumNormalisation(gamma[i]);
                nReads += readWeights[i];
            }
            ++i;
        }
        double oldD = Double.NEGATIVE_INFINITY;
        i = 0;
        while (true) {
            SplicingGraph.aPriori(aPrioriTranscripts, gamma, readWeights);
            double d = SplicingGraph.gamma(gamma, aPrioriTranscripts, readsTimesTranscripts, readWeights, relTranscriptLen, intronWeights, cdsWeights);
            double diff = d - oldD;
            if (diff < delta || i > nIterations) break;
            oldD = d;
            ++i;
        }
        readsTimesTranscripts = rTT_back;
        readWeights = rW_back;
        double[] idxs = new double[original.size()];
        i = 0;
        while (i < idxs.length) {
            idxs[i] = i;
            ++i;
        }
        double[] aPrioriTranscriptsOriginalOrder = (double[])aPrioriTranscripts.clone();
        ToolBox.sortAlongWith(aPrioriTranscripts, new double[][]{idxs});
        double sum = 0.0;
        i = aPrioriTranscripts.length;
        while (i > 0 && aPrioriTranscripts[i - 1] * nReads >= minReadsPerTranscript) {
            if ((sum += aPrioriTranscripts[--i]) >= percentExplained || i > 0 && (aPrioriTranscripts[i] / aPrioriTranscripts[i - 1] > maxFraction || aPrioriTranscripts[i - 1] < percentAbundance)) break;
        }
        LinkedList<Transcript> result = new LinkedList<Transcript>();
        int j10 = idxs.length - 1;
        while (j10 >= i) {
            Transcript temp = original.get((int)idxs[j10]);
            temp.setAbundance(aPrioriTranscripts[j10] * nReads);
            temp.setStrand(this.getStrand(aPrioriTranscriptsOriginalOrder, readsTimesTranscripts, readWeights, (int)idxs[j10], relTranscriptLen, intronWeights, cdsWeights));
            result.add(temp);
            --j10;
        }
        return result;
    }

    private double[] getCDSWeights(LinkedList<Transcript> original) {
        double[] w = new double[original.size()];
        double sum = 0.0;
        int i = 0;
        while (i < w.length) {
            int len = original.get(i).cdsEnd - original.get(i).cdsStart + 1;
            w[i] = len;
            sum += (double)len;
            ++i;
        }
        sum /= (double)w.length;
        i = 0;
        while (i < w.length) {
            int n = i++;
            w[n] = w[n] / sum;
        }
        return w;
    }

    private double[] getRelativeTranscriptLengths(boolean[][] inoutExons) {
        double[] rel = new double[inoutExons.length];
        int i = 0;
        while (i < rel.length) {
            double len = 0.0;
            int j = 0;
            while (j < inoutExons[i].length) {
                if (inoutExons[i][j]) {
                    len += (double)(this.contRegs[j].regionEnd - this.contRegs[j].regionStart);
                }
                ++j;
            }
            rel[i] = len;
            ++i;
        }
        double mean = ToolBox.mean(rel);
        int i2 = 0;
        while (i2 < rel.length) {
            rel[i2] = rel[i2] / mean;
            ++i2;
        }
        Arrays.fill(rel, 1.0);
        return rel;
    }

    private double[] getNumberOfIntrons(boolean[][] inoutIntrons, int minIntronLength) {
        double[] num = new double[inoutIntrons.length];
        int i = 0;
        while (i < num.length) {
            int n = 0;
            int j = 0;
            while (j < inoutIntrons[i].length) {
                if (inoutIntrons[i][j] && this.introns[j].getStart() + minIntronLength < this.introns[j].getEnd()) {
                    ++n;
                }
                ++j;
            }
            num[i] = n;
            ++i;
        }
        return num;
    }

    private double[] getIntronWeights(boolean[][] inoutIntrons, int minIntronLength) {
        double[] w = this.getNumberOfIntrons(inoutIntrons, minIntronLength);
        double[] w2 = new double[w.length];
        int i = 0;
        while (i < w2.length) {
            w2[i] = SplicingGraph.getIntronWeight(w, i);
            ++i;
        }
        return w2;
    }

    private static Pair<boolean[][], double[]> makeUnique(final boolean[][] readsTimesTranscripts, double[] readWeights2) throws CloneNotSupportedException {
        if (readsTimesTranscripts.length == 0) {
            return new Pair<boolean[][], double[]>(readsTimesTranscripts, readWeights2);
        }
        if (readsTimesTranscripts.length != readWeights2.length) {
            throw new RuntimeException();
        }
        Integer[] sortIdxs = new Integer[readsTimesTranscripts.length];
        int i = 0;
        while (i < sortIdxs.length) {
            sortIdxs[i] = i;
            ++i;
        }
        Arrays.sort(sortIdxs, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int i = 0;
                while (i < readsTimesTranscripts[o1].length) {
                    if (readsTimesTranscripts[o1][i] && !readsTimesTranscripts[o2][i]) {
                        return 1;
                    }
                    if (!readsTimesTranscripts[o1][i] && readsTimesTranscripts[o2][i]) {
                        return -1;
                    }
                    ++i;
                }
                return 0;
            }
        });
        int uni = 1;
        int i2 = 1;
        while (i2 < sortIdxs.length) {
            boolean eq = true;
            boolean[] x = readsTimesTranscripts[sortIdxs[i2]];
            boolean[] y = readsTimesTranscripts[sortIdxs[i2 - 1]];
            int j = 0;
            while (j < x.length) {
                if (x[j] != y[j]) {
                    eq = false;
                    break;
                }
                ++j;
            }
            if (!eq) {
                ++uni;
            }
            ++i2;
        }
        boolean[][] rTT = new boolean[uni][];
        double[] rW = new double[uni];
        rTT[0] = readsTimesTranscripts[sortIdxs[0]];
        rW[0] = readWeights2[sortIdxs[0]];
        int idx = 0;
        int i3 = 1;
        while (i3 < sortIdxs.length) {
            boolean eq = true;
            boolean[] x = readsTimesTranscripts[sortIdxs[i3]];
            boolean[] y = readsTimesTranscripts[sortIdxs[i3 - 1]];
            int j = 0;
            while (j < x.length) {
                if (x[j] != y[j]) {
                    eq = false;
                    break;
                }
                ++j;
            }
            if (eq) {
                int n = idx;
                rW[n] = rW[n] + readWeights2[sortIdxs[i3]];
            } else {
                rTT[++idx] = x;
                rW[idx] = readWeights2[sortIdxs[i3]];
            }
            ++i3;
        }
        return new Pair<boolean[][], double[]>(rTT, rW);
    }

    private void printPercentUnique(boolean[][] readsTimesTranscripts) {
        try {
            boolean[][] x = (boolean[][])ArrayHandler.clone((Cloneable[])readsTimesTranscripts);
            Arrays.sort(x, new Comparator<boolean[]>(){

                @Override
                public int compare(boolean[] o1, boolean[] o2) {
                    int i = 0;
                    while (i < o1.length) {
                        if (o1[i] && !o2[i]) {
                            return 1;
                        }
                        if (!o1[i] && o2[i]) {
                            return -1;
                        }
                        ++i;
                    }
                    return 0;
                }
            });
            int uni = 1;
            int i = 1;
            while (i < x.length) {
                boolean eq = true;
                int j = 0;
                while (j < x[i].length) {
                    if (x[i][j] != x[i - 1][j]) {
                        eq = false;
                        break;
                    }
                    ++j;
                }
                if (!eq) {
                    ++uni;
                }
                ++i;
            }
            System.out.println("%: " + uni + " " + x.length);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    private double delta(double[] aPrioriPrev, double[] aPrioriTranscripts) {
        double d = 0.0;
        int i = 0;
        while (i < aPrioriPrev.length) {
            d += (aPrioriPrev[i] - aPrioriTranscripts[i]) * (aPrioriPrev[i] - aPrioriTranscripts[i]);
            ++i;
        }
        return d;
    }

    private char getStrand(double[] aPrioriTranscripts, boolean[][] readsTimesTranscripts, double[] readWeights, int t, double[] relTranscriptLen, double[] intronWeights, double[] cdsWeights) {
        double[] counts = new double[3];
        int i = 0;
        while (i < readsTimesTranscripts.length) {
            char strand = this.strands.get(i).charValue();
            double[] gamma = new double[aPrioriTranscripts.length];
            SplicingGraph.gamma(gamma, aPrioriTranscripts, readsTimesTranscripts[i], readWeights[i], relTranscriptLen, intronWeights, cdsWeights);
            if (strand == '+') {
                counts[0] = counts[0] + gamma[t];
            } else if (strand == '-') {
                counts[2] = counts[2] + gamma[t];
            } else {
                counts[1] = counts[1] + gamma[t];
            }
            ++i;
        }
        Normalisation.sumNormalisation(counts);
        if (counts[0] > 0.8) {
            return '+';
        }
        if (counts[2] > 0.8) {
            return '-';
        }
        return '.';
    }

    private static final double gamma(double[] gamma, double[] aPrioriTranscripts, boolean[] readsTimesTranscripts, double readWeight, double[] relTranscriptLen, double[] intronWeights, double[] cdsWeights) {
        boolean found = false;
        int j = 0;
        while (j < gamma.length) {
            if (readsTimesTranscripts[j]) {
                gamma[j] = aPrioriTranscripts[j] / relTranscriptLen[j] * intronWeights[j] * cdsWeights[j];
                found = true;
            }
            ++j;
        }
        if (found) {
            double temp = SplicingGraph.sumNormalisation(gamma);
            return readWeight * Math.log(temp);
        }
        return 0.0;
    }

    private static final double gamma(double[][] gamma, double[] aPrioriTranscripts, boolean[][] readsTimesTranscripts, double[] readWeights, double[] relTranscriptLen, double[] intronWeights, double[] cdsWeights) {
        double d = 0.0;
        int i = 0;
        while (i < gamma.length) {
            d += SplicingGraph.gamma(gamma[i], aPrioriTranscripts, readsTimesTranscripts[i], readWeights[i], relTranscriptLen, intronWeights, cdsWeights);
            ++i;
        }
        return d;
    }

    private static double getIntronWeight(double[] numIntrons, int j) {
        return 1.0;
    }

    public static final double sumNormalisation(double[] gamma) {
        double sum = 0.0;
        int i = 0;
        while (i < gamma.length) {
            sum += gamma[i];
            ++i;
        }
        i = 0;
        while (i < gamma.length) {
            int n = i++;
            gamma[n] = gamma[n] / sum;
        }
        return sum;
    }

    private static final void aPriori(double[] aPrioriTranscripts, double[][] gamma, double[] readWeights) {
        Arrays.fill(aPrioriTranscripts, 0.0);
        int i = 0;
        while (i < gamma.length) {
            int j = 0;
            while (j < gamma[i].length) {
                int n = j;
                aPrioriTranscripts[n] = aPrioriTranscripts[n] + gamma[i][j] * readWeights[i];
                ++j;
            }
            ++i;
        }
        SplicingGraph.sumNormalisation(aPrioriTranscripts);
    }

    public LinkedList<Transcript> optimize(LinkedList<Transcript> original, double lambda1, double lambda2) throws DimensionException, TerminationException, IOException, EvaluationException, Exception {
        double[] target = new double[this.contRegs.length];
        int i = 0;
        while (i < target.length) {
            target[i] = this.contRegs[i].readIdxs.length;
            ++i;
        }
        System.out.println(Arrays.toString(target));
        int[][] assignment = new int[original.size()][];
        int i2 = 0;
        for (Transcript t : original) {
            assignment[i2] = new int[t.exons.size()];
            int j = 0;
            for (Integer k : t.exons) {
                assignment[i2][j] = k;
                ++j;
            }
            ++i2;
        }
        double[] w = new double[original.size() + 1];
        Arrays.fill(w, 1.0);
        TranscriptLasso lasso = new TranscriptLasso(assignment, target, lambda1, lambda2);
        Optimizer.optimize((byte)18, lasso, w, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-9), 1.0E-9, new ConstantStartDistance(1.0E-4), SafeOutputStream.getSafeOutputStream(System.out));
        System.out.println(Arrays.toString(w));
        LinkedList<Transcript> opt = new LinkedList<Transcript>();
        double thresh = Math.min(0.0, ToolBox.max(w));
        i2 = 0;
        for (Transcript t : original) {
            if (w[i2] >= thresh) {
                opt.add(t);
            }
            ++i2;
        }
        return opt;
    }

    /*
     * WARNING - void declaration
     */
    public void enumerateTranscripts(LinkedList<Transcript> results, double minReads, double minFraction) {
        void var7_6;
        LinkedList<ComparableElement<Integer, Double>> starts = new LinkedList<ComparableElement<Integer, Double>>();
        boolean bl = false;
        while (var7_6 < this.contRegs.length) {
            if (this.contRegs[var7_6].left.size() == 0) {
                starts.add(new ComparableElement<Integer, Double>((int)var7_6, -((double)this.contRegs[var7_6].readIdxs.length)));
            }
            ++var7_6;
        }
        Collections.sort(starts);
        for (ComparableElement comparableElement : starts) {
            LinkedList<Integer> exons = new LinkedList<Integer>();
            exons.add((Integer)comparableElement.getElement());
            LinkedList<Integer> introns = new LinkedList<Integer>();
            this.enumerate(exons, introns, results, minReads, minFraction);
        }
    }

    private void enumerate(LinkedList<Integer> exons, LinkedList<Integer> introns, LinkedList<Transcript> results, double minReads, double minFraction) {
        if (results.size() > 1000) {
            System.out.println("#" + results.size());
            return;
        }
        if (this.adjList[exons.getLast()].size() == 0) {
            if ((double)this.contRegs[exons.getLast()].readIdxs.length >= minReads) {
                Transcript temp = new Transcript(exons, introns);
                results.add(temp);
            }
        } else {
            boolean rec = false;
            int forLater = -1;
            int numForLater = 0;
            for (ComparableElement comparableElement : this.adjList[exons.getLast()]) {
                if ((double)this.introns[(Integer)comparableElement.getWeight()].readIdxs.length >= minReads && (double)this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length >= minReads) {
                    double inter;
                    double max = Math.max(((ReadGraph.Node)this.contRegs[exons.getLast()].readNodes.getLast()).getNumberOfReads(), ((ReadGraph.Node)this.contRegs[(Integer)comparableElement.getElement()].readNodes.getFirst()).getNumberOfReads());
                    if (!(max * minFraction < (inter = (double)this.introns[(Integer)comparableElement.getWeight()].readIdxs.length))) continue;
                    exons.addLast((Integer)comparableElement.getElement());
                    introns.addLast((Integer)comparableElement.getWeight());
                    this.enumerate(exons, introns, results, minReads, minFraction);
                    rec = true;
                    exons.removeLast();
                    introns.removeLast();
                    continue;
                }
                if (!((double)this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length >= minReads) || this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length <= numForLater) continue;
                numForLater = this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length;
                forLater = (Integer)comparableElement.getElement();
            }
        }
    }

    public void enumerateTranscripts2(LinkedList<Transcript> results, double minReads, double minFraction, double maxNum) {
        LinkedList<ComparableElement<Integer, Double>> starts = new LinkedList<ComparableElement<Integer, Double>>();
        double totalNum = this.countTranscripts(minReads, minFraction);
        double totalSum = 0.0;
        int i = 0;
        while (i < this.contRegs.length) {
            if (this.contRegs[i].left.size() == 0) {
                starts.add(new ComparableElement<Integer, Double>(i, -((double)this.contRegs[i].readIdxs.length)));
                totalSum += (double)this.contRegs[i].getNumberOfReads() * ToolBox.sum(this.adjCounts[i]);
            }
            ++i;
        }
        if (totalNum < maxNum) {
            this.enumerateTranscripts(results, minReads, minFraction);
            return;
        }
        double theoCount = 0.0;
        Collections.sort(starts);
        for (ComparableElement comparableElement : starts) {
            double prob = ToolBox.sum(this.adjCounts[(Integer)comparableElement.getElement()]) * (double)this.contRegs[(Integer)comparableElement.getElement()].getNumberOfReads() / totalSum;
            theoCount += prob * maxNum;
            LinkedList<Integer> exons = new LinkedList<Integer>();
            exons.add((Integer)comparableElement.getElement());
            LinkedList<Integer> introns = new LinkedList<Integer>();
            this.enumerate2(exons, introns, results, minReads, minFraction, maxNum * prob);
            if ((double)results.size() > maxNum) break;
            if (!(theoCount > (double)results.size())) continue;
            maxNum += theoCount - (double)results.size();
        }
    }

    private void enumerate2(LinkedList<Integer> exons, LinkedList<Integer> introns, LinkedList<Transcript> results, double minReads, double minFraction, double maxTranscripts) {
        if (this.adjList[exons.getLast()].size() == 0) {
            if ((double)this.contRegs[exons.getLast()].readIdxs.length >= minReads) {
                Transcript temp = new Transcript(exons, introns);
                results.add(temp);
            }
        } else {
            double totalSum = 0.0;
            for (ComparableElement comparableElement : this.adjList[exons.getLast()]) {
                totalSum += (double)this.contRegs[(Integer)comparableElement.getElement()].getNumberOfReads() * this.adjCounts[exons.getLast()][(Integer)comparableElement.getElement()];
            }
            if (totalSum == 0.0) {
                return;
            }
            double d = results.size();
            double theoCount = 0.0;
            boolean rec = false;
            int forLater = -1;
            int numForLater = 0;
            for (ComparableElement comparableElement : this.adjList[exons.getLast()]) {
                if ((double)this.introns[(Integer)comparableElement.getWeight()].readIdxs.length >= minReads && (double)this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length >= minReads) {
                    double inter;
                    double max = Math.max(((ReadGraph.Node)this.contRegs[exons.getLast()].readNodes.getLast()).getNumberOfReads(), ((ReadGraph.Node)this.contRegs[(Integer)comparableElement.getElement()].readNodes.getFirst()).getNumberOfReads());
                    if (!(max * minFraction < (inter = (double)this.introns[(Integer)comparableElement.getWeight()].readIdxs.length))) continue;
                    double prob = this.adjCounts[exons.getLast()][(Integer)comparableElement.getElement()] * (double)this.contRegs[(Integer)comparableElement.getElement()].getNumberOfReads() / totalSum;
                    theoCount += maxTranscripts * prob;
                    exons.addLast((Integer)comparableElement.getElement());
                    introns.addLast((Integer)comparableElement.getWeight());
                    rec = true;
                    this.enumerate2(exons, introns, results, minReads, minFraction, maxTranscripts * prob);
                    exons.removeLast();
                    introns.removeLast();
                    if ((double)results.size() - d > maxTranscripts) break;
                    if (!(theoCount > (double)results.size() - d)) continue;
                    maxTranscripts += theoCount - ((double)results.size() - d);
                    continue;
                }
                if (!((double)this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length >= minReads) || this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length <= numForLater) continue;
                numForLater = this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length;
                forLater = (Integer)comparableElement.getElement();
            }
        }
    }

    public double countTranscripts(double minReads, double minFraction) {
        LinkedList<ComparableElement<Integer, Double>> starts = new LinkedList<ComparableElement<Integer, Double>>();
        int i = 0;
        while (i < this.contRegs.length) {
            if (this.contRegs[i].left.size() == 0) {
                starts.add(new ComparableElement<Integer, Double>(i, -((double)this.contRegs[i].readIdxs.length)));
            }
            ++i;
        }
        double sum = 0.0;
        Collections.sort(starts);
        for (ComparableElement comparableElement : starts) {
            LinkedList<Integer> exons = new LinkedList<Integer>();
            exons.add((Integer)comparableElement.getElement());
            LinkedList<Integer> introns = new LinkedList<Integer>();
            sum += this.count(exons, introns, minReads, minFraction);
            if (!(sum > 1000000.0)) continue;
            return sum;
        }
        return sum;
    }

    private double count(LinkedList<Integer> exons, LinkedList<Integer> introns, double minReads, double minFraction) {
        double count = 0.0;
        if (exons.size() > 0 && this.adjList[exons.getLast()].size() == 0) {
            if ((double)this.contRegs[exons.getLast()].readIdxs.length >= minReads) {
                count += 1.0;
            }
        } else {
            for (ComparableElement comparableElement : this.adjList[exons.getLast()]) {
                double inter;
                double max;
                if (!((double)this.introns[(Integer)comparableElement.getWeight()].readIdxs.length >= minReads) || !((double)this.contRegs[(Integer)comparableElement.getElement()].readIdxs.length >= minReads) || !((max = (double)Math.max(((ReadGraph.Node)this.contRegs[exons.getLast()].readNodes.getLast()).getNumberOfReads(), ((ReadGraph.Node)this.contRegs[(Integer)comparableElement.getElement()].readNodes.getFirst()).getNumberOfReads())) * minFraction < (inter = (double)this.introns[(Integer)comparableElement.getWeight()].readIdxs.length))) continue;
                int temp = exons.getLast();
                exons.addLast((Integer)comparableElement.getElement());
                introns.addLast((Integer)comparableElement.getWeight());
                double temp2 = this.count(exons, introns, minReads, minFraction);
                double[] dArray = this.adjCounts[temp];
                int n = (Integer)comparableElement.getElement();
                dArray[n] = dArray[n] + temp2;
                count += temp2;
                if (count > 1000000.0) {
                    return count;
                }
                exons.removeLast();
                introns.removeLast();
            }
        }
        return count;
    }

    private ContiguousRegion[] getContRegs(LinkedList<Integer> exons) {
        ContiguousRegion[] res = new ContiguousRegion[exons.size()];
        int j = 0;
        Iterator iterator = exons.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            res[j] = this.contRegs[i];
            ++j;
        }
        return res;
    }

    public LinkedList<Transcript> testSplitByORF(LinkedList<Transcript> list, int[] proposedSplits, int minProteinLength) {
        LinkedList<Transcript> res = new LinkedList<Transcript>();
        boolean split = false;
        for (Transcript t : list) {
            char tempStrand = t.getStrand();
            t.addStrandAndCDS(minProteinLength, true);
            double utrFrac = 1.0 - (double)(t.cdsEnd - t.cdsStart) / (double)t.getLength();
            t.setStrand(tempStrand);
            t.cdsEnd = -1;
            t.cdsStart = -1;
            if (t.getNumberOfIntrons() < 1 && utrFrac < 0.5) {
                res.add(t);
                continue;
            }
            int s = res.size();
            t.testSplitByORF(res, proposedSplits, true, minProteinLength);
            split |= res.size() - s > 1;
        }
        return res;
    }

    public LinkedList<Transcript> testSplitByORF(LinkedList<Transcript> list, int minProteinLength) {
        LinkedList<Transcript> res = new LinkedList<Transcript>();
        boolean split = false;
        for (Transcript t : list) {
            if (t.getNumberOfIntrons() < 1) {
                res.add(t);
                continue;
            }
            int s = res.size();
            t.testSplitByORF2(res, minProteinLength);
            split |= res.size() - s > 1;
        }
        return res;
    }

    public LinkedList<Transcript> testSplitBySpliceSitesAndORF(LinkedList<Transcript> list, int minProteinLength) {
        LinkedList<Transcript> res = new LinkedList<Transcript>();
        boolean split = false;
        for (Transcript t : list) {
            if (t.getNumberOfIntrons() == 0) {
                res.add(t);
                continue;
            }
            boolean temp = t.testSplitBySpliceSitesAndORF2(res, minProteinLength);
            split |= temp;
        }
        return res;
    }

    private void makeUnique(LinkedList<Transcript> res) {
        Collections.sort(res, new Comparator<Transcript>(){

            @Override
            public int compare(Transcript o1, Transcript o2) {
                int e2;
                int e1;
                int s2;
                int s1 = o1.getFirstIntronPredecessor();
                int cmp = Integer.compare(s1, s2 = o2.getFirstIntronPredecessor());
                if (cmp == 0 && (cmp = Integer.compare(e1 = o1.getLastIntronSuccessor(), e2 = o2.getLastIntronSuccessor())) == 0) {
                    int x1 = o1.getFirstIntronPredecessor();
                    int x2 = o2.getFirstIntronPredecessor();
                    int i = 0;
                    while (i < o1.exons.size() && (Integer)o1.exons.get(i) < x1) {
                        ++i;
                    }
                    int j = 0;
                    while (j < o2.exons.size() && (Integer)o2.exons.get(j) < x2) {
                        ++j;
                    }
                    int k = 0;
                    while (i + k < o1.exons.size() && j + k < o2.exons.size()) {
                        cmp = Integer.compare((Integer)o1.exons.get(i + k), (Integer)o2.exons.get(j + k));
                        if (cmp != 0) {
                            return cmp;
                        }
                        ++k;
                    }
                }
                return cmp;
            }
        });
        IntList toRemove = new IntList();
        int i = 0;
        Transcript last = null;
        int lastIdx = -1;
        for (Transcript t : res) {
            if (t.equalsIntronChain(last) && t.overlaps(last)) {
                if (last.getEnd() - last.getStart() > t.getEnd() - t.getStart()) {
                    toRemove.add(i);
                } else {
                    if (toRemove.length() == 0 || toRemove.get(toRemove.length() - 1) != lastIdx) {
                        toRemove.add(lastIdx);
                    }
                    last = t;
                    lastIdx = i;
                }
            } else {
                last = t;
                lastIdx = i;
            }
            ++i;
        }
        toRemove.sort();
        i = toRemove.length() - 1;
        while (i >= 0) {
            res.remove(toRemove.get(i));
            --i;
        }
    }

    public LinkedList<Transcript>[] splitByLocationAndMakeUnique(LinkedList<Transcript> list, int minProteinLength, ExtractRNAseqEvidence.Stranded stranded) {
        Collections.sort(list);
        int endPlus = 0;
        int endMinus = 0;
        int endOther = 0;
        LinkedList lplus = null;
        LinkedList lminus = null;
        LinkedList lother = null;
        for (Transcript t : list) {
            char strand = t.getStrand();
            if (strand == '.') {
                strand = t.getStrandByIntrons();
            }
            if (strand == '+') {
                if (lplus == null) {
                    lplus = new LinkedList();
                }
                if (t.getStart() > endPlus) {
                    lplus.add(new LinkedList());
                }
                ((LinkedList)lplus.getLast()).add(t);
                if (t.getEnd() > endPlus) {
                    endPlus = t.getEnd();
                }
            } else if (strand == '-') {
                if (lminus == null) {
                    lminus = new LinkedList();
                }
                if (t.getStart() > endMinus) {
                    lminus.add(new LinkedList());
                }
                ((LinkedList)lminus.getLast()).add(t);
                if (t.getEnd() > endMinus) {
                    endMinus = t.getEnd();
                }
            } else {
                int diffplus = t.getStart() - endPlus;
                int diffminus = t.getStart() - endMinus;
                if (stranded == ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED && (lplus != null && diffplus < 0 || lminus != null && diffminus < 0)) {
                    if (diffplus < diffminus) {
                        ((LinkedList)lplus.getLast()).add(t);
                    } else {
                        ((LinkedList)lminus.getLast()).add(t);
                    }
                } else {
                    if (lother == null) {
                        lother = new LinkedList();
                    }
                    if (t.getStart() > endOther) {
                        lother.add(new LinkedList());
                    }
                    ((LinkedList)lother.getLast()).add(t);
                    if (t.getEnd() > endOther) {
                        endOther = t.getEnd();
                    }
                }
            }
            t.addStrandAndCDS(minProteinLength, false);
        }
        if (lother != null && lother.size() == 1) {
            if (lplus == null && lminus != null && lminus.size() == 1) {
                ((LinkedList)lminus.getFirst()).addAll((Collection)lother.getFirst());
                lother = null;
            } else if (lplus != null && lminus == null && lplus.size() == 1) {
                ((LinkedList)lplus.getFirst()).addAll((Collection)lother.getFirst());
                lother = null;
            }
        }
        LinkedList res = new LinkedList();
        if (lother != null) {
            res.addAll(lother);
        }
        if (lplus != null) {
            res.addAll(lplus);
        }
        if (lminus != null) {
            res.addAll(lminus);
        }
        for (LinkedList li : res) {
            this.makeUnique(li);
        }
        return res.toArray(new LinkedList[0]);
    }

    public LinkedList<Transcript>[] splitByStrandAndMakeUnique(LinkedList<Transcript> sList, int minProteinLength) {
        LinkedList[] sList2 = new LinkedList[]{new LinkedList(), new LinkedList(), new LinkedList()};
        for (Transcript t : sList) {
            t.addStrandAndCDS(minProteinLength, false);
            if (t.getStrand() == '+') {
                sList2[1].add(t);
                continue;
            }
            if (t.getStrand() == '-') {
                sList2[2].add(t);
                continue;
            }
            sList2[0].add(t);
        }
        if (sList2[1].size() == 0 && sList2[2].size() > 0) {
            sList2[2].addAll(sList2[0]);
            sList2[0].clear();
        } else if (sList2[1].size() > 0 && sList2[2].size() == 0) {
            sList2[1].addAll(sList2[0]);
            sList2[0].clear();
        }
        this.makeUnique(sList2[0]);
        this.makeUnique(sList2[1]);
        this.makeUnique(sList2[2]);
        return sList2;
    }

    private static class CDSCandidateList {
        private int[] lens;
        private int[] frames;
        private int[] idxs;
        private double[] vals;
        private boolean[] lasts;

        private CDSCandidateList(int numBest) {
            this.lens = new int[numBest];
            this.frames = new int[numBest];
            this.idxs = new int[numBest];
            this.vals = new double[numBest];
            this.lasts = new boolean[numBest];
        }

        private void add(int len, int frame, int numCDSIntrons, int numIntrons, int idx, boolean last) {
            double val = this.getValue(len, frame, numCDSIntrons, numIntrons, idx);
            int i = this.vals.length;
            while (i > 0 && val > this.vals[i - 1]) {
                --i;
            }
            if (i < this.vals.length) {
                int j = i;
                while (j < this.vals.length - 1) {
                    this.vals[j + 1] = this.vals[j];
                    this.lens[j + 1] = this.lens[j];
                    this.frames[j + 1] = this.frames[j];
                    this.idxs[j + 1] = this.idxs[j];
                    this.lasts[j + 1] = this.lasts[j];
                    ++j;
                }
                this.vals[i] = val;
                this.lens[i] = len;
                this.frames[i] = frame;
                this.idxs[i] = idx;
                this.lasts[i] = last;
            }
        }

        private double getValue(int len, int frame, int numCDSIntrons, int numIntrons, int idx) {
            return (double)len * (1.0 + 0.1 * (double)numCDSIntrons + 0.1 * ((double)numCDSIntrons + 1.0) / ((double)numIntrons + 1.0));
        }

        public int[] getBest() {
            if (this.vals[0] > 0.0) {
                return new int[]{this.lens[0], this.frames[0], this.idxs[0], this.lasts[0] ? 1 : 0};
            }
            int[] nArray = new int[4];
            nArray[3] = -1;
            return nArray;
        }
    }

    private class ContiguousRegion {
        private int regionStart;
        private int regionEnd;
        private LinkedList<ReadGraph.Node> readNodes;
        private int[] readIdxs;
        private int numReads;
        private int[] firstReadIdxs;
        private int[] lastReadIdxs;
        private LinkedList<Intron> left;
        private LinkedList<Intron> right;

        public ContiguousRegion(int regionStart, int regionEnd, LinkedList<ReadGraph.Node> readNodes) {
            this.regionStart = regionStart;
            this.regionEnd = regionEnd;
            this.readNodes = readNodes;
            this.numReads = 0;
            for (ReadGraph.Node node : readNodes) {
                if (node.getNumberOfReads() <= this.numReads) continue;
                this.numReads = node.getNumberOfReads();
            }
            this.left = new LinkedList();
            this.right = new LinkedList();
        }

        public void setSortedReads(int[] readIdxs, int[] firstReadIdxs, int[] lastReadIdxs) {
            this.readIdxs = readIdxs;
            this.numReads = readIdxs.length;
            this.firstReadIdxs = firstReadIdxs;
            this.lastReadIdxs = lastReadIdxs;
        }

        public int getNumberOfReads() {
            return this.numReads;
        }

        public String toString() {
            return this.toString(SplicingGraph.this.regionStart);
        }

        public String toString(int offset) {
            return String.valueOf(SplicingGraph.this.chromosome) + "\tcontReg\texon\t" + (offset + this.regionStart) + "\t" + (offset + this.regionEnd) + "\t.\t+\t.\tID=" + this.regionStart + "-" + this.regionEnd + "; left=" + this.left.size() + "; right=" + this.right.size() + "; cov=" + this.getCoverage();
        }

        public double getCoverage() {
            double cov = 0.0;
            double n = 0.0;
            for (ReadGraph.Node node : this.readNodes) {
                cov += (double)node.getNumberOfReads();
                n += 1.0;
            }
            return cov / n;
        }
    }

    public class Gene {
        private LinkedList<Transcript> transcripts;
        private String id;
        private char strand;

        public Gene(String id, LinkedList<Transcript> transcripts, char strand) {
            this.id = id;
            this.transcripts = transcripts;
            this.strand = strand;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int start = Integer.MAX_VALUE;
            int end = -1;
            for (Transcript t : this.transcripts) {
                if (t.getStart() < start) {
                    start = t.getStart();
                }
                if (t.getEnd() <= end) continue;
                end = t.getEnd();
            }
            buf.append(String.valueOf(SplicingGraph.this.chromosome) + "\t" + "GeMoRNA\t" + "gene\t" + start + "\t" + end + "\t" + ".\t" + this.strand + "\t" + ".\t" + "ID=" + this.id + ";" + "\n");
            for (Transcript t : this.transcripts) {
                buf.append(t.toString());
            }
            return buf.toString();
        }

        public String getChrom() {
            return SplicingGraph.this.chromosome;
        }
    }

    private class Intron
    implements Comparable {
        private ContiguousRegion left;
        private ContiguousRegion right;
        private ReadGraph.Edge edge;
        private int[] readIdxs;

        public Intron(ContiguousRegion left, ContiguousRegion right, ReadGraph.Edge edge) {
            this.left = left;
            this.right = right;
            this.edge = edge;
        }

        public double[] getFractions() {
            int[] leftReads = this.left.lastReadIdxs;
            int[] rightReads = this.right.firstReadIdxs;
            double leftIntersect = SplicingGraph.intersectSortedArrays(leftReads, this.readIdxs).length;
            double rightIntersect = SplicingGraph.intersectSortedArrays(rightReads, this.readIdxs).length;
            double nLeft = leftReads.length;
            double nRight = rightReads.length;
            return new double[]{leftIntersect / nLeft, rightIntersect / nRight};
        }

        public double getCoverage() {
            return this.edge.getNumberOfReads();
        }

        public String toString() {
            return this.toString(SplicingGraph.this.regionStart);
        }

        public String toString(int offset) {
            return String.valueOf(SplicingGraph.this.chromosome) + "\tintron\tintron\t" + (offset + this.left.regionEnd + 1) + "\t" + (offset + this.right.regionStart - 1) + "\t.\t+\t.\tID=" + this.left.regionEnd + "-" + this.right.regionStart + "; left=" + this.left.regionStart + "-" + this.left.regionEnd + "; right=" + this.right.regionStart + "-" + this.right.regionEnd + "; cov=" + this.getCoverage() + "; frac=" + Arrays.toString(this.getFractions());
        }

        public int getStart() {
            return this.left.regionEnd + 1;
        }

        public int getEnd() {
            return this.right.regionStart - 1;
        }

        public int getLength() {
            return this.right.regionStart - this.left.regionEnd - 1;
        }

        public int compareTo(Object o) {
            if (o instanceof Intron) {
                Intron i = (Intron)o;
                return Integer.compare(this.readIdxs.length, i.readIdxs.length);
            }
            return 1;
        }

        public boolean isCanonical(int shortestIntronLength) {
            if (this.edge.getRelEnd() - this.edge.getRelStart() + 1 < shortestIntronLength) {
                return false;
            }
            char[] chr = Genome.genome.getChromosome(SplicingGraph.this.chromosome);
            int lastEnd = this.left.regionEnd;
            int start = this.right.regionStart;
            char left1 = chr[SplicingGraph.this.regionStart + lastEnd];
            char left2 = chr[SplicingGraph.this.regionStart + lastEnd + 1];
            char right1 = chr[SplicingGraph.this.regionStart + start - 3];
            char right2 = chr[SplicingGraph.this.regionStart + start - 2];
            boolean res = true;
            res = 'G' == left1 && 'T' == left2 || 'G' == left1 && 'C' == left2 || 'C' == left1 && 'T' == left2 || 'A' == left1 && 'T' == left2 ? (res &= true) : (res &= false);
            res = 'A' == right1 && 'G' == right2 || 'A' == right1 && 'C' == right2 || 'G' == right1 && 'C' == right2 || 'A' == right1 && 'C' == right2 || 'A' == right1 && 'T' == right2 ? (res &= true) : (res &= false);
            return res;
        }

        public char getStrandBySpliceSites(int shortestIntronLength) {
            if (this.edge.getRelEnd() - this.edge.getRelStart() + 1 < shortestIntronLength) {
                return '.';
            }
            char[] chr = Genome.genome.getChromosome(SplicingGraph.this.chromosome);
            int lastEnd = this.left.regionEnd;
            int start = this.right.regionStart;
            char left1 = chr[SplicingGraph.this.regionStart + lastEnd];
            char left2 = chr[SplicingGraph.this.regionStart + lastEnd + 1];
            char right1 = chr[SplicingGraph.this.regionStart + start - 3];
            char right2 = chr[SplicingGraph.this.regionStart + start - 2];
            if ('G' == left1 && 'T' == left2 && 'A' == right1 && 'G' == right2) {
                return '+';
            }
            if ('C' == left1 && 'T' == left2 && 'A' == right1 && 'C' == right2) {
                return '-';
            }
            return '.';
        }
    }

    private static class IntronKey {
        private static int hashInt = 35;
        private int start;
        private int end;

        public IntronKey(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public void setStartEnd(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object o) {
            return ((IntronKey)o).start == this.start && ((IntronKey)o).end == this.end;
        }

        public int hashCode() {
            int value = this.start;
            value = value * 31 + hashInt;
            value = value * 31 + this.end;
            return value;
        }
    }

    private static class StopIterator
    implements Iterator<int[]> {
        private char[] sequence;
        private int offset;
        private int len;
        private int start;

        private StopIterator() {
        }

        public void set(char[] sequence, int offset) {
            this.sequence = sequence;
            this.offset = offset;
            this.len = -1;
            this.start = -3;
        }

        public boolean isAtEnd() {
            return this.len < 0 && this.offset + 3 > this.sequence.length;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.len >= 0) {
                return true;
            }
            localOff = this.offset;
            if (this.offset + 3 <= this.sequence.length) ** GOTO lbl13
            return false;
lbl-1000:
            // 1 sources

            {
                if (Genome.isStop[this.sequence[this.offset]][this.sequence[this.offset + 1]][this.sequence[this.offset + 2]]) {
                    this.len = this.offset - localOff;
                    this.offset += 3;
                    return true;
                }
                if (Genome.isStart[this.sequence[this.offset]][this.sequence[this.offset + 1]][this.sequence[this.offset + 2]] && this.start < 0) {
                    this.start = this.offset - localOff;
                }
                this.offset += 3;
lbl13:
                // 2 sources

                ** while (this.offset + 3 <= this.sequence.length)
            }
lbl14:
            // 1 sources

            this.len = this.offset - localOff;
            return true;
        }

        @Override
        public int[] next() {
            int[] temp = new int[]{this.len / 3, this.start / 3};
            this.len = -1;
            this.start = -3;
            return temp;
        }
    }

    public class Transcript
    implements Comparable {
        private LinkedList<Integer> exons;
        private LinkedList<Integer> introns;
        private String id;
        private String geneID;
        private double abundance;
        private char strand;
        private int cdsStart;
        private int cdsEnd;
        private int extraLeft;
        private int extraRight;
        private HashMap<String, String> attributes;

        private Transcript(LinkedList<Integer> exons, LinkedList<Integer> introns) {
            this.exons = (LinkedList)exons.clone();
            this.introns = (LinkedList)introns.clone();
            this.id = "T";
            this.strand = (char)46;
            this.cdsStart = -1;
            this.cdsEnd = -1;
        }

        public char determineStrandFromReads() {
            char temp;
            int j;
            int[] idxs;
            int countplus = 0;
            int countminus = 0;
            int i = 0;
            while (i < this.exons.size()) {
                idxs = SplicingGraph.this.contRegs[this.exons.get(i)].readIdxs;
                j = 0;
                while (j < idxs.length) {
                    temp = ((Character)SplicingGraph.this.strands.get(j)).charValue();
                    if (temp == '+') {
                        ++countplus;
                    } else if (temp == '-') {
                        ++countminus;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.introns.size()) {
                idxs = SplicingGraph.this.introns[this.introns.get(i)].readIdxs;
                j = 0;
                while (j < idxs.length) {
                    temp = ((Character)SplicingGraph.this.strands.get(j)).charValue();
                    if (temp == '+') {
                        ++countplus;
                    } else if (temp == '-') {
                        ++countminus;
                    }
                    ++j;
                }
                ++i;
            }
            if (countplus > countminus * 2) {
                return '+';
            }
            if (countminus > countplus * 2) {
                return '-';
            }
            return '.';
        }

        public double getAbundance() {
            return this.abundance;
        }

        public char getStrand() {
            return this.strand;
        }

        public void setStrand(char strand) {
            this.strand = strand;
        }

        public void setGene(String geneID) {
            this.geneID = geneID;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setAbundance(double abundance) {
            this.abundance = abundance;
        }

        public void setCDSStartEnd(int start, int end) {
            int l = this.getLength();
            while (start < 0) {
                start += 3;
            }
            while (end > l) {
                end -= 3;
            }
            this.cdsStart = start;
            this.cdsEnd = end;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int ce = 0;
            int i = 0;
            int start = -1;
            int end = -1;
            int currPos = 0;
            char startAS = 'X';
            char stopAS = 'X';
            String[] exStrings = new String[this.exons.size()];
            String[][] cdsStrings = new String[this.exons.size()][];
            int[] lens = new int[this.exons.size()];
            while (i < this.exons.size()) {
                start = SplicingGraph.this.contRegs[this.exons.get(i)].regionStart;
                if (i == 0) {
                    start += this.extraLeft;
                }
                end = SplicingGraph.this.contRegs[this.exons.get(i)].regionEnd;
                while (i + 1 < this.exons.size() && SplicingGraph.this.contRegs[this.exons.get(i)].regionEnd + 1 == SplicingGraph.this.contRegs[this.exons.get(i + 1)].regionStart) {
                    end = SplicingGraph.this.contRegs[this.exons.get(++i)].regionEnd;
                }
                if (i == this.exons.size() - 1) {
                    end += this.extraRight;
                }
                int currLen = end - start + 1;
                exStrings[i] = String.valueOf(SplicingGraph.this.chromosome) + "\t" + "GeMoRNA\t" + "exon\t" + (SplicingGraph.this.regionStart + start) + "\t" + (SplicingGraph.this.regionStart + end) + "\t" + ".\t" + this.strand + "\t" + ".\t" + "Parent=" + this.id + "\n";
                if (this.cdsStart > -1 && currPos + currLen > this.cdsStart && currPos <= this.cdsEnd) {
                    int locCdsStart = currPos > this.cdsStart ? start : start + (this.cdsStart - currPos);
                    int locCdsEnd = currPos + currLen <= this.cdsEnd ? end : start + (this.cdsEnd - currPos);
                    cdsStrings[i] = new String[]{String.valueOf(SplicingGraph.this.chromosome) + "\t" + "GeMoRNA\t" + "CDS\t" + (SplicingGraph.this.regionStart + locCdsStart) + "\t" + (SplicingGraph.this.regionStart + locCdsEnd) + "\t" + ".\t" + this.strand + "\t", "\tParent=" + this.id + "\n"};
                    ++ce;
                    lens[i] = locCdsEnd - locCdsStart + 1;
                }
                currPos += currLen;
                ++i;
            }
            double tie = 0.0;
            int minSplitReads = Integer.MAX_VALUE;
            if (SplicingGraph.this.introns.length == 0 || SplicingGraph.this.introns[0].readIdxs == null) {
                tie = Double.NaN;
                minSplitReads = 0;
            } else {
                i = 0;
                while (i < this.introns.size()) {
                    int temp = SplicingGraph.this.introns[this.introns.get(i)].readIdxs.length;
                    tie += (double)(temp > 0 ? 1 : 0);
                    if (temp < minSplitReads) {
                        minSplitReads = temp;
                    }
                    ++i;
                }
                tie /= (double)this.introns.size();
            }
            int aa = 0;
            if (this.cdsStart > -1) {
                aa = this.getCDSLength() / 3;
            }
            if (this.cdsStart > -1) {
                Character asChar;
                String key;
                if (this.strand == '-') {
                    key = this.getCodon(this.cdsStart);
                    asChar = Genome.code.get(key = Tools.rc(key));
                    if (asChar != null) {
                        stopAS = asChar.charValue();
                    }
                    key = this.getCodon(this.cdsEnd - 2);
                    asChar = Genome.code.get(key = Tools.rc(key));
                    if (asChar != null) {
                        startAS = asChar.charValue();
                    }
                } else {
                    key = this.getCodon(this.cdsStart);
                    asChar = Genome.code.get(key);
                    if (asChar != null) {
                        startAS = asChar.charValue();
                    }
                    if ((asChar = Genome.code.get(key = this.getCodon(this.cdsEnd - 2))) != null) {
                        stopAS = asChar.charValue();
                    }
                }
            }
            int minCov = Integer.MAX_VALUE;
            double avgCov = 0.0;
            double n = 0.0;
            double tpc = 0.0;
            i = 0;
            while (i < this.exons.size()) {
                for (ReadGraph.Node node : SplicingGraph.this.contRegs[this.exons.get(i)].readNodes) {
                    int temp = node.getNumberOfReads();
                    if (temp < minCov) {
                        minCov = temp;
                    }
                    avgCov += (double)temp;
                    if (temp > 0) {
                        tpc += 1.0;
                    }
                    n += 1.0;
                }
                ++i;
            }
            i = 0;
            while (i < this.introns.size()) {
                int temp = 0;
                if (SplicingGraph.this.introns.length != 0 && SplicingGraph.this.introns[0].readIdxs != null) {
                    temp = SplicingGraph.this.introns[this.introns.get(i)].readIdxs.length;
                }
                if (temp < minCov) {
                    minCov = temp;
                }
                avgCov += (double)temp;
                if (temp > 0) {
                    tpc += 1.0;
                }
                n += 1.0;
                ++i;
            }
            buf.append(String.valueOf(SplicingGraph.this.chromosome) + "\t" + "GeMoRNA\t" + "mRNA\t" + (SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[this.exons.getFirst()].regionStart + this.extraLeft) + "\t" + (SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[this.exons.getLast()].regionEnd + this.extraRight) + "\t" + ".\t" + this.strand + "\t" + ".\t" + "ID=" + this.id + ";" + "Parent=" + this.geneID + ";" + "percentCanonical=" + this.percentCanonicalSpliceSites() + ";" + "aa=" + aa + ";" + "score=" + df.format(this.abundance) + ";" + "ce=" + ce + ";" + "minCov=" + minCov + ";" + "avgCov=" + df.format(avgCov /= n) + ";" + "tpc=" + (tpc /= n) + ";" + "tie=" + tie + ";" + "start=" + startAS + ";" + "stop=" + stopAS + ";" + "minSplitReads=" + minSplitReads + ";" + (this.attributes == null ? "" : this.attributes.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + (String)e.getValue()).reduce("", (t, u) -> String.valueOf(t) + "; " + u)) + "\n");
            if (this.strand == '-') {
                int phase = 0;
                i = exStrings.length - 1;
                while (i >= 0) {
                    if (exStrings[i] != null) {
                        buf.append(exStrings[i]);
                    }
                    if (cdsStrings[i] != null) {
                        buf.append(String.valueOf(cdsStrings[i][0]) + phase + cdsStrings[i][1]);
                        int rest = (3 - phase + lens[i]) % 3;
                        phase = (3 - rest) % 3;
                    }
                    --i;
                }
            } else {
                int phase = 0;
                i = 0;
                while (i < exStrings.length) {
                    if (exStrings[i] != null) {
                        buf.append(exStrings[i]);
                    }
                    if (cdsStrings[i] != null) {
                        buf.append(String.valueOf(cdsStrings[i][0]) + phase + cdsStrings[i][1]);
                        int rest = (3 - phase + lens[i]) % 3;
                        phase = (3 - rest) % 3;
                    }
                    ++i;
                }
            }
            return buf.toString();
        }

        private String getCodon(int codonStart) {
            char[] chromosome = Genome.genome.getChromosome(SplicingGraph.this.chromosome);
            char[] codon = new char[3];
            int ci = 0;
            int i = 0;
            int off = 0;
            for (Integer idx : this.exons) {
                int start = SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[idx].regionStart - 1;
                int end = SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[idx].regionEnd;
                if (i == 0) {
                    start = SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[idx].regionStart - 1 + this.extraLeft;
                }
                if (i == this.exons.size() - 1) {
                    end = SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[idx].regionEnd + this.extraRight;
                }
                if (start < 0) {
                    start = 0;
                }
                if (end > chromosome.length) {
                    end = chromosome.length;
                }
                if (end > start) {
                    if (off <= codonStart + ci && off + (end - start) > codonStart + ci) {
                        int k = ci;
                        int l = 0;
                        while (k < 3 && start + codonStart - off + k < end) {
                            codon[k] = chromosome[start + codonStart - off + k];
                            ++ci;
                            ++k;
                            ++l;
                        }
                    }
                    off += end - start;
                }
                ++i;
            }
            return new String(codon);
        }

        private char[] getSequence(int extraLeft, int extraRight) {
            char[] chromosome = Genome.genome.getChromosome(SplicingGraph.this.chromosome);
            int l = this.getLength(extraLeft, extraRight);
            char[] res = new char[l];
            int i = 0;
            int off = 0;
            for (Integer idx : this.exons) {
                int start = SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[idx].regionStart - 1;
                int end = SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[idx].regionEnd;
                if (i == 0) {
                    start = SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[idx].regionStart - 1 + extraLeft;
                }
                if (i == this.exons.size() - 1) {
                    end = SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[idx].regionEnd + extraRight;
                }
                if (start < 0) {
                    start = 0;
                }
                if (end > chromosome.length) {
                    end = chromosome.length;
                }
                if (end > start) {
                    System.arraycopy(chromosome, start, res, off, end - start);
                    off += end - start;
                }
                ++i;
            }
            if (off < res.length) {
                char[] res2 = new char[off];
                System.arraycopy(res, 0, res2, 0, off);
                res = res2;
            }
            return res;
        }

        public int getLength() {
            return this.getLength(this.extraLeft, this.extraRight);
        }

        public int getLength(int extraLeft, int extraRight) {
            int l = 0;
            int i = 0;
            while (i < this.exons.size()) {
                int idx = this.exons.get(i);
                int start = SplicingGraph.this.contRegs[idx].regionStart - 1;
                int end = SplicingGraph.this.contRegs[idx].regionEnd;
                if (i == 0) {
                    start = SplicingGraph.this.contRegs[idx].regionStart - 1 + extraLeft;
                }
                if (i == this.exons.size() - 1) {
                    end = SplicingGraph.this.contRegs[idx].regionEnd + extraRight;
                }
                l += end - start;
                ++i;
            }
            return l;
        }

        public void addStrandAndCDS(int minProteinLength, boolean forTestSplit) {
            this.addStrandAndCDS(false, minProteinLength, forTestSplit);
        }

        public void addStrandAndCDS(boolean fix, int minProteinLength, boolean forTestSplit) {
            boolean isLast;
            int tl;
            if (this.strand == '.') {
                this.strand = this.getStrandByIntrons();
            }
            if ((tl = this.getLength()) + 2 * Math.min(50, tl) < minProteinLength * 3) {
                return;
            }
            char tempStrand = this.strand;
            if (fix) {
                this.extraRight = 0;
                this.extraLeft = 0;
            }
            char[] seqOrig = this.getSequence(this.extraLeft, this.extraRight);
            char[] seqRc = null;
            char[] longSeqOrig = null;
            char[] longSeqRc = null;
            int maxLonger = Math.min(50, seqOrig.length / 3);
            char[] chromosome = Genome.genome.getChromosome(SplicingGraph.this.chromosome);
            int tempLeft = -this.extraLeft;
            int tempRight = this.extraRight;
            if (fix) {
                tempLeft = Math.min((SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[this.exons.getFirst()].regionStart - 1) / 3, maxLonger) * 3;
                tempRight = Math.min((chromosome.length - (SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[this.exons.getLast()].regionEnd)) / 3, maxLonger) * 3;
                longSeqOrig = this.getSequence(-tempLeft, tempRight);
            }
            HashMap<String, Character> code = Genome.code;
            int firstD = 1;
            int lastD = -1;
            if (this.strand == '+') {
                lastD = 1;
            } else if (this.strand == '-') {
                firstD = -1;
            }
            int numIntrons = this.getNumberOfIntrons();
            CDSCandidateList candList = new CDSCandidateList(3);
            StopIterator it = new StopIterator();
            int d = firstD;
            while (d >= lastD) {
                char[] seq = seqOrig;
                char[] longSeq = longSeqOrig;
                if (d < 0) {
                    seqRc = Tools.rc(seqOrig);
                    seq = seqRc;
                    if (longSeqOrig != null) {
                        longSeq = longSeqRc = Tools.rc(longSeqOrig);
                    }
                }
                int i = 1;
                while (i <= 3) {
                    it.set(seq, i - 1);
                    boolean beforeContainsStart = false;
                    boolean afterContainsStop = false;
                    if (longSeq != null) {
                        int lastStop = this.containsLastStop(longSeq, i - 1, 0, (d < 0 ? tempRight : tempLeft) + i - 1 - 3) - (i - 1);
                        if (lastStop < 0) {
                            lastStop = 0;
                        }
                        beforeContainsStart = this.containsStart(longSeq, i - 1, lastStop, (d < 0 ? tempRight : tempLeft) + (i - 1)) >= 0;
                        afterContainsStop = this.containsStop(longSeq, i - 1, seq.length + (d < 0 ? tempRight : tempLeft) - (seq.length - (i - 1)) % 3 - (i - 1)) >= 0;
                    }
                    int off = 0;
                    int j = 0;
                    while (it.hasNext()) {
                        int[] lenstart = it.next();
                        int length = lenstart[0];
                        int start = lenstart[1];
                        if (start < 0) {
                            start = j == 0 && beforeContainsStart ? 0 : length + 1;
                        }
                        int len = length - start + 1;
                        if (it.hasNext() || it.isAtEnd() || afterContainsStop) {
                            int numCDSIntrons = 0;
                            numCDSIntrons = d > 0 ? this.getNumberOfCDSIntrons((off + start) * 3, (off + length + 1) * 3) : this.getNumberOfCDSIntrons(seq.length - (off + length + 1) * 3, seq.length - (off + start) * 3);
                            candList.add(len, d * i, numCDSIntrons, numIntrons, j, !it.hasNext());
                        }
                        off += length + 1;
                        ++j;
                    }
                    ++i;
                }
                d -= 2;
            }
            int[] bestCand = candList.getBest();
            int maxLen = bestCand[0];
            int frame = bestCand[1];
            int maxIdx = bestCand[2];
            boolean bl = isLast = bestCand[3] == 1;
            if (maxLen + tempLeft / 3 + tempRight / 3 < minProteinLength) {
                return;
            }
            char[] seq = seqOrig;
            char[] longSeq = longSeqOrig;
            if (frame < 0) {
                seq = seqRc;
                longSeq = longSeqRc;
            }
            if (this.strand == '.') {
                this.strand = (char)43;
                if (frame < 0) {
                    this.strand = (char)45;
                }
            }
            if (this.strand == '-') {
                frame = -frame;
            }
            if (frame != 0) {
                int protlen = (seq.length - (frame - 1)) / 3;
                it.set(seq, frame - 1);
                if (fix) {
                    int stopPos;
                    boolean b2;
                    int posStart;
                    int cpos2;
                    int cpos;
                    boolean fixed = false;
                    if (isLast && (cpos = (cpos2 = this.containsStop(longSeq, frame - 1, seq.length + (posStart = (this.strand == '-' ? tempRight : tempLeft) - (seq.length - (frame - 1)) % 3 - (frame - 1))) - (this.strand == '-' ? tempRight : tempLeft) - (frame - 1)) / 3) >= 0) {
                        cpos = cpos * 3 - protlen * 3 + 3;
                        if (this.strand == '+') {
                            this.extraRight = cpos;
                        } else if (this.strand == '-') {
                            this.extraLeft = -cpos;
                        }
                        fixed = true;
                    }
                    boolean bl2 = b2 = this.containsStart(seq, frame - 1, 0, (stopPos = this.containsStop(seq, frame - 1, 0)) < 0 ? seq.length : stopPos) < 0;
                    if (maxIdx == 0 && b2) {
                        int firstStart;
                        int lastStop = this.containsLastStop(longSeq, frame - 1, 0, (this.strand == '-' ? tempRight : tempLeft) + frame - 1 - 3) - (frame - 1);
                        int cpos3 = lastStop / 3;
                        if (cpos3 < 0) {
                            cpos3 = 0;
                        }
                        if (lastStop < 0) {
                            lastStop = 0;
                        }
                        if ((cpos3 = (firstStart = this.containsStart(longSeq, frame - 1, lastStop, (this.strand == '-' ? tempRight : tempLeft) + frame - 1) - (frame - 1)) / 3) >= 0) {
                            cpos3 = firstStart = (this.strand == '-' ? tempRight : tempLeft) + (frame == 1 ? 3 : 0) - firstStart;
                            if (this.strand == '+') {
                                this.extraLeft = -cpos3;
                            } else if (this.strand == '-') {
                                this.extraRight = cpos3;
                            }
                            fixed = true;
                        }
                    }
                    if (fixed) {
                        this.addStrandAndCDS(false, minProteinLength, forTestSplit);
                        return;
                    }
                }
                it.set(seq, frame - 1);
                int j = 0;
                int off = frame - 1;
                while (it.hasNext() && j < maxIdx) {
                    int[] lenstart = it.next();
                    int length = lenstart[0];
                    off += (length + 1) * 3;
                    ++j;
                }
                int[] lenstart = it.next();
                int temp2 = lenstart[1] * 3;
                if (temp2 < 0) {
                    if (maxIdx > 0) {
                        throw new RuntimeException();
                    }
                    temp2 = 0;
                }
                off += temp2;
                if (!forTestSplit && (double)(maxLen * 3) < (double)seq.length / 20.0 || maxLen < minProteinLength) {
                    this.cdsEnd = -1;
                    this.cdsStart = -1;
                    this.strand = tempStrand;
                } else if (this.strand == '+') {
                    this.cdsStart = off;
                    this.cdsEnd = off + maxLen * 3 - 1;
                } else {
                    this.cdsStart = seq.length - (off + maxLen * 3);
                    this.cdsEnd = seq.length - off - 1;
                }
            }
        }

        private int containsLastStop(char[] seq, int offset, int start, int end) {
            int j = end;
            while (j - 3 >= offset + start) {
                if (Genome.isStop[seq[j]][seq[j + 1]][seq[j + 2]]) {
                    return j;
                }
                j -= 3;
            }
            return -3;
        }

        private int containsStop(char[] seq, int offset, int start) {
            int j = offset + start;
            while (j + 3 <= seq.length) {
                if (Genome.isStop[seq[j]][seq[j + 1]][seq[j + 2]]) {
                    return j;
                }
                j += 3;
            }
            return -3;
        }

        private int containsStart(char[] seq, int offset, int start, int end) {
            int j = offset + start;
            while (j + 3 <= end) {
                if (Genome.isStart[seq[j]][seq[j + 1]][seq[j + 2]]) {
                    return j;
                }
                j += 3;
            }
            return -3;
        }

        public char getStrandByIntrons() {
            double[][] intronVotes = this.getIntronVotes();
            double nplus = ToolBox.sum(intronVotes[0]);
            double nminus = ToolBox.sum(intronVotes[1]);
            int strand = this.strand;
            if ((nplus + 1.0) / (nplus + nminus + 2.0) >= 0.75) {
                strand = 43;
            } else if ((nminus + 1.0) / (nplus + nminus + 2.0) >= 0.75) {
                strand = 45;
            }
            return (char)strand;
        }

        public int getStart() {
            return SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[this.exons.getFirst()].regionStart + this.extraLeft;
        }

        public int getEnd() {
            return SplicingGraph.this.regionStart + SplicingGraph.this.contRegs[this.exons.getLast()].regionEnd + this.extraRight;
        }

        public int compareTo(Object o) {
            if (o instanceof Transcript) {
                Transcript t = (Transcript)o;
                int cmpStart = Integer.compare(this.getStart(), t.getStart());
                if (cmpStart == 0) {
                    return Integer.compare(this.getEnd(), t.getEnd());
                }
                return cmpStart;
            }
            return -1;
        }

        public int getNumberOfIntrons() {
            int n = 0;
            Iterator it = this.exons.iterator();
            Integer idx = (Integer)it.next();
            while (it.hasNext()) {
                int start;
                int lastEnd = SplicingGraph.this.contRegs[idx].regionEnd;
                if (lastEnd + 1 >= (start = SplicingGraph.this.contRegs[idx = (Integer)it.next()].regionStart)) continue;
                ++n;
            }
            return n;
        }

        public int getNumberOfCDSIntrons(int cdsStart, int cdsEnd) {
            int n = 0;
            Iterator it = this.exons.iterator();
            Integer idx = (Integer)it.next();
            int len = SplicingGraph.this.contRegs[idx].regionEnd - SplicingGraph.this.contRegs[idx].regionStart + 1;
            while (it.hasNext()) {
                int start;
                int lastEnd = SplicingGraph.this.contRegs[idx].regionEnd;
                if (lastEnd + 1 < (start = SplicingGraph.this.contRegs[idx = (Integer)it.next()].regionStart) && len > cdsStart && len <= cdsEnd) {
                    ++n;
                }
                len += SplicingGraph.this.contRegs[idx].regionEnd - SplicingGraph.this.contRegs[idx].regionStart + 1;
            }
            return n;
        }

        public double percentCanonicalSpliceSites() {
            double[][] intronVotes = this.getIntronVotes();
            Iterator it = this.exons.iterator();
            Integer idx = (Integer)it.next();
            double n = 0.0;
            double canonical = 0.0;
            int i = 1;
            while (it.hasNext()) {
                int start;
                int lastEnd = SplicingGraph.this.contRegs[idx].regionEnd;
                if (lastEnd + 1 < (start = SplicingGraph.this.contRegs[idx = (Integer)it.next()].regionStart)) {
                    canonical = this.strand == '-' ? (canonical += intronVotes[1][i]) : (this.strand == '+' ? (canonical += intronVotes[0][i]) : (canonical += intronVotes[0][i] + intronVotes[1][i]));
                    n += 2.0;
                }
                ++i;
            }
            if (n == 0.0) {
                return -1.0;
            }
            return canonical / n;
        }

        private double[][] getIntronVotes() {
            char[] chromosome = Genome.genome.getChromosome(SplicingGraph.this.chromosome);
            double[][] intronVotes = new double[2][this.exons.size()];
            Iterator it = this.exons.iterator();
            Integer idx = (Integer)it.next();
            int i = 1;
            while (it.hasNext()) {
                int start;
                int lastEnd = SplicingGraph.this.contRegs[idx].regionEnd;
                if (lastEnd + 1 < (start = SplicingGraph.this.contRegs[idx = (Integer)it.next()].regionStart)) {
                    char left1 = chromosome[SplicingGraph.this.regionStart + lastEnd];
                    char left2 = chromosome[SplicingGraph.this.regionStart + lastEnd + 1];
                    char right1 = chromosome[SplicingGraph.this.regionStart + start - 3];
                    char right2 = chromosome[SplicingGraph.this.regionStart + start - 2];
                    if ('G' == left1 && 'T' == left2) {
                        double[] dArray = intronVotes[0];
                        int n = i;
                        dArray[n] = dArray[n] + 1.0;
                    } else if ('G' == left1 && 'C' == left2) {
                        double[] dArray = intronVotes[0];
                        int n = i;
                        dArray[n] = dArray[n] + 0.5;
                    } else if ('C' == left1 && 'T' == left2) {
                        double[] dArray = intronVotes[1];
                        int n = i;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    if ('A' == right1 && 'G' == right2) {
                        double[] dArray = intronVotes[0];
                        int n = i;
                        dArray[n] = dArray[n] + 1.0;
                    } else if ('A' == right1 && 'C' == right2) {
                        double[] dArray = intronVotes[1];
                        int n = i;
                        dArray[n] = dArray[n] + 1.0;
                    } else if ('G' == right1 && 'C' == right2) {
                        double[] dArray = intronVotes[1];
                        int n = i;
                        dArray[n] = dArray[n] + 0.5;
                    }
                }
                ++i;
            }
            return intronVotes;
        }

        private int[][] getExonsIntronsAndLengths(int[] possibleSplitPositions) {
            int[] numExon = new int[this.exons.size()];
            int num = 0;
            int i = 1;
            while (i < this.exons.size()) {
                if (SplicingGraph.this.contRegs[this.exons.get(i - 1)].regionEnd + 1 != SplicingGraph.this.contRegs[this.exons.get(i)].regionStart) {
                    // empty if block
                }
                numExon[i] = ++num;
                ++i;
            }
            int[] possibleSplitExons = new int[possibleSplitPositions.length];
            int[] possibleSplitIntrons = new int[possibleSplitPositions.length];
            Arrays.fill(possibleSplitExons, -1);
            Arrays.fill(possibleSplitIntrons, -1);
            int i2 = 0;
            while (i2 < possibleSplitPositions.length) {
                int splitpos = possibleSplitPositions[i2];
                int j = 0;
                while (j < this.exons.size()) {
                    if (SplicingGraph.this.contRegs[this.exons.get(j)].regionStart + SplicingGraph.this.regionStart < splitpos && SplicingGraph.this.contRegs[this.exons.get(j)].regionEnd + SplicingGraph.this.regionStart > splitpos) {
                        possibleSplitExons[i2] = j;
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.exons.size() - 1) {
                    if (SplicingGraph.this.contRegs[this.exons.get(j)].regionEnd + SplicingGraph.this.regionStart < splitpos && SplicingGraph.this.contRegs[this.exons.get(j + 1)].regionStart + SplicingGraph.this.regionStart >= splitpos) {
                        possibleSplitIntrons[i2] = j;
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            int[] cumSum = new int[this.exons.size()];
            int i3 = 0;
            while (i3 < this.exons.size()) {
                cumSum[i3] = i3 == 0 ? SplicingGraph.this.contRegs[this.exons.get(i3)].regionEnd - SplicingGraph.this.contRegs[this.exons.get(i3)].regionStart + 1 : cumSum[i3 - 1] + SplicingGraph.this.contRegs[this.exons.get(i3)].regionEnd - SplicingGraph.this.contRegs[this.exons.get(i3)].regionStart + 1;
                ++i3;
            }
            return new int[][]{possibleSplitExons, possibleSplitIntrons, cumSum};
        }

        private int[][] getExonsAndLengths(int[] possibleSplitPositions) {
            int[] numExon = new int[this.exons.size()];
            int num = 0;
            int i = 1;
            while (i < this.exons.size()) {
                if (SplicingGraph.this.contRegs[this.exons.get(i - 1)].regionEnd + 1 != SplicingGraph.this.contRegs[this.exons.get(i)].regionStart) {
                    // empty if block
                }
                numExon[i] = ++num;
                ++i;
            }
            int[] possibleSplitExons = new int[possibleSplitPositions.length];
            Arrays.fill(possibleSplitExons, -1);
            int i2 = 0;
            while (i2 < possibleSplitPositions.length) {
                int splitpos = possibleSplitPositions[i2];
                int j = 0;
                while (j < this.exons.size()) {
                    if (SplicingGraph.this.contRegs[this.exons.get(j)].regionStart + SplicingGraph.this.regionStart < splitpos && SplicingGraph.this.contRegs[this.exons.get(j)].regionEnd + SplicingGraph.this.regionStart > splitpos) {
                        if (numExon[j] <= 0 || numExon[j] >= numExon[numExon.length - 1]) break;
                        possibleSplitExons[i2] = j;
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            int[] cumSum = new int[this.exons.size()];
            int i3 = 0;
            while (i3 < this.exons.size()) {
                cumSum[i3] = i3 == 0 ? SplicingGraph.this.contRegs[this.exons.get(i3)].regionEnd - SplicingGraph.this.contRegs[this.exons.get(i3)].regionStart + 1 : cumSum[i3 - 1] + SplicingGraph.this.contRegs[this.exons.get(i3)].regionEnd - SplicingGraph.this.contRegs[this.exons.get(i3)].regionStart + 1;
                ++i3;
            }
            return new int[][]{possibleSplitExons, cumSum};
        }

        public void testSplitByORF(LinkedList<Transcript> res, int[] possibleSplitPositions, boolean checkAllHaveCDS, int minProteinLength) {
            possibleSplitPositions = (int[])possibleSplitPositions.clone();
            LinkedList<Transcript> curr = new LinkedList<Transcript>();
            curr.add(this);
            while (curr.size() > 0) {
                Transcript t = (Transcript)curr.removeFirst();
                char tempStrand = t.strand;
                t.addStrandAndCDS(minProteinLength, true);
                int[][] temp = t.getExonsIntronsAndLengths(possibleSplitPositions);
                int[] possibleSplitExons = temp[0];
                int[] possibleSplitIntrons = temp[1];
                int[] cumSum = temp[2];
                int idx = -1;
                boolean intron = false;
                int i = 0;
                while (i < possibleSplitExons.length) {
                    if (possibleSplitIntrons[i] >= 0) {
                        if (cumSum[possibleSplitIntrons[i]] < t.cdsStart) {
                            idx = i;
                            intron = true;
                        } else if (cumSum[possibleSplitIntrons[i]] > t.cdsEnd) {
                            idx = i;
                            intron = true;
                            break;
                        }
                    } else if (possibleSplitExons[i] > 0 && possibleSplitExons[i] < t.exons.size() - 1) {
                        if (cumSum[possibleSplitExons[i] - 1] < t.cdsStart) {
                            idx = i;
                            intron = false;
                        } else if (cumSum[possibleSplitExons[i]] > t.cdsEnd) {
                            idx = i;
                            intron = false;
                            break;
                        }
                    }
                    ++i;
                }
                if (idx > -1) {
                    Transcript[] s = null;
                    s = intron ? t.splitIntoTwo(possibleSplitIntrons[idx], true) : t.splitIntoTwo(possibleSplitExons[idx], false);
                    possibleSplitPositions[idx] = -1;
                    if (t.getNumberOfIntrons() > 3 && (s[0].getNumberOfIntrons() == 0 || s[1].getNumberOfIntrons() == 0)) {
                        curr.add(t);
                        continue;
                    }
                    s[0].addStrandAndCDS(minProteinLength, true);
                    s[1].addStrandAndCDS(minProteinLength, true);
                    if (s[0].cdsStart == -1) {
                        s[0].extraLeft = 0;
                        s[0].addStrandAndCDS(true, minProteinLength, false);
                    }
                    if (s[1].cdsStart == -1) {
                        s[1].extraRight = 0;
                        s[1].addStrandAndCDS(true, minProteinLength, false);
                    }
                    if (!checkAllHaveCDS || s[0].cdsStart > -1 && s[1].cdsStart > -1) {
                        s[0].strand = (char)46;
                        s[1].strand = (char)46;
                        s[0].cdsEnd = -1;
                        s[0].cdsStart = -1;
                        s[1].cdsEnd = -1;
                        s[1].cdsStart = -1;
                        s[0].extraLeft = t.extraLeft;
                        s[1].extraRight = t.extraRight;
                        curr.add(s[0]);
                        curr.add(s[1]);
                        continue;
                    }
                    curr.add(t);
                    continue;
                }
                t.strand = tempStrand;
                t.cdsStart = -1;
                t.cdsEnd = -1;
                res.add(t);
            }
        }

        public void testSplitByORF2(LinkedList<Transcript> res, int minProteinLength) {
            Transcript[] test;
            char oldstrand = this.strand;
            this.addStrandAndCDS(minProteinLength, true);
            int cdsStartIdx = -1;
            int cdsEndIdx = -1;
            int currPos = 0;
            int i = 0;
            while (i < this.exons.size()) {
                int start = SplicingGraph.this.contRegs[this.exons.get(i)].regionStart;
                int end = SplicingGraph.this.contRegs[this.exons.get(i)].regionEnd;
                int currLen = end - start + 1;
                if (this.cdsStart >= currPos && this.cdsStart < currPos + currLen) {
                    cdsStartIdx = i;
                }
                if (this.cdsEnd >= currPos && this.cdsEnd < currPos + currLen) {
                    cdsEndIdx = i;
                }
                currPos += currLen;
                ++i;
            }
            Transcript t1 = null;
            Transcript t2 = null;
            if (cdsStartIdx > 0 && cdsStartIdx < this.exons.size() - 1 && this.cdsStart > 500 && (test = this.splitIntoTwo(cdsStartIdx, false))[0].getNumberOfIntrons() > 1 && test[1].getNumberOfIntrons() > 1) {
                Transcript t1First = test[0];
                Transcript t2First = test[1];
                t2First.strand = this.strand;
                t1First.addStrandAndCDS(minProteinLength, true);
                t2First.addStrandAndCDS(minProteinLength, true);
                if (t1First.cdsEnd - t1First.cdsStart > 500 && t2First.cdsEnd - t2First.cdsStart > 500) {
                    t1 = t1First;
                    t2 = t2First;
                }
            }
            if (cdsEndIdx > 0 && cdsEndIdx < this.exons.size() - 1 && currPos - this.cdsEnd > 500 && (test = this.splitIntoTwo(cdsEndIdx, false))[0].getNumberOfIntrons() > 1 && test[1].getNumberOfIntrons() > 1) {
                Transcript t1Second = test[0];
                Transcript t2Second = test[1];
                t1Second.strand = this.strand;
                t1Second.addStrandAndCDS(minProteinLength, true);
                t2Second.addStrandAndCDS(minProteinLength, true);
                if (t1Second.cdsEnd - t1Second.cdsStart > 500 && t2Second.cdsEnd - t2Second.cdsStart > 500 && (t1 == null || t1Second.cdsEnd - t1Second.cdsStart + t2Second.cdsEnd - t2Second.cdsStart > t1.cdsEnd - t1.cdsStart + t2.cdsEnd - t2.cdsStart)) {
                    t1 = t1Second;
                    t2 = t2Second;
                }
            }
            if (t1 != null) {
                res.add(new Transcript(t1.exons, t1.introns));
                res.add(new Transcript(t2.exons, t2.introns));
            } else {
                this.cdsStart = -1;
                this.cdsEnd = -1;
                this.strand = oldstrand;
                res.add(this);
            }
        }

        private Transcript[] splitIntoTwo(int possibleSplit, boolean isIntron) {
            LinkedList<Integer> exons1 = new LinkedList<Integer>();
            LinkedList<Integer> exons2 = new LinkedList<Integer>();
            LinkedList<Integer> introns1 = new LinkedList<Integer>();
            LinkedList<Integer> introns2 = new LinkedList<Integer>();
            int i = 0;
            while (i <= possibleSplit & i < this.exons.size()) {
                exons1.add(this.exons.get(i));
                ++i;
            }
            i = possibleSplit + (isIntron ? 1 : 0);
            while (i < this.exons.size()) {
                exons2.add(this.exons.get(i));
                ++i;
            }
            i = 0;
            while (i < this.introns.size()) {
                if (SplicingGraph.this.introns[this.introns.get(i)].right.regionStart <= SplicingGraph.this.contRegs[exons1.getLast()].regionStart) {
                    introns1.add(this.introns.get(i));
                } else if (SplicingGraph.this.introns[this.introns.get(i)].left.regionEnd >= SplicingGraph.this.contRegs[exons2.getFirst()].regionEnd) {
                    introns2.add(this.introns.get(i));
                }
                ++i;
            }
            Transcript t1 = new Transcript(exons1, introns1);
            t1.extraLeft = this.extraLeft;
            Transcript t2 = new Transcript(exons2, introns2);
            t2.extraRight = this.extraRight;
            return new Transcript[]{t1, t2};
        }

        public boolean testSplitBySpliceSitesAndORF2(LinkedList<Transcript> resL, int minProteinLength) {
            double[][] intronVotes = this.getIntronVotes();
            IntList idxs = new IntList();
            int i = 0;
            int last = 0;
            while (i < intronVotes[0].length) {
                int j;
                boolean didit = false;
                while (i < intronVotes[0].length && (intronVotes[0][i] > 1.0 || intronVotes[0][i] == 0.0 && intronVotes[1][i] == 0.0)) {
                    ++i;
                    didit = true;
                }
                if (i > last && i < intronVotes[0].length) {
                    j = i - 1;
                    while (j > 0 && intronVotes[0][j] == 0.0 && intronVotes[1][j] == 0.0) {
                        idxs.add(j - 1);
                        --j;
                    }
                    idxs.add(i - 1);
                    last = i;
                }
                while (i < intronVotes[1].length && (intronVotes[1][i] > 1.0 || intronVotes[0][i] == 0.0 && intronVotes[1][i] == 0.0)) {
                    ++i;
                    didit = true;
                }
                if (i > last && i < intronVotes[1].length) {
                    j = i - 1;
                    while (j > 0 && intronVotes[0][j] == 0.0 && intronVotes[1][j] == 0.0) {
                        idxs.add(j - 1);
                        --j;
                    }
                    idxs.add(i - 1);
                    last = i;
                }
                if (didit) continue;
                last = ++i;
            }
            int minIdx = 0;
            while (minIdx < intronVotes[0].length && intronVotes[0][minIdx] == 0.0 && intronVotes[1][minIdx] == 0.0) {
                ++minIdx;
            }
            int maxIdx = intronVotes[0].length - 1;
            while (maxIdx >= 0 && intronVotes[0][maxIdx] == 0.0 && intronVotes[1][maxIdx] == 0.0) {
                --maxIdx;
            }
            IntList idxs2 = new IntList();
            i = 0;
            while (i < idxs.length()) {
                if (idxs.get(i) >= minIdx && idxs.get(i) <= maxIdx) {
                    idxs2.add(idxs.get(i));
                }
                ++i;
            }
            if (idxs2.length() == 0) {
                resL.add(this);
                return false;
            }
            IntList pos = new IntList();
            i = 0;
            while (i < idxs2.length()) {
                pos.add(SplicingGraph.this.regionStart + (SplicingGraph.this.contRegs[this.exons.get(idxs2.get(i))].regionStart + SplicingGraph.this.contRegs[this.exons.get(idxs2.get(i))].regionEnd) / 2);
                ++i;
            }
            pos.sort();
            int before = resL.size();
            this.testSplitByORF(resL, pos.toArray(), false, minProteinLength);
            return resL.size() > before;
        }

        private int getFirstIntronPredecessor() {
            int s1 = SplicingGraph.this.contRegs[this.exons.getFirst()].regionEnd;
            int x1 = this.exons.getFirst();
            int i = 1;
            while (i < this.exons.size() && SplicingGraph.this.contRegs[this.exons.get(i)].regionStart == s1 + 1) {
                x1 = this.exons.get(i);
                s1 = SplicingGraph.this.contRegs[x1].regionEnd;
                ++i;
            }
            if (i == this.exons.size()) {
                x1 = -1;
            }
            return x1;
        }

        private int getLastIntronSuccessor() {
            int e1 = SplicingGraph.this.contRegs[this.exons.getLast()].regionStart;
            int x1 = this.exons.getLast();
            int i = this.exons.size() - 2;
            while (i >= 0 && SplicingGraph.this.contRegs[this.exons.get(i)].regionEnd == e1 - 1) {
                x1 = this.exons.get(i);
                e1 = SplicingGraph.this.contRegs[x1].regionStart;
                --i;
            }
            if (i < 0) {
                x1 = -1;
            }
            return x1;
        }

        public boolean equalsIntronChain(Transcript last) {
            int y2;
            if (last == null) {
                return false;
            }
            int x1 = this.getFirstIntronPredecessor();
            int x2 = last.getFirstIntronPredecessor();
            if (x1 == -1 && x2 == -1) {
                return true;
            }
            if (x1 != x2) {
                return false;
            }
            int y1 = this.getLastIntronSuccessor();
            if (y1 != (y2 = last.getLastIntronSuccessor())) {
                return false;
            }
            int i = 0;
            while (i < this.exons.size() && this.exons.get(i) < x1) {
                ++i;
            }
            int j = 0;
            while (j < last.exons.size() && last.exons.get(j) < x2) {
                ++j;
            }
            int k = 0;
            while (i + k < this.exons.size() && j + k < last.exons.size() && this.exons.get(i + k) < y1 && last.exons.get(j + k) < y2) {
                if (this.exons.get(i + k) != last.exons.get(j + k)) {
                    return false;
                }
                ++k;
            }
            return this.exons.get(i + k) == y1 && last.exons.get(j + k) == y2;
        }

        public boolean overlaps(Transcript last) {
            return this.getStart() >= last.getStart() && this.getStart() <= last.getEnd() || this.getEnd() >= last.getStart() && this.getEnd() <= last.getEnd();
        }

        public double getMaximumNumberOfReads() {
            int num = 0;
            int i = 0;
            while (i < this.exons.size()) {
                int idx = this.exons.get(i);
                if (SplicingGraph.this.contRegs[idx].getNumberOfReads() > num) {
                    num = SplicingGraph.this.contRegs[idx].getNumberOfReads();
                }
                ++i;
            }
            return num;
        }

        public double getMaximumNumberOfCoveringIntronReads(LinkedList<ReadGraph.Edge> intronEdges, int edgeRegionStart) {
            int start = this.getStart();
            int end = this.getEnd();
            int num = intronEdges.stream().filter(e -> e.getRelStart() + edgeRegionStart < start && e.getRelEnd() + edgeRegionStart > end).map(e -> e.getNumberOfReads()).reduce(0, (a, b) -> Math.max(a, b));
            return num;
        }

        public int getCDSLength() {
            if (this.cdsStart < 0) {
                return 0;
            }
            return this.cdsEnd - this.cdsStart + 1;
        }

        public double getUTRFraction() {
            return 1.0 - (double)this.getCDSLength() / (double)this.getLength();
        }
    }

    public class TranscriptLasso
    extends DifferentiableFunction {
        private int[][] assign;
        private double[] totalLen;
        private double[] target;
        private double[] vals;
        private double lambda1;
        private double lambda2;

        public TranscriptLasso(int[][] assign, double[] target, double lambda1, double lambda2) {
            this.assign = assign;
            this.totalLen = new double[assign.length];
            int i = 0;
            while (i < assign.length) {
                int j = 0;
                while (j < assign[i].length) {
                    int n = i;
                    this.totalLen[n] = this.totalLen[n] + (double)(SplicingGraph.this.contRegs[assign[i][j]].regionEnd - SplicingGraph.this.contRegs[assign[i][j]].regionStart + 1);
                    ++j;
                }
                ++i;
            }
            this.target = target;
            this.vals = new double[target.length];
            this.lambda1 = lambda1;
            this.lambda2 = lambda2;
        }

        @Override
        public double evaluateFunction(double[] weights) throws DimensionException, EvaluationException {
            Arrays.fill(this.vals, 0.0);
            int i = 0;
            while (i < this.assign.length) {
                int j = 0;
                while (j < this.assign[i].length) {
                    int n = this.assign[i][j];
                    this.vals[n] = this.vals[n] + Math.exp(weights[i]) / this.totalLen[i] * (double)(SplicingGraph.this.contRegs[this.assign[i][j]].regionEnd - SplicingGraph.this.contRegs[this.assign[i][j]].regionStart + 1);
                    ++j;
                }
                ++i;
            }
            double val = 0.0;
            int i2 = 0;
            while (i2 < this.target.length) {
                double temp = this.vals[i2] * Math.exp(weights[weights.length - 1]) - this.target[i2];
                val += temp * temp;
                ++i2;
            }
            i2 = 0;
            while (i2 < weights.length) {
                val += this.lambda1 * Math.abs(Math.exp(weights[i2]));
                val += this.lambda2 * Math.exp(2.0 * weights[i2]);
                ++i2;
            }
            return val;
        }

        @Override
        public int getDimensionOfScope() {
            return this.assign.length + 1;
        }

        @Override
        public double[] evaluateGradientOfFunction(double[] weights) throws DimensionException, EvaluationException {
            double[] grad = new double[weights.length];
            Arrays.fill(this.vals, 0.0);
            int i = 0;
            while (i < this.assign.length) {
                int j = 0;
                while (j < this.assign[i].length) {
                    int n = this.assign[i][j];
                    this.vals[n] = this.vals[n] + Math.exp(weights[i]) / this.totalLen[i] * (double)(SplicingGraph.this.contRegs[this.assign[i][j]].regionEnd - SplicingGraph.this.contRegs[this.assign[i][j]].regionStart + 1);
                    ++j;
                }
                ++i;
            }
            System.out.println(String.valueOf(weights[weights.length - 1]) + " " + Arrays.toString(this.vals));
            double[] temps = new double[this.target.length];
            int i2 = 0;
            while (i2 < this.target.length) {
                temps[i2] = 2.0 * (this.vals[i2] * Math.exp(weights[weights.length - 1]) - this.target[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.assign.length) {
                int j = 0;
                while (j < this.assign[i2].length) {
                    int n = i2;
                    grad[n] = grad[n] + temps[this.assign[i2][j]] * Math.exp(weights[i2]);
                    int n2 = grad.length - 1;
                    grad[n2] = grad[n2] + temps[this.assign[i2][j]] * this.vals[this.assign[i2][j]] * Math.exp(weights[weights.length - 1]);
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < weights.length) {
                int n = i2;
                grad[n] = grad[n] + Math.exp(weights[i2]) * this.lambda1;
                int n3 = i2;
                grad[n3] = grad[n3] + 2.0 * Math.exp(2.0 * weights[i2]) * this.lambda2;
                ++i2;
            }
            return grad;
        }
    }
}

