/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import projects.tals.epigenetic.Methylationprofil;

public class MethylationprofilHashMap {
    private HashMap<String, Methylationprofil> methylationProfiles = new HashMap();

    public MethylationprofilHashMap(String faiPath, String pathToBismarkFile) throws Exception {
        this(faiPath, pathToBismarkFile, 0.0f, 0.0f);
    }

    public MethylationprofilHashMap(HashMap<String, Integer> chromLengthHash, String pathToBismarkFile, float PseudoCounts, float probCMethylated) throws Exception {
        float[] MethylationProb;
        BufferedReader BR = null;
        BR = pathToBismarkFile.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(pathToBismarkFile))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(pathToBismarkFile))));
        String line = "";
        HashMap<String, float[]> MethylationProbHash = new HashMap<String, float[]>();
        for (String chrom : chromLengthHash.keySet()) {
            MethylationProb = new float[chromLengthHash.get(chrom).intValue()];
            Arrays.fill(MethylationProb, PseudoCounts * probCMethylated);
            MethylationProbHash.put(chrom, (float[])MethylationProb.clone());
        }
        while ((line = BR.readLine()) != null) {
            float count_methylated = 0.0f;
            float count_unmethylated = 0.0f;
            String[] splitLine2 = line.split("\t");
            String chrom = splitLine2[0];
            if (!splitLine2[1].equals(splitLine2[2])) {
                BR.close();
                throw new Exception("Different <start position> and <end position> in " + pathToBismarkFile);
            }
            count_methylated = Float.parseFloat(splitLine2[4]) + PseudoCounts * probCMethylated;
            count_unmethylated = Float.parseFloat(splitLine2[5]) + PseudoCounts * (1.0f - probCMethylated);
            MethylationProb = (float[])MethylationProbHash.get(chrom);
            MethylationProb[Integer.parseInt((String)splitLine2[1]) - 1] = count_methylated / (count_methylated + count_unmethylated);
            MethylationProbHash.put(chrom, MethylationProb);
        }
        BR.close();
        for (String chrom : MethylationProbHash.keySet()) {
            this.methylationProfiles.put(chrom, new Methylationprofil(0, chrom, chromLengthHash.get(chrom), (float[])MethylationProbHash.get(chrom), true, PseudoCounts, probCMethylated));
        }
    }

    public MethylationprofilHashMap(HashMap<String, Integer> chromLengthHash, float PseudoCounts, float probCMethylated) throws Exception {
        HashMap<String, float[]> MethylationProbHash = new HashMap<String, float[]>();
        for (String chrom : chromLengthHash.keySet()) {
            float[] MethylationProb = new float[chromLengthHash.get(chrom).intValue()];
            Arrays.fill(MethylationProb, PseudoCounts * probCMethylated);
            MethylationProbHash.put(chrom, (float[])MethylationProb.clone());
        }
        for (String chrom : MethylationProbHash.keySet()) {
            this.methylationProfiles.put(chrom, new Methylationprofil(0, chrom, chromLengthHash.get(chrom), (float[])MethylationProbHash.get(chrom), true, PseudoCounts, probCMethylated));
        }
    }

    public MethylationprofilHashMap(String faiPath, String pathToBismarkFile, float PseudoCounts, float probCMethylated) throws Exception {
        float[] MethylationProb;
        HashMap<String, Integer> chromLengthHash = new HashMap<String, Integer>();
        BufferedReader readFai = new BufferedReader(new FileReader(faiPath));
        String line = "";
        int chromLength = -1;
        while ((line = readFai.readLine()) != null) {
            String[] splitLine = line.split("\t");
            chromLength = Integer.parseInt(splitLine[1]);
            chromLengthHash.put(splitLine[0], chromLength);
        }
        readFai.close();
        BufferedReader BR = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(pathToBismarkFile)))));
        line = "";
        HashMap<String, float[]> MethylationProbHash = new HashMap<String, float[]>();
        for (String chrom : chromLengthHash.keySet()) {
            MethylationProb = new float[((Integer)chromLengthHash.get(chrom)).intValue()];
            Arrays.fill(MethylationProb, PseudoCounts * probCMethylated);
            MethylationProbHash.put(chrom, (float[])MethylationProb.clone());
        }
        while ((line = BR.readLine()) != null) {
            float count_methylated = 0.0f;
            float count_unmethylated = 0.0f;
            String[] splitLine2 = line.split("\t");
            String chrom = splitLine2[0];
            if (!splitLine2[1].equals(splitLine2[2])) {
                BR.close();
                throw new Exception("Different <start position> and <end position> in " + pathToBismarkFile);
            }
            count_methylated = Float.parseFloat(splitLine2[4]) + PseudoCounts * probCMethylated;
            count_unmethylated = Float.parseFloat(splitLine2[5]) + PseudoCounts * (1.0f - probCMethylated);
            MethylationProb = (float[])MethylationProbHash.get(chrom);
            MethylationProb[Integer.parseInt((String)splitLine2[1]) - 1] = count_methylated / (count_methylated + count_unmethylated);
            MethylationProbHash.put(chrom, MethylationProb);
        }
        BR.close();
        for (String chrom : MethylationProbHash.keySet()) {
            this.methylationProfiles.put(chrom, new Methylationprofil(0, chrom, (Integer)chromLengthHash.get(chrom), (float[])MethylationProbHash.get(chrom), true, PseudoCounts, probCMethylated));
        }
    }

    public Methylationprofil getMethylationprofil(String chrom) {
        return this.methylationProfiles.get(chrom);
    }
}

